/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute;

import haveno.common.UserThread;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.persistable.PersistableList;
import haveno.common.proto.persistable.PersistableListAsObservable;
import haveno.common.proto.persistable.PersistedDataHost;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeList;
import haveno.core.trade.Contract;
import haveno.network.p2p.NodeAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.ObservableList;
import javax.annotation.Nullable;
import org.fxmisc.easybind.EasyBind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DisputeListService<T extends DisputeList<Dispute>>
implements PersistedDataHost {
    private static final Logger log = LoggerFactory.getLogger(DisputeListService.class);
    protected final PersistenceManager<T> persistenceManager;
    private final T disputeList;
    private final IntegerProperty numOpenDisputes = new SimpleIntegerProperty();
    private final Set<String> disputedTradeIds = new HashSet<String>();

    public DisputeListService(PersistenceManager<T> persistenceManager) {
        this.persistenceManager = persistenceManager;
        this.disputeList = this.getConcreteDisputeList();
        this.persistenceManager.initialize(this.disputeList, this.getFileName(), PersistenceManager.Source.PRIVATE);
    }

    protected abstract T getConcreteDisputeList();

    @Override
    public void readPersisted(Runnable completeHandler) {
        this.persistenceManager.readPersisted(this.getFileName(), persisted -> {
            List list = persisted.getList();
            synchronized (list) {
                ((PersistableList)this.disputeList).setAll(persisted.getList());
            }
            completeHandler.run();
        }, completeHandler);
    }

    protected String getFileName() {
        return this.disputeList.getDefaultStorageFileName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupDisputes(@Nullable Consumer<String> closedDisputeHandler) {
        ObservableList observableList = ((PersistableListAsObservable)this.disputeList).getObservableList();
        synchronized (observableList) {
            ((PersistableList)this.disputeList).stream().forEach(dispute -> {
                String tradeId = dispute.getTradeId();
                if (dispute.isClosed() && closedDisputeHandler != null) {
                    closedDisputeHandler.accept(tradeId);
                }
            });
        }
    }

    void onAllServicesInitialized() {
        ((PersistableListAsObservable)this.disputeList).addListener(change -> {
            change.next();
            this.onDisputesChangeListener(change.getAddedSubList(), change.getRemoved());
        });
        this.onDisputesChangeListener(((PersistableList)this.disputeList).getList(), null);
    }

    String getNrOfDisputes(boolean isBuyer, Contract contract) {
        return String.valueOf(this.getObservableList().stream().filter(e -> {
            Contract contract1 = e.getContract();
            if (contract1 == null) {
                return false;
            }
            if (isBuyer) {
                NodeAddress buyerNodeAddress = contract1.getBuyerNodeAddress();
                return buyerNodeAddress != null && buyerNodeAddress.equals(contract.getBuyerNodeAddress());
            }
            NodeAddress sellerNodeAddress = contract1.getSellerNodeAddress();
            return sellerNodeAddress != null && sellerNodeAddress.equals(contract.getSellerNodeAddress());
        }).collect(Collectors.toSet()).size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ObservableList<Dispute> getObservableList() {
        ObservableList observableList = ((PersistableListAsObservable)this.disputeList).getObservableList();
        synchronized (observableList) {
            return ((PersistableListAsObservable)this.disputeList).getObservableList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDisputesChangeListener(List<? extends Dispute> addedList, @Nullable List<? extends Dispute> removedList) {
        List<? extends Dispute> list;
        if (removedList != null) {
            list = removedList;
            synchronized (list) {
                removedList.forEach(dispute -> this.disputedTradeIds.remove(dispute.getTradeId()));
            }
        }
        list = addedList;
        synchronized (list) {
            addedList.forEach(dispute -> {
                EasyBind.subscribe(dispute.getBadgeCountProperty(), isAlerting -> UserThread.execute(() -> {
                    ObservableList observableList = ((PersistableListAsObservable)this.disputeList).getObservableList();
                    synchronized (observableList) {
                        int numAlerts = (int)((PersistableList)this.disputeList).getList().stream().mapToLong(x -> x.getBadgeCountProperty().getValue().intValue()).sum();
                        this.numOpenDisputes.set(numAlerts);
                    }
                }));
                this.disputedTradeIds.add(dispute.getTradeId());
            });
        }
    }

    public void requestPersistence() {
        this.persistenceManager.requestPersistence();
    }

    public PersistenceManager<T> getPersistenceManager() {
        return this.persistenceManager;
    }

    public T getDisputeList() {
        return this.disputeList;
    }

    public IntegerProperty getNumOpenDisputes() {
        return this.numOpenDisputes;
    }

    public Set<String> getDisputedTradeIds() {
        return this.disputedTradeIds;
    }
}

