/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute;

import com.google.protobuf.ByteString;
import haveno.common.proto.ProtoUtil;
import haveno.common.proto.network.NetworkPayload;
import haveno.common.util.Utilities;
import haveno.core.support.messages.ChatMessage;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.DisputeResult;

public final class DisputeResult
implements NetworkPayload {
    private static final Logger log = LoggerFactory.getLogger(DisputeResult.class);
    private final String tradeId;
    private final int traderId;
    @Nullable
    private Winner winner;
    private int reasonOrdinal = Reason.OTHER.ordinal();
    @Nullable
    private SubtractFeeFrom subtractFeeFrom;
    private final BooleanProperty tamperProofEvidenceProperty = new SimpleBooleanProperty();
    private final BooleanProperty idVerificationProperty = new SimpleBooleanProperty();
    private final BooleanProperty screenCastProperty = new SimpleBooleanProperty();
    private final StringProperty summaryNotesProperty = new SimpleStringProperty("");
    @Nullable
    private ChatMessage chatMessage;
    @Nullable
    private byte[] arbitratorSignature;
    private long buyerPayoutAmountBeforeCost;
    private long sellerPayoutAmountBeforeCost;
    @Nullable
    private byte[] arbitratorPubKey;
    private long closeDate;

    public DisputeResult(String tradeId, int traderId) {
        this.tradeId = tradeId;
        this.traderId = traderId;
    }

    public DisputeResult(String tradeId, int traderId, @Nullable Winner winner, int reasonOrdinal, @Nullable SubtractFeeFrom subtractFeeFrom, boolean tamperProofEvidence, boolean idVerification, boolean screenCast, String summaryNotes, @Nullable ChatMessage chatMessage, @Nullable byte[] arbitratorSignature, long buyerPayoutAmountBeforeCost, long sellerPayoutAmountBeforeCost, @Nullable byte[] arbitratorPubKey, long closeDate) {
        this.tradeId = tradeId;
        this.traderId = traderId;
        this.winner = winner;
        this.reasonOrdinal = reasonOrdinal;
        this.subtractFeeFrom = subtractFeeFrom;
        this.tamperProofEvidenceProperty.set(tamperProofEvidence);
        this.idVerificationProperty.set(idVerification);
        this.screenCastProperty.set(screenCast);
        this.summaryNotesProperty.set(summaryNotes);
        this.chatMessage = chatMessage;
        this.arbitratorSignature = arbitratorSignature;
        this.buyerPayoutAmountBeforeCost = buyerPayoutAmountBeforeCost;
        this.sellerPayoutAmountBeforeCost = sellerPayoutAmountBeforeCost;
        this.arbitratorPubKey = arbitratorPubKey;
        this.closeDate = closeDate;
    }

    public static DisputeResult fromProto(protobuf.DisputeResult proto) {
        return new DisputeResult(proto.getTradeId(), proto.getTraderId(), ProtoUtil.enumFromProto(Winner.class, proto.getWinner().name()), proto.getReasonOrdinal(), ProtoUtil.enumFromProto(SubtractFeeFrom.class, proto.getSubtractFeeFrom().name()), proto.getTamperProofEvidence(), proto.getIdVerification(), proto.getScreenCast(), proto.getSummaryNotes(), proto.getChatMessage() == null ? null : ChatMessage.fromPayloadProto(proto.getChatMessage()), proto.getArbitratorSignature().toByteArray(), proto.getBuyerPayoutAmountBeforeCost(), proto.getSellerPayoutAmountBeforeCost(), proto.getArbitratorPubKey().toByteArray(), proto.getCloseDate());
    }

    @Override
    public protobuf.DisputeResult toProtoMessage() {
        DisputeResult.Builder builder = protobuf.DisputeResult.newBuilder().setTradeId(this.tradeId).setTraderId(this.traderId).setReasonOrdinal(this.reasonOrdinal).setTamperProofEvidence(this.tamperProofEvidenceProperty.get()).setIdVerification(this.idVerificationProperty.get()).setScreenCast(this.screenCastProperty.get()).setSummaryNotes((String)this.summaryNotesProperty.get()).setBuyerPayoutAmountBeforeCost(this.buyerPayoutAmountBeforeCost).setSellerPayoutAmountBeforeCost(this.sellerPayoutAmountBeforeCost).setCloseDate(this.closeDate);
        Optional.ofNullable(this.arbitratorSignature).ifPresent(arbitratorSignature -> builder.setArbitratorSignature(ByteString.copyFrom(arbitratorSignature)));
        Optional.ofNullable(this.arbitratorPubKey).ifPresent(arbitratorPubKey -> builder.setArbitratorPubKey(ByteString.copyFrom(arbitratorPubKey)));
        Optional.ofNullable(this.winner).ifPresent(result -> builder.setWinner(DisputeResult.Winner.valueOf(this.winner.name())));
        Optional.ofNullable(this.subtractFeeFrom).ifPresent(result -> builder.setSubtractFeeFrom(DisputeResult.SubtractFeeFrom.valueOf(this.subtractFeeFrom.name())));
        Optional.ofNullable(this.chatMessage).ifPresent(chatMessage -> builder.setChatMessage(chatMessage.toProtoNetworkEnvelope().getChatMessage()));
        return builder.build();
    }

    public BooleanProperty tamperProofEvidenceProperty() {
        return this.tamperProofEvidenceProperty;
    }

    public BooleanProperty idVerificationProperty() {
        return this.idVerificationProperty;
    }

    public BooleanProperty screenCastProperty() {
        return this.screenCastProperty;
    }

    public void setReason(Reason reason) {
        this.reasonOrdinal = reason.ordinal();
    }

    public Reason getReason() {
        if (this.reasonOrdinal < Reason.values().length) {
            return Reason.values()[this.reasonOrdinal];
        }
        return Reason.OTHER;
    }

    public void setSummaryNotes(String summaryNotes) {
        this.summaryNotesProperty.set(summaryNotes);
    }

    public StringProperty summaryNotesProperty() {
        return this.summaryNotesProperty;
    }

    public void setBuyerPayoutAmountBeforeCost(BigInteger buyerPayoutAmountBeforeCost) {
        if (buyerPayoutAmountBeforeCost.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("buyerPayoutAmountBeforeCost cannot be negative");
        }
        this.buyerPayoutAmountBeforeCost = buyerPayoutAmountBeforeCost.longValueExact();
    }

    public BigInteger getBuyerPayoutAmountBeforeCost() {
        return BigInteger.valueOf(this.buyerPayoutAmountBeforeCost);
    }

    public void setSellerPayoutAmountBeforeCost(BigInteger sellerPayoutAmountBeforeCost) {
        if (sellerPayoutAmountBeforeCost.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("sellerPayoutAmountBeforeCost cannot be negative");
        }
        this.sellerPayoutAmountBeforeCost = sellerPayoutAmountBeforeCost.longValueExact();
    }

    public BigInteger getSellerPayoutAmountBeforeCost() {
        return BigInteger.valueOf(this.sellerPayoutAmountBeforeCost);
    }

    public void setCloseDate(Date closeDate) {
        this.closeDate = closeDate.getTime();
    }

    public Date getCloseDate() {
        return new Date(this.closeDate);
    }

    public String toString() {
        return "DisputeResult{\n     tradeId='" + this.tradeId + "',\n     traderId=" + this.traderId + ",\n     winner=" + String.valueOf((Object)this.winner) + ",\n     reasonOrdinal=" + this.reasonOrdinal + ",\n     subtractFeeFrom=" + String.valueOf((Object)this.subtractFeeFrom) + ",\n     tamperProofEvidenceProperty=" + String.valueOf(this.tamperProofEvidenceProperty) + ",\n     idVerificationProperty=" + String.valueOf(this.idVerificationProperty) + ",\n     screenCastProperty=" + String.valueOf(this.screenCastProperty) + ",\n     summaryNotesProperty=" + String.valueOf(this.summaryNotesProperty) + ",\n     chatMessage=" + String.valueOf(this.chatMessage) + ",\n     arbitratorSignature=" + Utilities.bytesAsHexString(this.arbitratorSignature) + ",\n     buyerPayoutAmountBeforeCost=" + this.buyerPayoutAmountBeforeCost + ",\n     sellerPayoutAmountBeforeCost=" + this.sellerPayoutAmountBeforeCost + ",\n     arbitratorPubKey=" + Utilities.bytesAsHexString(this.arbitratorPubKey) + ",\n     closeDate=" + this.closeDate + "\n}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisputeResult)) {
            return false;
        }
        DisputeResult other = (DisputeResult)o;
        if (this.getTraderId() != other.getTraderId()) {
            return false;
        }
        if (this.getReasonOrdinal() != other.getReasonOrdinal()) {
            return false;
        }
        BigInteger this$buyerPayoutAmountBeforeCost = this.getBuyerPayoutAmountBeforeCost();
        BigInteger other$buyerPayoutAmountBeforeCost = other.getBuyerPayoutAmountBeforeCost();
        if (this$buyerPayoutAmountBeforeCost == null ? other$buyerPayoutAmountBeforeCost != null : !((Object)this$buyerPayoutAmountBeforeCost).equals(other$buyerPayoutAmountBeforeCost)) {
            return false;
        }
        BigInteger this$sellerPayoutAmountBeforeCost = this.getSellerPayoutAmountBeforeCost();
        BigInteger other$sellerPayoutAmountBeforeCost = other.getSellerPayoutAmountBeforeCost();
        if (this$sellerPayoutAmountBeforeCost == null ? other$sellerPayoutAmountBeforeCost != null : !((Object)this$sellerPayoutAmountBeforeCost).equals(other$sellerPayoutAmountBeforeCost)) {
            return false;
        }
        Date this$closeDate = this.getCloseDate();
        Date other$closeDate = other.getCloseDate();
        if (this$closeDate == null ? other$closeDate != null : !((Object)this$closeDate).equals(other$closeDate)) {
            return false;
        }
        String this$tradeId = this.getTradeId();
        String other$tradeId = other.getTradeId();
        if (this$tradeId == null ? other$tradeId != null : !this$tradeId.equals(other$tradeId)) {
            return false;
        }
        Winner this$winner = this.getWinner();
        Winner other$winner = other.getWinner();
        if (this$winner == null ? other$winner != null : !((Object)((Object)this$winner)).equals((Object)other$winner)) {
            return false;
        }
        SubtractFeeFrom this$subtractFeeFrom = this.getSubtractFeeFrom();
        SubtractFeeFrom other$subtractFeeFrom = other.getSubtractFeeFrom();
        if (this$subtractFeeFrom == null ? other$subtractFeeFrom != null : !((Object)((Object)this$subtractFeeFrom)).equals((Object)other$subtractFeeFrom)) {
            return false;
        }
        BooleanProperty this$tamperProofEvidenceProperty = this.getTamperProofEvidenceProperty();
        BooleanProperty other$tamperProofEvidenceProperty = other.getTamperProofEvidenceProperty();
        if (this$tamperProofEvidenceProperty == null ? other$tamperProofEvidenceProperty != null : !this$tamperProofEvidenceProperty.equals(other$tamperProofEvidenceProperty)) {
            return false;
        }
        BooleanProperty this$idVerificationProperty = this.getIdVerificationProperty();
        BooleanProperty other$idVerificationProperty = other.getIdVerificationProperty();
        if (this$idVerificationProperty == null ? other$idVerificationProperty != null : !this$idVerificationProperty.equals(other$idVerificationProperty)) {
            return false;
        }
        BooleanProperty this$screenCastProperty = this.getScreenCastProperty();
        BooleanProperty other$screenCastProperty = other.getScreenCastProperty();
        if (this$screenCastProperty == null ? other$screenCastProperty != null : !this$screenCastProperty.equals(other$screenCastProperty)) {
            return false;
        }
        StringProperty this$summaryNotesProperty = this.getSummaryNotesProperty();
        StringProperty other$summaryNotesProperty = other.getSummaryNotesProperty();
        if (this$summaryNotesProperty == null ? other$summaryNotesProperty != null : !this$summaryNotesProperty.equals(other$summaryNotesProperty)) {
            return false;
        }
        ChatMessage this$chatMessage = this.getChatMessage();
        ChatMessage other$chatMessage = other.getChatMessage();
        if (this$chatMessage == null ? other$chatMessage != null : !((Object)this$chatMessage).equals(other$chatMessage)) {
            return false;
        }
        if (!Arrays.equals(this.getArbitratorSignature(), other.getArbitratorSignature())) {
            return false;
        }
        return Arrays.equals(this.getArbitratorPubKey(), other.getArbitratorPubKey());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTraderId();
        result = result * 59 + this.getReasonOrdinal();
        BigInteger $buyerPayoutAmountBeforeCost = this.getBuyerPayoutAmountBeforeCost();
        result = result * 59 + ($buyerPayoutAmountBeforeCost == null ? 43 : ((Object)$buyerPayoutAmountBeforeCost).hashCode());
        BigInteger $sellerPayoutAmountBeforeCost = this.getSellerPayoutAmountBeforeCost();
        result = result * 59 + ($sellerPayoutAmountBeforeCost == null ? 43 : ((Object)$sellerPayoutAmountBeforeCost).hashCode());
        Date $closeDate = this.getCloseDate();
        result = result * 59 + ($closeDate == null ? 43 : ((Object)$closeDate).hashCode());
        String $tradeId = this.getTradeId();
        result = result * 59 + ($tradeId == null ? 43 : $tradeId.hashCode());
        Winner $winner = this.getWinner();
        result = result * 59 + ($winner == null ? 43 : ((Object)((Object)$winner)).hashCode());
        SubtractFeeFrom $subtractFeeFrom = this.getSubtractFeeFrom();
        result = result * 59 + ($subtractFeeFrom == null ? 43 : ((Object)((Object)$subtractFeeFrom)).hashCode());
        BooleanProperty $tamperProofEvidenceProperty = this.getTamperProofEvidenceProperty();
        result = result * 59 + ($tamperProofEvidenceProperty == null ? 43 : $tamperProofEvidenceProperty.hashCode());
        BooleanProperty $idVerificationProperty = this.getIdVerificationProperty();
        result = result * 59 + ($idVerificationProperty == null ? 43 : $idVerificationProperty.hashCode());
        BooleanProperty $screenCastProperty = this.getScreenCastProperty();
        result = result * 59 + ($screenCastProperty == null ? 43 : $screenCastProperty.hashCode());
        StringProperty $summaryNotesProperty = this.getSummaryNotesProperty();
        result = result * 59 + ($summaryNotesProperty == null ? 43 : $summaryNotesProperty.hashCode());
        ChatMessage $chatMessage = this.getChatMessage();
        result = result * 59 + ($chatMessage == null ? 43 : ((Object)$chatMessage).hashCode());
        result = result * 59 + Arrays.hashCode(this.getArbitratorSignature());
        result = result * 59 + Arrays.hashCode(this.getArbitratorPubKey());
        return result;
    }

    public String getTradeId() {
        return this.tradeId;
    }

    public int getTraderId() {
        return this.traderId;
    }

    @Nullable
    public Winner getWinner() {
        return this.winner;
    }

    public int getReasonOrdinal() {
        return this.reasonOrdinal;
    }

    @Nullable
    public SubtractFeeFrom getSubtractFeeFrom() {
        return this.subtractFeeFrom;
    }

    public BooleanProperty getTamperProofEvidenceProperty() {
        return this.tamperProofEvidenceProperty;
    }

    public BooleanProperty getIdVerificationProperty() {
        return this.idVerificationProperty;
    }

    public BooleanProperty getScreenCastProperty() {
        return this.screenCastProperty;
    }

    public StringProperty getSummaryNotesProperty() {
        return this.summaryNotesProperty;
    }

    @Nullable
    public ChatMessage getChatMessage() {
        return this.chatMessage;
    }

    @Nullable
    public byte[] getArbitratorSignature() {
        return this.arbitratorSignature;
    }

    @Nullable
    public byte[] getArbitratorPubKey() {
        return this.arbitratorPubKey;
    }

    public void setWinner(@Nullable Winner winner) {
        this.winner = winner;
    }

    public void setSubtractFeeFrom(@Nullable SubtractFeeFrom subtractFeeFrom) {
        this.subtractFeeFrom = subtractFeeFrom;
    }

    public void setChatMessage(@Nullable ChatMessage chatMessage) {
        this.chatMessage = chatMessage;
    }

    public void setArbitratorSignature(@Nullable byte[] arbitratorSignature) {
        this.arbitratorSignature = arbitratorSignature;
    }

    public void setArbitratorPubKey(@Nullable byte[] arbitratorPubKey) {
        this.arbitratorPubKey = arbitratorPubKey;
    }

    public static enum Reason {
        OTHER,
        BUG,
        USABILITY,
        SCAM,
        PROTOCOL_VIOLATION,
        NO_REPLY,
        BANK_PROBLEMS,
        OPTION_TRADE,
        SELLER_NOT_RESPONDING,
        WRONG_SENDER_ACCOUNT,
        TRADE_ALREADY_SETTLED,
        PEER_WAS_LATE;

    }

    public static enum Winner {
        BUYER,
        SELLER;

    }

    public static enum SubtractFeeFrom {
        BUYER_ONLY,
        SELLER_ONLY,
        BUYER_AND_SELLER;

    }
}

