/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute;

import com.google.common.base.Preconditions;
import haveno.common.crypto.Hash;
import haveno.common.crypto.PubKeyRing;
import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeList;
import haveno.core.support.dispute.DisputeManager;
import haveno.core.support.dispute.DisputeResult;
import haveno.core.support.dispute.agent.DisputeAgent;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.core.trade.HavenoUtils;
import haveno.network.p2p.NodeAddress;
import java.security.KeyPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisputeSummaryVerification {
    private static final Logger log = LoggerFactory.getLogger(DisputeSummaryVerification.class);
    private static final String SEPARATOR1 = "\n-----BEGIN SIGNATURE-----\n";
    private static final String SEPARATOR2 = "\n-----END SIGNATURE-----\n";

    public static String signAndApply(DisputeManager<? extends DisputeList<Dispute>> disputeManager, DisputeResult disputeResult, String textToSign) {
        String sigAsHex;
        byte[] hash = Hash.getSha256Hash(textToSign);
        KeyPair signatureKeyPair = disputeManager.getSignatureKeyPair();
        try {
            byte[] signature = HavenoUtils.sign(signatureKeyPair.getPrivate(), hash);
            sigAsHex = Utilities.encodeToHex(signature);
            disputeResult.setArbitratorSignature(signature);
        }
        catch (Exception e) {
            sigAsHex = "Signing failed";
        }
        return Res.get("disputeSummaryWindow.close.msgWithSig", textToSign, SEPARATOR1, sigAsHex, SEPARATOR2);
    }

    public static void verifySignature(String input, ArbitratorManager arbitratorManager) {
        DisputeAgent disputeAgent = null;
        try {
            String[] parts = input.split(SEPARATOR1);
            String textToSign = parts[0];
            String fullAddress = textToSign.split("\n")[1].split(": ")[1];
            NodeAddress nodeAddress = new NodeAddress(fullAddress);
            disputeAgent = arbitratorManager.getDisputeAgentByNodeAddress(nodeAddress).orElse(null);
            Preconditions.checkNotNull(disputeAgent, "Dispute agent is null");
        }
        catch (Throwable e) {
            log.error("Error verifying signature: {}\n", (Object)e.getMessage(), (Object)e);
            throw new IllegalArgumentException(Res.get("support.sigCheck.popup.invalidFormat"));
        }
        DisputeSummaryVerification.verifySignature(input, disputeAgent.getPubKeyRing());
    }

    public static void verifySignature(String input, PubKeyRing agentPubKeyRing) {
        try {
            String[] parts = input.split(SEPARATOR1);
            String textToSign = parts[0];
            String sigString = parts[1].split(SEPARATOR2)[0];
            byte[] sig = Utilities.decodeFromHex(sigString);
            byte[] hash = Hash.getSha256Hash(textToSign);
            try {
                HavenoUtils.verifySignature(agentPubKeyRing, hash, sig);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(Res.get("support.sigCheck.popup.failed"));
            }
        }
        catch (Throwable e) {
            log.error("Error verifying signature with agent pub key ring: {}\n", (Object)e.getMessage(), (Object)e);
            throw new IllegalArgumentException(Res.get("support.sigCheck.popup.invalidFormat"));
        }
    }
}

