/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute;

import com.google.common.base.Preconditions;
import haveno.common.config.Config;
import haveno.common.crypto.Hash;
import haveno.core.support.dispute.Dispute;
import haveno.core.trade.Contract;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.util.JsonUtil;
import haveno.core.util.validation.RegexValidatorFactory;
import haveno.network.p2p.NodeAddress;
import java.util.Arrays;
import java.util.Objects;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisputeValidation {
    private static final Logger log = LoggerFactory.getLogger(DisputeValidation.class);

    public static void validatePaymentAccountPayloads(Dispute dispute) throws ValidationException {
        if (dispute.getSellerPaymentAccountPayload() == null) {
            throw new ValidationException(dispute, "Seller's payment account payload is null in dispute opened for trade " + dispute.getTradeId());
        }
        if (!Arrays.equals(dispute.getSellerPaymentAccountPayload().getHash(), dispute.getContract().getSellerPaymentAccountPayloadHash())) {
            throw new ValidationException(dispute, "Hash of seller's payment account payload does not match contract");
        }
        if (dispute.getBuyerPaymentAccountPayload() != null && !Arrays.equals(dispute.getBuyerPaymentAccountPayload().getHash(), dispute.getContract().getBuyerPaymentAccountPayloadHash())) {
            throw new ValidationException(dispute, "Hash of buyer's payment account payload does not match contract");
        }
    }

    public static void validateDisputeData(Dispute dispute) throws ValidationException {
        try {
            byte[] takerContractSignature;
            Contract contract = dispute.getContract();
            Preconditions.checkArgument(contract.getOfferPayload().getId().equals(dispute.getTradeId()), "Invalid tradeId");
            Preconditions.checkArgument(dispute.getContractAsJson().equals(JsonUtil.objectToJson(contract)), "Invalid contractAsJson");
            Preconditions.checkArgument(Arrays.equals(Objects.requireNonNull(dispute.getContractHash()), Hash.getSha256Hash(Preconditions.checkNotNull(dispute.getContractAsJson()))), "Invalid contractHash");
            byte[] makerContractSignature = dispute.getMakerContractSignature();
            if (makerContractSignature != null) {
                HavenoUtils.verifySignature(contract.getMakerPubKeyRing(), dispute.getContractAsJson(), makerContractSignature);
            }
            if ((takerContractSignature = dispute.getTakerContractSignature()) != null) {
                HavenoUtils.verifySignature(contract.getTakerPubKeyRing(), dispute.getContractAsJson(), takerContractSignature);
            }
        }
        catch (Throwable t2) {
            throw new ValidationException(dispute, t2.getMessage());
        }
    }

    public static void validateTradeAndDispute(Dispute dispute, Trade trade) throws ValidationException {
        try {
            Preconditions.checkArgument(dispute.getContract().equals(trade.getContract()), "contract must match contract from trade");
        }
        catch (Throwable t2) {
            throw new ValidationException(dispute, t2.getMessage());
        }
    }

    public static void validateSenderNodeAddress(Dispute dispute, NodeAddress senderNodeAddress, Config config) throws NodeAddressException {
        if (config.useLocalhostForP2P) {
            return;
        }
        if (!(senderNodeAddress.getHostName().equals(dispute.getContract().getBuyerNodeAddress().getHostName()) || senderNodeAddress.getHostName().equals(dispute.getContract().getSellerNodeAddress().getHostName()) || senderNodeAddress.getHostName().equals(dispute.getContract().getArbitratorNodeAddress().getHostName()))) {
            throw new NodeAddressException(dispute, "senderNodeAddress not matching any of the trade node addresses");
        }
    }

    public static void validateNodeAddresses(Dispute dispute, Config config) throws NodeAddressException {
        if (config.useLocalhostForP2P) {
            return;
        }
        DisputeValidation.validateNodeAddress(dispute, dispute.getContract().getBuyerNodeAddress());
        DisputeValidation.validateNodeAddress(dispute, dispute.getContract().getSellerNodeAddress());
    }

    private static void validateNodeAddress(Dispute dispute, NodeAddress nodeAddress) throws NodeAddressException {
        if (!RegexValidatorFactory.onionAddressRegexValidator().validate((String)nodeAddress.getFullAddress()).isValid) {
            String msg = "Node address " + nodeAddress.getFullAddress() + " at dispute with trade ID " + dispute.getShortTradeId() + " is not a valid address";
            log.error(msg);
            throw new NodeAddressException(dispute, msg);
        }
    }

    public static void validateDonationAddress(Dispute dispute, Transaction delayedPayoutTx, NetworkParameters params) throws AddressException {
        TransactionOutput output = delayedPayoutTx.getOutput(0L);
        Address address = output.getScriptPubKey().getToAddress(params);
        if (address == null) {
            String errorMsg = "Donation address cannot be resolved (not of type P2PK nor P2SH nor P2WH). Output: " + String.valueOf(output);
            log.error(errorMsg);
            log.error(delayedPayoutTx.toString());
            throw new AddressException(dispute, errorMsg);
        }
        String delayedPayoutTxOutputAddress = address.toString();
        Preconditions.checkArgument(delayedPayoutTxOutputAddress.equals(dispute.getDonationAddressOfDelayedPayoutTx()), "donationAddressOfDelayedPayoutTx from dispute does not match address from delayed payout tx. delayedPayoutTxOutputAddress=" + delayedPayoutTxOutputAddress + "; dispute.getDonationAddressOfDelayedPayoutTx()=" + dispute.getDonationAddressOfDelayedPayoutTx());
    }

    public static class ValidationException
    extends Exception {
        private final Dispute dispute;

        ValidationException(Dispute dispute, String msg) {
            super(msg);
            this.dispute = dispute;
        }

        public Dispute getDispute() {
            return this.dispute;
        }
    }

    public static class NodeAddressException
    extends ValidationException {
        NodeAddressException(Dispute dispute, String msg) {
            super(dispute, msg);
        }
    }

    public static class AddressException
    extends ValidationException {
        AddressException(Dispute dispute, String msg) {
            super(dispute, msg);
        }
    }

    public static class DisputeReplayException
    extends ValidationException {
        DisputeReplayException(Dispute dispute, String msg) {
            super(dispute, msg);
        }
    }
}

