/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.agent;

import haveno.common.config.Config;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.common.util.Utilities;
import haveno.core.filter.FilterManager;
import haveno.core.support.dispute.agent.DisputeAgent;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.storage.HashMapChangedListener;
import haveno.network.p2p.storage.payload.ProtectedStoragePayload;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DisputeAgentService<T extends DisputeAgent> {
    private static final Logger log = LoggerFactory.getLogger(DisputeAgentService.class);
    protected final P2PService p2PService;
    protected final FilterManager filterManager;

    public DisputeAgentService(P2PService p2PService, FilterManager filterManager) {
        this.p2PService = p2PService;
        this.filterManager = filterManager;
    }

    public void addHashSetChangedListener(HashMapChangedListener hashMapChangedListener) {
        this.p2PService.addHashSetChangedListener(hashMapChangedListener);
    }

    public void addDisputeAgent(T disputeAgent, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        log.debug("addDisputeAgent disputeAgent.hashCode() " + ((DisputeAgent)disputeAgent).hashCode());
        if (!Config.baseCurrencyNetwork().isMainnet() || !Utilities.encodeToHex(((DisputeAgent)disputeAgent).getRegistrationPubKey()).equals("027a381b5333a56e1cc3d90d3a7d07f26509adf7029ed06fc997c656621f8da1ee")) {
            boolean result = this.p2PService.addProtectedStorageEntry((ProtectedStoragePayload)disputeAgent);
            if (result) {
                log.trace("Add disputeAgent to network was successful. DisputeAgent.hashCode() = {}", (Object)((DisputeAgent)disputeAgent).hashCode());
                resultHandler.handleResult();
            } else {
                errorMessageHandler.handleErrorMessage("Add disputeAgent failed");
            }
        } else {
            log.error("Attempt to publish dev disputeAgent on mainnet.");
            errorMessageHandler.handleErrorMessage("Add disputeAgent failed. Attempt to publish dev disputeAgent on mainnet.");
        }
    }

    public void removeDisputeAgent(T disputeAgent, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        log.debug("removeDisputeAgent disputeAgent.hashCode() " + ((DisputeAgent)disputeAgent).hashCode());
        if (this.p2PService.removeData((ProtectedStoragePayload)disputeAgent)) {
            log.trace("Remove disputeAgent from network was successful. DisputeAgent.hashCode() = {}", (Object)((DisputeAgent)disputeAgent).hashCode());
            resultHandler.handleResult();
        } else {
            errorMessageHandler.handleErrorMessage("Remove disputeAgent failed");
        }
    }

    public P2PService getP2PService() {
        return this.p2PService;
    }

    public Map<NodeAddress, T> getDisputeAgents() {
        List<String> bannedDisputeAgents = this.filterManager.getFilter() != null ? this.getDisputeAgentsFromFilter() : null;
        if (bannedDisputeAgents != null && !bannedDisputeAgents.isEmpty()) {
            log.warn("bannedDisputeAgents=" + String.valueOf(bannedDisputeAgents));
        }
        Set<T> disputeAgentSet = this.getDisputeAgentSet(bannedDisputeAgents);
        HashMap<NodeAddress, DisputeAgent> map = new HashMap<NodeAddress, DisputeAgent>();
        for (DisputeAgent disputeAgent : disputeAgentSet) {
            NodeAddress disputeAgentNodeAddress = disputeAgent.getNodeAddress();
            if (map.containsKey(disputeAgentNodeAddress)) {
                log.warn("disputeAgentAddress already exists in disputeAgent map. Seems a disputeAgent object is already registered with the same address.");
            }
            map.put(disputeAgentNodeAddress, disputeAgent);
        }
        return map;
    }

    protected abstract Set<T> getDisputeAgentSet(List<String> var1);

    protected abstract List<String> getDisputeAgentsFromFilter();
}

