/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.arbitration;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import haveno.common.proto.ProtoUtil;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.support.SupportType;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.PersistableEnvelope;

public final class ArbitrationDisputeList
extends DisputeList<Dispute> {
    private static final Logger log = LoggerFactory.getLogger(ArbitrationDisputeList.class);

    ArbitrationDisputeList() {
    }

    protected ArbitrationDisputeList(Collection<Dispute> collection) {
        super(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message toProtoMessage() {
        List list = this.list;
        synchronized (list) {
            this.forEach(dispute -> Preconditions.checkArgument(dispute.getSupportType().equals((Object)SupportType.ARBITRATION), "Support type has to be ARBITRATION"));
            return PersistableEnvelope.newBuilder().setArbitrationDisputeList(protobuf.ArbitrationDisputeList.newBuilder().addAllDispute(ProtoUtil.collectionToProto(this.getList(), protobuf.Dispute.class))).build();
        }
    }

    public static ArbitrationDisputeList fromProto(protobuf.ArbitrationDisputeList proto, CoreProtoResolver coreProtoResolver) {
        List<Dispute> list = proto.getDisputeList().stream().map(disputeProto -> Dispute.fromProto(disputeProto, coreProtoResolver)).filter(e -> e.getSupportType().equals((Object)SupportType.ARBITRATION)).collect(Collectors.toList());
        return new ArbitrationDisputeList((Collection<Dispute>)list);
    }

    @Override
    public String toString() {
        return "ArbitrationDisputeList()";
    }
}

