/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.arbitration.arbitrator;

import com.google.protobuf.ByteString;
import haveno.common.crypto.PubKeyRing;
import haveno.common.proto.ProtoUtil;
import haveno.common.util.CollectionUtils;
import haveno.core.support.dispute.agent.DisputeAgent;
import haveno.network.p2p.NodeAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.Arbitrator;
import protobuf.StoragePayload;

public final class Arbitrator
extends DisputeAgent {
    private static final Logger log = LoggerFactory.getLogger(Arbitrator.class);

    public Arbitrator(NodeAddress nodeAddress, PubKeyRing pubKeyRing, List<String> languageCodes, long registrationDate, byte[] registrationPubKey, String registrationSignature, @Nullable String emailAddress, @Nullable String info, @Nullable Map<String, String> extraDataMap) {
        super(nodeAddress, pubKeyRing, languageCodes, registrationDate, registrationPubKey, registrationSignature, emailAddress, info, extraDataMap);
    }

    @Override
    public StoragePayload toProtoMessage() {
        Arbitrator.Builder builder = protobuf.Arbitrator.newBuilder().setNodeAddress(this.nodeAddress.toProtoMessage()).setPubKeyRing(this.pubKeyRing.toProtoMessage()).addAllLanguageCodes(this.languageCodes).setRegistrationDate(this.registrationDate).setRegistrationPubKey(ByteString.copyFrom(this.registrationPubKey)).setRegistrationSignature(this.registrationSignature);
        Optional.ofNullable(this.emailAddress).ifPresent(builder::setEmailAddress);
        Optional.ofNullable(this.info).ifPresent(builder::setInfo);
        Optional.ofNullable(this.extraDataMap).ifPresent(builder::putAllExtraData);
        return StoragePayload.newBuilder().setArbitrator(builder).build();
    }

    public static Arbitrator fromProto(protobuf.Arbitrator proto) {
        return new Arbitrator(NodeAddress.fromProto(proto.getNodeAddress()), PubKeyRing.fromProto(proto.getPubKeyRing()), new ArrayList<String>(proto.getLanguageCodesList()), proto.getRegistrationDate(), proto.getRegistrationPubKey().toByteArray(), proto.getRegistrationSignature(), ProtoUtil.stringOrNullFromProto(proto.getEmailAddress()), ProtoUtil.stringOrNullFromProto(proto.getInfo()), CollectionUtils.isEmpty(proto.getExtraDataMap()) ? null : proto.getExtraDataMap());
    }

    @Override
    public String toString() {
        return "Arbitrator{} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Arbitrator)) {
            return false;
        }
        Arbitrator other = (Arbitrator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Arbitrator;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

