/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.mediation;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import haveno.common.UserThread;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.util.Utilities;
import haveno.core.support.dispute.mediation.FileTransferReceiver;
import haveno.core.support.dispute.mediation.FileTransferSender;
import haveno.network.p2p.AckMessage;
import haveno.network.p2p.AckMessageSourceType;
import haveno.network.p2p.FileTransferPart;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.MessageListener;
import haveno.network.p2p.network.NetworkNode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileTransferSession
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(FileTransferSession.class);
    protected static final int FTP_SESSION_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(60L);
    protected static final int FILE_BLOCK_SIZE = Connection.getPermittedMessageSize() - 1024;
    protected final String fullTradeId;
    protected final int traderId;
    protected final String zipId;
    protected final Optional<FtpCallback> ftpCallback;
    protected final NetworkNode networkNode;
    protected final NodeAddress peerNodeAddress;
    protected Optional<FileTransferPart> dataAwaitingAck;
    protected long fileOffsetBytes;
    protected long currentBlockSeqNum;
    protected long expectedFileLength;
    protected long lastActivityTime;

    public FileTransferSession(NetworkNode networkNode, NodeAddress peerNodeAddress, String tradeId, int traderId, String traderRole, @Nullable FtpCallback callback) {
        this.networkNode = networkNode;
        this.peerNodeAddress = peerNodeAddress;
        this.fullTradeId = tradeId;
        this.traderId = traderId;
        this.ftpCallback = Optional.ofNullable(callback);
        this.zipId = Utilities.getShortId(this.fullTradeId) + "_" + traderRole.toUpperCase() + "_" + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        this.resetSession();
    }

    public void resetSession() {
        this.lastActivityTime = 0L;
        this.currentBlockSeqNum = -1L;
        this.fileOffsetBytes = 0L;
        this.expectedFileLength = 0L;
        this.dataAwaitingAck = Optional.empty();
        this.networkNode.removeMessageListener(this);
        log.info("Ftp session parameters have been reset.");
    }

    @Override
    public void onMessage(NetworkEnvelope networkEnvelope, Connection connection) {
        AckMessage ackMessage;
        if (networkEnvelope instanceof FileTransferPart) {
            FileTransferPart ftp = (FileTransferPart)networkEnvelope;
            if (this instanceof FileTransferReceiver) {
                ((FileTransferReceiver)this).processFilePartReceived(ftp);
            }
        } else if (networkEnvelope instanceof AckMessage && (ackMessage = (AckMessage)networkEnvelope).getSourceType() == AckMessageSourceType.LOG_TRANSFER) {
            if (ackMessage.isSuccess()) {
                log.info("Received AckMessage for {} with id {} and uid {}", ackMessage.getSourceMsgClassName(), ackMessage.getSourceId(), ackMessage.getSourceUid());
                if (this instanceof FileTransferSender) {
                    ((FileTransferSender)this).processAckForFilePart(ackMessage.getSourceUid());
                }
            } else {
                log.warn("Received AckMessage with error state for {} with id {} and errorMessage={}", ackMessage.getSourceMsgClassName(), ackMessage.getSourceId(), ackMessage.getErrorMessage());
            }
        }
    }

    protected void checkpointLastActivity() {
        this.lastActivityTime = System.currentTimeMillis();
    }

    protected void initSessionTimer() {
        UserThread.runAfter(() -> {
            if (!this.transferIsInProgress()) {
                return;
            }
            if (System.currentTimeMillis() - this.lastActivityTime < (long)FTP_SESSION_TIMEOUT_MILLIS) {
                log.info("Last activity was {}, we have not yet timed out.", (Object)new Date(this.lastActivityTime));
                this.initSessionTimer();
            } else {
                log.warn("File transfer session timed out. expected: {} received: {}", (Object)this.expectedFileLength, (Object)this.fileOffsetBytes);
                this.ftpCallback.ifPresent(e -> e.onFtpTimeout("Timed out during send", this));
            }
        }, FTP_SESSION_TIMEOUT_MILLIS / 4, TimeUnit.MILLISECONDS);
    }

    protected boolean transferIsInProgress() {
        return this.fileOffsetBytes != this.expectedFileLength;
    }

    protected void sendMessage(final NetworkEnvelope message, NetworkNode networkNode, final NodeAddress nodeAddress) {
        SettableFuture<Connection> future = networkNode.sendMessage(nodeAddress, message);
        if (future != null) {
            Futures.addCallback(future, new FutureCallback<Connection>(){

                @Override
                public void onSuccess(Connection connection) {
                }

                @Override
                public void onFailure(@NotNull Throwable throwable) {
                    String errorSend = "Sending " + message.getClass().getSimpleName() + " to " + nodeAddress.getFullAddress() + " failed. That is expected if the peer is offline.\n\t.\n\tException=" + throwable.getMessage();
                    log.warn(errorSend);
                    FileTransferSession.this.ftpCallback.ifPresent(f -> f.onFtpTimeout("Peer offline", FileTransferSession.this));
                    FileTransferSession.this.resetSession();
                }
            }, MoreExecutors.directExecutor());
        }
    }

    public String getFullTradeId() {
        return this.fullTradeId;
    }

    public int getTraderId() {
        return this.traderId;
    }

    public String getZipId() {
        return this.zipId;
    }

    public static interface FtpCallback {
        public void onFtpProgress(double var1);

        public void onFtpComplete(FileTransferSession var1);

        public void onFtpTimeout(String var1, FileTransferSession var2);
    }
}

