/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.mediation;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.config.Config;
import haveno.common.crypto.KeyRing;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.api.CoreNotificationService;
import haveno.core.api.XmrConnectionService;
import haveno.core.locale.Res;
import haveno.core.offer.OpenOffer;
import haveno.core.offer.OpenOfferManager;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.support.SupportType;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeManager;
import haveno.core.support.dispute.DisputeResult;
import haveno.core.support.dispute.mediation.MediationDisputeList;
import haveno.core.support.dispute.mediation.MediationDisputeListService;
import haveno.core.support.dispute.mediation.MediationResultState;
import haveno.core.support.dispute.messages.DisputeClosedMessage;
import haveno.core.support.dispute.messages.DisputeOpenedMessage;
import haveno.core.support.messages.ChatMessage;
import haveno.core.support.messages.SupportMessage;
import haveno.core.trade.ClosedTradableManager;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.trade.protocol.DisputeProtocol;
import haveno.core.trade.protocol.ProcessModel;
import haveno.core.xmr.wallet.TradeWalletService;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.AckMessageSourceType;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import java.math.BigInteger;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class MediationManager
extends DisputeManager<MediationDisputeList> {
    private static final Logger log = LoggerFactory.getLogger(MediationManager.class);

    @Inject
    public MediationManager(P2PService p2PService, TradeWalletService tradeWalletService, XmrWalletService walletService, XmrConnectionService xmrConnectionService, CoreNotificationService notificationService, TradeManager tradeManager, ClosedTradableManager closedTradableManager, OpenOfferManager openOfferManager, KeyRing keyRing, MediationDisputeListService mediationDisputeListService, Config config, PriceFeedService priceFeedService) {
        super(p2PService, tradeWalletService, walletService, xmrConnectionService, notificationService, tradeManager, closedTradableManager, openOfferManager, keyRing, mediationDisputeListService, config, priceFeedService);
    }

    @Override
    public SupportType getSupportType() {
        return SupportType.MEDIATION;
    }

    @Override
    public void onSupportMessage(SupportMessage message) {
        if (this.canProcessMessage(message)) {
            log.info("Received {} with tradeId {} and uid {}", message.getClass().getSimpleName(), message.getTradeId(), message.getUid());
            if (message instanceof DisputeOpenedMessage) {
                this.handleDisputeOpenedMessage((DisputeOpenedMessage)message);
            } else if (message instanceof ChatMessage) {
                this.handleChatMessage((ChatMessage)message);
            } else if (message instanceof DisputeClosedMessage) {
                this.handleDisputeClosedMessage((DisputeClosedMessage)message);
            } else {
                log.warn("Unsupported message at dispatchMessage. message={}", (Object)message);
            }
        }
    }

    @Override
    protected AckMessageSourceType getAckMessageSourceType() {
        return AckMessageSourceType.MEDIATION_MESSAGE;
    }

    @Override
    public void cleanupDisputes() {
        this.disputeListService.cleanupDisputes(tradeId -> this.tradeManager.getOpenTrade((String)tradeId).filter(trade -> trade.getPayoutTx() != null).ifPresent(trade -> this.tradeManager.closeDisputedTrade((String)tradeId, Trade.DisputeState.MEDIATION_CLOSED)));
    }

    @Override
    protected String getDisputeInfo(Dispute dispute) {
        String role = Res.get("shared.mediator").toLowerCase();
        String link = "https://docs.haveno.exchange/trading-rules.html#mediation";
        return Res.get("support.initialInfo", role, role, link);
    }

    @Override
    protected String getDisputeIntroForPeer(String disputeInfo) {
        return Res.get("support.peerOpenedDisputeForMediation", disputeInfo, "1.1.1");
    }

    @Override
    protected String getDisputeIntroForDisputeCreator(String disputeInfo) {
        return Res.get("support.youOpenedDisputeForMediation", disputeInfo, "1.1.1");
    }

    @Override
    public void handleDisputeClosedMessage(DisputeClosedMessage disputeResultMessage) {
        DisputeResult disputeResult = disputeResultMessage.getDisputeResult();
        String tradeId = disputeResult.getTradeId();
        ChatMessage chatMessage = disputeResult.getChatMessage();
        Preconditions.checkNotNull(chatMessage, "chatMessage must not be null");
        Optional<Dispute> disputeOptional = this.findDispute(disputeResult);
        String uid = disputeResultMessage.getUid();
        if (!disputeOptional.isPresent()) {
            log.warn("We got a dispute result msg but we don't have a matching dispute. That might happen when we get the disputeResultMessage before the dispute was created. We try again after 2 sec. to apply the disputeResultMessage. TradeId = " + tradeId);
            if (!this.delayMsgMap.containsKey(uid)) {
                Timer timer = UserThread.runAfter(() -> this.handleDisputeClosedMessage(disputeResultMessage), 2L);
                this.delayMsgMap.put(uid, timer);
            } else {
                log.warn("We got a dispute result msg after we already repeated to apply the message after a delay. That should never happen. TradeId = " + tradeId);
            }
            return;
        }
        Dispute dispute = disputeOptional.get();
        this.cleanupRetryMap(uid);
        if (!dispute.getChatMessages().contains(chatMessage)) {
            dispute.addAndPersistChatMessage(chatMessage);
        } else {
            log.warn("We got a dispute mail msg that we have already stored. TradeId = " + chatMessage.getTradeId());
        }
        dispute.setIsClosed();
        dispute.setDisputeResult(disputeResult);
        Optional<Trade> tradeOptional = this.tradeManager.getOpenTrade(tradeId);
        if (tradeOptional.isPresent()) {
            Trade trade = tradeOptional.get();
            if (trade.getDisputeState() == Trade.DisputeState.MEDIATION_REQUESTED || trade.getDisputeState() == Trade.DisputeState.MEDIATION_STARTED_BY_PEER) {
                trade.getProcessModel().setBuyerPayoutAmountFromMediation(disputeResult.getBuyerPayoutAmountBeforeCost().longValueExact());
                trade.getProcessModel().setSellerPayoutAmountFromMediation(disputeResult.getSellerPayoutAmountBeforeCost().longValueExact());
                trade.setDisputeState(Trade.DisputeState.MEDIATION_CLOSED);
                this.tradeManager.requestPersistence();
            }
        } else {
            Optional<OpenOffer> openOfferOptional = this.openOfferManager.getOpenOffer(tradeId);
            openOfferOptional.ifPresent(openOffer -> this.openOfferManager.closeSpentOffer(openOffer.getOffer()));
        }
        this.sendAckMessage(chatMessage, dispute.getAgentPubKeyRing(), true, null);
        this.requestPersistence();
    }

    @Override
    @Nullable
    public NodeAddress getAgentNodeAddress(Dispute dispute) {
        return dispute.getContract().getArbitratorNodeAddress();
    }

    public void onAcceptMediationResult(Trade trade, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        String tradeId = trade.getId();
        Optional<Dispute> optionalDispute = this.findDispute(tradeId);
        Preconditions.checkArgument(optionalDispute.isPresent(), "dispute must be present");
        DisputeResult disputeResult = (DisputeResult)optionalDispute.get().getDisputeResultProperty().get();
        BigInteger buyerPayoutAmount = disputeResult.getBuyerPayoutAmountBeforeCost();
        BigInteger sellerPayoutAmount = disputeResult.getSellerPayoutAmountBeforeCost();
        ProcessModel processModel = trade.getProcessModel();
        processModel.setBuyerPayoutAmountFromMediation(buyerPayoutAmount.longValueExact());
        processModel.setSellerPayoutAmountFromMediation(sellerPayoutAmount.longValueExact());
        DisputeProtocol tradeProtocol = (DisputeProtocol)this.tradeManager.getTradeProtocol(trade);
        trade.setMediationResultState(MediationResultState.MEDIATION_RESULT_ACCEPTED);
        this.tradeManager.requestPersistence();
        if (trade.getTradePeer().getMediatedPayoutTxSignature() == null) {
            tradeProtocol.onAcceptMediationResult(() -> {
                if (trade.getPayoutTx() != null) {
                    this.tradeManager.closeDisputedTrade(tradeId, Trade.DisputeState.MEDIATION_CLOSED);
                }
                resultHandler.handleResult();
            }, errorMessageHandler);
        } else {
            tradeProtocol.onFinalizeMediationResultPayout(() -> {
                if (trade.getPayoutTx() != null) {
                    this.tradeManager.closeDisputedTrade(tradeId, Trade.DisputeState.MEDIATION_CLOSED);
                }
                resultHandler.handleResult();
            }, errorMessageHandler);
        }
    }

    public void rejectMediationResult(Trade trade) {
        trade.setMediationResultState(MediationResultState.MEDIATION_RESULT_REJECTED);
        this.tradeManager.requestPersistence();
    }
}

