/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.mediation.mediator;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.core.filter.FilterManager;
import haveno.core.support.dispute.agent.DisputeAgentService;
import haveno.core.support.dispute.mediation.mediator.Mediator;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MediatorService
extends DisputeAgentService<Mediator> {
    private static final Logger log = LoggerFactory.getLogger(MediatorService.class);

    @Inject
    public MediatorService(P2PService p2PService, FilterManager filterManager) {
        super(p2PService, filterManager);
    }

    @Override
    protected Set<Mediator> getDisputeAgentSet(List<String> bannedDisputeAgents) {
        return this.p2PService.getDataMap().values().stream().filter(data -> data.getProtectedStoragePayload() instanceof Mediator).map(data -> (Mediator)data.getProtectedStoragePayload()).filter(a -> bannedDisputeAgents == null || !bannedDisputeAgents.contains(a.getNodeAddress().getFullAddress())).collect(Collectors.toSet());
    }

    @Override
    protected List<String> getDisputeAgentsFromFilter() {
        return this.filterManager.getFilter() != null ? this.filterManager.getFilter().getMediators() : new ArrayList();
    }

    public Map<NodeAddress, Mediator> getMediators() {
        return super.getDisputeAgents();
    }
}

