/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.messages;

import haveno.common.app.Version;
import haveno.common.proto.ProtoUtil;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.support.SupportType;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.messages.DisputeMessage;
import haveno.core.trade.messages.PaymentSentMessage;
import haveno.network.p2p.NodeAddress;
import java.util.Optional;
import protobuf.DisputeOpenedMessage;
import protobuf.NetworkEnvelope;

public final class DisputeOpenedMessage
extends DisputeMessage {
    private final Dispute dispute;
    private final NodeAddress senderNodeAddress;
    private final String openerUpdatedMultisigHex;
    private final PaymentSentMessage paymentSentMessage;

    public DisputeOpenedMessage(Dispute dispute, NodeAddress senderNodeAddress, String uid, SupportType supportType, String updatedMultisigHex, PaymentSentMessage paymentSentMessage) {
        this(dispute, senderNodeAddress, uid, Version.getP2PMessageVersion(), supportType, updatedMultisigHex, paymentSentMessage);
    }

    private DisputeOpenedMessage(Dispute dispute, NodeAddress senderNodeAddress, String uid, String messageVersion, SupportType supportType, String updatedMultisigHex, PaymentSentMessage paymentSentMessage) {
        super(messageVersion, uid, supportType);
        this.dispute = dispute;
        this.senderNodeAddress = senderNodeAddress;
        this.openerUpdatedMultisigHex = updatedMultisigHex;
        this.paymentSentMessage = paymentSentMessage;
    }

    @Override
    public NetworkEnvelope toProtoNetworkEnvelope() {
        DisputeOpenedMessage.Builder builder = protobuf.DisputeOpenedMessage.newBuilder().setUid(this.uid).setDispute(this.dispute.toProtoMessage()).setSenderNodeAddress(this.senderNodeAddress.toProtoMessage()).setType(SupportType.toProtoMessage(this.supportType)).setOpenerUpdatedMultisigHex(this.openerUpdatedMultisigHex);
        Optional.ofNullable(this.paymentSentMessage).ifPresent(e -> builder.setPaymentSentMessage(this.paymentSentMessage.toProtoNetworkEnvelope().getPaymentSentMessage()));
        return this.getNetworkEnvelopeBuilder().setDisputeOpenedMessage(builder).build();
    }

    public static DisputeOpenedMessage fromProto(protobuf.DisputeOpenedMessage proto, CoreProtoResolver coreProtoResolver, String messageVersion) {
        return new DisputeOpenedMessage(Dispute.fromProto(proto.getDispute(), coreProtoResolver), NodeAddress.fromProto(proto.getSenderNodeAddress()), proto.getUid(), messageVersion, SupportType.fromProto(proto.getType()), ProtoUtil.stringOrNullFromProto(proto.getOpenerUpdatedMultisigHex()), proto.hasPaymentSentMessage() ? PaymentSentMessage.fromProto(proto.getPaymentSentMessage(), messageVersion) : null);
    }

    @Override
    public String getTradeId() {
        return this.dispute.getTradeId();
    }

    @Override
    public String toString() {
        return "DisputeOpenedMessage{\n     dispute=" + String.valueOf(this.dispute) + ",\n     senderNodeAddress=" + String.valueOf(this.senderNodeAddress) + ",\n     DisputeOpenedMessage.uid='" + this.uid + "',\n     messageVersion=" + this.messageVersion + ",\n     supportType=" + String.valueOf((Object)this.supportType) + ",\n     openerUpdatedMultisigHex=" + this.openerUpdatedMultisigHex + ",\n     paymentSentMessage=" + String.valueOf(this.paymentSentMessage) + "\n} " + super.toString();
    }

    public Dispute getDispute() {
        return this.dispute;
    }

    @Override
    public NodeAddress getSenderNodeAddress() {
        return this.senderNodeAddress;
    }

    public String getOpenerUpdatedMultisigHex() {
        return this.openerUpdatedMultisigHex;
    }

    public PaymentSentMessage getPaymentSentMessage() {
        return this.paymentSentMessage;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisputeOpenedMessage)) {
            return false;
        }
        DisputeOpenedMessage other = (DisputeOpenedMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Dispute this$dispute = this.getDispute();
        Dispute other$dispute = other.getDispute();
        if (this$dispute == null ? other$dispute != null : !((Object)this$dispute).equals(other$dispute)) {
            return false;
        }
        NodeAddress this$senderNodeAddress = this.getSenderNodeAddress();
        NodeAddress other$senderNodeAddress = other.getSenderNodeAddress();
        if (this$senderNodeAddress == null ? other$senderNodeAddress != null : !((Object)this$senderNodeAddress).equals(other$senderNodeAddress)) {
            return false;
        }
        String this$openerUpdatedMultisigHex = this.getOpenerUpdatedMultisigHex();
        String other$openerUpdatedMultisigHex = other.getOpenerUpdatedMultisigHex();
        if (this$openerUpdatedMultisigHex == null ? other$openerUpdatedMultisigHex != null : !this$openerUpdatedMultisigHex.equals(other$openerUpdatedMultisigHex)) {
            return false;
        }
        PaymentSentMessage this$paymentSentMessage = this.getPaymentSentMessage();
        PaymentSentMessage other$paymentSentMessage = other.getPaymentSentMessage();
        return !(this$paymentSentMessage == null ? other$paymentSentMessage != null : !((Object)this$paymentSentMessage).equals(other$paymentSentMessage));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DisputeOpenedMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Dispute $dispute = this.getDispute();
        result = result * 59 + ($dispute == null ? 43 : ((Object)$dispute).hashCode());
        NodeAddress $senderNodeAddress = this.getSenderNodeAddress();
        result = result * 59 + ($senderNodeAddress == null ? 43 : ((Object)$senderNodeAddress).hashCode());
        String $openerUpdatedMultisigHex = this.getOpenerUpdatedMultisigHex();
        result = result * 59 + ($openerUpdatedMultisigHex == null ? 43 : $openerUpdatedMultisigHex.hashCode());
        PaymentSentMessage $paymentSentMessage = this.getPaymentSentMessage();
        result = result * 59 + ($paymentSentMessage == null ? 43 : ((Object)$paymentSentMessage).hashCode());
        return result;
    }
}

