/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.refund;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import haveno.common.proto.ProtoUtil;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.support.SupportType;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.PersistableEnvelope;

public final class RefundDisputeList
extends DisputeList<Dispute> {
    private static final Logger log = LoggerFactory.getLogger(RefundDisputeList.class);

    RefundDisputeList() {
    }

    protected RefundDisputeList(Collection<Dispute> collection) {
        super(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message toProtoMessage() {
        this.forEach(dispute -> Preconditions.checkArgument(dispute.getSupportType().equals((Object)SupportType.REFUND), "Support type has to be REFUND"));
        List list = this.getList();
        synchronized (list) {
            return PersistableEnvelope.newBuilder().setRefundDisputeList(protobuf.RefundDisputeList.newBuilder().addAllDispute(ProtoUtil.collectionToProto(this.getList(), protobuf.Dispute.class))).build();
        }
    }

    public static RefundDisputeList fromProto(protobuf.RefundDisputeList proto, CoreProtoResolver coreProtoResolver) {
        List<Dispute> list = proto.getDisputeList().stream().map(disputeProto -> Dispute.fromProto(disputeProto, coreProtoResolver)).filter(e -> e.getSupportType().equals((Object)SupportType.REFUND)).collect(Collectors.toList());
        return new RefundDisputeList((Collection<Dispute>)list);
    }

    @Override
    public String toString() {
        return "RefundDisputeList()";
    }
}

