/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.refund.refundagent;

import com.google.protobuf.ByteString;
import haveno.common.app.Capabilities;
import haveno.common.app.Capability;
import haveno.common.crypto.PubKeyRing;
import haveno.common.proto.ProtoUtil;
import haveno.common.util.CollectionUtils;
import haveno.core.support.dispute.agent.DisputeAgent;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.storage.payload.CapabilityRequiringPayload;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.RefundAgent;
import protobuf.StoragePayload;

public final class RefundAgent
extends DisputeAgent
implements CapabilityRequiringPayload {
    private static final Logger log = LoggerFactory.getLogger(RefundAgent.class);

    public RefundAgent(NodeAddress nodeAddress, PubKeyRing pubKeyRing, List<String> languageCodes, long registrationDate, byte[] registrationPubKey, String registrationSignature, @Nullable String emailAddress, @Nullable String info, @Nullable Map<String, String> extraDataMap) {
        super(nodeAddress, pubKeyRing, languageCodes, registrationDate, registrationPubKey, registrationSignature, emailAddress, info, extraDataMap);
    }

    @Override
    public StoragePayload toProtoMessage() {
        RefundAgent.Builder builder = protobuf.RefundAgent.newBuilder().setNodeAddress(this.nodeAddress.toProtoMessage()).setPubKeyRing(this.pubKeyRing.toProtoMessage()).addAllLanguageCodes(this.languageCodes).setRegistrationDate(this.registrationDate).setRegistrationPubKey(ByteString.copyFrom(this.registrationPubKey)).setRegistrationSignature(this.registrationSignature);
        Optional.ofNullable(this.emailAddress).ifPresent(builder::setEmailAddress);
        Optional.ofNullable(this.info).ifPresent(builder::setInfo);
        Optional.ofNullable(this.extraDataMap).ifPresent(builder::putAllExtraData);
        return StoragePayload.newBuilder().setRefundAgent(builder).build();
    }

    public static RefundAgent fromProto(protobuf.RefundAgent proto) {
        return new RefundAgent(NodeAddress.fromProto(proto.getNodeAddress()), PubKeyRing.fromProto(proto.getPubKeyRing()), new ArrayList<String>(proto.getLanguageCodesList()), proto.getRegistrationDate(), proto.getRegistrationPubKey().toByteArray(), proto.getRegistrationSignature(), ProtoUtil.stringOrNullFromProto(proto.getEmailAddress()), ProtoUtil.stringOrNullFromProto(proto.getInfo()), CollectionUtils.isEmpty(proto.getExtraDataMap()) ? null : proto.getExtraDataMap());
    }

    @Override
    public String toString() {
        return "RefundAgent{} " + super.toString();
    }

    @Override
    public Capabilities getRequiredCapabilities() {
        return new Capabilities(Capability.REFUND_AGENT);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RefundAgent)) {
            return false;
        }
        RefundAgent other = (RefundAgent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RefundAgent;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

