/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.traderchat;

import haveno.core.support.SupportSession;
import haveno.core.support.messages.ChatMessage;
import haveno.core.trade.Trade;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradeChatSession
extends SupportSession {
    private static final Logger log = LoggerFactory.getLogger(TradeChatSession.class);
    @Nullable
    private Trade trade;

    public TradeChatSession(@Nullable Trade trade, boolean isClient) {
        super(isClient);
        this.trade = trade;
    }

    @Override
    public String getTradeId() {
        return this.trade != null ? this.trade.getId() : "";
    }

    @Override
    public int getClientId() {
        try {
            return this.trade.getContract().getTakerPubKeyRing().hashCode();
        }
        catch (NullPointerException e) {
            log.warn("Unable to get takerPubKeyRing from Trade Contract - {}", (Object)e.toString());
            return 0;
        }
    }

    @Override
    public ObservableList<ChatMessage> getObservableChatMessageList() {
        return this.trade != null ? this.trade.getChatMessages() : FXCollections.observableArrayList();
    }

    @Override
    public boolean chatIsOpen() {
        return this.trade != null && !this.trade.isCompleted();
    }

    @Override
    public boolean isDisputeAgent() {
        return false;
    }
}

