/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.traderchat;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.crypto.PubKeyRing;
import haveno.common.crypto.PubKeyRingProvider;
import haveno.core.api.CoreNotificationService;
import haveno.core.api.XmrConnectionService;
import haveno.core.locale.Res;
import haveno.core.support.SupportManager;
import haveno.core.support.SupportType;
import haveno.core.support.messages.ChatMessage;
import haveno.core.support.messages.SupportMessage;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.AckMessageSourceType;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import java.util.List;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TraderChatManager
extends SupportManager {
    private static final Logger log = LoggerFactory.getLogger(TraderChatManager.class);
    private final PubKeyRingProvider pubKeyRingProvider;

    @Inject
    public TraderChatManager(P2PService p2PService, XmrConnectionService xmrConnectionService, XmrWalletService xmrWalletService, CoreNotificationService notificationService, TradeManager tradeManager, PubKeyRingProvider pubKeyRingProvider) {
        super(p2PService, xmrConnectionService, xmrWalletService, notificationService, tradeManager);
        this.pubKeyRingProvider = pubKeyRingProvider;
    }

    @Override
    public SupportType getSupportType() {
        return SupportType.TRADE;
    }

    @Override
    public void requestPersistence() {
        this.tradeManager.requestPersistence();
    }

    @Override
    public NodeAddress getPeerNodeAddress(ChatMessage message) {
        return this.tradeManager.getOpenTrade(message.getTradeId()).map(trade -> {
            if (trade.getContract() != null) {
                return trade.getContract().getPeersNodeAddress(this.pubKeyRingProvider.get());
            }
            return null;
        }).orElse(null);
    }

    @Override
    public PubKeyRing getPeerPubKeyRing(ChatMessage message) {
        return this.tradeManager.getOpenTrade(message.getTradeId()).map(trade -> {
            if (trade.getContract() != null) {
                return trade.getContract().getPeersPubKeyRing(this.pubKeyRingProvider.get());
            }
            return null;
        }).orElse(null);
    }

    @Override
    public List<ChatMessage> getAllChatMessages(String tradeId) {
        return Optional.of(this.tradeManager.getTrade(tradeId)).map(Trade::getChatMessages).orElse(FXCollections.emptyObservableList());
    }

    @Override
    public boolean channelOpen(ChatMessage message) {
        return this.tradeManager.getOpenTrade(message.getTradeId()).isPresent();
    }

    @Override
    public void addAndPersistChatMessage(ChatMessage message) {
        this.tradeManager.getOpenTrade(message.getTradeId()).ifPresent(trade -> {
            ObservableList<ChatMessage> chatMessages = trade.getChatMessages();
            if (chatMessages.stream().noneMatch(m4 -> m4.getUid().equals(message.getUid()))) {
                if (chatMessages.isEmpty()) {
                    this.addSystemMsg((Trade)trade);
                }
                trade.addAndPersistChatMessage(message);
                this.tradeManager.requestPersistence();
            } else {
                log.warn("Trade got a chatMessage that we have already stored. UId = {} TradeId = {}", (Object)message.getUid(), (Object)message.getTradeId());
            }
        });
    }

    @Override
    protected AckMessageSourceType getAckMessageSourceType() {
        return AckMessageSourceType.TRADE_CHAT_MESSAGE;
    }

    @Override
    public void onAllServicesInitialized() {
        super.onAllServicesInitialized();
        this.tryApplyMessages();
    }

    @Override
    public void onSupportMessage(SupportMessage message) {
        if (this.canProcessMessage(message)) {
            log.info("Received {} with tradeId {} and uid {}", message.getClass().getSimpleName(), message.getTradeId(), message.getUid());
            if (message instanceof ChatMessage) {
                this.handleChatMessage((ChatMessage)message);
            } else {
                log.warn("Unsupported message at dispatchMessage. message={}", (Object)message);
            }
        }
    }

    public void addSystemMsg(Trade trade) {
        ChatMessage chatMessage = new ChatMessage(this.getSupportType(), trade.getId(), 0, false, Res.get("tradeChat.rules"), new NodeAddress("null:0000"), trade.getDate().getTime());
        chatMessage.setSystemMessage(true);
        trade.getChatMessages().add(chatMessage);
        this.requestPersistence();
    }
}

