/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import haveno.common.proto.ProtoUtil;
import haveno.core.offer.Offer;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.trade.BuyerTrade;
import haveno.core.trade.MakerTrade;
import haveno.core.trade.Tradable;
import haveno.core.trade.protocol.ProcessModel;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.NodeAddress;
import java.math.BigInteger;
import java.util.UUID;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.Trade;

public final class BuyerAsMakerTrade
extends BuyerTrade
implements MakerTrade {
    private static final Logger log = LoggerFactory.getLogger(BuyerAsMakerTrade.class);

    public BuyerAsMakerTrade(Offer offer, BigInteger tradeAmount, long tradePrice, XmrWalletService xmrWalletService, ProcessModel processModel, String uid, NodeAddress makerNodeAddress, NodeAddress takerNodeAddress, NodeAddress arbitratorNodeAddress, @Nullable String challenge) {
        super(offer, tradeAmount, tradePrice, xmrWalletService, processModel, uid, makerNodeAddress, takerNodeAddress, arbitratorNodeAddress, challenge);
    }

    @Override
    public protobuf.Tradable toProtoMessage() {
        return protobuf.Tradable.newBuilder().setBuyerAsMakerTrade(protobuf.BuyerAsMakerTrade.newBuilder().setTrade((Trade)super.toProtoMessage())).build();
    }

    public static Tradable fromProto(protobuf.BuyerAsMakerTrade buyerAsMakerTradeProto, XmrWalletService xmrWalletService, CoreProtoResolver coreProtoResolver) {
        Trade proto = buyerAsMakerTradeProto.getTrade();
        ProcessModel processModel = ProcessModel.fromProto(proto.getProcessModel(), coreProtoResolver);
        String uid = ProtoUtil.stringOrNullFromProto(proto.getUid());
        if (uid == null) {
            uid = UUID.randomUUID().toString();
        }
        BuyerAsMakerTrade trade = new BuyerAsMakerTrade(Offer.fromProto(proto.getOffer()), BigInteger.valueOf(proto.getAmount()), proto.getPrice(), xmrWalletService, processModel, uid, proto.getProcessModel().getMaker().hasNodeAddress() ? NodeAddress.fromProto(proto.getProcessModel().getMaker().getNodeAddress()) : null, proto.getProcessModel().getTaker().hasNodeAddress() ? NodeAddress.fromProto(proto.getProcessModel().getTaker().getNodeAddress()) : null, proto.getProcessModel().getArbitrator().hasNodeAddress() ? NodeAddress.fromProto(proto.getProcessModel().getArbitrator().getNodeAddress()) : null, ProtoUtil.stringOrNullFromProto(proto.getChallenge()));
        trade.setPrice(proto.getPrice());
        return BuyerAsMakerTrade.fromProto(trade, proto, coreProtoResolver);
    }
}

