/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import com.google.common.base.Preconditions;
import haveno.core.offer.Offer;
import haveno.core.trade.Trade;
import haveno.core.trade.protocol.ProcessModel;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.NodeAddress;
import java.math.BigInteger;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BuyerTrade
extends Trade {
    private static final Logger log = LoggerFactory.getLogger(BuyerTrade.class);

    BuyerTrade(Offer offer, BigInteger tradeAmount, long tradePrice, XmrWalletService xmrWalletService, ProcessModel processModel, String uid, @Nullable NodeAddress takerNodeAddress, @Nullable NodeAddress makerNodeAddress, @Nullable NodeAddress arbitratorNodeAddress, @Nullable String challenge) {
        super(offer, tradeAmount, tradePrice, xmrWalletService, processModel, uid, takerNodeAddress, makerNodeAddress, arbitratorNodeAddress, challenge);
    }

    @Override
    public BigInteger getPayoutAmountBeforeCost() {
        Preconditions.checkNotNull(this.getAmount(), "Invalid state: getTradeAmount() = null");
        return this.getAmount().add(this.getBuyerSecurityDepositBeforeMiningFee());
    }

    @Override
    public boolean confirmPermitted() {
        return true;
    }
}

