/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import haveno.core.offer.OpenOffer;
import haveno.core.trade.Tradable;
import haveno.core.trade.Trade;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClosedTradableUtil {
    public static BigInteger getTotalAmount(List<Tradable> tradableList) {
        return BigInteger.valueOf(tradableList.stream().flatMap(tradable -> tradable.getOptionalAmount().stream()).mapToLong(value -> value.longValueExact()).sum());
    }

    public static BigInteger getTotalTxFee(List<Tradable> tradableList) {
        return BigInteger.valueOf(tradableList.stream().mapToLong(tradable -> ClosedTradableUtil.getTotalTxFee(tradable).longValueExact()).sum());
    }

    public static Map<String, Long> getTotalVolumeByCurrency(List<Tradable> tradableList) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        tradableList.stream().filter(tradable -> {
            if (tradable instanceof Trade) {
                Trade trade = ClosedTradableUtil.castToTrade(tradable);
                return trade.isCompleted();
            }
            return false;
        }).flatMap(tradable -> tradable.getOptionalVolume().stream()).forEach(volume -> {
            String currencyCode = volume.getCurrencyCode();
            map.putIfAbsent(currencyCode, 0L);
            map.put(currencyCode, volume.getValue() + (Long)map.get(currencyCode));
        });
        return map;
    }

    public static BigInteger getTotalTxFee(Tradable tradable) {
        return tradable.getTotalTxFee();
    }

    public static boolean isOpenOffer(Tradable tradable) {
        return tradable instanceof OpenOffer;
    }

    public static boolean isHavenoV1Trade(Tradable tradable) {
        return tradable instanceof Trade;
    }

    public static Trade castToTrade(Tradable tradable) {
        return (Trade)tradable;
    }

    public static Trade castToTradeModel(Tradable tradable) {
        return (Trade)tradable;
    }
}

