/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import haveno.common.crypto.PubKeyRing;
import haveno.common.proto.ProtoUtil;
import haveno.common.proto.network.NetworkPayload;
import haveno.common.util.JsonExclude;
import haveno.common.util.Utilities;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.OfferPayload;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.util.JsonUtil;
import haveno.core.util.VolumeUtil;
import haveno.network.p2p.NodeAddress;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.Contract;

public final class Contract
implements NetworkPayload {
    private static final Logger log = LoggerFactory.getLogger(Contract.class);
    private final OfferPayload offerPayload;
    private final long tradeAmount;
    private final long tradePrice;
    private final NodeAddress buyerNodeAddress;
    private final NodeAddress sellerNodeAddress;
    private final NodeAddress arbitratorNodeAddress;
    private final boolean isBuyerMakerAndSellerTaker;
    private final String makerAccountId;
    private final String takerAccountId;
    private final String makerPaymentMethodId;
    private final String takerPaymentMethodId;
    private final byte[] makerPaymentAccountPayloadHash;
    private final byte[] takerPaymentAccountPayloadHash;
    @JsonExclude
    private final PubKeyRing makerPubKeyRing;
    @JsonExclude
    private final PubKeyRing takerPubKeyRing;
    private final String makerPayoutAddressString;
    private final String takerPayoutAddressString;
    private final String makerDepositTxHash;
    @Nullable
    private final String takerDepositTxHash;

    public Contract(OfferPayload offerPayload, long tradeAmount, long tradePrice, NodeAddress buyerNodeAddress, NodeAddress sellerNodeAddress, NodeAddress arbitratorNodeAddress, boolean isBuyerMakerAndSellerTaker, String makerAccountId, String takerAccountId, String makerPaymentMethodId, String takerPaymentMethodId, byte[] makerPaymentAccountPayloadHash, byte[] takerPaymentAccountPayloadHash, PubKeyRing makerPubKeyRing, PubKeyRing takerPubKeyRing, String makerPayoutAddressString, String takerPayoutAddressString, String makerDepositTxHash, @Nullable String takerDepositTxHash) {
        this.offerPayload = offerPayload;
        this.tradeAmount = tradeAmount;
        this.tradePrice = tradePrice;
        this.buyerNodeAddress = buyerNodeAddress;
        this.sellerNodeAddress = sellerNodeAddress;
        this.arbitratorNodeAddress = arbitratorNodeAddress;
        this.isBuyerMakerAndSellerTaker = isBuyerMakerAndSellerTaker;
        this.makerAccountId = makerAccountId;
        this.takerAccountId = takerAccountId;
        this.makerPaymentMethodId = makerPaymentMethodId;
        this.takerPaymentMethodId = takerPaymentMethodId;
        this.makerPaymentAccountPayloadHash = makerPaymentAccountPayloadHash;
        this.takerPaymentAccountPayloadHash = takerPaymentAccountPayloadHash;
        this.makerPubKeyRing = makerPubKeyRing;
        this.takerPubKeyRing = takerPubKeyRing;
        this.makerPayoutAddressString = makerPayoutAddressString;
        this.takerPayoutAddressString = takerPayoutAddressString;
        this.makerDepositTxHash = makerDepositTxHash;
        this.takerDepositTxHash = takerDepositTxHash;
        boolean result = makerPaymentMethodId.equals("SEPA") && takerPaymentMethodId.equals("SEPA_INSTANT") || makerPaymentMethodId.equals(takerPaymentMethodId);
        Preconditions.checkArgument(result, "payment methods of maker and taker must be the same.\nmakerPaymentMethodId=" + makerPaymentMethodId + "\ntakerPaymentMethodId=" + takerPaymentMethodId);
    }

    @Override
    public protobuf.Contract toProtoMessage() {
        Contract.Builder builder = protobuf.Contract.newBuilder().setOfferPayload(this.offerPayload.toProtoMessage().getOfferPayload()).setTradeAmount(this.tradeAmount).setTradePrice(this.tradePrice).setBuyerNodeAddress(this.buyerNodeAddress.toProtoMessage()).setSellerNodeAddress(this.sellerNodeAddress.toProtoMessage()).setArbitratorNodeAddress(this.arbitratorNodeAddress.toProtoMessage()).setIsBuyerMakerAndSellerTaker(this.isBuyerMakerAndSellerTaker).setMakerAccountId(this.makerAccountId).setTakerAccountId(this.takerAccountId).setMakerPaymentMethodId(this.makerPaymentMethodId).setTakerPaymentMethodId(this.takerPaymentMethodId).setMakerPaymentAccountPayloadHash(ByteString.copyFrom(this.makerPaymentAccountPayloadHash)).setTakerPaymentAccountPayloadHash(ByteString.copyFrom(this.takerPaymentAccountPayloadHash)).setMakerPubKeyRing(this.makerPubKeyRing.toProtoMessage()).setTakerPubKeyRing(this.takerPubKeyRing.toProtoMessage()).setMakerPayoutAddressString(this.makerPayoutAddressString).setTakerPayoutAddressString(this.takerPayoutAddressString).setMakerDepositTxHash(this.makerDepositTxHash);
        Optional.ofNullable(this.takerDepositTxHash).ifPresent(builder::setTakerDepositTxHash);
        return builder.build();
    }

    public static Contract fromProto(protobuf.Contract proto, CoreProtoResolver coreProtoResolver) {
        return new Contract(OfferPayload.fromProto(proto.getOfferPayload()), proto.getTradeAmount(), proto.getTradePrice(), NodeAddress.fromProto(proto.getBuyerNodeAddress()), NodeAddress.fromProto(proto.getSellerNodeAddress()), NodeAddress.fromProto(proto.getArbitratorNodeAddress()), proto.getIsBuyerMakerAndSellerTaker(), proto.getMakerAccountId(), proto.getTakerAccountId(), proto.getMakerPaymentMethodId(), proto.getTakerPaymentMethodId(), proto.getMakerPaymentAccountPayloadHash().toByteArray(), proto.getTakerPaymentAccountPayloadHash().toByteArray(), PubKeyRing.fromProto(proto.getMakerPubKeyRing()), PubKeyRing.fromProto(proto.getTakerPubKeyRing()), proto.getMakerPayoutAddressString(), proto.getTakerPayoutAddressString(), proto.getMakerDepositTxHash(), ProtoUtil.stringOrNullFromProto(proto.getTakerDepositTxHash()));
    }

    public String getBuyerPayoutAddressString() {
        return this.isBuyerMakerAndSellerTaker ? this.makerPayoutAddressString : this.takerPayoutAddressString;
    }

    public String getSellerPayoutAddressString() {
        return this.isBuyerMakerAndSellerTaker ? this.takerPayoutAddressString : this.makerPayoutAddressString;
    }

    public PubKeyRing getBuyerPubKeyRing() {
        return this.isBuyerMakerAndSellerTaker ? this.makerPubKeyRing : this.takerPubKeyRing;
    }

    public PubKeyRing getSellerPubKeyRing() {
        return this.isBuyerMakerAndSellerTaker ? this.takerPubKeyRing : this.makerPubKeyRing;
    }

    public byte[] getBuyerPaymentAccountPayloadHash() {
        return this.isBuyerMakerAndSellerTaker ? this.makerPaymentAccountPayloadHash : this.takerPaymentAccountPayloadHash;
    }

    public byte[] getSellerPaymentAccountPayloadHash() {
        return this.isBuyerMakerAndSellerTaker ? this.takerPaymentAccountPayloadHash : this.makerPaymentAccountPayloadHash;
    }

    public String getPaymentMethodId() {
        return this.makerPaymentMethodId;
    }

    public BigInteger getTradeAmount() {
        return BigInteger.valueOf(this.tradeAmount);
    }

    public Volume getTradeVolume() {
        Volume volumeByAmount = this.getPrice().getVolumeByAmount(this.getTradeAmount());
        volumeByAmount = VolumeUtil.getAdjustedVolume(volumeByAmount, this.getPaymentMethodId());
        return volumeByAmount;
    }

    public Price getPrice() {
        return Price.valueOf(this.offerPayload.getCurrencyCode(), this.tradePrice);
    }

    public NodeAddress getMyNodeAddress(PubKeyRing myPubKeyRing) {
        if (myPubKeyRing.equals(this.getBuyerPubKeyRing())) {
            return this.buyerNodeAddress;
        }
        return this.sellerNodeAddress;
    }

    public NodeAddress getPeersNodeAddress(PubKeyRing myPubKeyRing) {
        if (myPubKeyRing.equals(this.getSellerPubKeyRing())) {
            return this.buyerNodeAddress;
        }
        return this.sellerNodeAddress;
    }

    public PubKeyRing getPeersPubKeyRing(PubKeyRing myPubKeyRing) {
        if (myPubKeyRing.equals(this.getSellerPubKeyRing())) {
            return this.getBuyerPubKeyRing();
        }
        return this.getSellerPubKeyRing();
    }

    public boolean isMyRoleBuyer(PubKeyRing myPubKeyRing) {
        return this.getBuyerPubKeyRing().equals(myPubKeyRing);
    }

    public boolean isMyRoleMaker(PubKeyRing myPubKeyRing) {
        return this.isBuyerMakerAndSellerTaker() == this.isMyRoleBuyer(myPubKeyRing);
    }

    public boolean maybeClearSensitiveData() {
        return false;
    }

    public static String sanitizeContractAsJson(String contractAsJson) {
        return contractAsJson.replaceAll("\"takerPaymentAccountPayload\": \\{[^}]*}", "\"takerPaymentAccountPayload\": null").replaceAll("\"makerPaymentAccountPayload\": \\{[^}]*}", "\"makerPaymentAccountPayload\": null");
    }

    public void printDiff(@Nullable String peersContractAsJson) {
        String json = JsonUtil.objectToJson(this);
        String diff = StringUtils.difference(json, peersContractAsJson);
        if (!diff.isEmpty()) {
            log.warn("Diff of both contracts: \n" + diff);
            log.warn("\n\n------------------------------------------------------------\nContract as json\n" + json + "\n------------------------------------------------------------\n");
            log.warn("\n\n------------------------------------------------------------\nPeers contract as json\n" + peersContractAsJson + "\n------------------------------------------------------------\n");
        } else {
            log.debug("Both contracts are the same");
        }
    }

    public String toString() {
        return "Contract{\n     offerPayload=" + String.valueOf(this.offerPayload) + ",\n     tradeAmount=" + this.tradeAmount + ",\n     tradePrice=" + this.tradePrice + ",\n     buyerNodeAddress=" + String.valueOf(this.buyerNodeAddress) + ",\n     sellerNodeAddress=" + String.valueOf(this.sellerNodeAddress) + ",\n     arbitratorNodeAddress=" + String.valueOf(this.arbitratorNodeAddress) + ",\n     isBuyerMakerAndSellerTaker=" + this.isBuyerMakerAndSellerTaker + ",\n     makerAccountId='" + this.makerAccountId + "',\n     takerAccountId='" + this.takerAccountId + "',\n     makerPaymentMethodId='" + this.makerPaymentMethodId + "',\n     takerPaymentMethodId='" + this.takerPaymentMethodId + "',\n     makerPaymentAccountPayloadHash=" + Utilities.bytesAsHexString(this.makerPaymentAccountPayloadHash) + ",\n     takerPaymentAccountPayloadHash=" + Utilities.bytesAsHexString(this.takerPaymentAccountPayloadHash) + ",\n     makerPubKeyRing=" + String.valueOf(this.makerPubKeyRing) + ",\n     takerPubKeyRing=" + String.valueOf(this.takerPubKeyRing) + ",\n     makerPayoutAddressString='" + this.makerPayoutAddressString + "',\n     takerPayoutAddressString='" + this.takerPayoutAddressString + "',\n     makerDepositTxHash='" + this.makerDepositTxHash + "',\n     takerDepositTxHash='" + this.takerDepositTxHash + "'\n}";
    }

    public OfferPayload getOfferPayload() {
        return this.offerPayload;
    }

    public long getTradePrice() {
        return this.tradePrice;
    }

    public NodeAddress getBuyerNodeAddress() {
        return this.buyerNodeAddress;
    }

    public NodeAddress getSellerNodeAddress() {
        return this.sellerNodeAddress;
    }

    public NodeAddress getArbitratorNodeAddress() {
        return this.arbitratorNodeAddress;
    }

    public boolean isBuyerMakerAndSellerTaker() {
        return this.isBuyerMakerAndSellerTaker;
    }

    public String getMakerAccountId() {
        return this.makerAccountId;
    }

    public String getTakerAccountId() {
        return this.takerAccountId;
    }

    public String getMakerPaymentMethodId() {
        return this.makerPaymentMethodId;
    }

    public String getTakerPaymentMethodId() {
        return this.takerPaymentMethodId;
    }

    public byte[] getMakerPaymentAccountPayloadHash() {
        return this.makerPaymentAccountPayloadHash;
    }

    public byte[] getTakerPaymentAccountPayloadHash() {
        return this.takerPaymentAccountPayloadHash;
    }

    public PubKeyRing getMakerPubKeyRing() {
        return this.makerPubKeyRing;
    }

    public PubKeyRing getTakerPubKeyRing() {
        return this.takerPubKeyRing;
    }

    public String getMakerPayoutAddressString() {
        return this.makerPayoutAddressString;
    }

    public String getTakerPayoutAddressString() {
        return this.takerPayoutAddressString;
    }

    public String getMakerDepositTxHash() {
        return this.makerDepositTxHash;
    }

    @Nullable
    public String getTakerDepositTxHash() {
        return this.takerDepositTxHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Contract)) {
            return false;
        }
        Contract other = (Contract)o;
        BigInteger this$tradeAmount = this.getTradeAmount();
        BigInteger other$tradeAmount = other.getTradeAmount();
        if (this$tradeAmount == null ? other$tradeAmount != null : !((Object)this$tradeAmount).equals(other$tradeAmount)) {
            return false;
        }
        if (this.getTradePrice() != other.getTradePrice()) {
            return false;
        }
        if (this.isBuyerMakerAndSellerTaker() != other.isBuyerMakerAndSellerTaker()) {
            return false;
        }
        OfferPayload this$offerPayload = this.getOfferPayload();
        OfferPayload other$offerPayload = other.getOfferPayload();
        if (this$offerPayload == null ? other$offerPayload != null : !((Object)this$offerPayload).equals(other$offerPayload)) {
            return false;
        }
        NodeAddress this$buyerNodeAddress = this.getBuyerNodeAddress();
        NodeAddress other$buyerNodeAddress = other.getBuyerNodeAddress();
        if (this$buyerNodeAddress == null ? other$buyerNodeAddress != null : !((Object)this$buyerNodeAddress).equals(other$buyerNodeAddress)) {
            return false;
        }
        NodeAddress this$sellerNodeAddress = this.getSellerNodeAddress();
        NodeAddress other$sellerNodeAddress = other.getSellerNodeAddress();
        if (this$sellerNodeAddress == null ? other$sellerNodeAddress != null : !((Object)this$sellerNodeAddress).equals(other$sellerNodeAddress)) {
            return false;
        }
        NodeAddress this$arbitratorNodeAddress = this.getArbitratorNodeAddress();
        NodeAddress other$arbitratorNodeAddress = other.getArbitratorNodeAddress();
        if (this$arbitratorNodeAddress == null ? other$arbitratorNodeAddress != null : !((Object)this$arbitratorNodeAddress).equals(other$arbitratorNodeAddress)) {
            return false;
        }
        String this$makerAccountId = this.getMakerAccountId();
        String other$makerAccountId = other.getMakerAccountId();
        if (this$makerAccountId == null ? other$makerAccountId != null : !this$makerAccountId.equals(other$makerAccountId)) {
            return false;
        }
        String this$takerAccountId = this.getTakerAccountId();
        String other$takerAccountId = other.getTakerAccountId();
        if (this$takerAccountId == null ? other$takerAccountId != null : !this$takerAccountId.equals(other$takerAccountId)) {
            return false;
        }
        String this$makerPaymentMethodId = this.getMakerPaymentMethodId();
        String other$makerPaymentMethodId = other.getMakerPaymentMethodId();
        if (this$makerPaymentMethodId == null ? other$makerPaymentMethodId != null : !this$makerPaymentMethodId.equals(other$makerPaymentMethodId)) {
            return false;
        }
        String this$takerPaymentMethodId = this.getTakerPaymentMethodId();
        String other$takerPaymentMethodId = other.getTakerPaymentMethodId();
        if (this$takerPaymentMethodId == null ? other$takerPaymentMethodId != null : !this$takerPaymentMethodId.equals(other$takerPaymentMethodId)) {
            return false;
        }
        if (!Arrays.equals(this.getMakerPaymentAccountPayloadHash(), other.getMakerPaymentAccountPayloadHash())) {
            return false;
        }
        if (!Arrays.equals(this.getTakerPaymentAccountPayloadHash(), other.getTakerPaymentAccountPayloadHash())) {
            return false;
        }
        PubKeyRing this$makerPubKeyRing = this.getMakerPubKeyRing();
        PubKeyRing other$makerPubKeyRing = other.getMakerPubKeyRing();
        if (this$makerPubKeyRing == null ? other$makerPubKeyRing != null : !((Object)this$makerPubKeyRing).equals(other$makerPubKeyRing)) {
            return false;
        }
        PubKeyRing this$takerPubKeyRing = this.getTakerPubKeyRing();
        PubKeyRing other$takerPubKeyRing = other.getTakerPubKeyRing();
        if (this$takerPubKeyRing == null ? other$takerPubKeyRing != null : !((Object)this$takerPubKeyRing).equals(other$takerPubKeyRing)) {
            return false;
        }
        String this$makerPayoutAddressString = this.getMakerPayoutAddressString();
        String other$makerPayoutAddressString = other.getMakerPayoutAddressString();
        if (this$makerPayoutAddressString == null ? other$makerPayoutAddressString != null : !this$makerPayoutAddressString.equals(other$makerPayoutAddressString)) {
            return false;
        }
        String this$takerPayoutAddressString = this.getTakerPayoutAddressString();
        String other$takerPayoutAddressString = other.getTakerPayoutAddressString();
        if (this$takerPayoutAddressString == null ? other$takerPayoutAddressString != null : !this$takerPayoutAddressString.equals(other$takerPayoutAddressString)) {
            return false;
        }
        String this$makerDepositTxHash = this.getMakerDepositTxHash();
        String other$makerDepositTxHash = other.getMakerDepositTxHash();
        if (this$makerDepositTxHash == null ? other$makerDepositTxHash != null : !this$makerDepositTxHash.equals(other$makerDepositTxHash)) {
            return false;
        }
        String this$takerDepositTxHash = this.getTakerDepositTxHash();
        String other$takerDepositTxHash = other.getTakerDepositTxHash();
        return !(this$takerDepositTxHash == null ? other$takerDepositTxHash != null : !this$takerDepositTxHash.equals(other$takerDepositTxHash));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $tradeAmount = this.getTradeAmount();
        result = result * 59 + ($tradeAmount == null ? 43 : ((Object)$tradeAmount).hashCode());
        long $tradePrice = this.getTradePrice();
        result = result * 59 + (int)($tradePrice >>> 32 ^ $tradePrice);
        result = result * 59 + (this.isBuyerMakerAndSellerTaker() ? 79 : 97);
        OfferPayload $offerPayload = this.getOfferPayload();
        result = result * 59 + ($offerPayload == null ? 43 : ((Object)$offerPayload).hashCode());
        NodeAddress $buyerNodeAddress = this.getBuyerNodeAddress();
        result = result * 59 + ($buyerNodeAddress == null ? 43 : ((Object)$buyerNodeAddress).hashCode());
        NodeAddress $sellerNodeAddress = this.getSellerNodeAddress();
        result = result * 59 + ($sellerNodeAddress == null ? 43 : ((Object)$sellerNodeAddress).hashCode());
        NodeAddress $arbitratorNodeAddress = this.getArbitratorNodeAddress();
        result = result * 59 + ($arbitratorNodeAddress == null ? 43 : ((Object)$arbitratorNodeAddress).hashCode());
        String $makerAccountId = this.getMakerAccountId();
        result = result * 59 + ($makerAccountId == null ? 43 : $makerAccountId.hashCode());
        String $takerAccountId = this.getTakerAccountId();
        result = result * 59 + ($takerAccountId == null ? 43 : $takerAccountId.hashCode());
        String $makerPaymentMethodId = this.getMakerPaymentMethodId();
        result = result * 59 + ($makerPaymentMethodId == null ? 43 : $makerPaymentMethodId.hashCode());
        String $takerPaymentMethodId = this.getTakerPaymentMethodId();
        result = result * 59 + ($takerPaymentMethodId == null ? 43 : $takerPaymentMethodId.hashCode());
        result = result * 59 + Arrays.hashCode(this.getMakerPaymentAccountPayloadHash());
        result = result * 59 + Arrays.hashCode(this.getTakerPaymentAccountPayloadHash());
        PubKeyRing $makerPubKeyRing = this.getMakerPubKeyRing();
        result = result * 59 + ($makerPubKeyRing == null ? 43 : ((Object)$makerPubKeyRing).hashCode());
        PubKeyRing $takerPubKeyRing = this.getTakerPubKeyRing();
        result = result * 59 + ($takerPubKeyRing == null ? 43 : ((Object)$takerPubKeyRing).hashCode());
        String $makerPayoutAddressString = this.getMakerPayoutAddressString();
        result = result * 59 + ($makerPayoutAddressString == null ? 43 : $makerPayoutAddressString.hashCode());
        String $takerPayoutAddressString = this.getTakerPayoutAddressString();
        result = result * 59 + ($takerPayoutAddressString == null ? 43 : $takerPayoutAddressString.hashCode());
        String $makerDepositTxHash = this.getMakerDepositTxHash();
        result = result * 59 + ($makerDepositTxHash == null ? 43 : $makerDepositTxHash.hashCode());
        String $takerDepositTxHash = this.getTakerDepositTxHash();
        result = result * 59 + ($takerDepositTxHash == null ? 43 : $takerDepositTxHash.hashCode());
        return result;
    }
}

