/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import com.google.common.base.CaseFormat;
import com.google.common.base.Charsets;
import common.utils.GenUtils;
import haveno.common.config.Config;
import haveno.common.crypto.CryptoException;
import haveno.common.crypto.Hash;
import haveno.common.crypto.KeyRing;
import haveno.common.crypto.PubKeyRing;
import haveno.common.crypto.Sig;
import haveno.common.file.FileUtil;
import haveno.common.util.Base64;
import haveno.common.util.Utilities;
import haveno.core.api.CoreNotificationService;
import haveno.core.api.XmrConnectionService;
import haveno.core.app.HavenoSetup;
import haveno.core.offer.OfferPayload;
import haveno.core.offer.OpenOfferManager;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.support.dispute.arbitration.arbitrator.Arbitrator;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.PaymentReceivedMessage;
import haveno.core.trade.messages.PaymentSentMessage;
import haveno.core.user.Preferences;
import haveno.core.util.JsonUtil;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.NodeAddress;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import monero.common.MoneroRpcConnection;
import monero.common.MoneroUtils;
import monero.daemon.model.MoneroOutput;
import monero.wallet.model.MoneroDestination;
import monero.wallet.model.MoneroTxWallet;
import org.bitcoinj.core.Coin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HavenoUtils {
    private static final Logger log = LoggerFactory.getLogger(HavenoUtils.class);
    private static final String RELEASE_DATE = "25-05-2024 00:00:00";
    public static final int RELEASE_LIMIT_DAYS = 60;
    public static final int WARN_ON_OFFER_EXCEEDS_UNSIGNED_BUY_LIMIT_DAYS = 182;
    public static final int ARBITRATOR_ACK_TIMEOUT_SECONDS = 60;
    public static final boolean ARBITRATOR_ASSIGNS_TRADE_FEE_ADDRESS = true;
    public static final double PENALTY_FEE_PCT = 0.02;
    public static final double MAKER_FEE_PCT = 0.0015;
    public static final double TAKER_FEE_PCT = 0.0075;
    public static final double MAKER_FEE_FOR_TAKER_WITHOUT_DEPOSIT_PCT = 0.009;
    public static final double MINER_FEE_TOLERANCE_FACTOR = 5.0;
    public static final long LOG_POLL_ERROR_PERIOD_MS = 240000L;
    public static final long LOG_DAEMON_NOT_SYNCED_WARN_PERIOD_MS = 30000L;
    public static final int PRIVATE_OFFER_PASSPHRASE_NUM_WORDS = 8;
    private static boolean SYNC_DAEMON_REQUESTS = false;
    private static boolean SYNC_WALLET_REQUESTS = false;
    private static Object DAEMON_LOCK = new Object();
    public static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = DecimalFormatSymbols.getInstance(Locale.US);
    public static int XMR_SMALLEST_UNIT_EXPONENT = 12;
    public static final String LOOPBACK_HOST = "127.0.0.1";
    public static final String LOCALHOST = "localhost";
    private static final long CENTINEROS_AU_MULTIPLIER = 10000L;
    private static final BigInteger XMR_AU_MULTIPLIER = new BigInteger("1000000000000");
    public static final DecimalFormat XMR_FORMATTER = new DecimalFormat("##############0.000000000000", DECIMAL_FORMAT_SYMBOLS);
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    public static HavenoSetup havenoSetup;
    public static ArbitrationManager arbitrationManager;
    public static XmrWalletService xmrWalletService;
    public static XmrConnectionService xmrConnectionService;
    public static OpenOfferManager openOfferManager;
    public static CoreNotificationService notificationService;
    public static Preferences preferences;

    public static Object getDaemonLock() {
        return SYNC_DAEMON_REQUESTS ? DAEMON_LOCK : new Object();
    }

    public static Object getWalletFunctionLock() {
        return SYNC_WALLET_REQUESTS ? HavenoUtils.getDaemonLock() : new Object();
    }

    public static boolean isSeedNode() {
        return havenoSetup == null;
    }

    public static boolean isDaemon() {
        if (HavenoUtils.isSeedNode()) {
            return true;
        }
        return havenoSetup.getCoreContext().isApiUser();
    }

    public static Date getReleaseDate() {
        if (RELEASE_DATE == null) {
            return null;
        }
        try {
            return DATE_FORMAT.parse(RELEASE_DATE);
        }
        catch (Exception e) {
            log.error("Failed to parse release date: 25-05-2024 00:00:00", e);
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isReleasedWithinDays(int days) {
        Date releaseDate = HavenoUtils.getReleaseDate();
        if (releaseDate == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(releaseDate);
        calendar.add(5, days);
        Date releaseDatePlusDays = calendar.getTime();
        return new Date().before(releaseDatePlusDays);
    }

    public static void waitFor(long waitMs) {
        GenUtils.waitFor(waitMs);
    }

    public static BigInteger coinToAtomicUnits(Coin coin) {
        return HavenoUtils.centinerosToAtomicUnits(coin.value);
    }

    public static BigInteger centinerosToAtomicUnits(long centineros) {
        return BigInteger.valueOf(centineros).multiply(BigInteger.valueOf(10000L));
    }

    public static double centinerosToXmr(long centineros) {
        return HavenoUtils.atomicUnitsToXmr(HavenoUtils.centinerosToAtomicUnits(centineros));
    }

    public static Coin centinerosToCoin(long centineros) {
        return HavenoUtils.atomicUnitsToCoin(HavenoUtils.centinerosToAtomicUnits(centineros));
    }

    public static long atomicUnitsToCentineros(long atomicUnits) {
        return HavenoUtils.atomicUnitsToCentineros(BigInteger.valueOf(atomicUnits));
    }

    public static long atomicUnitsToCentineros(BigInteger atomicUnits) {
        return atomicUnits.divide(BigInteger.valueOf(10000L)).longValueExact();
    }

    public static Coin atomicUnitsToCoin(long atomicUnits) {
        return Coin.valueOf(HavenoUtils.atomicUnitsToCentineros(atomicUnits));
    }

    public static Coin atomicUnitsToCoin(BigInteger atomicUnits) {
        return HavenoUtils.atomicUnitsToCoin(atomicUnits.longValueExact());
    }

    public static double atomicUnitsToXmr(long atomicUnits) {
        return HavenoUtils.atomicUnitsToXmr(BigInteger.valueOf(atomicUnits));
    }

    public static double atomicUnitsToXmr(BigInteger atomicUnits) {
        return MoneroUtils.atomicUnitsToXmr(atomicUnits);
    }

    public static BigInteger xmrToAtomicUnits(double xmr) {
        return MoneroUtils.xmrToAtomicUnits(xmr);
    }

    public static long xmrToCentineros(double xmr) {
        return HavenoUtils.atomicUnitsToCentineros(HavenoUtils.xmrToAtomicUnits(xmr));
    }

    public static double coinToXmr(Coin coin) {
        return HavenoUtils.atomicUnitsToXmr(HavenoUtils.coinToAtomicUnits(coin));
    }

    public static double divide(BigInteger auDividend, BigInteger auDivisor) {
        return MoneroUtils.divide(auDividend, auDivisor);
    }

    public static BigInteger multiply(BigInteger amount1, double amount2) {
        return MoneroUtils.multiply(amount1, amount2);
    }

    public static String formatXmr(BigInteger atomicUnits) {
        return HavenoUtils.formatXmr(atomicUnits, false);
    }

    public static String formatXmr(BigInteger atomicUnits, int decimalPlaces) {
        return HavenoUtils.formatXmr(atomicUnits, false, decimalPlaces);
    }

    public static String formatXmr(BigInteger atomicUnits, boolean appendCode) {
        return HavenoUtils.formatXmr(atomicUnits, appendCode, 0);
    }

    public static String formatXmr(BigInteger atomicUnits, boolean appendCode, int decimalPlaces) {
        if (atomicUnits == null) {
            return "";
        }
        return HavenoUtils.formatXmr(atomicUnits.longValueExact(), appendCode, decimalPlaces);
    }

    public static String formatXmr(long atomicUnits) {
        return HavenoUtils.formatXmr(atomicUnits, false, 0);
    }

    public static String formatXmr(long atomicUnits, boolean appendCode) {
        return HavenoUtils.formatXmr(atomicUnits, appendCode, 0);
    }

    public static String formatXmr(long atomicUnits, boolean appendCode, int decimalPlaces) {
        String formatted = XMR_FORMATTER.format(HavenoUtils.atomicUnitsToXmr(atomicUnits));
        if (formatted.contains(".")) {
            while (formatted.length() > 3 && formatted.charAt(formatted.length() - 1) == '0') {
                formatted = formatted.substring(0, formatted.length() - 1);
            }
        }
        return HavenoUtils.applyDecimals(formatted, Math.max(2, decimalPlaces)) + (appendCode ? " XMR" : "");
    }

    public static String formatPercent(double percent) {
        return percent * 100.0 + "%";
    }

    private static String applyDecimals(String decimalStr, int decimalPlaces) {
        if (decimalStr.contains(".")) {
            return decimalStr + HavenoUtils.getNumZeros(decimalPlaces - (decimalStr.length() - decimalStr.indexOf(".") - 1));
        }
        return decimalStr + "." + HavenoUtils.getNumZeros(decimalPlaces);
    }

    private static String getNumZeros(int numZeros) {
        Object zeros = "";
        for (int i = 0; i < numZeros; ++i) {
            zeros = (String)zeros + "0";
        }
        return zeros;
    }

    public static BigInteger parseXmr(String input) {
        if (input == null || input.length() == 0) {
            return BigInteger.ZERO;
        }
        try {
            return new BigDecimal(input).multiply(new BigDecimal(XMR_AU_MULTIPLIER)).toBigInteger();
        }
        catch (Exception e) {
            return BigInteger.ZERO;
        }
    }

    public static String generateChallenge() {
        try {
            String fileName = "bip39_english.txt";
            File bip39File = new File(HavenoUtils.havenoSetup.getConfig().appDataDir, fileName);
            if (!bip39File.exists()) {
                FileUtil.resourceToFile(fileName, bip39File);
            }
            List<String> bip39Words = Files.readAllLines(bip39File.toPath(), StandardCharsets.UTF_8);
            ArrayList<String> passphraseWords = new ArrayList<String>();
            SecureRandom secureRandom = new SecureRandom();
            for (int i = 0; i < 8; ++i) {
                passphraseWords.add(bip39Words.get(secureRandom.nextInt(bip39Words.size())));
            }
            return String.join((CharSequence)" ", passphraseWords);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to generate challenge", e);
        }
    }

    public static String getChallengeHash(String challenge) {
        if (challenge == null) {
            return null;
        }
        String[] words = challenge.toLowerCase().split(" ");
        ArrayList<String> prefixes = new ArrayList<String>();
        for (String word : words) {
            prefixes.add(word.substring(0, Math.min(word.length(), 4)));
        }
        return Base64.encode(Hash.getSha256Hash(String.join((CharSequence)" ", prefixes).getBytes()));
    }

    public static byte[] sign(KeyRing keyRing, String message) {
        return HavenoUtils.sign(keyRing.getSignatureKeyPair().getPrivate(), message);
    }

    public static byte[] sign(KeyRing keyRing, byte[] message) {
        return HavenoUtils.sign(keyRing.getSignatureKeyPair().getPrivate(), message);
    }

    public static byte[] sign(PrivateKey privateKey, String message) {
        return HavenoUtils.sign(privateKey, message.getBytes(Charsets.UTF_8));
    }

    public static byte[] sign(PrivateKey privateKey, byte[] message) {
        try {
            return Sig.sign(privateKey, message);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void verifySignature(PubKeyRing pubKeyRing, String message, byte[] signature) {
        HavenoUtils.verifySignature(pubKeyRing, message.getBytes(Charsets.UTF_8), signature);
    }

    public static void verifySignature(PubKeyRing pubKeyRing, byte[] message, byte[] signature) {
        try {
            boolean isValid = Sig.verify(pubKeyRing.getSignaturePubKey(), message, signature);
            if (!isValid) {
                throw new IllegalArgumentException("Signature verification failed.");
            }
        }
        catch (CryptoException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isSignatureValid(PubKeyRing pubKeyRing, String message, byte[] signature) {
        return HavenoUtils.isSignatureValid(pubKeyRing, message.getBytes(Charsets.UTF_8), signature);
    }

    public static boolean isSignatureValid(PubKeyRing pubKeyRing, byte[] message, byte[] signature) {
        try {
            HavenoUtils.verifySignature(pubKeyRing, message, signature);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static byte[] signOffer(OfferPayload offer, KeyRing keyRing) {
        return HavenoUtils.sign(keyRing, offer.getSignatureHash());
    }

    public static boolean isArbitratorSignatureValid(OfferPayload offer, Arbitrator arbitrator) {
        return HavenoUtils.isSignatureValid(arbitrator.getPubKeyRing(), offer.getSignatureHash(), offer.getArbitratorSignature());
    }

    public static void verifyPaymentSentMessage(Trade trade, PaymentSentMessage message) {
        byte[] signature = message.getBuyerSignature();
        message.setBuyerSignature(null);
        String unsignedMessageAsJson = JsonUtil.objectToJson(message);
        message.setBuyerSignature(signature);
        if (!HavenoUtils.isSignatureValid(trade.getBuyer().getPubKeyRing(), unsignedMessageAsJson, signature)) {
            throw new IllegalArgumentException("The buyer signature is invalid for the " + message.getClass().getSimpleName() + " for " + trade.getClass().getSimpleName() + " " + trade.getId());
        }
        if (!trade.getId().equals(message.getOfferId())) {
            throw new IllegalArgumentException("The " + message.getClass().getSimpleName() + " has the wrong trade id, expected " + trade.getId() + " but was " + message.getOfferId());
        }
    }

    public static void verifyPaymentReceivedMessage(Trade trade, PaymentReceivedMessage message) {
        byte[] signature = message.getSellerSignature();
        message.setSellerSignature(null);
        String unsignedMessageAsJson = JsonUtil.objectToJson(message);
        message.setSellerSignature(signature);
        if (!HavenoUtils.isSignatureValid(trade.getSeller().getPubKeyRing(), unsignedMessageAsJson, signature)) {
            throw new IllegalArgumentException("The seller signature is invalid for the " + message.getClass().getSimpleName() + " for " + trade.getClass().getSimpleName() + " " + trade.getId());
        }
        if (!trade.getId().equals(message.getOfferId())) {
            throw new IllegalArgumentException("The " + message.getClass().getSimpleName() + " has the wrong trade id, expected " + trade.getId() + " but was " + message.getOfferId());
        }
        if (message.getPaymentSentMessage() != null) {
            HavenoUtils.verifyPaymentSentMessage(trade, message.getPaymentSentMessage());
        }
    }

    public static String getGlobalTradeFeeAddress() {
        switch (Config.baseCurrencyNetwork()) {
            case XMR_LOCAL: {
                return "Bd37nTGHjL3RvPxc9dypzpWiXQrPzxxG4RsWAasD9CV2iZ1xfFZ7mzTKNDxWBfsqQSUimctAsGtTZ8c8bZJy35BYL9jYj88";
            }
            case XMR_STAGENET: {
                return "5B11hTJdG2XDNwjdKGLRxwSLwDhkbGg7C7UEAZBxjE6FbCeRMjudrpNACmDNtWPiSnNfjDQf39QRjdtdgoL69txv81qc2Mc";
            }
            case XMR_MAINNET: {
                throw new RuntimeException("Mainnet fee address not implemented");
            }
        }
        throw new RuntimeException("Unhandled base currency network: " + String.valueOf((Object)Config.baseCurrencyNetwork()));
    }

    public static String getBurnAddress() {
        switch (Config.baseCurrencyNetwork()) {
            case XMR_LOCAL: {
                return "Bd37nTGHjL3RvPxc9dypzpWiXQrPzxxG4RsWAasD9CV2iZ1xfFZ7mzTKNDxWBfsqQSUimctAsGtTZ8c8bZJy35BYL9jYj88";
            }
            case XMR_STAGENET: {
                return "577XbZ8yGfrWJM3aAoCpHVgDCm5higshGVJBb4ZNpTYARp8rLcCdcA1J8QgRfFWTzmJ8QgRfFWTzmJ8QgRfFWTzmCbXF9hd";
            }
            case XMR_MAINNET: {
                return "46uVWiE1d4kWJM3aAoCpHVgDCm5higshGVJBb4ZNpTYARp8rLcCdcA1J8QgRfFWTzmJ8QgRfFWTzmJ8QgRfFWTzmCag5CXT";
            }
        }
        throw new RuntimeException("Unhandled base currency network: " + String.valueOf((Object)Config.baseCurrencyNetwork()));
    }

    public static boolean isLocalHost(String uriString) {
        try {
            String host = new URI(uriString).getHost();
            return LOOPBACK_HOST.equals(host) || LOCALHOST.equals(host);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isPrivateIp(String uriString) {
        if (HavenoUtils.isLocalHost(uriString)) {
            return true;
        }
        try {
            URI uri = new URI(uriString);
            String host = uri.getHost();
            if (host == null) {
                return false;
            }
            InetAddress inetAddress = InetAddress.getByName(host);
            return inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isSiteLocalAddress();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getDeterministicId(Trade trade, Class<?> tradeMessageClass, NodeAddress receiver) {
        String uniqueId = trade.getId() + "_" + tradeMessageClass.getSimpleName() + "_" + trade.getRole() + "_to_" + trade.getPeerRole(trade.getTradePeer(receiver));
        return Utilities.bytesAsHexString(Hash.getSha256Ripemd160hash(uniqueId.getBytes(Charsets.UTF_8)));
    }

    public static void awaitLatch(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toCamelCase(String underscore) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, underscore);
    }

    public static boolean connectionConfigsEqual(MoneroRpcConnection c1, MoneroRpcConnection c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null) {
            return false;
        }
        return c1.equals(c2);
    }

    public static MoneroDestination getDestination(String address, MoneroTxWallet tx) {
        for (MoneroDestination destination : tx.getOutgoingTransfer().getDestinations()) {
            if (!address.equals(destination.getAddress())) continue;
            return destination;
        }
        return null;
    }

    public static List<String> getInputKeyImages(MoneroTxWallet tx) {
        ArrayList<String> inputKeyImages = new ArrayList<String>();
        for (MoneroOutput input : tx.getInputs()) {
            inputKeyImages.add(input.getKeyImage().getHex());
        }
        return inputKeyImages;
    }

    public static int getDefaultMoneroPort() {
        if (Config.baseCurrencyNetwork().isMainnet()) {
            return 18081;
        }
        if (Config.baseCurrencyNetwork().isTestnet()) {
            return 28081;
        }
        if (Config.baseCurrencyNetwork().isStagenet()) {
            return 38081;
        }
        throw new RuntimeException("Base network is not local testnet, stagenet, or mainnet");
    }

    public static void setTopError(String msg) {
        havenoSetup.getTopErrorMsg().set(msg);
    }

    public static boolean isConnectionRefused(Throwable e) {
        return e != null && e.getMessage().contains("Connection refused");
    }

    public static boolean isReadTimeout(Throwable e) {
        return e != null && e.getMessage().contains("Read timed out");
    }

    public static boolean isUnresponsive(Throwable e) {
        return HavenoUtils.isConnectionRefused(e) || HavenoUtils.isReadTimeout(e);
    }

    public static boolean isNotEnoughSigners(Throwable e) {
        return e != null && e.getMessage().contains("Not enough signers");
    }

    public static boolean isTransactionRejected(Throwable e) {
        return e != null && e.getMessage().contains("was rejected");
    }

    public static boolean isIllegal(Throwable e) {
        return e instanceof IllegalArgumentException || e instanceof IllegalStateException;
    }

    public static void playChimeSound() {
        HavenoUtils.playAudioFile("chime.wav");
    }

    public static void playCashRegisterSound() {
        HavenoUtils.playAudioFile("cash_register.wav");
    }

    private static void playAudioFile(String fileName) {
        if (HavenoUtils.isDaemon()) {
            return;
        }
        if (!preferences.getUseSoundForNotificationsProperty().get()) {
            return;
        }
        new Thread(() -> {
            try {
                File wavFile = new File(HavenoUtils.havenoSetup.getConfig().appDataDir, fileName);
                if (!wavFile.exists()) {
                    FileUtil.resourceToFile(fileName, wavFile);
                }
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(wavFile);
                AudioFormat baseFormat = audioInputStream.getFormat();
                AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, 44100.0f, false);
                AudioInputStream convertedStream = AudioSystem.getAudioInputStream(targetFormat, audioInputStream);
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, targetFormat);
                SourceDataLine sourceLine = (SourceDataLine)AudioSystem.getLine(info);
                sourceLine.open(targetFormat);
                sourceLine.start();
                byte[] buffer = new byte[1024];
                int bytesRead = 0;
                while ((bytesRead = convertedStream.read(buffer, 0, buffer.length)) != -1) {
                    sourceLine.write(buffer, 0, bytesRead);
                }
                sourceLine.drain();
                sourceLine.close();
                convertedStream.close();
                audioInputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    public static void verifyMinerFee(BigInteger expected, BigInteger actual) {
        BigInteger max = expected.max(actual);
        BigInteger min2 = expected.min(actual);
        if (min2.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("Miner fees must be greater than zero");
        }
        double factor = HavenoUtils.divide(max, min2);
        if (factor > 5.0) {
            throw new IllegalArgumentException("Miner fees are not within 5.0x of each other. Expected=" + String.valueOf(expected) + ", actual=" + String.valueOf(actual) + ", factor=" + factor);
        }
    }
}

