/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import haveno.common.proto.ProtoUtil;
import haveno.core.offer.Offer;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.trade.SellerTrade;
import haveno.core.trade.TakerTrade;
import haveno.core.trade.Tradable;
import haveno.core.trade.protocol.ProcessModel;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.NodeAddress;
import java.math.BigInteger;
import java.util.UUID;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.Trade;

public final class SellerAsTakerTrade
extends SellerTrade
implements TakerTrade {
    private static final Logger log = LoggerFactory.getLogger(SellerAsTakerTrade.class);

    public SellerAsTakerTrade(Offer offer, BigInteger tradeAmount, long tradePrice, XmrWalletService xmrWalletService, ProcessModel processModel, String uid, @Nullable NodeAddress makerNodeAddress, @Nullable NodeAddress takerNodeAddress, @Nullable NodeAddress arbitratorNodeAddress, @Nullable String challenge) {
        super(offer, tradeAmount, tradePrice, xmrWalletService, processModel, uid, makerNodeAddress, takerNodeAddress, arbitratorNodeAddress, challenge);
    }

    @Override
    public protobuf.Tradable toProtoMessage() {
        return protobuf.Tradable.newBuilder().setSellerAsTakerTrade(protobuf.SellerAsTakerTrade.newBuilder().setTrade((Trade)super.toProtoMessage())).build();
    }

    public static Tradable fromProto(protobuf.SellerAsTakerTrade sellerAsTakerTradeProto, XmrWalletService xmrWalletService, CoreProtoResolver coreProtoResolver) {
        Trade proto = sellerAsTakerTradeProto.getTrade();
        ProcessModel processModel = ProcessModel.fromProto(proto.getProcessModel(), coreProtoResolver);
        String uid = ProtoUtil.stringOrNullFromProto(proto.getUid());
        if (uid == null) {
            uid = UUID.randomUUID().toString();
        }
        return SellerAsTakerTrade.fromProto(new SellerAsTakerTrade(Offer.fromProto(proto.getOffer()), BigInteger.valueOf(proto.getAmount()), proto.getPrice(), xmrWalletService, processModel, uid, proto.getProcessModel().getMaker().hasNodeAddress() ? NodeAddress.fromProto(proto.getProcessModel().getMaker().getNodeAddress()) : null, proto.getProcessModel().getTaker().hasNodeAddress() ? NodeAddress.fromProto(proto.getProcessModel().getTaker().getNodeAddress()) : null, proto.getProcessModel().getArbitrator().hasNodeAddress() ? NodeAddress.fromProto(proto.getProcessModel().getArbitrator().getNodeAddress()) : null, ProtoUtil.stringOrNullFromProto(proto.getChallenge())), proto, coreProtoResolver);
    }
}

