/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import haveno.core.offer.Offer;
import haveno.core.trade.Trade;
import haveno.core.trade.protocol.ProcessModel;
import haveno.core.trade.protocol.SellerProtocol;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.NodeAddress;
import java.math.BigInteger;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SellerTrade
extends Trade {
    private static final Logger log = LoggerFactory.getLogger(SellerTrade.class);

    SellerTrade(Offer offer, BigInteger tradeAmount, long tradePrice, XmrWalletService xmrWalletService, ProcessModel processModel, String uid, @Nullable NodeAddress makerNodeAddress, @Nullable NodeAddress takerNodeAddress, @Nullable NodeAddress arbitratorNodeAddress, @Nullable String challenge) {
        super(offer, tradeAmount, tradePrice, xmrWalletService, processModel, uid, makerNodeAddress, takerNodeAddress, arbitratorNodeAddress, challenge);
    }

    @Override
    public BigInteger getPayoutAmountBeforeCost() {
        return this.getSellerSecurityDepositBeforeMiningFee();
    }

    @Override
    public boolean confirmPermitted() {
        return true;
    }

    @Override
    public boolean isFinished() {
        return super.isFinished() && ((SellerProtocol)this.getProtocol()).needsToResendPaymentReceivedMessages();
    }
}

