/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import haveno.common.proto.persistable.PersistablePayload;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.Offer;
import haveno.core.trade.Trade;
import haveno.network.p2p.NodeAddress;
import java.math.BigInteger;
import java.util.Date;
import java.util.Optional;

public interface Tradable
extends PersistablePayload {
    public Offer getOffer();

    public Date getDate();

    public String getId();

    public String getShortId();

    default public Optional<Trade> asTradeModel() {
        if (this instanceof Trade) {
            return Optional.of((Trade)this);
        }
        return Optional.empty();
    }

    default public Optional<Volume> getOptionalVolume() {
        return this.asTradeModel().map(Trade::getVolume).or(() -> Optional.ofNullable(this.getOffer().getVolume()));
    }

    default public Optional<Price> getOptionalPrice() {
        return this.asTradeModel().map(Trade::getPrice).or(() -> Optional.ofNullable(this.getOffer().getPrice()));
    }

    default public Optional<BigInteger> getOptionalAmount() {
        return this.asTradeModel().map(Trade::getAmount);
    }

    default public BigInteger getTotalTxFee() {
        return this.asTradeModel().map(Trade::getTotalTxFee).orElse(BigInteger.ZERO);
    }

    default public Optional<BigInteger> getOptionalTakerFee() {
        return this.asTradeModel().map(Trade::getTakerFee);
    }

    default public Optional<BigInteger> getOptionalMakerFee() {
        return this.asTradeModel().map(Trade::getMakerFee);
    }

    default public Optional<NodeAddress> getOptionalTradePeerNodeAddress() {
        return this.asTradeModel().map(Trade::getTradePeerNodeAddress);
    }
}

