/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import com.google.protobuf.Message;
import haveno.common.proto.ProtoUtil;
import haveno.common.proto.ProtobufferRuntimeException;
import haveno.common.proto.persistable.PersistableListAsObservable;
import haveno.core.offer.OpenOffer;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.BuyerAsMakerTrade;
import haveno.core.trade.BuyerAsTakerTrade;
import haveno.core.trade.SellerAsMakerTrade;
import haveno.core.trade.SellerAsTakerTrade;
import haveno.core.trade.Tradable;
import haveno.core.xmr.wallet.XmrWalletService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.PersistableEnvelope;

public final class TradableList<T extends Tradable>
extends PersistableListAsObservable<T> {
    private static final Logger log = LoggerFactory.getLogger(TradableList.class);

    public TradableList() {
    }

    protected TradableList(Collection<T> collection) {
        super(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message toProtoMessage() {
        List list = this.getList();
        synchronized (list) {
            return PersistableEnvelope.newBuilder().setTradableList(protobuf.TradableList.newBuilder().addAllTradable(ProtoUtil.collectionToProto(this.getList(), protobuf.Tradable.class))).build();
        }
    }

    public static TradableList<Tradable> fromProto(protobuf.TradableList proto, CoreProtoResolver coreProtoResolver, XmrWalletService xmrWalletService) {
        List list = proto.getTradableList().stream().map(tradable -> {
            switch (tradable.getMessageCase()) {
                case OPEN_OFFER: {
                    return OpenOffer.fromProto(tradable.getOpenOffer());
                }
                case BUYER_AS_MAKER_TRADE: {
                    return BuyerAsMakerTrade.fromProto(tradable.getBuyerAsMakerTrade(), xmrWalletService, coreProtoResolver);
                }
                case BUYER_AS_TAKER_TRADE: {
                    return BuyerAsTakerTrade.fromProto(tradable.getBuyerAsTakerTrade(), xmrWalletService, coreProtoResolver);
                }
                case SELLER_AS_MAKER_TRADE: {
                    return SellerAsMakerTrade.fromProto(tradable.getSellerAsMakerTrade(), xmrWalletService, coreProtoResolver);
                }
                case SELLER_AS_TAKER_TRADE: {
                    return SellerAsTakerTrade.fromProto(tradable.getSellerAsTakerTrade(), xmrWalletService, coreProtoResolver);
                }
                case ARBITRATOR_TRADE: {
                    return ArbitratorTrade.fromProto(tradable.getArbitratorTrade(), xmrWalletService, coreProtoResolver);
                }
            }
            log.error("Unknown messageCase. tradable.getMessageCase() = " + String.valueOf(tradable.getMessageCase()));
            throw new ProtobufferRuntimeException("Unknown messageCase. tradable.getMessageCase() = " + String.valueOf(tradable.getMessageCase()));
        }).collect(Collectors.toList());
        return new TradableList<Tradable>(list);
    }

    public String toString() {
        return "TradableList{,\n     list=" + String.valueOf(this.getList()) + "\n}";
    }
}

