/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import haveno.common.ThreadUtils;
import haveno.common.UserThread;
import haveno.common.crypto.Encryption;
import haveno.common.crypto.PubKeyRing;
import haveno.common.proto.ProtoUtil;
import haveno.common.taskrunner.Model;
import haveno.common.util.Utilities;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.network.MessageState;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OpenOffer;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.proto.network.CoreNetworkProtoResolver;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeResult;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.support.dispute.mediation.MediationResultState;
import haveno.core.support.dispute.refund.RefundResultState;
import haveno.core.support.messages.ChatMessage;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.BuyerTrade;
import haveno.core.trade.Contract;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.MakerTrade;
import haveno.core.trade.SellerTrade;
import haveno.core.trade.TakerTrade;
import haveno.core.trade.Tradable;
import haveno.core.trade.messages.TradeMessage;
import haveno.core.trade.protocol.ProcessModel;
import haveno.core.trade.protocol.ProcessModelServiceProvider;
import haveno.core.trade.protocol.TradeListener;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.TradeProtocol;
import haveno.core.trade.statistics.TradeStatistics3;
import haveno.core.util.VolumeUtil;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.core.xmr.wallet.XmrWalletBase;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.AckMessage;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.network.TorNetworkNode;
import java.math.BigInteger;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import monero.common.MoneroError;
import monero.common.MoneroRpcConnection;
import monero.common.TaskLooper;
import monero.daemon.MoneroDaemonRpc;
import monero.daemon.model.MoneroKeyImage;
import monero.daemon.model.MoneroTx;
import monero.wallet.MoneroWallet;
import monero.wallet.MoneroWalletRpc;
import monero.wallet.model.MoneroDestination;
import monero.wallet.model.MoneroMultisigSignResult;
import monero.wallet.model.MoneroOutputQuery;
import monero.wallet.model.MoneroOutputWallet;
import monero.wallet.model.MoneroTxConfig;
import monero.wallet.model.MoneroTxQuery;
import monero.wallet.model.MoneroTxSet;
import monero.wallet.model.MoneroTxWallet;
import monero.wallet.model.MoneroWalletListener;
import org.apache.commons.lang3.StringUtils;
import org.bitcoinj.core.Coin;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.Trade;

public abstract class Trade
extends XmrWalletBase
implements Tradable,
Model {
    private static final Logger log = LoggerFactory.getLogger(Trade.class);
    public final Object lock = new Object();
    private static final String MONERO_TRADE_WALLET_PREFIX = "xmr_trade_";
    private static final long SHUTDOWN_TIMEOUT_MS = 60000L;
    private static final long SYNC_EVERY_NUM_BLOCKS = 360L;
    private static final long DELETE_AFTER_NUM_BLOCKS = 2L;
    private static final long EXTENDED_RPC_TIMEOUT = 600000L;
    private static final long DELETE_AFTER_MS = TradeProtocol.TRADE_STEP_TIMEOUT_SECONDS;
    private static final int NUM_CONFIRMATIONS_FOR_SCHEDULED_IMPORT = 5;
    protected final Object pollLock = new Object();
    private final Object removeTradeOnErrorLock = new Object();
    protected static final Object importMultisigLock = new Object();
    private boolean pollInProgress;
    private boolean restartInProgress;
    private Subscription protocolErrorStateSubscription;
    private Subscription protocolErrorHeightSubscription;
    private final ProcessModel processModel;
    private final Offer offer;
    private final String uid;
    private long takeOfferDate;
    private static final int TOTAL_INIT_STEPS = 24;
    private int initStep = 0;
    private double initProgress = 0.0;
    private Exception initError;
    private long amount;
    private long price;
    @Nullable
    private State state = State.PREPARATION;
    private PayoutState payoutState = PayoutState.PAYOUT_UNPUBLISHED;
    private DisputeState disputeState = DisputeState.NO_DISPUTE;
    private TradePeriodState periodState = TradePeriodState.FIRST_HALF;
    @Nullable
    private Contract contract;
    @Nullable
    private String contractAsJson;
    @Nullable
    private byte[] contractHash;
    @Nullable
    private String errorMessage;
    @Nullable
    private String counterCurrencyTxId;
    private final ObservableList<ChatMessage> chatMessages = FXCollections.observableArrayList();
    private final transient XmrWalletService xmrWalletService;
    private final transient DoubleProperty initProgressProperty = new SimpleDoubleProperty(0.0);
    private final transient ObjectProperty<State> stateProperty = new SimpleObjectProperty<State>(this.state);
    private final transient ObjectProperty<Phase> phaseProperty;
    private final transient ObjectProperty<PayoutState> payoutStateProperty;
    private final transient ObjectProperty<DisputeState> disputeStateProperty;
    private final transient ObjectProperty<TradePeriodState> tradePeriodStateProperty;
    public final transient IntegerProperty depositTxsUpdateCounter;
    private final transient StringProperty errorMessageProperty;
    private transient Subscription tradeStateSubscription;
    private transient Subscription tradePhaseSubscription;
    private transient Subscription payoutStateSubscription;
    private transient Subscription disputeStateSubscription;
    private transient TaskLooper pollLooper;
    private transient Long pollPeriodMs;
    private transient Long pollNormalStartTimeMs;
    public static final long DEFER_PUBLISH_MS = 25000L;
    private static final long IDLE_SYNC_PERIOD_MS = 1680000L;
    private static final long MAX_REPROCESS_DELAY_SECONDS = 7200L;
    private transient boolean isInitialized;
    private transient boolean isFullyInitialized;
    private transient ObjectProperty<BigInteger> tradeAmountProperty;
    private transient ObjectProperty<Volume> tradeVolumeProperty;
    @Nullable
    private MediationResultState mediationResultState;
    private final transient ObjectProperty<MediationResultState> mediationResultStateProperty;
    private long lockTime;
    private long startTime;
    @Nullable
    private RefundResultState refundResultState;
    private final transient ObjectProperty<RefundResultState> refundResultStateProperty;
    private String counterCurrencyExtraData;
    private transient List<TradeListener> tradeListeners;
    transient MoneroWalletListener depositTxListener;
    transient MoneroWalletListener payoutTxListener;
    transient Boolean makerDepositLocked;
    transient Boolean takerDepositLocked;
    @Nullable
    private transient MoneroTx payoutTx;
    private String payoutTxId;
    @Nullable
    private String payoutTxHex;
    private String payoutTxKey;
    private long payoutTxFee;
    private Long payoutHeight;
    private IdlePayoutSyncer idlePayoutSyncer;
    private boolean isCompleted;
    private final String challenge;

    protected Trade(Offer offer, BigInteger tradeAmount, long tradePrice, XmrWalletService xmrWalletService, ProcessModel processModel, String uid, @Nullable NodeAddress makerNodeAddress, @Nullable NodeAddress takerNodeAddress, @Nullable NodeAddress arbitratorNodeAddress, @Nullable String challenge) {
        this.phaseProperty = new SimpleObjectProperty<Phase>(this.state.phase);
        this.payoutStateProperty = new SimpleObjectProperty<PayoutState>(this.payoutState);
        this.disputeStateProperty = new SimpleObjectProperty<DisputeState>(this.disputeState);
        this.tradePeriodStateProperty = new SimpleObjectProperty<TradePeriodState>(this.periodState);
        this.depositTxsUpdateCounter = new SimpleIntegerProperty(0);
        this.errorMessageProperty = new SimpleStringProperty();
        this.mediationResultState = MediationResultState.UNDEFINED_MEDIATION_RESULT;
        this.mediationResultStateProperty = new SimpleObjectProperty<MediationResultState>(this.mediationResultState);
        this.refundResultState = RefundResultState.UNDEFINED_REFUND_RESULT;
        this.refundResultStateProperty = new SimpleObjectProperty<RefundResultState>(this.refundResultState);
        this.offer = offer;
        this.amount = tradeAmount.longValueExact();
        this.price = tradePrice;
        this.xmrWalletService = xmrWalletService;
        this.xmrConnectionService = xmrWalletService.getXmrConnectionService();
        this.processModel = processModel;
        this.uid = uid;
        this.takeOfferDate = new Date().getTime();
        this.tradeListeners = new ArrayList<TradeListener>();
        this.challenge = challenge;
        this.getMaker().setNodeAddress(makerNodeAddress);
        this.getTaker().setNodeAddress(takerNodeAddress);
        this.getArbitrator().setNodeAddress(arbitratorNodeAddress);
        this.setAmount(tradeAmount);
    }

    protected Trade(Offer offer, BigInteger tradeAmount, BigInteger txFee, long tradePrice, @Nullable NodeAddress mediatorNodeAddress, @Nullable NodeAddress refundAgentNodeAddress, XmrWalletService xmrWalletService, ProcessModel processModel, String uid, @Nullable NodeAddress makerNodeAddress, @Nullable NodeAddress takerNodeAddress, @Nullable NodeAddress arbitratorNodeAddress, @Nullable String challenge) {
        this(offer, tradeAmount, tradePrice, xmrWalletService, processModel, uid, makerNodeAddress, takerNodeAddress, arbitratorNodeAddress, challenge);
    }

    protected Trade(Offer offer, BigInteger tradeAmount, Coin txFee, long tradePrice, NodeAddress makerNodeAddress, NodeAddress takerNodeAddress, NodeAddress arbitratorNodeAddress, XmrWalletService xmrWalletService, ProcessModel processModel, String uid, @Nullable String challenge) {
        this(offer, tradeAmount, tradePrice, xmrWalletService, processModel, uid, makerNodeAddress, takerNodeAddress, arbitratorNodeAddress, challenge);
        this.setAmount(tradeAmount);
    }

    public void addListener(TradeListener listener) {
        this.tradeListeners.add(listener);
    }

    public void removeListener(TradeListener listener) {
        if (!this.tradeListeners.remove(listener)) {
            throw new RuntimeException("TradeMessageListener is not registered");
        }
    }

    public void onVerifiedTradeMessage(TradeMessage message, NodeAddress sender) {
        for (TradeListener listener : new ArrayList<TradeListener>(this.tradeListeners)) {
            listener.onVerifiedTradeMessage(message, sender);
        }
    }

    public void onAckMessage(AckMessage ackMessage, NodeAddress sender) {
        for (TradeListener listener : new ArrayList<TradeListener>(this.tradeListeners)) {
            listener.onAckMessage(ackMessage, sender);
        }
    }

    public void initialize(ProcessModelServiceProvider serviceProvider) {
        MessageState expectedState;
        if (this.isInitialized) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " " + this.getId() + " is already initialized");
        }
        if (this.isFinished()) {
            this.clearAndShutDown();
            return;
        }
        serviceProvider.getArbitratorManager().getDisputeAgentByNodeAddress(this.getArbitratorNodeAddress()).ifPresent(arbitrator -> this.getArbitrator().setPubKeyRing(arbitrator.getPubKeyRing()));
        this.xmrConnectionService.addConnectionListener(connection -> ThreadUtils.execute(() -> this.onConnectionChanged(connection), this.getId()));
        if (!this.isPayoutPublished()) {
            if (this instanceof BuyerTrade && this.getState().ordinal() >= State.BUYER_CONFIRMED_PAYMENT_SENT.ordinal() && this.getState().ordinal() < State.BUYER_STORED_IN_MAILBOX_PAYMENT_SENT_MSG.ordinal()) {
                log.warn("Resetting state of {} {} from {} to {} because no ack was received", new Object[]{this.getClass().getSimpleName(), this.getId(), this.getState(), State.DEPOSIT_TXS_UNLOCKED_IN_BLOCKCHAIN});
                this.setState(State.DEPOSIT_TXS_UNLOCKED_IN_BLOCKCHAIN);
            }
            if (this instanceof SellerTrade && this.getState().ordinal() >= State.SELLER_CONFIRMED_PAYMENT_RECEIPT.ordinal() && this.getState().ordinal() < State.SELLER_STORED_IN_MAILBOX_PAYMENT_RECEIVED_MSG.ordinal()) {
                log.warn("Resetting state of {} {} from {} to {} because no ack was received", new Object[]{this.getClass().getSimpleName(), this.getId(), this.getState(), State.BUYER_SENT_PAYMENT_SENT_MSG});
                this.resetToPaymentSentState();
            }
        }
        this.tradeStateSubscription = EasyBind.subscribe(this.stateProperty, newValue -> {
            if (!this.isInitialized || this.isShutDownStarted) {
                return;
            }
        });
        this.tradePhaseSubscription = EasyBind.subscribe(this.phaseProperty, newValue -> {
            if (!this.isInitialized || this.isShutDownStarted) {
                return;
            }
            ThreadUtils.submitToPool(() -> {
                if (newValue == Phase.DEPOSIT_REQUESTED) {
                    this.startPolling();
                }
                if (newValue == Phase.DEPOSITS_PUBLISHED) {
                    this.onDepositsPublished();
                }
                if (newValue == Phase.DEPOSITS_CONFIRMED) {
                    this.onDepositsConfirmed();
                }
                if (newValue == Phase.DEPOSITS_UNLOCKED) {
                    this.onDepositsUnlocked();
                }
                if (newValue == Phase.PAYMENT_SENT) {
                    this.onPaymentSent();
                }
                if (this.isDepositsPublished() && !this.isPayoutUnlocked()) {
                    this.updatePollPeriod();
                }
                if (this.isPaymentReceived()) {
                    UserThread.execute(() -> {
                        if (this.tradePhaseSubscription != null) {
                            this.tradePhaseSubscription.unsubscribe();
                            this.tradePhaseSubscription = null;
                        }
                    });
                }
            });
        });
        this.payoutStateSubscription = EasyBind.subscribe(this.payoutStateProperty, newValue -> {
            if (!this.isInitialized || this.isShutDownStarted) {
                return;
            }
            ThreadUtils.submitToPool(() -> {
                if (this.isPayoutPublished()) {
                    this.updatePollPeriod();
                }
                if (newValue == PayoutState.PAYOUT_PUBLISHED) {
                    log.info("Payout published for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                    ThreadUtils.submitToPool(() -> {
                        HavenoUtils.waitFor(1000L);
                        if (this.isPayoutConfirmed()) {
                            return;
                        }
                        if (this.isShutDownStarted) {
                            return;
                        }
                        if (this.xmrConnectionService.isConnected().booleanValue()) {
                            this.syncAndPollWallet();
                        }
                    });
                    if (this.getDisputeState().isArbitrated() && !this.getDisputeState().isClosed()) {
                        this.processModel.getTradeManager().closeDisputedTrade(this.getId(), DisputeState.DISPUTE_CLOSED);
                        if (!this.isArbitrator()) {
                            for (Dispute dispute : this.getDisputes()) {
                                dispute.setIsClosed();
                            }
                        }
                    }
                    if (this.isArbitrator() && !this.isCompleted()) {
                        this.processModel.getTradeManager().onTradeCompleted(this);
                    }
                    this.maybePublishTradeStatistics();
                    this.processModel.getXmrWalletService().swapPayoutAddressEntryToAvailable(this.getId());
                }
                if (newValue == PayoutState.PAYOUT_UNLOCKED) {
                    if (!this.isInitialized) {
                        return;
                    }
                    log.info("Payout unlocked for {} {}, deleting multisig wallet", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                    if (this.isCompleted()) {
                        this.clearAndShutDown();
                    } else {
                        this.deleteWallet();
                    }
                }
            });
        });
        this.disputeStateSubscription = EasyBind.subscribe(this.disputeStateProperty, newValue -> {
            if (!this.isInitialized || this.isShutDownStarted) {
                return;
            }
            ThreadUtils.submitToPool(() -> {
                if (this.isDisputeClosed()) {
                    this.maybePublishTradeStatistics();
                }
            });
        });
        if (this instanceof ArbitratorTrade) {
            this.idlePayoutSyncer = new IdlePayoutSyncer();
            this.xmrWalletService.addWalletListener(this.idlePayoutSyncer);
        }
        if (this.isBuyer() && (expectedState = this.getPaymentSentMessageState()) != null && expectedState != this.getSeller().getPaymentSentMessageStateProperty().get()) {
            log.warn("Updating unexpected payment sent message state for {} {}, expected={}, actual={}", new Object[]{this.getClass().getSimpleName(), this.getId(), expectedState, this.processModel.getPaymentSentMessageStatePropertySeller().get()});
            this.getSeller().getPaymentSentMessageStateProperty().set(expectedState);
        }
        this.walletHeight.addListener((ObservableValue<? super T> observable2, ? super T oldValue, ? super T newValue) -> this.importMultisigHexIfScheduled());
        if (!this.isDepositRequested() || this.isPayoutUnlocked()) {
            this.isInitialized = true;
            this.isFullyInitialized = true;
            return;
        }
        if (!this.walletExists()) {
            MoneroTx payoutTx = this.getPayoutTx();
            if (payoutTx != null && payoutTx.getNumConfirmations() >= 10L) {
                log.warn("Payout state for {} {} is {} but payout is unlocked, updating state", new Object[]{this.getClass().getSimpleName(), this.getId(), this.getPayoutState()});
                this.setPayoutStateUnlocked();
                this.isInitialized = true;
                this.isFullyInitialized = true;
                return;
            }
            throw new RuntimeException("Missing trade wallet for " + this.getClass().getSimpleName() + " " + this.getShortId() + ", state=" + String.valueOf((Object)this.getState()) + ", marked completed=" + this.isCompleted());
        }
        this.getWallet();
        this.isInitialized = true;
        if (this.isDepositRequested()) {
            this.tryInitSyncing();
        }
        this.isFullyInitialized = true;
    }

    public boolean isFinished() {
        return this.isPayoutUnlocked() && this.isCompleted();
    }

    public void resetToPaymentSentState() {
        this.setState(State.BUYER_SENT_PAYMENT_SENT_MSG);
        for (TradePeer peer : this.getAllPeers()) {
            peer.setPaymentReceivedMessage(null);
            peer.setPaymentReceivedMessageState(MessageState.UNDEFINED);
        }
        this.setPayoutTxHex(null);
    }

    public void reprocessApplicableMessages() {
        if (!this.isDepositRequested() || this.isPayoutUnlocked() || this.isCompleted()) {
            return;
        }
        this.getProtocol().maybeReprocessPaymentSentMessage(false);
        this.getProtocol().maybeReprocessPaymentReceivedMessage(false);
        HavenoUtils.arbitrationManager.maybeReprocessDisputeClosedMessage(this, false);
    }

    public void awaitInitialized() {
        while (!this.isFullyInitialized) {
            HavenoUtils.waitFor(100L);
        }
    }

    public void requestPersistence() {
        if (this.processModel.getTradeManager() != null) {
            this.processModel.getTradeManager().requestPersistence();
        }
    }

    public void persistNow(@Nullable Runnable completeHandler) {
        this.processModel.getTradeManager().persistNow(completeHandler);
    }

    public TradeProtocol getProtocol() {
        return this.processModel.getTradeManager().getTradeProtocol(this);
    }

    public void setMyNodeAddress() {
        this.getSelf().setNodeAddress(P2PService.getMyNodeAddress());
    }

    public NodeAddress getTradePeerNodeAddress() {
        return this.getTradePeer() == null ? null : this.getTradePeer().getNodeAddress();
    }

    public NodeAddress getArbitratorNodeAddress() {
        return this.getArbitrator() == null ? null : this.getArbitrator().getNodeAddress();
    }

    public void setCompleted(boolean completed) {
        this.isCompleted = completed;
        if (this.isPayoutUnlocked()) {
            this.clearAndShutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean walletExists() {
        Object object = this.walletLock;
        synchronized (object) {
            return this.xmrWalletService.walletExists(this.getWalletName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroWallet createWallet() {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.walletExists()) {
                throw new RuntimeException("Cannot create trade wallet because it already exists");
            }
            long time = System.currentTimeMillis();
            this.wallet = this.xmrWalletService.createWallet(this.getWalletName());
            log.info("{} {} created multisig wallet in {} ms", this.getClass().getSimpleName(), this.getId(), System.currentTimeMillis() - time);
            return this.wallet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroWallet getWallet() {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.wallet != null) {
                return this.wallet;
            }
            if (!this.walletExists()) {
                return null;
            }
            if (this.isShutDownStarted) {
                throw new RuntimeException("Cannot open wallet for " + this.getClass().getSimpleName() + " " + this.getId() + " because shut down is started");
            }
            this.wallet = this.xmrWalletService.openWallet(this.getWalletName(), this.xmrWalletService.isProxyApplied(this.wasWalletSynced));
            return this.wallet;
        }
    }

    public long getHeight() {
        return this.walletHeight.get();
    }

    private String getWalletName() {
        return MONERO_TRADE_WALLET_PREFIX + this.getShortId() + "_" + this.getShortUid();
    }

    public void verifyDaemonConnection() {
        if (!Boolean.TRUE.equals(this.xmrConnectionService.isConnected())) {
            throw new RuntimeException("Connection service is not connected to a Monero node");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWalletConnectedToDaemon() {
        Object object = this.walletLock;
        synchronized (object) {
            try {
                if (this.wallet == null) {
                    return false;
                }
                return this.wallet.isConnectedToDaemon();
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public boolean isIdling() {
        return this instanceof ArbitratorTrade && this.isDepositsConfirmed() && this.walletExists() && this.pollNormalStartTimeMs == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSyncedWithinTolerance() {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.wallet == null) {
                return false;
            }
            if (!this.xmrConnectionService.isSyncedWithinTolerance()) {
                return false;
            }
            Long targetHeight = this.xmrConnectionService.getTargetHeight();
            if (targetHeight == null) {
                return false;
            }
            return targetHeight - this.walletHeight.get() <= 3L;
            {
            }
        }
    }

    public void syncAndPollWallet() {
        this.syncWallet(true);
    }

    public void pollWalletNormallyForMs(long pollNormalDuration) {
        this.pollNormalStartTimeMs = System.currentTimeMillis();
        this.setPollPeriod(this.xmrConnectionService.getRefreshPeriodMs());
        new Thread(() -> {
            HavenoUtils.waitFor(pollNormalDuration);
            Long pollNormalStartTimeMsCopy = this.pollNormalStartTimeMs;
            if (pollNormalStartTimeMsCopy == null) {
                return;
            }
            if (!this.isShutDown && System.currentTimeMillis() >= pollNormalStartTimeMsCopy + pollNormalDuration) {
                this.pollNormalStartTimeMs = null;
                this.updatePollPeriod();
            }
        }).start();
    }

    private boolean isInvalidImportError(String errMsg) {
        return errMsg.contains("Failed to parse hex") || errMsg.contains("Multisig info is for a different account");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeWalletPassword(String oldPassword, String newPassword) {
        Object object = this.walletLock;
        synchronized (object) {
            this.getWallet().changePassword(oldPassword, newPassword);
            this.saveWallet();
        }
    }

    @Override
    public void requestSaveWallet() {
        ThreadUtils.execute(() -> {
            Object object = this.walletLock;
            synchronized (object) {
                if (this.walletExists()) {
                    this.saveWallet();
                }
            }
        }, this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveWallet() {
        Object object = this.walletLock;
        synchronized (object) {
            if (!this.walletExists()) {
                log.warn("Cannot save wallet for {} {} because it does not exist", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                return;
            }
            if (this.wallet == null) {
                throw new RuntimeException("Trade wallet is not open for trade " + this.getShortId());
            }
            this.xmrWalletService.saveWallet(this.wallet);
            this.maybeBackupWallet();
        }
    }

    private void maybeBackupWallet() {
        boolean createBackup;
        boolean bl = createBackup = !this.isArbitrator() && (!Utilities.isWindows() || !this.isWalletOpen());
        if (createBackup) {
            this.xmrWalletService.backupWallet(this.getWalletName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWalletOpen() {
        Object object = this.walletLock;
        synchronized (object) {
            return this.wallet != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeWallet() {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.wallet == null) {
                throw new RuntimeException("Trade wallet to close is not open for trade " + this.getId());
            }
            this.stopPolling();
            this.xmrWalletService.closeWallet(this.wallet, true);
            this.maybeBackupWallet();
            this.wallet = null;
            this.pollPeriodMs = null;
        }
    }

    private void forceCloseWallet() {
        if (this.wallet != null) {
            try {
                this.xmrWalletService.forceCloseWallet(this.wallet, this.wallet.getPath());
            }
            catch (Exception e) {
                log.warn("Error force closing wallet for {} {}: {}", this.getClass().getSimpleName(), this.getId(), e.getMessage());
            }
            this.stopPolling();
            this.wallet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWallet() {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.walletExists()) {
                try {
                    if (this.isDepositRequested()) {
                        boolean syncedWallet = false;
                        if (this.wallet == null) {
                            log.warn("Wallet is not initialized for {} {}, opening", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                            this.getWallet();
                            this.syncWallet(true);
                            syncedWallet = true;
                        }
                        if (!this.isPayoutUnlocked() && !syncedWallet) {
                            log.warn("Syncing wallet on deletion for trade {} {}, syncing", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                            this.syncWallet(true);
                        }
                        if (this.isDepositsPublished() && !this.isPayoutUnlocked()) {
                            throw new IllegalStateException("Refusing to delete wallet for " + this.getClass().getSimpleName() + " " + this.getId() + " because the deposit txs have been published but payout tx has not unlocked");
                        }
                        if (this.wallet.getBalance().compareTo(BigInteger.ZERO) > 0) {
                            log.warn("Rescanning spent outputs for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                            this.wallet.rescanSpent();
                            if (this.wallet.getBalance().compareTo(BigInteger.ZERO) > 0) {
                                throw new IllegalStateException("Refusing to delete wallet for " + this.getClass().getSimpleName() + " " + this.getId() + " because it has a balance of " + String.valueOf(this.wallet.getBalance()));
                            }
                        }
                    }
                    this.forceCloseWallet();
                    log.info("Deleting wallet and backups for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                    this.xmrWalletService.deleteWallet(this.getWalletName());
                    this.xmrWalletService.deleteWalletBackups(this.getWalletName());
                }
                catch (Exception e) {
                    log.warn("Error deleting wallet for {} {}: {}\n", this.getClass().getSimpleName(), this.getId(), e.getMessage(), e);
                    this.setErrorMessage(e.getMessage());
                    this.processModel.getTradeManager().getNotificationService().sendErrorNotification("Error", e.getMessage());
                }
            } else {
                log.warn("Multisig wallet to delete for trade {} does not exist", (Object)this.getId());
            }
        }
    }

    public Contract createContract() {
        boolean isBuyerMakerAndSellerTaker = this.getOffer().getDirection() == OfferDirection.BUY;
        Contract contract = new Contract(this.getOffer().getOfferPayload(), Preconditions.checkNotNull(this.getAmount()).longValueExact(), this.getPrice().getValue(), (isBuyerMakerAndSellerTaker ? this.getMaker() : this.getTaker()).getNodeAddress(), (isBuyerMakerAndSellerTaker ? this.getTaker() : this.getMaker()).getNodeAddress(), this.getArbitrator().getNodeAddress(), isBuyerMakerAndSellerTaker, this instanceof MakerTrade ? this.processModel.getAccountId() : this.getMaker().getAccountId(), this instanceof TakerTrade ? this.processModel.getAccountId() : this.getTaker().getAccountId(), Preconditions.checkNotNull(this instanceof MakerTrade ? this.getMaker().getPaymentAccountPayload().getPaymentMethodId() : this.getOffer().getOfferPayload().getPaymentMethodId()), Preconditions.checkNotNull(this instanceof TakerTrade ? this.getTaker().getPaymentAccountPayload().getPaymentMethodId() : this.getTaker().getPaymentMethodId()), this instanceof MakerTrade ? this.getMaker().getPaymentAccountPayload().getHash() : this.getMaker().getPaymentAccountPayloadHash(), this instanceof TakerTrade ? this.getTaker().getPaymentAccountPayload().getHash() : this.getTaker().getPaymentAccountPayloadHash(), this.getMaker().getPubKeyRing(), this.getTaker().getPubKeyRing(), this instanceof MakerTrade ? this.xmrWalletService.getAddressEntry(this.getId(), XmrAddressEntry.Context.TRADE_PAYOUT).get().getAddressString() : this.getMaker().getPayoutAddressString(), this instanceof TakerTrade ? this.xmrWalletService.getAddressEntry(this.getId(), XmrAddressEntry.Context.TRADE_PAYOUT).get().getAddressString() : this.getTaker().getPayoutAddressString(), this.getMaker().getDepositTxHash(), this.getTaker().getDepositTxHash());
        return contract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroTxWallet createTx(MoneroTxConfig txConfig) {
        Object object = this.walletLock;
        synchronized (object) {
            Object object2 = HavenoUtils.getWalletFunctionLock();
            synchronized (object2) {
                MoneroTxWallet tx = this.wallet.createTx(txConfig);
                this.exportMultisigHex();
                this.saveWallet();
                return tx;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportMultisigHex() {
        Object object = this.walletLock;
        synchronized (object) {
            this.getSelf().setUpdatedMultisigHex(this.wallet.exportMultisigHex());
            this.requestPersistence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importMultisigHexIfNeeded() {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.wallet.isMultisigImportNeeded()) {
                this.importMultisigHex();
            }
        }
    }

    public void scheduleImportMultisigHex() {
        this.processModel.setImportMultisigHexScheduled(true);
        this.requestPersistence();
    }

    private void importMultisigHexIfScheduled() {
        if (!this.isInitialized || this.isShutDownStarted) {
            return;
        }
        if (!this.isDepositsConfirmed() || this.getMaker().getDepositTx() == null) {
            return;
        }
        if (this.walletHeight.get() - this.getMaker().getDepositTx().getHeight() < 5L) {
            return;
        }
        ThreadUtils.execute(() -> {
            if (!this.isInitialized || this.isShutDownStarted) {
                return;
            }
            Object object = this.getLock();
            synchronized (object) {
                if (this.processModel.isImportMultisigHexScheduled()) {
                    this.importMultisigHex();
                    this.processModel.setImportMultisigHexScheduled(false);
                }
            }
        }, this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importMultisigHex() {
        Object object = this.walletLock;
        synchronized (object) {
            Object object2 = HavenoUtils.getDaemonLock();
            synchronized (object2) {
                Object object3 = importMultisigLock;
                synchronized (object3) {
                    for (int i = 0; i < 5; ++i) {
                        MoneroRpcConnection sourceConnection = this.xmrConnectionService.getConnection();
                        try {
                            this.doImportMultisigHex();
                            break;
                        }
                        catch (IllegalArgumentException | IllegalStateException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            log.warn("Failed to import multisig hex, tradeId={}, attempt={}/{}, error={}", this.getShortId(), i + 1, 5, e.getMessage());
                            this.handleWalletError(e, sourceConnection);
                            this.doPollWallet();
                            if (this.isPayoutPublished()) break;
                            if (i == 4) {
                                throw e;
                            }
                            HavenoUtils.waitFor(5000L);
                            continue;
                        }
                    }
                }
            }
        }
    }

    private void doImportMultisigHex() {
        if (!this.isDepositsConfirmed()) {
            this.syncAndPollWallet();
        }
        ArrayList<String> multisigHexes = new ArrayList<String>();
        for (TradePeer peer : this.getOtherPeers()) {
            if (peer.getUpdatedMultisigHex() == null) continue;
            multisigHexes.add(peer.getUpdatedMultisigHex());
        }
        log.info("Importing multisig hexes for {} {}, count={}", this.getClass().getSimpleName(), this.getShortId(), multisigHexes.size());
        long startTime = System.currentTimeMillis();
        if (!multisigHexes.isEmpty()) {
            try {
                this.wallet.importMultisigHex(multisigHexes.toArray(new String[0]));
                if (this.wallet.isMultisigImportNeeded()) {
                    String errorMessage = "Multisig import still needed for " + this.getClass().getSimpleName() + " " + this.getShortId() + " after already importing, multisigHexes=" + String.valueOf(multisigHexes);
                    log.warn(errorMessage);
                    int maxLength = 0;
                    boolean removed = false;
                    for (String hex : multisigHexes) {
                        maxLength = Math.max(maxLength, hex.length());
                    }
                    for (String hex : new ArrayList(multisigHexes)) {
                        if (hex.length() >= maxLength / 2) continue;
                        String ignoringMessage = "Ignoring multisig hex from " + this.getMultisigHexRole(hex) + " for " + this.getClass().getSimpleName() + " " + this.getShortId() + " because it is too short, multisigHex=" + hex;
                        this.setErrorMessage(ignoringMessage);
                        log.warn(ignoringMessage);
                        multisigHexes.remove(hex);
                        removed = true;
                    }
                    if (removed) {
                        this.wallet.importMultisigHex(multisigHexes.toArray(new String[0]));
                    }
                    if (this.wallet.isMultisigImportNeeded()) {
                        throw new IllegalStateException(errorMessage);
                    }
                }
                this.processModel.setImportMultisigHexScheduled(false);
            }
            catch (MoneroError e) {
                if (this.isInvalidImportError(e.getMessage())) {
                    log.warn("Peer has invalid multisig hex for {} {}, importing individually", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                    boolean imported = false;
                    MoneroError lastError = null;
                    for (TradePeer peer : this.getOtherPeers()) {
                        if (peer.getUpdatedMultisigHex() == null) continue;
                        try {
                            this.wallet.importMultisigHex(peer.getUpdatedMultisigHex());
                            imported = true;
                        }
                        catch (MoneroError e2) {
                            lastError = e2;
                            if (this.isInvalidImportError(e2.getMessage())) {
                                log.warn("{} has invalid multisig hex for {} {}, error={}, multisigHex={}", this.getPeerRole(peer), this.getClass().getSimpleName(), this.getShortId(), e2.getMessage(), peer.getUpdatedMultisigHex());
                                continue;
                            }
                            throw e2;
                        }
                    }
                    if (!imported) {
                        throw new IllegalArgumentException("Could not import any multisig hexes for " + this.getClass().getSimpleName() + " " + this.getShortId(), lastError);
                    }
                }
                throw e;
            }
            this.saveWallet();
        }
        log.info("Done importing multisig hexes for {} {} in {} ms, count={}", this.getClass().getSimpleName(), this.getShortId(), System.currentTimeMillis() - startTime, multisigHexes.size());
    }

    private void handleWalletError(Exception e, MoneroRpcConnection sourceConnection) {
        if (HavenoUtils.isUnresponsive(e)) {
            this.forceCloseWallet();
        }
        if (!HavenoUtils.isIllegal(e) && this.xmrConnectionService.isConnected().booleanValue()) {
            this.requestSwitchToNextBestConnection(sourceConnection);
        }
        this.getWallet();
    }

    private String getMultisigHexRole(String multisigHex) {
        if (multisigHex.equals(this.getArbitrator().getUpdatedMultisigHex())) {
            return "arbitrator";
        }
        if (multisigHex.equals(this.getBuyer().getUpdatedMultisigHex())) {
            return "buyer";
        }
        if (multisigHex.equals(this.getSeller().getUpdatedMultisigHex())) {
            return "seller";
        }
        throw new IllegalArgumentException("Multisig hex does not belong to any peer");
    }

    public MoneroTxWallet createPayoutTx() {
        this.verifyDaemonConnection();
        Object object = this.walletLock;
        synchronized (object) {
            Object object2 = HavenoUtils.getWalletFunctionLock();
            synchronized (object2) {
                this.importMultisigHexIfNeeded();
                for (int i = 0; i < 5; ++i) {
                    MoneroRpcConnection sourceConnection = this.xmrConnectionService.getConnection();
                    try {
                        return this.doCreatePayoutTx();
                    }
                    catch (IllegalArgumentException | IllegalStateException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        this.handleWalletError(e, sourceConnection);
                        this.doPollWallet();
                        if (this.isPayoutPublished()) break;
                        log.warn("Failed to create payout tx, tradeId={}, attempt={}/{}, error={}", this.getShortId(), i + 1, 5, e.getMessage());
                        if (i == 4) {
                            throw e;
                        }
                        HavenoUtils.waitFor(5000L);
                        continue;
                    }
                }
                throw new RuntimeException("Failed to create payout tx for " + this.getClass().getSimpleName() + " " + this.getId());
            }
        }
    }

    private MoneroTxWallet doCreatePayoutTx() {
        if (this.wallet.isMultisigImportNeeded()) {
            throw new IllegalStateException("Cannot create payout tx because multisig import is needed for " + this.getClass().getSimpleName() + " " + this.getShortId());
        }
        this.recoverIfMissingWalletData();
        String sellerPayoutAddress = this.getSeller().getPayoutAddressString();
        String buyerPayoutAddress = this.getBuyer().getPayoutAddressString();
        Preconditions.checkNotNull(sellerPayoutAddress, "Seller payout address must not be null");
        Preconditions.checkNotNull(buyerPayoutAddress, "Buyer payout address must not be null");
        BigInteger sellerDepositAmount = this.getSeller().getDepositTx().getIncomingAmount();
        BigInteger buyerDepositAmount = this.hasBuyerAsTakerWithoutDeposit() ? BigInteger.ZERO : this.getBuyer().getDepositTx().getIncomingAmount();
        BigInteger tradeAmount = this.getAmount();
        BigInteger buyerPayoutAmount = buyerDepositAmount.add(tradeAmount);
        BigInteger sellerPayoutAmount = sellerDepositAmount.subtract(tradeAmount);
        MoneroTxWallet payoutTx = this.createTx(new MoneroTxConfig().setAccountIndex(0).addDestination(buyerPayoutAddress, buyerPayoutAmount).addDestination(sellerPayoutAddress, sellerPayoutAmount).setSubtractFeeFrom(0, 1).setRelay(false).setPriority(XmrWalletService.PROTOCOL_FEE_PRIORITY));
        BigInteger payoutTxFeeSplit = payoutTx.getFee().divide(BigInteger.valueOf(2L));
        this.getBuyer().setPayoutTxFee(payoutTxFeeSplit);
        this.getBuyer().setPayoutAmount(HavenoUtils.getDestination(buyerPayoutAddress, payoutTx).getAmount());
        this.getSeller().setPayoutTxFee(payoutTxFeeSplit);
        this.getSeller().setPayoutAmount(HavenoUtils.getDestination(sellerPayoutAddress, payoutTx).getAmount());
        return payoutTx;
    }

    public MoneroTxWallet createDisputePayoutTx(MoneroTxConfig txConfig) {
        Object object = this.walletLock;
        synchronized (object) {
            Object object2 = HavenoUtils.getWalletFunctionLock();
            synchronized (object2) {
                for (int i = 0; i < 5; ++i) {
                    MoneroRpcConnection sourceConnection = this.xmrConnectionService.getConnection();
                    try {
                        if (this.wallet.isMultisigImportNeeded()) {
                            throw new IllegalStateException("Cannot create dispute payout tx because multisig import is needed for " + this.getClass().getSimpleName() + " " + this.getShortId());
                        }
                        return this.createTx(txConfig);
                    }
                    catch (IllegalArgumentException | IllegalStateException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        if (e.getMessage().contains("not possible")) {
                            throw new IllegalArgumentException("Loser payout is too small to cover the mining fee");
                        }
                        this.handleWalletError(e, sourceConnection);
                        this.doPollWallet();
                        if (this.isPayoutPublished()) break;
                        log.warn("Failed to create dispute payout tx, tradeId={}, attempt={}/{}, error={}", this.getShortId(), i + 1, 5, e.getMessage());
                        if (i == 4) {
                            throw e;
                        }
                        HavenoUtils.waitFor(5000L);
                        continue;
                    }
                }
                throw new RuntimeException("Failed to create payout tx for " + this.getClass().getSimpleName() + " " + this.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPayoutTx(String payoutTxHex, boolean sign, boolean publish) {
        Object object = this.walletLock;
        synchronized (object) {
            Object object2 = HavenoUtils.getWalletFunctionLock();
            synchronized (object2) {
                for (int i = 0; i < 5; ++i) {
                    MoneroRpcConnection sourceConnection = this.xmrConnectionService.getConnection();
                    try {
                        this.doProcessPayoutTx(payoutTxHex, sign, publish);
                        break;
                    }
                    catch (IllegalArgumentException | IllegalStateException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        this.handleWalletError(e, sourceConnection);
                        this.doPollWallet();
                        if (this.isPayoutPublished()) break;
                        log.warn("Failed to process payout tx, tradeId={}, attempt={}/{}, error={}", this.getShortId(), i + 1, 5, e.getMessage(), e);
                        if (i == 4) {
                            throw e;
                        }
                        HavenoUtils.waitFor(5000L);
                        continue;
                    }
                    finally {
                        this.requestSaveWallet();
                        this.requestPersistence();
                    }
                }
            }
        }
    }

    private void doProcessPayoutTx(String payoutTxHex, boolean sign, boolean publish) {
        block20: {
            boolean doPublish;
            boolean doSign;
            log.info("Processing payout tx for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
            this.recoverIfMissingWalletData();
            MoneroWallet wallet = this.getWallet();
            Contract contract = this.getContract();
            BigInteger sellerDepositAmount = this.getSeller().getDepositTx().getIncomingAmount();
            BigInteger buyerDepositAmount = this.hasBuyerAsTakerWithoutDeposit() ? BigInteger.ZERO : this.getBuyer().getDepositTx().getIncomingAmount();
            BigInteger tradeAmount = this.getAmount();
            MoneroTxSet describedTxSet = wallet.describeTxSet(new MoneroTxSet().setMultisigTxHex(payoutTxHex));
            if (describedTxSet.getTxs() == null || describedTxSet.getTxs().size() != 1) {
                throw new IllegalArgumentException("Bad payout tx");
            }
            MoneroTxWallet payoutTx = describedTxSet.getTxs().get(0);
            if (this.payoutTxId == null) {
                this.updatePayout(payoutTx);
            }
            if (payoutTx.getOutgoingTransfer() == null || payoutTx.getOutgoingTransfer().getDestinations() == null || payoutTx.getOutgoingTransfer().getDestinations().size() != 2) {
                throw new IllegalArgumentException("Payout tx does not have exactly two destinations");
            }
            boolean buyerFirst = payoutTx.getOutgoingTransfer().getDestinations().get(0).getAddress().equals(contract.getBuyerPayoutAddressString());
            MoneroDestination buyerPayoutDestination = payoutTx.getOutgoingTransfer().getDestinations().get(buyerFirst ? 0 : 1);
            MoneroDestination sellerPayoutDestination = payoutTx.getOutgoingTransfer().getDestinations().get(buyerFirst ? 1 : 0);
            if (!buyerPayoutDestination.getAddress().equals(contract.getBuyerPayoutAddressString())) {
                throw new IllegalArgumentException("Buyer payout address does not match contract");
            }
            if (!sellerPayoutDestination.getAddress().equals(contract.getSellerPayoutAddressString())) {
                throw new IllegalArgumentException("Seller payout address does not match contract");
            }
            if (!payoutTx.getChangeAmount().equals(BigInteger.ZERO)) {
                log.warn("Dust left in multisig wallet for {} {}: {}", this.getClass().getSimpleName(), this.getId(), payoutTx.getChangeAmount());
            }
            if (!payoutTx.getChangeAmount().equals(BigInteger.ZERO) && !payoutTx.getChangeAddress().equals(wallet.getPrimaryAddress())) {
                throw new IllegalArgumentException("Change address is not multisig wallet's primary address");
            }
            if (!payoutTx.getOutputSum().equals(buyerPayoutDestination.getAmount().add(sellerPayoutDestination.getAmount()).add(payoutTx.getChangeAmount()))) {
                throw new IllegalArgumentException("Sum of outputs != destination amounts + change amount");
            }
            BigInteger txCost = payoutTx.getFee().add(payoutTx.getChangeAmount());
            BigInteger txCostSplit = txCost.divide(BigInteger.valueOf(2L));
            BigInteger expectedBuyerPayout = buyerDepositAmount.add(tradeAmount).subtract(txCostSplit);
            if (!buyerPayoutDestination.getAmount().equals(expectedBuyerPayout)) {
                throw new IllegalArgumentException("Buyer destination amount is not deposit amount + trade amount - 1/2 tx costs, " + String.valueOf(buyerPayoutDestination.getAmount()) + " vs " + String.valueOf(expectedBuyerPayout));
            }
            BigInteger expectedSellerPayout = sellerDepositAmount.subtract(tradeAmount).subtract(txCostSplit);
            if (!sellerPayoutDestination.getAmount().equals(expectedSellerPayout)) {
                throw new IllegalArgumentException("Seller destination amount is not deposit amount - trade amount - 1/2 tx costs, " + String.valueOf(sellerPayoutDestination.getAmount()) + " vs " + String.valueOf(expectedSellerPayout));
            }
            this.updatePayout(payoutTx);
            boolean bl = doSign = sign && this.getPayoutTxHex() == null;
            if (doSign || publish) {
                this.verifyDaemonConnection();
            }
            if (doSign) {
                String signedPayoutTxHex;
                try {
                    MoneroMultisigSignResult result = wallet.signMultisigTxHex(payoutTxHex);
                    if (result.getSignedMultisigTxHex() == null) {
                        throw new IllegalArgumentException("Error signing payout tx, signed multisig hex is null");
                    }
                    signedPayoutTxHex = result.getSignedMultisigTxHex();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                if (this.getOffer().getOfferPayload().getProtocolVersion() >= 2) {
                    log.info("Creating fee estimate tx for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                    this.saveWallet();
                    MoneroTxWallet feeEstimateTx = this.createPayoutTx();
                    HavenoUtils.verifyMinerFee(feeEstimateTx.getFee(), payoutTx.getFee());
                    log.info("Payout tx fee {} is within tolerance");
                }
                this.setPayoutTxHex(signedPayoutTxHex);
                describedTxSet = wallet.describeMultisigTxSet(this.getPayoutTxHex());
                payoutTx = describedTxSet.getTxs().get(0);
                this.updatePayout(payoutTx);
            }
            this.saveWallet();
            this.requestPersistence();
            boolean bl2 = doPublish = publish && !this.isPayoutPublished();
            if (doPublish) {
                try {
                    wallet.submitMultisigTxHex(this.getPayoutTxHex());
                    this.setPayoutStatePublished();
                }
                catch (Exception e) {
                    if (this.isPayoutPublished()) break block20;
                    if (HavenoUtils.isTransactionRejected(e) || HavenoUtils.isNotEnoughSigners(e)) {
                        throw new IllegalArgumentException(e);
                    }
                    throw new RuntimeException("Failed to submit payout tx for " + this.getClass().getSimpleName() + " " + this.getId() + ", error=" + e.getMessage(), e);
                }
            }
        }
    }

    public void decryptPeerPaymentAccountPayload(byte[] paymentAccountKey) {
        try {
            byte[] peerPaymentAccountPayloadHash;
            this.getTradePeer().setPaymentAccountKey(paymentAccountKey);
            SecretKey sk = Encryption.getSecretKeyFromBytes(this.getTradePeer().getPaymentAccountKey());
            byte[] decryptedPaymentAccountPayload = Encryption.decrypt(this.getTradePeer().getEncryptedPaymentAccountPayload(), sk);
            CoreNetworkProtoResolver resolver = new CoreNetworkProtoResolver(Clock.systemDefaultZone());
            PaymentAccountPayload paymentAccountPayload = resolver.fromProto(protobuf.PaymentAccountPayload.parseFrom(decryptedPaymentAccountPayload));
            byte[] byArray = peerPaymentAccountPayloadHash = this instanceof MakerTrade ? this.getContract().getTakerPaymentAccountPayloadHash() : this.getContract().getMakerPaymentAccountPayloadHash();
            if (!Arrays.equals(paymentAccountPayload.getHash(), peerPaymentAccountPayloadHash)) {
                throw new RuntimeException("Hash of peer's payment account payload does not match contract");
            }
            this.getTradePeer().setPaymentAccountPayload(paymentAccountPayload);
            this.processModel.getPaymentAccountDecryptedProperty().set(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public MoneroTx getTakerDepositTx() {
        return this.getTaker().getDepositTx();
    }

    @Nullable
    public MoneroTx getMakerDepositTx() {
        return this.getMaker().getDepositTx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndPersistChatMessage(ChatMessage chatMessage) {
        ObservableList<ChatMessage> observableList = this.chatMessages;
        synchronized (observableList) {
            if (!this.chatMessages.contains(chatMessage)) {
                this.chatMessages.add(chatMessage);
            } else {
                log.error("Trade ChatMessage already exists");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllChatMessages() {
        ObservableList<ChatMessage> observableList = this.chatMessages;
        synchronized (observableList) {
            if (this.chatMessages.size() > 0) {
                this.chatMessages.clear();
                return true;
            }
            return false;
        }
    }

    public boolean mediationResultAppliedPenaltyToSeller() {
        long normalPayoutAmount;
        long payoutAmountFromMediation = this.processModel.getSellerPayoutAmountFromMediation();
        return payoutAmountFromMediation < (normalPayoutAmount = this.getSeller().getSecurityDeposit().longValueExact());
    }

    public void clearAndShutDown() {
        ThreadUtils.execute(() -> {
            this.clearProcessData();
            this.onShutDownStarted();
            ThreadUtils.submitToPool(() -> this.shutDown());
        }, this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearProcessData() {
        Iterator<TradePeer> iterator2 = this.walletLock;
        synchronized (iterator2) {
            if (!this.walletExists()) {
                return;
            }
            this.deleteWallet();
        }
        this.setPayoutTxHex(null);
        for (TradePeer peer : this.getAllPeers()) {
            peer.setUnsignedPayoutTxHex(null);
            peer.setUpdatedMultisigHex(null);
            peer.setDisputeClosedMessage(null);
            peer.setPaymentSentMessage(null);
            if (!peer.isPaymentReceivedMessageReceived()) continue;
            peer.setPaymentReceivedMessage(null);
        }
    }

    public void maybeClearSensitiveData() {
        Object change = "";
        if (this.removeAllChatMessages()) {
            change = (String)change + "chat messages;";
        }
        if (((String)change).length() > 0) {
            log.info("cleared sensitive data from {} of trade {}", change, (Object)this.getShortId());
        }
    }

    public void onShutDownStarted() {
        if (this.wallet != null) {
            log.info("Preparing to shut down {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
        }
        this.isShutDownStarted = true;
        this.stopPolling();
    }

    public void shutDown() {
        if (this.isShutDown) {
            return;
        }
        this.isShutDownStarted = true;
        if (!this.isPayoutUnlocked()) {
            log.info("Shutting down {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
        }
        Runnable shutDownTask = () -> {
            for (int i = 0; i < 20; ++i) {
                Object object = this.getLock();
                synchronized (object) {
                    HavenoUtils.waitFor(10L);
                    continue;
                }
            }
            this.isShutDown = true;
            ArrayList<Runnable> shutDownThreads = new ArrayList<Runnable>();
            shutDownThreads.add(() -> ThreadUtils.shutDown(this.getId()));
            ThreadUtils.awaitTasks(shutDownThreads);
            this.stopProtocolTimeout();
            this.isInitialized = false;
            if (this.wallet != null) {
                try {
                    this.closeWallet();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        try {
            ThreadUtils.awaitTask(shutDownTask, 60000L);
        }
        catch (Exception e) {
            log.warn("Error shutting down {} {}: {}\n", this.getClass().getSimpleName(), this.getId(), e.getMessage(), e);
            this.forceCloseWallet();
        }
        if (this.idlePayoutSyncer != null) {
            this.xmrWalletService.removeWalletListener(this.idlePayoutSyncer);
            this.idlePayoutSyncer = null;
        }
        UserThread.execute(() -> {
            if (this.tradeStateSubscription != null) {
                this.tradeStateSubscription.unsubscribe();
            }
            if (this.tradePhaseSubscription != null) {
                this.tradePhaseSubscription.unsubscribe();
            }
            if (this.payoutStateSubscription != null) {
                this.payoutStateSubscription.unsubscribe();
            }
            if (this.disputeStateSubscription != null) {
                this.disputeStateSubscription.unsubscribe();
            }
        });
    }

    public void onProtocolError() {
        if (this.isDepositsPublished()) {
            this.restoreDepositsPublishedTrade();
            return;
        }
        if (this instanceof TakerTrade) {
            ThreadUtils.submitToPool(() -> this.xmrWalletService.thawOutputs(this.getSelf().getReserveTxKeyImages()));
        }
        Optional<OpenOffer> openOffer = this.processModel.getOpenOfferManager().getOpenOffer(this.getId());
        if (this instanceof MakerTrade && openOffer.isPresent()) {
            this.processModel.getOpenOfferManager().unreserveOpenOffer(openOffer.get());
        }
        if (!this.isDepositRequested() || this.isDepositFailed()) {
            this.removeTradeOnError();
            return;
        }
        if (!this.walletExists()) {
            return;
        }
        if (this.processModel.getTradeProtocolErrorHeight() == 0L) {
            log.warn("Scheduling to remove trade if unfunded for {} {} from height {}", this.getClass().getSimpleName(), this.getId(), this.xmrConnectionService.getLastInfo().getHeight());
            this.processModel.setTradeProtocolErrorHeight(this.xmrConnectionService.getLastInfo().getHeight());
        }
        this.processModel.getTradeManager().onMoveInvalidTradeToFailedTrades(this);
        this.requestPersistence();
        this.protocolErrorStateSubscription = EasyBind.subscribe(this.stateProperty(), state -> {
            if (this.isDepositsPublished()) {
                this.restoreDepositsPublishedTrade();
                if (this.protocolErrorStateSubscription != null) {
                    this.protocolErrorStateSubscription.unsubscribe();
                    this.protocolErrorStateSubscription = null;
                }
            }
        });
        long startTime = System.currentTimeMillis();
        this.protocolErrorHeightSubscription = EasyBind.subscribe(this.walletHeight, lastWalletHeight -> {
            if (this.isShutDown || this.isDepositsPublished()) {
                return;
            }
            if (lastWalletHeight.longValue() < this.processModel.getTradeProtocolErrorHeight() + 2L) {
                return;
            }
            if (System.currentTimeMillis() - startTime < DELETE_AFTER_MS) {
                return;
            }
            ThreadUtils.submitToPool(() -> {
                MoneroTx takerDepositTx;
                MoneroTx makerDepositTx = this.getMaker().getDepositTxHash() == null ? null : this.xmrWalletService.getDaemon().getTx(this.getMaker().getDepositTxHash());
                MoneroTx moneroTx = takerDepositTx = this.getTaker().getDepositTxHash() == null ? null : this.xmrWalletService.getDaemon().getTx(this.getTaker().getDepositTxHash());
                if (makerDepositTx == null && takerDepositTx == null) {
                    log.warn("Deleting {} {} after protocol error", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                    if (this instanceof ArbitratorTrade && (this.getMaker().getReserveTxHash() != null || this.getTaker().getReserveTxHash() != null)) {
                        this.processModel.getTradeManager().onMoveInvalidTradeToFailedTrades(this);
                        this.deleteWallet();
                        this.onShutDownStarted();
                        ThreadUtils.submitToPool(() -> this.shutDown());
                    } else {
                        this.removeTradeOnError();
                    }
                } else if (!this.isPayoutPublished()) {
                    String errorMessage = "Refusing to delete " + this.getClass().getSimpleName() + " " + this.getId() + " after protocol error because its wallet might be funded";
                    this.prependErrorMessage(errorMessage);
                    log.warn(errorMessage);
                }
                if (this.protocolErrorHeightSubscription != null) {
                    this.protocolErrorHeightSubscription.unsubscribe();
                    this.protocolErrorHeightSubscription = null;
                }
            });
        });
    }

    public boolean isProtocolErrorHandlingScheduled() {
        return this.processModel.getTradeProtocolErrorHeight() > 0L;
    }

    private void restoreDepositsPublishedTrade() {
        if (this instanceof MakerTrade && this.processModel.getOpenOfferManager().getOpenOffer(this.getId()).isPresent()) {
            log.info("Closing open offer because {} {} was restored after protocol error", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
            this.processModel.getOpenOfferManager().closeSpentOffer(Preconditions.checkNotNull(this.getOffer()));
        }
        this.xmrWalletService.freezeOutputs(this.getSelf().getReserveTxKeyImages());
        this.processModel.getTradeManager().onMoveFailedTradeToPendingTrades(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTradeOnError() {
        Object object = this.removeTradeOnErrorLock;
        synchronized (object) {
            if (this.isShutDown || !this.processModel.getTradeManager().hasTrade(this.getId())) {
                return;
            }
            log.warn("removeTradeOnError() trade={}, tradeId={}, state={}", new Object[]{this.getClass().getSimpleName(), this.getShortId(), this.getState()});
            this.forceCloseWallet();
            if (this.isDepositRequested()) {
                this.getWallet();
            }
            this.onShutDownStarted();
            this.clearAndShutDown();
            try {
                ThreadUtils.shutDown(this.getId(), 5000L);
            }
            catch (Exception e) {
                log.warn("Error shutting down trade thread for {} {}: {}", this.getClass().getSimpleName(), this.getId(), e.getMessage());
            }
            this.processModel.getTradeManager().unregisterTrade(this);
        }
    }

    @Override
    public void onComplete() {
    }

    public abstract BigInteger getPayoutAmountBeforeCost();

    public abstract boolean confirmPermitted();

    public void setStateIfValidTransitionTo(State newState) {
        if (this.state.isValidTransitionTo(newState)) {
            this.setState(newState);
        }
    }

    public void addInitProgressStep() {
        this.startProtocolTimeout();
        this.initProgress = Math.min(1.0, (double)(++this.initStep) / 24.0);
        UserThread.execute(() -> this.initProgressProperty.set(this.initProgress));
    }

    public void startProtocolTimeout() {
        this.getProtocol().startTimeout(TradeProtocol.TRADE_STEP_TIMEOUT_SECONDS);
    }

    public void stopProtocolTimeout() {
        if (!this.isInitialized) {
            return;
        }
        TradeProtocol protocol = this.getProtocol();
        if (protocol == null) {
            return;
        }
        protocol.stopTimeout();
    }

    public void setState(State state) {
        if (this.isInitialized) {
            log.info("Set new state at {} (id={}): {}", new Object[]{this.getClass().getSimpleName(), this.getShortId(), state});
        }
        if (state.getPhase().ordinal() < this.state.getPhase().ordinal()) {
            String message = "We got a state change to a previous phase (id=" + this.getShortId() + ").\nOld state is: " + String.valueOf((Object)this.state) + ". New state is: " + String.valueOf((Object)state);
            log.warn(message);
        }
        this.state = state;
        this.requestPersistence();
        UserThread.execute(() -> {
            this.stateProperty.set(state);
            this.phaseProperty.set(state.getPhase());
        });
    }

    public void advanceState(State state) {
        if (state.ordinal() > this.getState().ordinal()) {
            this.setState(state);
        }
    }

    public void setPayoutStateIfValidTransitionTo(PayoutState newPayoutState) {
        if (this.payoutState.isValidTransitionTo(newPayoutState)) {
            this.setPayoutState(newPayoutState);
        } else {
            log.warn("Payout state change is not getting applied because it would cause an invalid transition. Trade payout state={}, intended payout state={}", (Object)this.payoutState, (Object)newPayoutState);
        }
    }

    public void setPayoutState(PayoutState payoutState) {
        if (this.isInitialized) {
            log.info("Set new payout state for {} {}: {}", new Object[]{this.getClass().getSimpleName(), this.getId(), payoutState});
        }
        if (payoutState.ordinal() < this.payoutState.ordinal()) {
            String message = "We got a payout state change to a previous phase (id=" + this.getShortId() + ").\nOld payout state is: " + String.valueOf((Object)this.state) + ". New payout state is: " + String.valueOf((Object)payoutState);
            log.warn(message);
        }
        this.payoutState = payoutState;
        this.requestPersistence();
        UserThread.execute(() -> this.payoutStateProperty.set(payoutState));
    }

    public void setDisputeState(DisputeState disputeState) {
        if (this.isInitialized) {
            log.info("Set new dispute state for {} {}: {}", new Object[]{this.getClass().getSimpleName(), this.getShortId(), disputeState});
        }
        if (disputeState.ordinal() < this.disputeState.ordinal()) {
            String message = "We got a dispute state change to a previous state (id=" + this.getShortId() + ").\nOld dispute state is: " + String.valueOf((Object)this.disputeState) + ". New dispute state is: " + String.valueOf((Object)disputeState);
            log.warn(message);
        }
        this.disputeState = disputeState;
        UserThread.execute(() -> this.disputeStateProperty.set(disputeState));
    }

    public void advanceDisputeState(DisputeState disputeState) {
        if (disputeState.ordinal() > this.getDisputeState().ordinal()) {
            this.setDisputeState(disputeState);
        }
    }

    public List<Dispute> getDisputes() {
        return HavenoUtils.arbitrationManager.findDisputes(this.getId());
    }

    public void setMediationResultState(MediationResultState mediationResultState) {
        this.mediationResultState = mediationResultState;
        this.mediationResultStateProperty.set(mediationResultState);
    }

    public void setRefundResultState(RefundResultState refundResultState) {
        this.refundResultState = refundResultState;
        this.refundResultStateProperty.set(refundResultState);
    }

    public void setPeriodState(TradePeriodState tradePeriodState) {
        this.periodState = tradePeriodState;
        this.tradePeriodStateProperty.set(tradePeriodState);
    }

    public void setAmount(BigInteger tradeAmount) {
        this.amount = tradeAmount.longValueExact();
        this.getAmountProperty().set(this.getAmount());
        this.getVolumeProperty().set(this.getVolume());
    }

    public void updatePayout(MoneroTxWallet payoutTx) {
        this.payoutTx = payoutTx;
        this.payoutTxKey = payoutTx.getKey();
        this.payoutTxFee = payoutTx.getFee().longValueExact();
        this.payoutTxId = payoutTx.getHash();
        if ("".equals(this.payoutTxId)) {
            this.payoutTxId = null;
        }
        for (Dispute dispute : this.getDisputes()) {
            dispute.setDisputePayoutTxId(this.payoutTxId);
        }
        if (this.isPaymentReceived()) {
            BigInteger splitTxFee = payoutTx.getFee().divide(BigInteger.valueOf(2L));
            this.getBuyer().setPayoutTxFee(splitTxFee);
            this.getSeller().setPayoutTxFee(splitTxFee);
            this.getBuyer().setPayoutAmount(this.getBuyer().getSecurityDeposit().subtract(this.getBuyer().getPayoutTxFee()).add(this.getAmount()));
            this.getSeller().setPayoutAmount(this.getSeller().getSecurityDeposit().subtract(this.getSeller().getPayoutTxFee()));
        } else {
            DisputeResult disputeResult = this.getDisputeResult();
            if (disputeResult != null) {
                BigInteger[] buyerSellerPayoutTxFees = ArbitrationManager.getBuyerSellerPayoutTxCost(disputeResult, payoutTx.getFee());
                this.getBuyer().setPayoutTxFee(buyerSellerPayoutTxFees[0]);
                this.getSeller().setPayoutTxFee(buyerSellerPayoutTxFees[1]);
                this.getBuyer().setPayoutAmount(disputeResult.getBuyerPayoutAmountBeforeCost().subtract(this.getBuyer().getPayoutTxFee()));
                this.getSeller().setPayoutAmount(disputeResult.getSellerPayoutAmountBeforeCost().subtract(this.getSeller().getPayoutTxFee()));
            }
        }
    }

    public DisputeResult getDisputeResult() {
        if (this.getDisputes().isEmpty()) {
            return null;
        }
        return (DisputeResult)this.getDisputes().get(this.getDisputes().size() - 1).getDisputeResultProperty().get();
    }

    @Nullable
    public MoneroTx getPayoutTx() {
        if (this.payoutTx == null) {
            this.payoutTx = this.payoutTxId == null ? null : (this instanceof ArbitratorTrade ? this.xmrWalletService.getDaemonTxWithCache(this.payoutTxId) : this.xmrWalletService.getTx(this.payoutTxId));
        }
        return this.payoutTx;
    }

    public void setPayoutTxFee(BigInteger payoutTxFee) {
        this.payoutTxFee = payoutTxFee.longValueExact();
    }

    public BigInteger getPayoutTxFee() {
        return BigInteger.valueOf(this.payoutTxFee);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        this.errorMessageProperty.set(errorMessage);
    }

    public void prependErrorMessage(String errorMessage) {
        String appendedErrorMessage;
        StringBuilder sb = new StringBuilder();
        sb.append(errorMessage);
        if (this.errorMessage != null && !this.errorMessage.isEmpty()) {
            sb.append("\n\n---- Previous Error -----\n\n");
            sb.append(this.errorMessage);
        }
        this.errorMessage = appendedErrorMessage = sb.toString();
        this.errorMessageProperty.set(appendedErrorMessage);
    }

    public boolean isArbitrator() {
        return this instanceof ArbitratorTrade;
    }

    public boolean isBuyer() {
        return this.getBuyer() == this.getSelf();
    }

    public boolean isSeller() {
        return this.getSeller() == this.getSelf();
    }

    public boolean isMaker() {
        return this instanceof MakerTrade;
    }

    public boolean isTaker() {
        return this instanceof TakerTrade;
    }

    public TradePeer getSelf() {
        if (this instanceof MakerTrade) {
            return this.processModel.getMaker();
        }
        if (this instanceof TakerTrade) {
            return this.processModel.getTaker();
        }
        if (this instanceof ArbitratorTrade) {
            return this.processModel.getArbitrator();
        }
        throw new RuntimeException("Trade is not maker, taker, or arbitrator");
    }

    private List<TradePeer> getOtherPeers() {
        List<TradePeer> peers = this.getAllPeers();
        if (!peers.remove(this.getSelf())) {
            throw new IllegalStateException("Failed to remove self from list of peers");
        }
        return peers;
    }

    private List<TradePeer> getAllPeers() {
        ArrayList<TradePeer> peers = new ArrayList<TradePeer>();
        peers.add(this.getMaker());
        peers.add(this.getTaker());
        peers.add(this.getArbitrator());
        return peers;
    }

    public TradePeer getArbitrator() {
        return this.processModel.getArbitrator();
    }

    public TradePeer getMaker() {
        return this.processModel.getMaker();
    }

    public TradePeer getTaker() {
        return this.processModel.getTaker();
    }

    public TradePeer getBuyer() {
        return this.offer.getDirection() == OfferDirection.BUY ? this.processModel.getMaker() : this.processModel.getTaker();
    }

    public TradePeer getSeller() {
        return this.offer.getDirection() == OfferDirection.BUY ? this.processModel.getTaker() : this.processModel.getMaker();
    }

    public TradePeer getTradePeer() {
        if (this instanceof MakerTrade) {
            return this.processModel.getTaker();
        }
        if (this instanceof TakerTrade) {
            return this.processModel.getMaker();
        }
        if (this instanceof ArbitratorTrade) {
            return null;
        }
        throw new RuntimeException("Unknown trade type: " + this.getClass().getName());
    }

    public TradePeer getTradePeer(NodeAddress address) {
        if (address.equals(this.getMaker().getNodeAddress())) {
            return this.processModel.getMaker();
        }
        if (address.equals(this.getTaker().getNodeAddress())) {
            return this.processModel.getTaker();
        }
        if (address.equals(this.getArbitrator().getNodeAddress())) {
            return this.processModel.getArbitrator();
        }
        return null;
    }

    public TradePeer getTradePeer(PubKeyRing pubKeyRing) {
        if (this.getMaker() != null && this.getMaker().getPubKeyRing().equals(pubKeyRing)) {
            return this.getMaker();
        }
        if (this.getTaker() != null && this.getTaker().getPubKeyRing().equals(pubKeyRing)) {
            return this.getTaker();
        }
        if (this.getArbitrator() != null && this.getArbitrator().getPubKeyRing().equals(pubKeyRing)) {
            return this.getArbitrator();
        }
        return null;
    }

    public String getRole() {
        if (this.isBuyer()) {
            return "Buyer";
        }
        if (this.isSeller()) {
            return "Seller";
        }
        if (this.isArbitrator()) {
            return "Arbitrator";
        }
        throw new IllegalArgumentException("Trade is not buyer, seller, or arbitrator");
    }

    private MessageState getPaymentSentMessageState() {
        if (this.isPaymentReceived()) {
            return MessageState.ACKNOWLEDGED;
        }
        if (this.getSeller().getPaymentSentMessageStateProperty().get() == MessageState.ACKNOWLEDGED) {
            return MessageState.ACKNOWLEDGED;
        }
        if (this.getSeller().getPaymentSentMessageStateProperty().get() == MessageState.NACKED) {
            return MessageState.NACKED;
        }
        switch (this.state.ordinal()) {
            case 16: {
                return MessageState.SENT;
            }
            case 19: {
                return MessageState.ARRIVED;
            }
            case 18: {
                return MessageState.STORED_IN_MAILBOX;
            }
            case 20: {
                return MessageState.ACKNOWLEDGED;
            }
            case 17: {
                return MessageState.FAILED;
            }
        }
        return null;
    }

    public String getPeerRole(TradePeer peer) {
        if (peer == this.getBuyer()) {
            return "Buyer";
        }
        if (peer == this.getSeller()) {
            return "Seller";
        }
        if (peer == this.getArbitrator()) {
            return "Arbitrator";
        }
        throw new IllegalArgumentException("Peer is not buyer, seller, or arbitrator");
    }

    public Date getTakeOfferDate() {
        return new Date(this.takeOfferDate);
    }

    public Phase getPhase() {
        return this.state.getPhase();
    }

    @Nullable
    public Volume getVolume() {
        try {
            if (this.getAmount() != null && this.getPrice() != null) {
                Volume volumeByAmount = this.getPrice().getVolumeByAmount(this.getAmount());
                if (this.offer != null) {
                    volumeByAmount = VolumeUtil.getAdjustedVolume(volumeByAmount, this.offer.getPaymentMethod().getId());
                }
                return volumeByAmount;
            }
            return null;
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    public Date getHalfTradePeriodDate() {
        return new Date(this.getStartTime() + this.getMaxTradePeriod() / 2L);
    }

    public Date getMaxTradePeriodDate() {
        return new Date(this.getStartTime() + this.getMaxTradePeriod());
    }

    private long getMaxTradePeriod() {
        return this.getOffer().getPaymentMethod().getMaxTradePeriod();
    }

    private long getStartTime() {
        long now = System.currentTimeMillis();
        if (this.isDepositsConfirmed() && this.getTakeOfferDate() != null) {
            if (this.isDepositsUnlocked()) {
                if (this.startTime <= 0L) {
                    this.setStartTimeFromUnlockedTxs();
                }
                return this.startTime;
            }
            log.debug("depositTx not confirmed yet. We don't start counting remaining trade period yet. makerTxId={}, takerTxId={}", (Object)this.getMaker().getDepositTxHash(), (Object)this.getTaker().getDepositTxHash());
            return now;
        }
        return now;
    }

    private void setStartTimeFromUnlockedTxs() {
        long now = System.currentTimeMillis();
        long tradeTime = this.getTakeOfferDate().getTime();
        MoneroDaemonRpc daemonRpc = this.xmrWalletService.getDaemon();
        if (daemonRpc == null) {
            throw new RuntimeException("Cannot set start time for trade " + this.getId() + " because it has no connection to monerod");
        }
        if (this.getMakerDepositTx() == null || this.getTakerDepositTx() == null && !this.hasBuyerAsTakerWithoutDeposit()) {
            throw new RuntimeException("Cannot set start time for trade " + this.getId() + " because its unlocked deposit tx is null. Is client connected to a daemon?");
        }
        long unlockHeight = Math.max(this.getMakerDepositTx().getHeight() + 10L - 1L, this.hasBuyerAsTakerWithoutDeposit() ? 0L : this.getTakerDepositTx().getHeight() + 10L - 1L);
        long unlockTime = daemonRpc.getBlockByHeight(unlockHeight).getTimestamp() * 1000L;
        this.startTime = unlockTime > now ? now : Math.max(unlockTime, tradeTime);
        log.debug("We set the start for the trade period to {}. Trade started at: {}. Block got mined at: {}", new Date(this.startTime), new Date(tradeTime), new Date(unlockTime));
    }

    public boolean hasFailed() {
        return this.errorMessageProperty().get() != null;
    }

    public boolean isInPreparation() {
        return this.getState().getPhase().ordinal() == Phase.INIT.ordinal();
    }

    public boolean isDepositRequested() {
        return this.getState().getPhase().ordinal() >= Phase.DEPOSIT_REQUESTED.ordinal();
    }

    public boolean isDepositFailed() {
        return this.getState() == State.PUBLISH_DEPOSIT_TX_REQUEST_FAILED;
    }

    public boolean isDepositsPublished() {
        if (this.isDepositFailed()) {
            return false;
        }
        return this.getState().getPhase().ordinal() >= Phase.DEPOSITS_PUBLISHED.ordinal() && this.getMaker().getDepositTxHash() != null && (this.getTaker().getDepositTxHash() != null || this.hasBuyerAsTakerWithoutDeposit());
    }

    public boolean isFundsLockedIn() {
        return this.isDepositsPublished() && !this.isPayoutPublished();
    }

    public boolean isDepositsConfirmed() {
        return this.isDepositsPublished() && this.getState().getPhase().ordinal() >= Phase.DEPOSITS_CONFIRMED.ordinal();
    }

    public boolean isDepositsConfirmedAcked() {
        if (this instanceof BuyerTrade) {
            return this.getArbitrator().isDepositsConfirmedMessageAcked();
        }
        for (TradePeer peer : this.getOtherPeers()) {
            if (peer.isDepositsConfirmedMessageAcked()) continue;
            return false;
        }
        return true;
    }

    public boolean isDepositsUnlocked() {
        return this.isDepositsPublished() && this.getState().getPhase().ordinal() >= Phase.DEPOSITS_UNLOCKED.ordinal();
    }

    public boolean isPaymentSent() {
        return this.getState().getPhase().ordinal() >= Phase.PAYMENT_SENT.ordinal() && this.getState() != State.BUYER_SEND_FAILED_PAYMENT_SENT_MSG;
    }

    public boolean hasPaymentReceivedMessage() {
        return (this.isSeller() ? this.getBuyer() : this.getSeller()).getPaymentReceivedMessage() != null;
    }

    public boolean hasDisputeClosedMessage() {
        return this.isArbitrator() ? this.getBuyer().getDisputeClosedMessage() != null || this.getSeller().getDisputeClosedMessage() != null : this.getArbitrator().getDisputeClosedMessage() != null;
    }

    public boolean isDisputeClosed() {
        return this.getDisputeState().isClosed();
    }

    public boolean isPaymentReceived() {
        return this.getState().getPhase().ordinal() >= Phase.PAYMENT_RECEIVED.ordinal() && this.getState() != State.SELLER_SEND_FAILED_PAYMENT_RECEIVED_MSG;
    }

    public boolean isPayoutPublished() {
        return this.getPayoutState().ordinal() >= PayoutState.PAYOUT_PUBLISHED.ordinal();
    }

    public boolean isPayoutConfirmed() {
        return this.getPayoutState().ordinal() >= PayoutState.PAYOUT_CONFIRMED.ordinal();
    }

    public boolean isPayoutUnlocked() {
        return this.getPayoutState().ordinal() >= PayoutState.PAYOUT_UNLOCKED.ordinal();
    }

    public ReadOnlyDoubleProperty initProgressProperty() {
        return this.initProgressProperty;
    }

    public ReadOnlyObjectProperty<State> stateProperty() {
        return this.stateProperty;
    }

    public ReadOnlyObjectProperty<Phase> statePhaseProperty() {
        return this.phaseProperty;
    }

    public ReadOnlyObjectProperty<PayoutState> payoutStateProperty() {
        return this.payoutStateProperty;
    }

    public ReadOnlyObjectProperty<DisputeState> disputeStateProperty() {
        return this.disputeStateProperty;
    }

    public ReadOnlyObjectProperty<MediationResultState> mediationResultStateProperty() {
        return this.mediationResultStateProperty;
    }

    public ReadOnlyObjectProperty<RefundResultState> refundResultStateProperty() {
        return this.refundResultStateProperty;
    }

    public ReadOnlyObjectProperty<TradePeriodState> tradePeriodStateProperty() {
        return this.tradePeriodStateProperty;
    }

    public ReadOnlyObjectProperty<BigInteger> tradeAmountProperty() {
        return this.tradeAmountProperty;
    }

    public ReadOnlyObjectProperty<Volume> tradeVolumeProperty() {
        return this.tradeVolumeProperty;
    }

    public ReadOnlyStringProperty errorMessageProperty() {
        return this.errorMessageProperty;
    }

    @Override
    public Date getDate() {
        return this.getTakeOfferDate();
    }

    @Override
    public String getId() {
        return this.offer.getId();
    }

    @Override
    public String getShortId() {
        return this.offer.getShortId();
    }

    public String getShortUid() {
        return Utilities.getShortId(this.getUid());
    }

    public BigInteger getFrozenAmount() {
        BigInteger sum = BigInteger.ZERO;
        if (this.getSelf().getReserveTxKeyImages() != null) {
            for (String keyImage : this.getSelf().getReserveTxKeyImages()) {
                List<MoneroOutputWallet> outputs = this.xmrWalletService.getOutputs(new MoneroOutputQuery().setIsFrozen(true).setIsSpent(false).setKeyImage(new MoneroKeyImage(keyImage)));
                if (outputs.isEmpty()) continue;
                sum = sum.add(outputs.get(0).getAmount());
            }
        }
        return sum;
    }

    public BigInteger getReservedAmount() {
        if (this.isArbitrator() || !this.isDepositsPublished() || this.isPayoutPublished()) {
            return BigInteger.ZERO;
        }
        return this.isBuyer() ? this.getBuyer().getSecurityDeposit() : this.getAmount().add(this.getSeller().getSecurityDeposit());
    }

    public Price getPrice() {
        return Price.valueOf(this.offer.getCurrencyCode(), this.price);
    }

    @Nullable
    public BigInteger getAmount() {
        return BigInteger.valueOf(this.amount);
    }

    public BigInteger getMakerFee() {
        return this.offer.getMakerFee(this.getAmount());
    }

    public BigInteger getTakerFee() {
        return this.hasBuyerAsTakerWithoutDeposit() ? BigInteger.ZERO : this.offer.getTakerFee(this.getAmount());
    }

    public BigInteger getSecurityDepositBeforeMiningFee() {
        return this.isBuyer() ? this.getBuyerSecurityDepositBeforeMiningFee() : this.getSellerSecurityDepositBeforeMiningFee();
    }

    public BigInteger getBuyerSecurityDepositBeforeMiningFee() {
        return this.offer.getOfferPayload().getBuyerSecurityDepositForTradeAmount(this.getAmount());
    }

    public BigInteger getSellerSecurityDepositBeforeMiningFee() {
        return this.offer.getOfferPayload().getSellerSecurityDepositForTradeAmount(this.getAmount());
    }

    public boolean isBuyerAsTakerWithoutDeposit() {
        return this.isBuyer() && this.isTaker() && BigInteger.ZERO.equals(this.getBuyerSecurityDepositBeforeMiningFee());
    }

    public boolean hasBuyerAsTakerWithoutDeposit() {
        return this.getOffer().getOfferPayload().isBuyerAsTakerWithoutDeposit();
    }

    @Override
    public BigInteger getTotalTxFee() {
        return this.getSelf().getDepositTxFee().add(this.getSelf().getPayoutTxFee());
    }

    public boolean hasErrorMessage() {
        return this.getErrorMessage() != null && !this.getErrorMessage().isEmpty();
    }

    @Nullable
    public String getErrorMessage() {
        return (String)this.errorMessageProperty.get();
    }

    public boolean isTxChainInvalid() {
        return this.processModel.getMaker().getDepositTxHash() == null || this.processModel.getTaker().getDepositTxHash() == null && !this.hasBuyerAsTakerWithoutDeposit();
    }

    public long getReprocessDelayInSeconds(int reprocessCount) {
        int retryCycles = 3;
        if (reprocessCount < retryCycles) {
            return this.xmrConnectionService.getRefreshPeriodMs() / 1000L;
        }
        long delay = 60L;
        for (int i = retryCycles; i < reprocessCount; ++i) {
            delay *= 2L;
        }
        return Math.min(7200L, delay);
    }

    public void maybePublishTradeStatistics() {
        if (this.shouldPublishTradeStatistics()) {
            this.doPublishTradeStatistics();
        }
    }

    public boolean shouldPublishTradeStatistics() {
        if (!this.isSeller()) {
            return false;
        }
        return this.tradeAmountTransferred();
    }

    private boolean tradeAmountTransferred() {
        return this.isPaymentReceived() || this.getDisputeResult() != null && this.getDisputeResult().getWinner() == DisputeResult.Winner.SELLER;
    }

    private void doPublishTradeStatistics() {
        boolean isTorNetworkNode;
        String referralId = this.processModel.getReferralIdService().getOptionalReferralId().orElse(null);
        TradeStatistics3 tradeStatistics = TradeStatistics3.from(this, referralId, isTorNetworkNode = this.getProcessModel().getP2PService().getNetworkNode() instanceof TorNetworkNode, true);
        if (tradeStatistics.isValid()) {
            log.info("Publishing trade statistics for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
            this.processModel.getP2PService().addPersistableNetworkPayload(tradeStatistics, true);
        } else {
            log.warn("Trade statistics are invalid for {} {}. We do not publish: {}", this.getClass().getSimpleName(), this.getId(), tradeStatistics);
        }
    }

    private ObjectProperty<BigInteger> getAmountProperty() {
        if (this.tradeAmountProperty == null) {
            this.tradeAmountProperty = this.getAmount() != null ? new SimpleObjectProperty<BigInteger>(this.getAmount()) : new SimpleObjectProperty();
        }
        return this.tradeAmountProperty;
    }

    private ObjectProperty<Volume> getVolumeProperty() {
        if (this.tradeVolumeProperty == null) {
            this.tradeVolumeProperty = this.getVolume() != null ? new SimpleObjectProperty<Volume>(this.getVolume()) : new SimpleObjectProperty();
        }
        return this.tradeVolumeProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onConnectionChanged(MoneroRpcConnection connection) {
        Object object = this.walletLock;
        synchronized (object) {
            connection = this.xmrConnectionService.getConnection();
            if (this.isShutDownStarted) {
                return;
            }
            if (this.getWallet() == null) {
                return;
            }
            if (HavenoUtils.connectionConfigsEqual(connection, this.wallet.getDaemonConnection())) {
                this.updatePollPeriod();
                return;
            }
            String oldProxyUri = this.wallet.getDaemonConnection() == null ? null : this.wallet.getDaemonConnection().getProxyUri();
            String newProxyUri = connection == null ? null : connection.getProxyUri();
            log.info("Setting daemon connection for trade wallet {}: uri={}, proxyUri={}", this.getId(), connection == null ? null : connection.getUri(), newProxyUri);
            if (this.xmrWalletService.isProxyApplied(this.wasWalletSynced) && this.wallet instanceof MoneroWalletRpc && !StringUtils.equals(oldProxyUri, newProxyUri)) {
                log.info("Restarting trade wallet {} because proxy URI has changed, old={}, new={}", this.getId(), oldProxyUri, newProxyUri);
                this.closeWallet();
                this.wallet = this.getWallet();
            } else {
                this.wallet.setDaemonConnection(connection);
            }
            if (this.isInitialized && connection != null && !Boolean.FALSE.equals(this.xmrConnectionService.isConnected())) {
                ThreadUtils.execute(() -> this.tryInitSyncing(), this.getId());
            }
        }
    }

    private void tryInitSyncing() {
        if (this.isShutDownStarted) {
            return;
        }
        List<MoneroTxWallet> depositTxs = this.wallet.getTxs(new MoneroTxQuery().setIncludeOutputs(true).setInTxPool(false));
        this.setDepositTxs(depositTxs);
        if (!this.isIdling()) {
            this.doTryInitSyncing();
        } else {
            long startSyncingInMs = ThreadLocalRandom.current().nextLong(0L, this.getPollPeriod());
            UserThread.runAfter(() -> ThreadUtils.execute(() -> {
                if (!this.isShutDownStarted) {
                    this.doTryInitSyncing();
                }
            }, this.getId()), startSyncingInMs / 1000L);
        }
    }

    private void doTryInitSyncing() {
        if (!this.wasWalletSynced) {
            this.trySyncWallet(true);
        }
        this.updatePollPeriod();
        this.startPolling();
    }

    private void trySyncWallet(boolean pollWallet) {
        block2: {
            try {
                this.syncWallet(pollWallet);
            }
            catch (Exception e) {
                if (this.isShutDownStarted || !this.walletExists()) break block2;
                log.warn("Error syncing trade wallet for {} {}: {}", this.getClass().getSimpleName(), this.getId(), e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncWallet(boolean pollWallet) {
        MoneroRpcConnection sourceConnection = this.xmrConnectionService.getConnection();
        try {
            Object object = this.walletLock;
            synchronized (object) {
                if (this.getWallet() == null) {
                    throw new RuntimeException("Cannot sync trade wallet because it doesn't exist for " + this.getClass().getSimpleName() + ", " + this.getId());
                }
                if (this.getWallet().getDaemonConnection() == null) {
                    throw new RuntimeException("Cannot sync trade wallet because it's not connected to a Monero daemon for " + this.getClass().getSimpleName() + ", " + this.getId());
                }
                if (this.isWalletBehind()) {
                    log.info("Syncing wallet for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                    long startTime = System.currentTimeMillis();
                    this.syncWalletIfBehind();
                    log.info("Done syncing wallet for {} {} in {} ms", this.getClass().getSimpleName(), this.getShortId(), System.currentTimeMillis() - startTime);
                }
            }
            if (!this.wasWalletSynced) {
                this.wasWalletSynced = true;
                if (this.xmrWalletService.isProxyApplied(this.wasWalletSynced)) {
                    this.onConnectionChanged(this.xmrConnectionService.getConnection());
                }
            }
            if (pollWallet) {
                this.doPollWallet();
            }
        }
        catch (Exception e) {
            if (!this.isShutDownStarted) {
                ThreadUtils.execute(() -> this.requestSwitchToNextBestConnection(sourceConnection), this.getId());
            }
            throw e;
        }
    }

    public void updatePollPeriod() {
        if (this.isShutDownStarted) {
            return;
        }
        this.setPollPeriod(this.getPollPeriod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPollPeriod(long pollPeriodMs) {
        Object object = this.pollLock;
        synchronized (object) {
            if (this.isShutDownStarted) {
                return;
            }
            if (this.pollPeriodMs != null && this.pollPeriodMs == pollPeriodMs) {
                return;
            }
            this.pollPeriodMs = pollPeriodMs;
            if (this.isPolling()) {
                this.stopPolling();
                this.startPolling();
            }
        }
    }

    private long getPollPeriod() {
        if (this.isIdling()) {
            return 1680000L;
        }
        return this.xmrConnectionService.getRefreshPeriodMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPolling() {
        Object object = this.pollLock;
        synchronized (object) {
            if (this.isShutDownStarted || this.isPolling()) {
                return;
            }
            this.updatePollPeriod();
            log.info("Starting to poll wallet for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
            this.pollLooper = new TaskLooper(() -> this.pollWallet());
            this.pollLooper.start(this.pollPeriodMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPolling() {
        Object object = this.pollLock;
        synchronized (object) {
            if (this.isPolling()) {
                this.pollLooper.stop();
                this.pollLooper = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPolling() {
        Object object = this.pollLock;
        synchronized (object) {
            return this.pollLooper != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollWallet() {
        Object object = this.pollLock;
        synchronized (object) {
            if (this.pollInProgress) {
                return;
            }
        }
        this.doPollWallet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPollWallet() {
        block80: {
            if (this.isShutDownStarted) {
                return;
            }
            boolean pollInProgressSet = false;
            Object object = this.pollLock;
            synchronized (object) {
                if (!this.pollInProgress) {
                    pollInProgressSet = true;
                }
                this.pollInProgress = true;
            }
            try {
                boolean updatePool;
                boolean isPayoutExpected;
                Object sellerSecurityDeposit;
                if (this.isPayoutUnlocked()) {
                    return;
                }
                if (!this.isDepositRequested() || this.processModel.getMaker().getDepositTxHash() == null || this.processModel.getTaker().getDepositTxHash() == null && !this.hasBuyerAsTakerWithoutDeposit()) {
                    return;
                }
                if (this.xmrConnectionService.getTargetHeight() == null || !this.xmrConnectionService.isSyncedWithinTolerance()) {
                    return;
                }
                if (this.walletHeight.get() < this.xmrConnectionService.getTargetHeight() - 360L) {
                    this.syncWallet(false);
                }
                if (!this.isDepositsUnlocked()) {
                    List<MoneroTxWallet> txs;
                    this.syncWalletIfBehind();
                    MoneroTxQuery query = new MoneroTxQuery().setIncludeOutputs(true);
                    Boolean updatePool2 = !this.isDepositsConfirmed() && (this.getMaker().getDepositTx() == null || this.getTaker().getDepositTx() == null && this.hasBuyerAsTakerWithoutDeposit());
                    if (!updatePool2.booleanValue()) {
                        query.setInTxPool(false);
                    }
                    if (!updatePool2.booleanValue()) {
                        txs = this.wallet.getTxs(query);
                    } else {
                        Object object2 = this.walletLock;
                        synchronized (object2) {
                            Object object3 = HavenoUtils.getDaemonLock();
                            synchronized (object3) {
                                txs = this.wallet.getTxs(query);
                            }
                        }
                    }
                    this.setDepositTxs(txs);
                    if (!Trade.isPublished(this.getMaker().getDepositTx()) || !this.hasBuyerAsTakerWithoutDeposit() && !Trade.isPublished(this.getTaker().getDepositTx())) {
                        return;
                    }
                    this.setStateDepositsSeen();
                    if (this.getBuyer().getSecurityDeposit().longValueExact() == 0L) {
                        BigInteger buyerSecurityDeposit = this.hasBuyerAsTakerWithoutDeposit() ? BigInteger.ZERO : this.getBuyer().getDepositTx().getIncomingAmount();
                        sellerSecurityDeposit = this.getSeller().getDepositTx().getIncomingAmount().subtract(this.getAmount());
                        this.getBuyer().setSecurityDeposit(buyerSecurityDeposit);
                        this.getSeller().setSecurityDeposit((BigInteger)sellerSecurityDeposit);
                    }
                    if (this.getMaker().getDepositTx().isConfirmed().booleanValue() && (this.hasBuyerAsTakerWithoutDeposit() || this.getTaker().getDepositTx().isConfirmed().booleanValue())) {
                        this.setStateDepositsConfirmed();
                    }
                    if (this.getMaker().getDepositTx().getNumConfirmations() >= 10L && (this.hasBuyerAsTakerWithoutDeposit() || this.getTaker().getDepositTx().getNumConfirmations() >= 10L)) {
                        this.setStateDepositsUnlocked();
                    }
                }
                if (!this.isDepositsUnlocked()) break block80;
                boolean bl = isPayoutExpected = this.isPaymentReceived() || this.hasPaymentReceivedMessage() || this.hasDisputeClosedMessage() || this.disputeState.ordinal() >= DisputeState.ARBITRATOR_SENT_DISPUTE_CLOSED_MSG.ordinal();
                if (isPayoutExpected || this.isPayoutPublished()) {
                    this.syncWalletIfBehind();
                }
                if (isPayoutExpected && this.wallet.getBalance().compareTo(BigInteger.ZERO) > 0) {
                    MoneroRpcConnection sourceConnection = this.xmrConnectionService.getConnection();
                    try {
                        this.wallet.rescanSpent();
                    }
                    catch (Exception e) {
                        log.warn("Failed to rescan spent outputs for {} {}, errorMessage={}", this.getClass().getSimpleName(), this.getShortId(), e.getMessage());
                        ThreadUtils.execute(() -> this.requestSwitchToNextBestConnection(sourceConnection), this.getId());
                    }
                }
                MoneroTxQuery query = new MoneroTxQuery().setIncludeOutputs(true);
                boolean bl2 = updatePool = isPayoutExpected && !this.isPayoutConfirmed();
                if (!updatePool) {
                    query.setInTxPool(false);
                }
                List<MoneroTxWallet> txs = null;
                if (!updatePool) {
                    txs = this.wallet.getTxs(query);
                } else {
                    sellerSecurityDeposit = this.walletLock;
                    synchronized (sellerSecurityDeposit) {
                        Object object4 = HavenoUtils.getDaemonLock();
                        synchronized (object4) {
                            txs = this.wallet.getTxs(query);
                        }
                    }
                }
                this.setDepositTxs(txs);
                boolean hasSpentOutput = false;
                boolean hasFailedTx = false;
                for (MoneroTxWallet tx : txs) {
                    if (tx.isFailed().booleanValue()) {
                        hasFailedTx = true;
                    }
                    for (MoneroOutputWallet output : tx.getOutputsWallet()) {
                        if (!Boolean.TRUE.equals(output.isSpent())) continue;
                        hasSpentOutput = true;
                    }
                }
                if (hasSpentOutput) {
                    this.setPayoutStatePublished();
                } else if (hasFailedTx && this.isPayoutPublished()) {
                    log.warn("{} {} is in payout published state but has failed tx and no spent outputs, resetting payout state to unpublished", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                    this.setPayoutState(PayoutState.PAYOUT_UNPUBLISHED);
                }
                for (MoneroTxWallet tx : txs) {
                    if (!tx.isOutgoing().booleanValue() || tx.isFailed().booleanValue()) continue;
                    this.updatePayout(tx);
                    this.setPayoutStatePublished();
                    if (tx.isConfirmed().booleanValue()) {
                        this.setPayoutStateConfirmed();
                    }
                    if (tx.isLocked().booleanValue()) continue;
                    this.setPayoutStateUnlocked();
                }
            }
            catch (Exception e) {
                if (HavenoUtils.isUnresponsive(e)) {
                    if (this.isShutDownStarted) {
                        this.forceCloseWallet();
                    } else {
                        this.forceRestartTradeWallet();
                    }
                } else {
                    boolean isWalletConnected = this.isWalletConnectedToDaemon();
                    if (this.wallet != null && !this.isShutDownStarted && isWalletConnected) {
                        log.warn("Error polling trade wallet for {} {}, errorMessage={}. Monerod={}", this.getClass().getSimpleName(), this.getShortId(), e.getMessage(), this.wallet.getDaemonConnection());
                    }
                }
            }
            finally {
                if (pollInProgressSet) {
                    Object object5 = this.pollLock;
                    synchronized (object5) {
                        this.pollInProgress = false;
                    }
                }
                this.saveWalletWithDelay();
            }
        }
    }

    private static boolean isPublished(MoneroTx tx) {
        if (tx == null) {
            return false;
        }
        if (Boolean.TRUE.equals(tx.isFailed())) {
            return false;
        }
        return Boolean.TRUE.equals(tx.inTxPool()) || Boolean.TRUE.equals(tx.isConfirmed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncWalletIfBehind() {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.isWalletBehind()) {
                if (this.xmrConnectionService.getTargetHeight() - this.walletHeight.get() < 100L) {
                    this.xmrWalletService.syncWallet(this.wallet);
                } else {
                    this.syncWithProgress();
                }
                this.walletHeight.set(this.wallet.getHeight());
            }
        }
    }

    private boolean isWalletBehind() {
        return this.walletHeight.get() < this.xmrConnectionService.getTargetHeight();
    }

    private void setDepositTxs(List<MoneroTxWallet> txs) {
        for (MoneroTxWallet tx : txs) {
            if (tx.getHash().equals(this.getMaker().getDepositTxHash())) {
                this.getMaker().setDepositTx(tx);
            }
            if (!tx.getHash().equals(this.getTaker().getDepositTxHash())) continue;
            this.getTaker().setDepositTx(tx);
        }
        this.depositTxsUpdateCounter.set(this.depositTxsUpdateCounter.get() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverIfMissingWalletData() {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.isWalletMissingData()) {
                log.warn("Wallet is missing data for {} {}, attempting to recover", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                this.forceRestartTradeWallet();
                if (this.isPayoutPublished()) {
                    return;
                }
                Object object2 = HavenoUtils.getDaemonLock();
                synchronized (object2) {
                    Long timeout = null;
                    try {
                        if (this.wallet instanceof MoneroWalletRpc) {
                            timeout = ((MoneroWalletRpc)this.wallet).getRpcConnection().getTimeout();
                            ((MoneroWalletRpc)this.wallet).getRpcConnection().setTimeout(600000L);
                        }
                        log.warn("Rescanning blockchain for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                        this.wallet.rescanBlockchain();
                    }
                    catch (Exception e) {
                        log.warn("Error rescanning blockchain for {} {}, errorMessage={}", this.getClass().getSimpleName(), this.getShortId(), e.getMessage());
                        if (HavenoUtils.isUnresponsive(e)) {
                            this.forceRestartTradeWallet();
                        }
                        throw e;
                    }
                    finally {
                        if (this.wallet instanceof MoneroWalletRpc) {
                            ((MoneroWalletRpc)this.wallet).getRpcConnection().setTimeout(timeout);
                        }
                    }
                }
                log.warn("Importing multisig hex to recover wallet data for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                this.importMultisigHex();
                this.doPollWallet();
                if (this.isWalletMissingData()) {
                    throw new IllegalStateException("Wallet is still missing data after attempting recovery for " + this.getClass().getSimpleName() + " " + this.getShortId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWalletMissingData() {
        Object object = this.walletLock;
        synchronized (object) {
            if (!this.isDepositsUnlocked() || this.isPayoutPublished()) {
                return false;
            }
            if (this.getMakerDepositTx() == null) {
                log.warn("Missing maker deposit tx for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                return true;
            }
            if (this.getTakerDepositTx() == null && !this.hasBuyerAsTakerWithoutDeposit()) {
                log.warn("Missing taker deposit tx for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                return true;
            }
            if (this.wallet.getBalance().equals(BigInteger.ZERO)) {
                this.doPollWallet();
                if (this.isPayoutPublished()) {
                    return false;
                }
                log.warn("Wallet balance is zero for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                return true;
            }
            return false;
        }
    }

    private void forceRestartTradeWallet() {
        if (this.isShutDownStarted || this.restartInProgress) {
            return;
        }
        log.warn("Force restarting trade wallet for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
        this.restartInProgress = true;
        this.forceCloseWallet();
        if (!this.isShutDownStarted) {
            this.wallet = this.getWallet();
        }
        this.restartInProgress = false;
        this.pollWallet();
        if (!this.isShutDownStarted) {
            ThreadUtils.execute(() -> this.tryInitSyncing(), this.getId());
        }
    }

    private void setStateDepositsSeen() {
        if (!this.isDepositsPublished()) {
            this.setState(State.DEPOSIT_TXS_SEEN_IN_NETWORK);
        }
    }

    private void setStateDepositsConfirmed() {
        if (!this.isDepositsConfirmed()) {
            this.setState(State.DEPOSIT_TXS_CONFIRMED_IN_BLOCKCHAIN);
        }
    }

    private void setStateDepositsUnlocked() {
        if (!this.isDepositsUnlocked()) {
            this.setState(State.DEPOSIT_TXS_UNLOCKED_IN_BLOCKCHAIN);
            this.setStartTimeFromUnlockedTxs();
        }
    }

    private void setPayoutStatePublished() {
        if (!this.isPayoutPublished()) {
            this.setPayoutState(PayoutState.PAYOUT_PUBLISHED);
        }
    }

    private void setPayoutStateConfirmed() {
        if (!this.isPayoutConfirmed()) {
            this.setPayoutState(PayoutState.PAYOUT_CONFIRMED);
        }
    }

    private void setPayoutStateUnlocked() {
        if (!this.isPayoutUnlocked()) {
            this.setPayoutState(PayoutState.PAYOUT_UNLOCKED);
        }
    }

    private Trade getTrade() {
        return this;
    }

    private void onDepositsPublished() {
        if (this instanceof ArbitratorTrade) {
            return;
        }
        if (this instanceof MakerTrade) {
            this.processModel.getOpenOfferManager().closeSpentOffer(this.getOffer());
            HavenoUtils.notificationService.sendTradeNotification(this, Phase.DEPOSITS_PUBLISHED, "Offer Taken", "Your offer " + this.offer.getId() + " has been accepted");
        } else {
            this.getXmrWalletService().resetAddressEntriesForOpenOffer(this.getId());
        }
        ThreadUtils.submitToPool(() -> this.xmrWalletService.freezeOutputs(this.getSelf().getReserveTxKeyImages()));
    }

    private void onDepositsConfirmed() {
        HavenoUtils.notificationService.sendTradeNotification(this, Phase.DEPOSITS_CONFIRMED, "Trade Deposits Confirmed", "The deposit transactions have confirmed");
    }

    private void onDepositsUnlocked() {
        HavenoUtils.notificationService.sendTradeNotification(this, Phase.DEPOSITS_UNLOCKED, "Trade Deposits Unlocked", "The deposit transactions have unlocked");
    }

    private void onPaymentSent() {
        HavenoUtils.notificationService.sendTradeNotification(this, Phase.PAYMENT_SENT, "Payment Sent", "The buyer has sent the payment");
    }

    @Override
    public Message toProtoMessage() {
        Trade.Builder builder = protobuf.Trade.newBuilder().setOffer(this.offer.toProtoMessage()).setTakeOfferDate(this.takeOfferDate).setProcessModel(this.processModel.toProtoMessage()).setAmount(this.amount).setPrice(this.price).setState(State.toProtoMessage(this.state)).setPayoutState(PayoutState.toProtoMessage(this.payoutState)).setDisputeState(DisputeState.toProtoMessage(this.disputeState)).setPeriodState(TradePeriodState.toProtoMessage(this.periodState)).addAllChatMessage(this.getChatMessages().stream().map(msg -> msg.toProtoNetworkEnvelope().getChatMessage()).collect(Collectors.toList())).setLockTime(this.lockTime).setStartTime(this.startTime).setUid(this.uid).setIsCompleted(this.isCompleted);
        Optional.ofNullable(this.payoutTxId).ifPresent(builder::setPayoutTxId);
        Optional.ofNullable(this.contract).ifPresent(e -> builder.setContract(this.contract.toProtoMessage()));
        Optional.ofNullable(this.contractAsJson).ifPresent(builder::setContractAsJson);
        Optional.ofNullable(this.contractHash).ifPresent(e -> builder.setContractHash(ByteString.copyFrom(this.contractHash)));
        Optional.ofNullable(this.errorMessage).ifPresent(builder::setErrorMessage);
        Optional.ofNullable(this.counterCurrencyTxId).ifPresent(e -> builder.setCounterCurrencyTxId(this.counterCurrencyTxId));
        Optional.ofNullable(this.mediationResultState).ifPresent(e -> builder.setMediationResultState(MediationResultState.toProtoMessage(this.mediationResultState)));
        Optional.ofNullable(this.refundResultState).ifPresent(e -> builder.setRefundResultState(RefundResultState.toProtoMessage(this.refundResultState)));
        Optional.ofNullable(this.payoutTxHex).ifPresent(e -> builder.setPayoutTxHex(this.payoutTxHex));
        Optional.ofNullable(this.payoutTxKey).ifPresent(e -> builder.setPayoutTxKey(this.payoutTxKey));
        Optional.ofNullable(this.counterCurrencyExtraData).ifPresent(e -> builder.setCounterCurrencyExtraData(this.counterCurrencyExtraData));
        Optional.ofNullable(this.challenge).ifPresent(e -> builder.setChallenge(this.challenge));
        return builder.build();
    }

    public static Trade fromProto(Trade trade, protobuf.Trade proto, CoreProtoResolver coreProtoResolver) {
        trade.setTakeOfferDate(proto.getTakeOfferDate());
        trade.setState(State.fromProto(proto.getState()));
        trade.setPayoutState(PayoutState.fromProto(proto.getPayoutState()));
        trade.setDisputeState(DisputeState.fromProto(proto.getDisputeState()));
        trade.setPeriodState(TradePeriodState.fromProto(proto.getPeriodState()));
        trade.setPayoutTxId(ProtoUtil.stringOrNullFromProto(proto.getPayoutTxId()));
        trade.setPayoutTxHex(ProtoUtil.stringOrNullFromProto(proto.getPayoutTxHex()));
        trade.setPayoutTxKey(ProtoUtil.stringOrNullFromProto(proto.getPayoutTxKey()));
        trade.setContract(proto.hasContract() ? Contract.fromProto(proto.getContract(), coreProtoResolver) : null);
        trade.setContractAsJson(ProtoUtil.stringOrNullFromProto(proto.getContractAsJson()));
        trade.setContractHash(ProtoUtil.byteArrayOrNullFromProto(proto.getContractHash()));
        trade.setErrorMessage(ProtoUtil.stringOrNullFromProto(proto.getErrorMessage()));
        trade.setCounterCurrencyTxId(proto.getCounterCurrencyTxId().isEmpty() ? null : proto.getCounterCurrencyTxId());
        trade.setMediationResultState(MediationResultState.fromProto(proto.getMediationResultState()));
        trade.setRefundResultState(RefundResultState.fromProto(proto.getRefundResultState()));
        trade.setLockTime(proto.getLockTime());
        trade.setStartTime(proto.getStartTime());
        trade.setCounterCurrencyExtraData(ProtoUtil.stringOrNullFromProto(proto.getCounterCurrencyExtraData()));
        trade.setCompleted(proto.getIsCompleted());
        trade.chatMessages.addAll(proto.getChatMessageList().stream().map(ChatMessage::fromPayloadProto).collect(Collectors.toList()));
        return trade;
    }

    public String toString() {
        return "Trade{\n     offer=" + String.valueOf(this.offer) + ",\n     totalTxFee=" + String.valueOf(this.getTotalTxFee()) + ",\n     takeOfferDate=" + this.takeOfferDate + ",\n     processModel=" + String.valueOf(this.processModel) + ",\n     payoutTxId='" + this.payoutTxId + "',\n     amount=" + this.amount + ",\n     tradePrice=" + this.price + ",\n     state=" + String.valueOf((Object)this.state) + ",\n     payoutState=" + String.valueOf((Object)this.payoutState) + ",\n     disputeState=" + String.valueOf((Object)this.disputeState) + ",\n     tradePeriodState=" + String.valueOf((Object)this.periodState) + ",\n     contract=" + String.valueOf(this.contract) + ",\n     contractAsJson='" + this.contractAsJson + "',\n     contractHash=" + Utilities.bytesAsHexString(this.contractHash) + ",\n     errorMessage='" + this.errorMessage + "',\n     counterCurrencyTxId='" + this.counterCurrencyTxId + "',\n     counterCurrencyExtraData='" + this.counterCurrencyExtraData + "',\n     chatMessages=" + String.valueOf(this.chatMessages) + ",\n     xmrWalletService=" + String.valueOf(this.xmrWalletService) + ",\n     stateProperty=" + String.valueOf(this.stateProperty) + ",\n     statePhaseProperty=" + String.valueOf(this.phaseProperty) + ",\n     disputeStateProperty=" + String.valueOf(this.disputeStateProperty) + ",\n     tradePeriodStateProperty=" + String.valueOf(this.tradePeriodStateProperty) + ",\n     errorMessageProperty=" + String.valueOf(this.errorMessageProperty) + ",\n     payoutTx=" + String.valueOf(this.payoutTx) + ",\n     amount=" + this.amount + ",\n     tradeAmountProperty=" + String.valueOf(this.tradeAmountProperty) + ",\n     tradeVolumeProperty=" + String.valueOf(this.tradeVolumeProperty) + ",\n     mediationResultState=" + String.valueOf((Object)this.mediationResultState) + ",\n     mediationResultStateProperty=" + String.valueOf(this.mediationResultStateProperty) + ",\n     lockTime=" + this.lockTime + ",\n     startTime=" + this.startTime + ",\n     refundResultState=" + String.valueOf((Object)this.refundResultState) + ",\n     refundResultStateProperty=" + String.valueOf(this.refundResultStateProperty) + ",\n     isCompleted=" + this.isCompleted + ",\n     challenge='" + this.challenge + "'\n}";
    }

    public Object getLock() {
        return this.lock;
    }

    public ProcessModel getProcessModel() {
        return this.processModel;
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    public String getUid() {
        return this.uid;
    }

    public void setTakeOfferDate(long takeOfferDate) {
        this.takeOfferDate = takeOfferDate;
    }

    public double getInitProgress() {
        return this.initProgress;
    }

    public Exception getInitError() {
        return this.initError;
    }

    public void setInitError(Exception initError) {
        this.initError = initError;
    }

    public void setPrice(long price) {
        this.price = price;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    public PayoutState getPayoutState() {
        return this.payoutState;
    }

    public DisputeState getDisputeState() {
        return this.disputeState;
    }

    public TradePeriodState getPeriodState() {
        return this.periodState;
    }

    @Nullable
    public Contract getContract() {
        return this.contract;
    }

    public void setContract(@Nullable Contract contract) {
        this.contract = contract;
    }

    @Nullable
    public String getContractAsJson() {
        return this.contractAsJson;
    }

    public void setContractAsJson(@Nullable String contractAsJson) {
        this.contractAsJson = contractAsJson;
    }

    @Nullable
    public byte[] getContractHash() {
        return this.contractHash;
    }

    public void setContractHash(@Nullable byte[] contractHash) {
        this.contractHash = contractHash;
    }

    @Nullable
    public String getCounterCurrencyTxId() {
        return this.counterCurrencyTxId;
    }

    public void setCounterCurrencyTxId(@Nullable String counterCurrencyTxId) {
        this.counterCurrencyTxId = counterCurrencyTxId;
    }

    public ObservableList<ChatMessage> getChatMessages() {
        return this.chatMessages;
    }

    public XmrWalletService getXmrWalletService() {
        return this.xmrWalletService;
    }

    public IntegerProperty getDepositTxsUpdateCounter() {
        return this.depositTxsUpdateCounter;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Nullable
    public MediationResultState getMediationResultState() {
        return this.mediationResultState;
    }

    public long getLockTime() {
        return this.lockTime;
    }

    public void setLockTime(long lockTime) {
        this.lockTime = lockTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Nullable
    public RefundResultState getRefundResultState() {
        return this.refundResultState;
    }

    public String getCounterCurrencyExtraData() {
        return this.counterCurrencyExtraData;
    }

    public void setCounterCurrencyExtraData(String counterCurrencyExtraData) {
        this.counterCurrencyExtraData = counterCurrencyExtraData;
    }

    public String getPayoutTxId() {
        return this.payoutTxId;
    }

    public void setPayoutTxId(String payoutTxId) {
        this.payoutTxId = payoutTxId;
    }

    @Nullable
    public String getPayoutTxHex() {
        return this.payoutTxHex;
    }

    public void setPayoutTxHex(@Nullable String payoutTxHex) {
        this.payoutTxHex = payoutTxHex;
    }

    public String getPayoutTxKey() {
        return this.payoutTxKey;
    }

    public void setPayoutTxKey(String payoutTxKey) {
        this.payoutTxKey = payoutTxKey;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public String getChallenge() {
        return this.challenge;
    }

    public static enum State {
        PREPARATION(Phase.INIT),
        MULTISIG_PREPARED(Phase.INIT),
        MULTISIG_MADE(Phase.INIT),
        MULTISIG_EXCHANGED(Phase.INIT),
        MULTISIG_COMPLETED(Phase.INIT),
        CONTRACT_SIGNATURE_REQUESTED(Phase.INIT),
        CONTRACT_SIGNED(Phase.INIT),
        SENT_PUBLISH_DEPOSIT_TX_REQUEST(Phase.DEPOSIT_REQUESTED),
        SEND_FAILED_PUBLISH_DEPOSIT_TX_REQUEST(Phase.DEPOSIT_REQUESTED),
        SAW_ARRIVED_PUBLISH_DEPOSIT_TX_REQUEST(Phase.DEPOSIT_REQUESTED),
        PUBLISH_DEPOSIT_TX_REQUEST_FAILED(Phase.DEPOSIT_REQUESTED),
        ARBITRATOR_PUBLISHED_DEPOSIT_TXS(Phase.DEPOSITS_PUBLISHED),
        DEPOSIT_TXS_SEEN_IN_NETWORK(Phase.DEPOSITS_PUBLISHED),
        DEPOSIT_TXS_CONFIRMED_IN_BLOCKCHAIN(Phase.DEPOSITS_CONFIRMED),
        DEPOSIT_TXS_UNLOCKED_IN_BLOCKCHAIN(Phase.DEPOSITS_UNLOCKED),
        BUYER_CONFIRMED_PAYMENT_SENT(Phase.PAYMENT_SENT),
        BUYER_SENT_PAYMENT_SENT_MSG(Phase.PAYMENT_SENT),
        BUYER_SEND_FAILED_PAYMENT_SENT_MSG(Phase.PAYMENT_SENT),
        BUYER_STORED_IN_MAILBOX_PAYMENT_SENT_MSG(Phase.PAYMENT_SENT),
        BUYER_SAW_ARRIVED_PAYMENT_SENT_MSG(Phase.PAYMENT_SENT),
        SELLER_RECEIVED_PAYMENT_SENT_MSG(Phase.PAYMENT_SENT),
        SELLER_CONFIRMED_PAYMENT_RECEIPT(Phase.PAYMENT_RECEIVED),
        SELLER_SENT_PAYMENT_RECEIVED_MSG(Phase.PAYMENT_RECEIVED),
        SELLER_SEND_FAILED_PAYMENT_RECEIVED_MSG(Phase.PAYMENT_RECEIVED),
        SELLER_STORED_IN_MAILBOX_PAYMENT_RECEIVED_MSG(Phase.PAYMENT_RECEIVED),
        SELLER_SAW_ARRIVED_PAYMENT_RECEIVED_MSG(Phase.PAYMENT_RECEIVED),
        BUYER_RECEIVED_PAYMENT_RECEIVED_MSG(Phase.PAYMENT_RECEIVED);

        @NotNull
        private final Phase phase;

        @NotNull
        public Phase getPhase() {
            return this.phase;
        }

        private State(Phase phase) {
            this.phase = phase;
        }

        public static State fromProto(Trade.State state) {
            return ProtoUtil.enumFromProto(State.class, state.name());
        }

        public static Trade.State toProtoMessage(State state) {
            return Trade.State.valueOf(state.name());
        }

        public boolean isValidTransitionTo(State newState) {
            Phase newPhase = newState.getPhase();
            Phase currentPhase = this.getPhase();
            return currentPhase.isValidTransitionTo(newPhase) || newPhase.equals((Object)currentPhase);
        }
    }

    public static enum PayoutState {
        PAYOUT_UNPUBLISHED,
        PAYOUT_PUBLISHED,
        PAYOUT_CONFIRMED,
        PAYOUT_UNLOCKED;


        public static PayoutState fromProto(Trade.PayoutState state) {
            return ProtoUtil.enumFromProto(PayoutState.class, state.name());
        }

        public static Trade.PayoutState toProtoMessage(PayoutState state) {
            return Trade.PayoutState.valueOf(state.name());
        }

        public boolean isValidTransitionTo(PayoutState newState) {
            return newState.ordinal() > this.ordinal();
        }
    }

    public static enum DisputeState {
        NO_DISPUTE,
        DISPUTE_REQUESTED,
        DISPUTE_OPENED,
        ARBITRATOR_SENT_DISPUTE_CLOSED_MSG,
        ARBITRATOR_SEND_FAILED_DISPUTE_CLOSED_MSG,
        ARBITRATOR_STORED_IN_MAILBOX_DISPUTE_CLOSED_MSG,
        ARBITRATOR_SAW_ARRIVED_DISPUTE_CLOSED_MSG,
        DISPUTE_CLOSED,
        MEDIATION_REQUESTED,
        MEDIATION_STARTED_BY_PEER,
        MEDIATION_CLOSED,
        REFUND_REQUESTED,
        REFUND_REQUEST_STARTED_BY_PEER,
        REFUND_REQUEST_CLOSED;


        public static DisputeState fromProto(Trade.DisputeState disputeState) {
            return ProtoUtil.enumFromProto(DisputeState.class, disputeState.name());
        }

        public static Trade.DisputeState toProtoMessage(DisputeState disputeState) {
            return Trade.DisputeState.valueOf(disputeState.name());
        }

        public boolean isNotDisputed() {
            return this == NO_DISPUTE;
        }

        public boolean isMediated() {
            return this == MEDIATION_REQUESTED || this == MEDIATION_STARTED_BY_PEER || this == MEDIATION_CLOSED;
        }

        public boolean isArbitrated() {
            if (this.isMediated()) {
                return false;
            }
            return this.ordinal() >= DISPUTE_REQUESTED.ordinal();
        }

        public boolean isRequested() {
            return this.ordinal() >= DISPUTE_REQUESTED.ordinal();
        }

        public boolean isOpen() {
            return this.isRequested() && !this.isClosed();
        }

        public boolean isCloseRequested() {
            return this.ordinal() >= ARBITRATOR_SENT_DISPUTE_CLOSED_MSG.ordinal();
        }

        public boolean isClosed() {
            return this == DISPUTE_CLOSED;
        }
    }

    public static enum TradePeriodState {
        FIRST_HALF,
        SECOND_HALF,
        TRADE_PERIOD_OVER;


        public static TradePeriodState fromProto(Trade.TradePeriodState tradePeriodState) {
            return ProtoUtil.enumFromProto(TradePeriodState.class, tradePeriodState.name());
        }

        public static Trade.TradePeriodState toProtoMessage(TradePeriodState tradePeriodState) {
            return Trade.TradePeriodState.valueOf(tradePeriodState.name());
        }
    }

    public static enum Phase {
        INIT,
        DEPOSIT_REQUESTED,
        DEPOSITS_PUBLISHED,
        DEPOSITS_CONFIRMED,
        DEPOSITS_UNLOCKED,
        PAYMENT_SENT,
        PAYMENT_RECEIVED;


        public static Phase fromProto(Trade.Phase phase) {
            return ProtoUtil.enumFromProto(Phase.class, phase.name());
        }

        public static Trade.Phase toProtoMessage(Phase phase) {
            return Trade.Phase.valueOf(phase.name());
        }

        public boolean isValidTransitionTo(Phase newPhase) {
            return newPhase.ordinal() > this.ordinal();
        }
    }

    private class IdlePayoutSyncer
    extends MoneroWalletListener {
        boolean processing = false;

        private IdlePayoutSyncer() {
        }

        @Override
        public void onNewBlock(long height) {
            ThreadUtils.execute(() -> {
                block10: {
                    if (this.processing) {
                        return;
                    }
                    this.processing = true;
                    if (!Trade.this.isIdling() || !Trade.this.isPayoutPublished() || Trade.this.isPayoutUnlocked()) {
                        this.processing = false;
                        return;
                    }
                    try {
                        if (Trade.this.payoutHeight == null && Trade.this.getPayoutTxId() != null && Trade.this.isPayoutPublished()) {
                            MoneroTx tx = Trade.this.xmrWalletService.getDaemon().getTx(Trade.this.getPayoutTxId());
                            if (tx == null) {
                                log.warn("Payout tx not found for {} {}, txId={}", Trade.this.getTrade().getClass().getSimpleName(), Trade.this.getId(), Trade.this.getPayoutTxId());
                            } else if (tx.isConfirmed().booleanValue()) {
                                Trade.this.payoutHeight = tx.getHeight();
                            }
                        }
                        long currentHeight = Trade.this.xmrWalletService.getDaemon().getHeight();
                        if (!Trade.this.isPayoutConfirmed() || Trade.this.payoutHeight != null && currentHeight >= Trade.this.payoutHeight + 10L) {
                            log.info("Syncing idle trade wallet to update payout tx, tradeId={}", (Object)Trade.this.getId());
                            Trade.this.syncAndPollWallet();
                        }
                        this.processing = false;
                    }
                    catch (Exception e) {
                        this.processing = false;
                        if (!Trade.this.isInitialized || Trade.this.isShutDownStarted) {
                            return;
                        }
                        if (!Trade.this.isWalletConnectedToDaemon()) break block10;
                        log.warn("Error polling idle trade for {} {}: {}. Monerod={}\n", this.getClass().getSimpleName(), Trade.this.getId(), e.getMessage(), Trade.this.getXmrWalletService().getXmrConnectionService().getConnection(), e);
                    }
                }
            }, Trade.this.getId());
        }
    }
}

