/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import haveno.common.ClockWatcher;
import haveno.common.ThreadUtils;
import haveno.common.UserThread;
import haveno.common.crypto.KeyRing;
import haveno.common.crypto.PubKeyRing;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.FaultHandler;
import haveno.common.handlers.ResultHandler;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.proto.persistable.PersistedDataHost;
import haveno.common.util.Tuple2;
import haveno.core.api.AccountServiceListener;
import haveno.core.api.CoreAccountService;
import haveno.core.api.CoreNotificationService;
import haveno.core.locale.Res;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferBookService;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OfferUtil;
import haveno.core.offer.OpenOffer;
import haveno.core.offer.OpenOfferManager;
import haveno.core.offer.SignedOffer;
import haveno.core.offer.availability.OfferAvailabilityModel;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.support.dispute.arbitration.arbitrator.Arbitrator;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.core.support.dispute.mediation.mediator.MediatorManager;
import haveno.core.support.dispute.messages.DisputeClosedMessage;
import haveno.core.support.dispute.messages.DisputeOpenedMessage;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.BuyerAsMakerTrade;
import haveno.core.trade.BuyerAsTakerTrade;
import haveno.core.trade.ClosedTradableManager;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.SellerAsMakerTrade;
import haveno.core.trade.SellerAsTakerTrade;
import haveno.core.trade.TradableList;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeTxException;
import haveno.core.trade.TradeUtil;
import haveno.core.trade.failed.FailedTradesManager;
import haveno.core.trade.handlers.TradeResultHandler;
import haveno.core.trade.messages.DepositRequest;
import haveno.core.trade.messages.DepositResponse;
import haveno.core.trade.messages.DepositsConfirmedMessage;
import haveno.core.trade.messages.InitMultisigRequest;
import haveno.core.trade.messages.InitTradeRequest;
import haveno.core.trade.messages.PaymentReceivedMessage;
import haveno.core.trade.messages.PaymentSentMessage;
import haveno.core.trade.messages.SignContractRequest;
import haveno.core.trade.messages.SignContractResponse;
import haveno.core.trade.messages.TradeMessage;
import haveno.core.trade.protocol.ArbitratorProtocol;
import haveno.core.trade.protocol.MakerProtocol;
import haveno.core.trade.protocol.ProcessModel;
import haveno.core.trade.protocol.ProcessModelServiceProvider;
import haveno.core.trade.protocol.TakerProtocol;
import haveno.core.trade.protocol.TradeProtocol;
import haveno.core.trade.protocol.TradeProtocolFactory;
import haveno.core.trade.protocol.TraderProtocol;
import haveno.core.trade.statistics.ReferralIdService;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.core.user.User;
import haveno.core.util.Validator;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.AckMessage;
import haveno.network.p2p.AckMessageSourceType;
import haveno.network.p2p.BootstrapListener;
import haveno.network.p2p.DecryptedDirectMessageListener;
import haveno.network.p2p.DecryptedMessageWithPubKey;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.SendMailboxMessageListener;
import haveno.network.p2p.mailbox.MailboxMessage;
import haveno.network.p2p.mailbox.MailboxMessageService;
import haveno.network.p2p.network.TorNetworkNode;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.collections.ObservableList;
import javax.annotation.Nullable;
import monero.daemon.model.MoneroTx;
import org.bitcoinj.core.Coin;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradeManager
implements PersistedDataHost,
DecryptedDirectMessageListener {
    private static final Logger log = LoggerFactory.getLogger(TradeManager.class);
    private boolean isShutDownStarted;
    private boolean isShutDown;
    private final User user;
    private final KeyRing keyRing;
    private final CoreAccountService accountService;
    private final XmrWalletService xmrWalletService;
    private final CoreNotificationService notificationService;
    private final OfferBookService offerBookService;
    private final OpenOfferManager openOfferManager;
    private final ClosedTradableManager closedTradableManager;
    private final FailedTradesManager failedTradesManager;
    private final P2PService p2PService;
    private final PriceFeedService priceFeedService;
    private final TradeStatisticsManager tradeStatisticsManager;
    private final OfferUtil offerUtil;
    private final TradeUtil tradeUtil;
    private final ArbitratorManager arbitratorManager;
    private final MediatorManager mediatorManager;
    private final ProcessModelServiceProvider processModelServiceProvider;
    private final ClockWatcher clockWatcher;
    private final Map<String, TradeProtocol> tradeProtocolByTradeId = new HashMap<String, TradeProtocol>();
    private final PersistenceManager<TradableList<Trade>> persistenceManager;
    private final TradableList<Trade> tradableList = new TradableList();
    private final BooleanProperty persistedTradesInitialized = new SimpleBooleanProperty();
    private final LongProperty numPendingTrades = new SimpleLongProperty();
    private final ReferralIdService referralIdService;
    @Nullable
    private Consumer<String> lockedUpFundsHandler;

    @Inject
    public TradeManager(User user, KeyRing keyRing, CoreAccountService accountService, XmrWalletService xmrWalletService, CoreNotificationService notificationService, OfferBookService offerBookService, OpenOfferManager openOfferManager, ClosedTradableManager closedTradableManager, FailedTradesManager failedTradesManager, P2PService p2PService, PriceFeedService priceFeedService, TradeStatisticsManager tradeStatisticsManager, OfferUtil offerUtil, TradeUtil tradeUtil, ArbitratorManager arbitratorManager, MediatorManager mediatorManager, ProcessModelServiceProvider processModelServiceProvider, ClockWatcher clockWatcher, PersistenceManager<TradableList<Trade>> persistenceManager, ReferralIdService referralIdService) {
        this.user = user;
        this.keyRing = keyRing;
        this.accountService = accountService;
        this.xmrWalletService = xmrWalletService;
        this.notificationService = notificationService;
        this.offerBookService = offerBookService;
        this.openOfferManager = openOfferManager;
        this.closedTradableManager = closedTradableManager;
        this.failedTradesManager = failedTradesManager;
        this.p2PService = p2PService;
        this.priceFeedService = priceFeedService;
        this.tradeStatisticsManager = tradeStatisticsManager;
        this.offerUtil = offerUtil;
        this.tradeUtil = tradeUtil;
        this.arbitratorManager = arbitratorManager;
        this.mediatorManager = mediatorManager;
        this.processModelServiceProvider = processModelServiceProvider;
        this.clockWatcher = clockWatcher;
        this.referralIdService = referralIdService;
        this.persistenceManager = persistenceManager;
        this.persistenceManager.initialize(this.tradableList, "PendingTrades", PersistenceManager.Source.PRIVATE);
        p2PService.addDecryptedDirectMessageListener(this);
        failedTradesManager.setUnFailTradeCallback(this::unFailTrade);
        xmrWalletService.setTradeManager(this);
        HavenoUtils.notificationService = notificationService;
    }

    @Override
    public void readPersisted(Runnable completeHandler) {
        this.persistenceManager.readPersisted(persisted -> {
            List list = persisted.getList();
            synchronized (list) {
                this.tradableList.setAll(persisted.getList());
                this.tradableList.stream().filter(trade -> trade.getOffer() != null).forEach(trade -> trade.getOffer().setPriceFeedService(this.priceFeedService));
            }
            completeHandler.run();
        }, completeHandler);
    }

    @Override
    public void onDirectMessage(DecryptedMessageWithPubKey message, NodeAddress sender) {
        NetworkEnvelope networkEnvelope = message.getNetworkEnvelope();
        if (!(networkEnvelope instanceof TradeMessage)) {
            return;
        }
        TradeMessage tradeMessage = (TradeMessage)networkEnvelope;
        String tradeId = tradeMessage.getOfferId();
        log.info("TradeManager received {} for tradeId={}, sender={}, uid={}", networkEnvelope.getClass().getSimpleName(), tradeId, sender, tradeMessage.getUid());
        ThreadUtils.execute(() -> {
            if (networkEnvelope instanceof InitTradeRequest) {
                this.handleInitTradeRequest((InitTradeRequest)networkEnvelope, sender);
            } else if (networkEnvelope instanceof InitMultisigRequest) {
                this.handleInitMultisigRequest((InitMultisigRequest)networkEnvelope, sender);
            } else if (networkEnvelope instanceof SignContractRequest) {
                this.handleSignContractRequest((SignContractRequest)networkEnvelope, sender);
            } else if (networkEnvelope instanceof SignContractResponse) {
                this.handleSignContractResponse((SignContractResponse)networkEnvelope, sender);
            } else if (networkEnvelope instanceof DepositRequest) {
                this.handleDepositRequest((DepositRequest)networkEnvelope, sender);
            } else if (networkEnvelope instanceof DepositResponse) {
                this.handleDepositResponse((DepositResponse)networkEnvelope, sender);
            }
        }, tradeId);
    }

    public void onAllServicesInitialized() {
        if (this.p2PService.isBootstrapped()) {
            this.initPersistedTrades();
        } else {
            this.p2PService.addP2PServiceListener(new BootstrapListener(){

                @Override
                public void onDataReceived() {
                    TradeManager.this.initPersistedTrades();
                }
            });
        }
        this.accountService.addListener(new AccountServiceListener(){

            @Override
            public void onAccountCreated() {
                log.info(String.valueOf(TradeManager.class) + ".accountService.onAccountCreated()");
                TradeManager.this.initPersistedTrades();
            }

            @Override
            public void onAccountOpened() {
                log.info(String.valueOf(TradeManager.class) + ".accountService.onAccountOpened()");
                TradeManager.this.initPersistedTrades();
            }

            @Override
            public void onAccountClosed() {
                log.info(String.valueOf(TradeManager.class) + ".accountService.onAccountClosed()");
                TradeManager.this.closeAllTrades();
            }

            @Override
            public void onPasswordChanged(String oldPassword, String newPassword) {
            }
        });
    }

    public void onShutDownStarted() {
        log.info("{}.onShutDownStarted()", (Object)this.getClass().getSimpleName());
        this.isShutDownStarted = true;
        List<Trade> trades = this.getAllTrades();
        HashSet<Runnable> tasks = new HashSet<Runnable>();
        for (Trade trade : trades) {
            tasks.add(() -> {
                try {
                    trade.onShutDownStarted();
                }
                catch (Exception e) {
                    if (e.getMessage() != null && e.getMessage().contains("Connection reset")) {
                        return;
                    }
                    log.warn("Error notifying {} {} that shut down started: {}\n", trade.getClass().getSimpleName(), trade.getId(), e.getMessage(), e);
                }
            });
        }
        try {
            ThreadUtils.awaitTasks(tasks);
        }
        catch (Exception e) {
            log.warn("Error notifying trades that shut down started: {}", (Object)e.getMessage());
            throw e;
        }
    }

    public void shutDown() {
        log.info("Shutting down {}", (Object)this.getClass().getSimpleName());
        this.isShutDown = true;
        this.closeAllTrades();
    }

    private void closeAllTrades() {
        List<Trade> trades = this.getAllTrades();
        HashSet<Runnable> tasks = new HashSet<Runnable>();
        for (Trade trade : trades) {
            tasks.add(() -> {
                try {
                    trade.shutDown();
                }
                catch (Exception e) {
                    if (e.getMessage() != null && (e.getMessage().contains("Connection reset") || e.getMessage().contains("Connection refused"))) {
                        return;
                    }
                    log.warn("Error closing {} {}: {}", trade.getClass().getSimpleName(), trade.getId(), e.getMessage(), e);
                }
            });
        }
        try {
            ThreadUtils.awaitTasks(tasks);
        }
        catch (Exception e) {
            log.warn("Error shutting down trades: {}\n", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TradeProtocol getTradeProtocol(Trade trade) {
        Map<String, TradeProtocol> map = this.tradeProtocolByTradeId;
        synchronized (map) {
            return this.tradeProtocolByTradeId.get(trade.getUid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TradeProtocol createTradeProtocol(Trade trade) {
        Map<String, TradeProtocol> map = this.tradeProtocolByTradeId;
        synchronized (map) {
            TradeProtocol tradeProtocol = TradeProtocolFactory.getNewTradeProtocol(trade);
            TradeProtocol prev = this.tradeProtocolByTradeId.put(trade.getUid(), tradeProtocol);
            if (prev != null) {
                log.error("We had already an entry with uid {}", (Object)trade.getUid());
            }
            return tradeProtocol;
        }
    }

    private void initPersistedTrades() {
        log.info("Initializing persisted trades");
        new Thread(() -> {
            List<Trade> trades = this.getAllTrades();
            int threadPoolSize = 10;
            HashSet<Runnable> tasks = new HashSet<Runnable>();
            HashSet uids = new HashSet();
            HashSet tradesToSkip = new HashSet();
            HashSet uninitializedTrades = new HashSet();
            for (Trade trade : trades) {
                tasks.add(() -> {
                    block5: {
                        try {
                            if (!uids.add(trade.getUid())) {
                                log.warn("Found trade with duplicate uid, skipping. That should never happen. {} {}, uid={}", trade.getClass().getSimpleName(), trade.getId(), trade.getUid());
                                tradesToSkip.add(trade);
                                return;
                            }
                            if (this.failedTradesManager.getObservableList().contains(trade) && !trade.isProtocolErrorHandlingScheduled()) {
                                log.warn("Skipping initialization of failed trade {} {}", (Object)trade.getClass().getSimpleName(), (Object)trade.getId());
                                tradesToSkip.add(trade);
                                return;
                            }
                            this.initPersistedTrade(trade);
                            if (!trade.isDepositsPublished()) {
                                uninitializedTrades.add(trade);
                            }
                        }
                        catch (Exception e) {
                            if (this.isShutDownStarted) break block5;
                            log.warn("Error initializing {} {}: {}\n", trade.getClass().getSimpleName(), trade.getId(), e.getMessage(), e);
                            trade.setInitError(e);
                            trade.prependErrorMessage(e.getMessage());
                        }
                    }
                });
            }
            ThreadUtils.awaitTasks(tasks, threadPoolSize);
            log.info("Done initializing persisted trades");
            if (this.isShutDownStarted) {
                return;
            }
            trades.removeAll(tradesToSkip);
            for (Trade trade : trades) {
                if (!trade.isIdling()) continue;
                ThreadUtils.submitToPool(() -> trade.syncAndPollWallet());
            }
            if (!HavenoUtils.isSeedNode()) {
                for (Trade trade : uninitializedTrades) {
                    trade.onProtocolError();
                }
                if (this.isShutDownStarted) {
                    return;
                }
                this.xmrWalletService.fixReservedOutputs();
                if (this.isShutDownStarted) {
                    return;
                }
                this.xmrWalletService.getAddressEntriesForAvailableBalanceStream().filter(addressEntry -> addressEntry.getOfferId() != null).forEach(addressEntry -> {
                    log.warn("Swapping pending {} entries at startup. offerId={}", (Object)addressEntry.getContext(), (Object)addressEntry.getOfferId());
                    this.xmrWalletService.swapAddressEntryToAvailable(addressEntry.getOfferId(), addressEntry.getContext());
                });
                this.checkForLockedUpFunds();
            }
            if (this.isShutDownStarted) {
                return;
            }
            this.persistedTradesInitialized.set(true);
            this.getObservableList().addListener(change -> this.onTradesChanged());
            this.onTradesChanged();
            HashSet<Trade> nonFailedTrades = new HashSet<Trade>(this.closedTradableManager.getClosedTrades());
            nonFailedTrades.addAll(this.tradableList.getList());
            String referralId = this.referralIdService.getOptionalReferralId().orElse(null);
            boolean isTorNetworkNode = this.p2PService.getNetworkNode() instanceof TorNetworkNode;
            this.tradeStatisticsManager.maybeRepublishTradeStatistics(nonFailedTrades, referralId, isTorNetworkNode);
        }).start();
        HavenoUtils.waitFor(100L);
    }

    private void initPersistedTrade(Trade trade) {
        if (this.isShutDown) {
            return;
        }
        if (this.getTradeProtocol(trade) != null) {
            return;
        }
        this.initTradeAndProtocol(trade, this.createTradeProtocol(trade));
        this.requestPersistence();
    }

    private void initTradeAndProtocol(Trade trade, TradeProtocol tradeProtocol) {
        tradeProtocol.initialize(this.processModelServiceProvider, this);
        this.requestPersistence();
    }

    public void requestPersistence() {
        this.persistenceManager.requestPersistence();
    }

    public void persistNow(@Nullable Runnable completeHandler) {
        this.persistenceManager.persistNow(completeHandler);
    }

    private void handleInitTradeRequest(InitTradeRequest request, NodeAddress sender) {
        log.info("TradeManager handling InitTradeRequest for tradeId={}, sender={}, uid={}", request.getOfferId(), sender, request.getUid());
        try {
            Validator.nonEmptyStringOf(request.getOfferId());
        }
        catch (Throwable t2) {
            log.warn("Invalid InitTradeRequest message " + request.toString());
            return;
        }
        if (request.getMakerNodeAddress().equals(this.p2PService.getNetworkNode().getNodeAddress())) {
            Optional<OpenOffer> openOfferOptional = this.openOfferManager.getOpenOffer(request.getOfferId());
            if (!openOfferOptional.isPresent()) {
                return;
            }
            OpenOffer openOffer = openOfferOptional.get();
            Offer offer = openOffer.getOffer();
            if (openOffer.getState() != OpenOffer.State.AVAILABLE) {
                log.warn("Ignoring InitTradeRequest to maker because offer is not available, offerId={}, sender={}", (Object)request.getOfferId(), (Object)sender);
                return;
            }
            if (openOffer.getChallenge() != null && !HavenoUtils.getChallengeHash(openOffer.getChallenge()).equals(HavenoUtils.getChallengeHash(request.getChallenge()))) {
                log.warn("Ignoring InitTradeRequest to maker because challenge is incorrect, tradeId={}, sender={}", (Object)request.getOfferId(), (Object)sender);
                return;
            }
            Optional<Trade> tradeOptional = this.getOpenTrade(request.getOfferId());
            if (tradeOptional.isPresent()) {
                log.warn("Ignoring InitTradeRequest to maker because trade already exists with id " + request.getOfferId() + ". This should never happen.");
                return;
            }
            this.openOfferManager.reserveOpenOffer(openOffer);
            Trade trade = offer.isBuyOffer() ? new BuyerAsMakerTrade(offer, BigInteger.valueOf(request.getTradeAmount()), offer.getOfferPayload().getPrice(), this.xmrWalletService, this.getNewProcessModel(offer), UUID.randomUUID().toString(), request.getMakerNodeAddress(), request.getTakerNodeAddress(), request.getArbitratorNodeAddress(), openOffer.getChallenge()) : new SellerAsMakerTrade(offer, BigInteger.valueOf(request.getTradeAmount()), offer.getOfferPayload().getPrice(), this.xmrWalletService, this.getNewProcessModel(offer), UUID.randomUUID().toString(), request.getMakerNodeAddress(), request.getTakerNodeAddress(), request.getArbitratorNodeAddress(), openOffer.getChallenge());
            trade.getMaker().setPaymentAccountId(trade.getOffer().getOfferPayload().getMakerPaymentAccountId());
            trade.getTaker().setPaymentAccountId(request.getTakerPaymentAccountId());
            trade.getMaker().setPubKeyRing(trade.getOffer().getPubKeyRing());
            trade.getTaker().setPubKeyRing(request.getTakerPubKeyRing());
            trade.getSelf().setPaymentAccountId(offer.getOfferPayload().getMakerPaymentAccountId());
            trade.getSelf().setReserveTxHash(openOffer.getReserveTxHash());
            trade.getSelf().setReserveTxHex(openOffer.getReserveTxHex());
            trade.getSelf().setReserveTxKey(openOffer.getReserveTxKey());
            trade.getSelf().setReserveTxKeyImages(offer.getOfferPayload().getReserveTxKeyImages());
            this.initTradeAndProtocol(trade, this.createTradeProtocol(trade));
            this.addTrade(trade);
            ((MakerProtocol)((Object)this.getTradeProtocol(trade))).handleInitTradeRequest(request, sender, errorMessage -> {
                log.warn("Maker error during trade initialization: " + errorMessage);
                trade.onProtocolError();
            });
        } else if (request.getArbitratorNodeAddress().equals(this.p2PService.getNetworkNode().getNodeAddress())) {
            Trade trade;
            Arbitrator thisArbitrator = this.user.getRegisteredArbitrator();
            NodeAddress thisAddress = this.p2PService.getNetworkNode().getNodeAddress();
            if (thisArbitrator == null || !thisArbitrator.getNodeAddress().equals(thisAddress)) {
                log.warn("Ignoring InitTradeRequest because we are not an arbitrator, tradeId={}, sender={}", (Object)request.getOfferId(), (Object)sender);
                return;
            }
            Offer offer = null;
            for (Offer anOffer : this.offerBookService.getOffers()) {
                if (!anOffer.getId().equals(request.getOfferId())) continue;
                offer = anOffer;
            }
            if (offer == null) {
                log.warn("Ignoring InitTradeRequest to arbitrator because offer is not on the books, tradeId={}, sender={}", (Object)request.getOfferId(), (Object)sender);
                return;
            }
            if (!offer.getOwnerNodeAddress().equals(request.getMakerNodeAddress())) {
                log.warn("Ignoring InitTradeRequest to arbitrator because maker is not offer owner, tradeId={}, sender={}", (Object)request.getOfferId(), (Object)sender);
                return;
            }
            if (offer.getChallengeHash() != null && !offer.getChallengeHash().equals(HavenoUtils.getChallengeHash(request.getChallenge()))) {
                log.warn("Ignoring InitTradeRequest to arbitrator because challenge hash is incorrect, tradeId={}, sender={}", (Object)request.getOfferId(), (Object)sender);
                return;
            }
            Optional<Trade> tradeOptional = this.getOpenTrade(offer.getId());
            if (tradeOptional.isPresent()) {
                trade = tradeOptional.get();
                if (!sender.equals(request.getTakerNodeAddress())) {
                    if (sender.equals(request.getMakerNodeAddress())) {
                        log.warn("Received InitTradeRequest from maker to arbitrator for trade that is already initializing, tradeId={}, sender={}", (Object)request.getOfferId(), (Object)sender);
                        this.sendAckMessage(sender, trade.getMaker().getPubKeyRing(), request, false, "Trade is already initializing for " + this.getClass().getSimpleName() + " " + trade.getId(), null);
                    } else {
                        log.warn("Ignoring InitTradeRequest from non-taker, tradeId={}, sender={}", (Object)request.getOfferId(), (Object)sender);
                    }
                    return;
                }
            } else {
                if (!sender.equals(request.getMakerNodeAddress())) {
                    log.warn("Ignoring InitTradeRequest to arbitrator because request must be from maker when trade is not initialized, tradeId={}, sender={}", (Object)request.getOfferId(), (Object)sender);
                    return;
                }
                trade = new ArbitratorTrade(offer, BigInteger.valueOf(request.getTradeAmount()), offer.getOfferPayload().getPrice(), this.xmrWalletService, this.getNewProcessModel(offer), UUID.randomUUID().toString(), request.getMakerNodeAddress(), request.getTakerNodeAddress(), request.getArbitratorNodeAddress(), request.getChallenge());
                Optional<SignedOffer> signedOfferOptional = this.openOfferManager.getSignedOfferById(request.getOfferId());
                if (signedOfferOptional.isPresent()) {
                    SignedOffer signedOffer = signedOfferOptional.get();
                    trade.getMaker().setReserveTxHash(signedOffer.getReserveTxHash());
                }
                this.initTradeAndProtocol(trade, this.createTradeProtocol(trade));
                this.addTrade(trade);
            }
            ((ArbitratorProtocol)this.getTradeProtocol(trade)).handleInitTradeRequest(request, sender, errorMessage -> {
                log.warn("Arbitrator error during trade initialization for trade {}: {}", (Object)trade.getId(), (Object)errorMessage);
                trade.onProtocolError();
            });
            this.requestPersistence();
        } else if (request.getTakerNodeAddress().equals(this.p2PService.getNetworkNode().getNodeAddress())) {
            Arbitrator arbitrator = this.user.getAcceptedArbitratorByAddress(sender);
            if (arbitrator == null) {
                log.warn("Ignoring InitTradeRequest to taker because request is not from accepted arbitrator, tradeId={}, sender={}", (Object)request.getOfferId(), (Object)sender);
                return;
            }
            Optional<Trade> tradeOptional = this.getOpenTrade(request.getOfferId());
            if (!tradeOptional.isPresent()) {
                log.warn("Ignoring InitTradeRequest to taker because trade is not initialized, tradeId={}, sender={}", (Object)request.getOfferId(), (Object)sender);
                return;
            }
            Trade trade = tradeOptional.get();
            ((TakerProtocol)((Object)this.getTradeProtocol(trade))).handleInitTradeRequest(request, sender);
        } else {
            log.warn("Ignoring InitTradeRequest because sender is not maker, arbitrator, or taker, tradeId={}, sender={}", (Object)request.getOfferId(), (Object)sender);
            return;
        }
    }

    private void handleInitMultisigRequest(InitMultisigRequest request, NodeAddress sender) {
        log.info("TradeManager handling InitMultisigRequest for tradeId={}, sender={}, uid={}", request.getOfferId(), sender, request.getUid());
        try {
            Validator.nonEmptyStringOf(request.getOfferId());
        }
        catch (Throwable t2) {
            log.warn("Invalid InitMultisigRequest " + request.toString());
            return;
        }
        Optional<Trade> tradeOptional = this.getOpenTrade(request.getOfferId());
        if (!tradeOptional.isPresent()) {
            log.warn("No trade with id " + request.getOfferId() + " at node " + String.valueOf(P2PService.getMyNodeAddress()));
            return;
        }
        Trade trade = tradeOptional.get();
        this.getTradeProtocol(trade).handleInitMultisigRequest(request, sender);
    }

    private void handleSignContractRequest(SignContractRequest request, NodeAddress sender) {
        log.info("TradeManager handling SignContractRequest for tradeId={}, sender={}, uid={}", request.getOfferId(), sender, request.getUid());
        try {
            Validator.nonEmptyStringOf(request.getOfferId());
        }
        catch (Throwable t2) {
            log.warn("Invalid SignContractRequest message " + request.toString());
            return;
        }
        Optional<Trade> tradeOptional = this.getOpenTrade(request.getOfferId());
        if (!tradeOptional.isPresent()) {
            log.warn("No trade with id " + request.getOfferId());
            return;
        }
        Trade trade = tradeOptional.get();
        this.getTradeProtocol(trade).handleSignContractRequest(request, sender);
    }

    private void handleSignContractResponse(SignContractResponse request, NodeAddress sender) {
        log.info("TradeManager handling SignContractResponse for tradeId={}, sender={}, uid={}", request.getOfferId(), sender, request.getUid());
        try {
            Validator.nonEmptyStringOf(request.getOfferId());
        }
        catch (Throwable t2) {
            log.warn("Invalid SignContractResponse message " + request.toString());
            return;
        }
        Optional<Trade> tradeOptional = this.getOpenTrade(request.getOfferId());
        if (!tradeOptional.isPresent()) {
            log.warn("No trade with id " + request.getOfferId());
            return;
        }
        Trade trade = tradeOptional.get();
        ((TraderProtocol)((Object)this.getTradeProtocol(trade))).handleSignContractResponse(request, sender);
    }

    private void handleDepositRequest(DepositRequest request, NodeAddress sender) {
        log.info("TradeManager handling DepositRequest for tradeId={}, sender={}, uid={}", request.getOfferId(), sender, request.getUid());
        try {
            Validator.nonEmptyStringOf(request.getOfferId());
        }
        catch (Throwable t2) {
            log.warn("Invalid DepositRequest message " + request.toString());
            return;
        }
        Optional<Trade> tradeOptional = this.getOpenTrade(request.getOfferId());
        if (!tradeOptional.isPresent()) {
            log.warn("No trade with id " + request.getOfferId());
            return;
        }
        Trade trade = tradeOptional.get();
        ((ArbitratorProtocol)this.getTradeProtocol(trade)).handleDepositRequest(request, sender);
    }

    private void handleDepositResponse(DepositResponse response, NodeAddress sender) {
        log.info("TradeManager handling DepositResponse for tradeId={}, sender={}, uid={}", response.getOfferId(), sender, response.getUid());
        try {
            Validator.nonEmptyStringOf(response.getOfferId());
        }
        catch (Throwable t2) {
            log.warn("Invalid DepositResponse message " + response.toString());
            return;
        }
        Optional<Trade> tradeOptional = this.getOpenTrade(response.getOfferId());
        if (!tradeOptional.isPresent() && !(tradeOptional = this.getFailedTrade(response.getOfferId())).isPresent()) {
            log.warn("No trade with id " + response.getOfferId());
            return;
        }
        Trade trade = tradeOptional.get();
        ((TraderProtocol)((Object)this.getTradeProtocol(trade))).handleDepositResponse(response, sender);
    }

    public void checkOfferAvailability(Offer offer, boolean isTakerApiUser, String paymentAccountId, BigInteger tradeAmount, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        offer.checkOfferAvailability(this.getOfferAvailabilityModel(offer, isTakerApiUser, paymentAccountId, tradeAmount), resultHandler, errorMessageHandler);
    }

    public void onTakeOffer(BigInteger amount, BigInteger fundsNeededForTrade, Offer offer, String paymentAccountId, boolean useSavingsWallet, boolean isTakerApiUser, TradeResultHandler tradeResultHandler, ErrorMessageHandler errorMessageHandler) {
        ThreadUtils.execute(() -> {
            Preconditions.checkArgument(!this.wasOfferAlreadyUsedInTrade(offer.getId()));
            if (amount.compareTo(offer.getAmount()) > 0) {
                throw new RuntimeException("Trade amount exceeds offer amount");
            }
            if (amount.compareTo(offer.getMinAmount()) < 0) {
                throw new RuntimeException("Trade amount is less than minimum offer amount");
            }
            Optional<Trade> tradeOptional = this.getOpenTrade(offer.getId());
            if (tradeOptional.isPresent()) {
                throw new RuntimeException("Cannot create trade protocol because trade with ID " + offer.getId() + " is already open");
            }
            Trade trade = offer.isBuyOffer() ? new SellerAsTakerTrade(offer, amount, offer.getPrice().getValue(), this.xmrWalletService, this.getNewProcessModel(offer), UUID.randomUUID().toString(), offer.getMakerNodeAddress(), P2PService.getMyNodeAddress(), null, offer.getChallenge()) : new BuyerAsTakerTrade(offer, amount, offer.getPrice().getValue(), this.xmrWalletService, this.getNewProcessModel(offer), UUID.randomUUID().toString(), offer.getMakerNodeAddress(), P2PService.getMyNodeAddress(), null, offer.getChallenge());
            trade.getProcessModel().setUseSavingsWallet(useSavingsWallet);
            trade.getProcessModel().setFundsNeededForTrade(fundsNeededForTrade.longValueExact());
            trade.getMaker().setPaymentAccountId(offer.getOfferPayload().getMakerPaymentAccountId());
            trade.getMaker().setPubKeyRing(offer.getPubKeyRing());
            trade.getSelf().setPubKeyRing(this.keyRing.getPubKeyRing());
            trade.getSelf().setPaymentAccountId(paymentAccountId);
            trade.getSelf().setPaymentMethodId(this.user.getPaymentAccount(paymentAccountId).getPaymentAccountPayload().getPaymentMethodId());
            TradeProtocol tradeProtocol = this.createTradeProtocol(trade);
            this.addTrade(trade);
            this.initTradeAndProtocol(trade, tradeProtocol);
            trade.addInitProgressStep();
            ((TakerProtocol)((Object)tradeProtocol)).onTakeOffer(result -> {
                tradeResultHandler.handleResult(trade);
                this.requestPersistence();
            }, errorMessage -> {
                log.warn("Taker error during trade initialization: " + errorMessage);
                trade.onProtocolError();
                this.xmrWalletService.resetAddressEntriesForOpenOffer(trade.getId());
                errorMessageHandler.handleErrorMessage(errorMessage);
            });
            this.requestPersistence();
        }, offer.getId());
    }

    private ProcessModel getNewProcessModel(Offer offer) {
        return new ProcessModel(Preconditions.checkNotNull(offer).getId(), this.processModelServiceProvider.getUser().getAccountId(), this.processModelServiceProvider.getKeyRing().getPubKeyRing());
    }

    private OfferAvailabilityModel getOfferAvailabilityModel(Offer offer, boolean isTakerApiUser, String paymentAccountId, BigInteger tradeAmount) {
        return new OfferAvailabilityModel(offer, this.keyRing.getPubKeyRing(), this.xmrWalletService, this.p2PService, this.user, this.mediatorManager, this.tradeStatisticsManager, isTakerApiUser, paymentAccountId, tradeAmount, this.offerUtil);
    }

    public void onWithdrawRequest(String toAddress, Coin amount, Coin fee, KeyParameter aesKey, Trade trade, @Nullable String memo, ResultHandler resultHandler, FaultHandler faultHandler) {
        throw new RuntimeException("Withdraw trade funds after payout to Haveno wallet not supported");
    }

    public void onTradeCompleted(Trade trade) {
        if (trade.isCompleted()) {
            throw new RuntimeException("Trade " + trade.getId() + " was already completed");
        }
        this.closedTradableManager.add(trade);
        trade.setCompleted(true);
        this.removeTrade(trade, true);
        this.xmrWalletService.swapPayoutAddressEntryToAvailable(trade.getId());
        this.requestPersistence();
    }

    public void unregisterTrade(Trade trade) {
        log.warn("Unregistering {} {}", (Object)trade.getClass().getSimpleName(), (Object)trade.getId());
        this.removeTrade(trade, true);
        this.removeFailedTrade(trade);
        this.xmrWalletService.swapPayoutAddressEntryToAvailable(trade.getId());
        this.requestPersistence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrade(Trade trade, boolean removeDirectMessageListener) {
        log.info("TradeManager.removeTrade() " + trade.getId());
        List list = this.tradableList.getList();
        synchronized (list) {
            if (!this.tradableList.remove(trade)) {
                return;
            }
        }
        if (removeDirectMessageListener) {
            this.p2PService.removeDecryptedDirectMessageListener(this.getTradeProtocol(trade));
        }
        this.requestPersistence();
    }

    public void closeDisputedTrade(String tradeId, Trade.DisputeState disputeState) {
        Optional<Trade> tradeOptional = this.getOpenTrade(tradeId);
        if (tradeOptional.isPresent()) {
            Trade trade = tradeOptional.get();
            trade.setDisputeState(disputeState);
            this.xmrWalletService.swapPayoutAddressEntryToAvailable(trade.getId());
            this.requestPersistence();
        }
    }

    public void applyTradePeriodState() {
        this.updateTradePeriodState();
        this.clockWatcher.addListener(new ClockWatcher.Listener(){

            @Override
            public void onSecondTick() {
            }

            @Override
            public void onMinuteTick() {
                TradeManager.this.updateTradePeriodState();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTradePeriodState() {
        if (this.isShutDownStarted) {
            return;
        }
        List list = this.tradableList.getList();
        synchronized (list) {
            for (Trade trade : this.tradableList.getList()) {
                if (!trade.isInitialized() || trade.isPayoutPublished()) continue;
                Date maxTradePeriodDate = trade.getMaxTradePeriodDate();
                Date halfTradePeriodDate = trade.getHalfTradePeriodDate();
                if (maxTradePeriodDate == null || halfTradePeriodDate == null) continue;
                Date now = new Date();
                if (now.after(maxTradePeriodDate)) {
                    trade.setPeriodState(Trade.TradePeriodState.TRADE_PERIOD_OVER);
                    this.requestPersistence();
                    continue;
                }
                if (!now.after(halfTradePeriodDate)) continue;
                trade.setPeriodState(Trade.TradePeriodState.SECOND_HALF);
                this.requestPersistence();
            }
        }
    }

    public void onMoveInvalidTradeToFailedTrades(Trade trade) {
        this.failedTradesManager.add(trade);
        this.removeTrade(trade, false);
    }

    public void onMoveFailedTradeToPendingTrades(Trade trade) {
        this.addTradeToPendingTrades(trade);
        this.failedTradesManager.removeTrade(trade);
    }

    public void onMoveClosedTradeToPendingTrades(Trade trade) {
        trade.setCompleted(false);
        this.addTradeToPendingTrades(trade);
        this.closedTradableManager.removeTrade(trade);
    }

    private void removeFailedTrade(Trade trade) {
        this.failedTradesManager.removeTrade(trade);
    }

    private void addTradeToPendingTrades(Trade trade) {
        if (!trade.isInitialized()) {
            try {
                this.initPersistedTrade(trade);
            }
            catch (Exception e) {
                log.warn("Error initializing {} {} on move to pending trades", trade.getClass().getSimpleName(), trade.getShortId(), e);
            }
        }
        this.addTrade(trade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<Trade> getTradesStreamWithFundsLockedIn() {
        List list = this.tradableList.getList();
        synchronized (list) {
            return this.getObservableList().stream().filter(Trade::isFundsLockedIn);
        }
    }

    private void checkForLockedUpFunds() {
        try {
            this.getSetOfFailedOrClosedTradeIdsFromLockedInFunds();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSetOfFailedOrClosedTradeIdsFromLockedInFunds() throws TradeTxException {
        AtomicReference tradeTxException = new AtomicReference();
        List list = this.tradableList.getList();
        synchronized (list) {
            Set<String> tradesIdSet = this.getTradesStreamWithFundsLockedIn().filter(Trade::hasFailed).map(Trade::getId).collect(Collectors.toSet());
            tradesIdSet.addAll(this.failedTradesManager.getTradesStreamWithFundsLockedIn().filter(trade -> trade.getMakerDepositTx() != null || trade.getTakerDepositTx() != null).map(trade -> {
                log.warn("We found a failed trade with locked up funds. That should never happen. trade ID=" + trade.getId());
                return trade.getId();
            }).collect(Collectors.toSet()));
            tradesIdSet.addAll(this.closedTradableManager.getTradesStreamWithFundsLockedIn().map(trade -> {
                MoneroTx makerDepositTx = trade.getMakerDepositTx();
                if (makerDepositTx != null) {
                    if (!makerDepositTx.isConfirmed().booleanValue()) {
                        tradeTxException.set(new TradeTxException(Res.get("error.closedTradeWithUnconfirmedDepositTx", trade.getShortId())));
                    } else {
                        log.warn("We found a closed trade with locked up funds. That should never happen. {} ID={}, state={}, payoutState={}, disputeState={}", new Object[]{trade.getClass().getSimpleName(), trade.getId(), trade.getState(), trade.getPayoutState(), trade.getDisputeState()});
                    }
                } else {
                    log.warn("Closed trade with locked up funds missing maker deposit tx. {} ID={}, state={}, payoutState={}, disputeState={}", new Object[]{trade.getClass().getSimpleName(), trade.getId(), trade.getState(), trade.getPayoutState(), trade.getDisputeState()});
                    tradeTxException.set(new TradeTxException(Res.get("error.closedTradeWithNoDepositTx", trade.getShortId())));
                }
                MoneroTx takerDepositTx = trade.getTakerDepositTx();
                if (takerDepositTx != null) {
                    if (!takerDepositTx.isConfirmed().booleanValue()) {
                        tradeTxException.set(new TradeTxException(Res.get("error.closedTradeWithUnconfirmedDepositTx", trade.getShortId())));
                    } else {
                        log.warn("We found a closed trade with locked up funds. That should never happen. trade ID={} ID={}, state={}, payoutState={}, disputeState={}", new Object[]{trade.getClass().getSimpleName(), trade.getId(), trade.getState(), trade.getPayoutState(), trade.getDisputeState()});
                    }
                } else if (!trade.hasBuyerAsTakerWithoutDeposit()) {
                    log.warn("Closed trade with locked up funds missing taker deposit tx. {} ID={}, state={}, payoutState={}, disputeState={}", new Object[]{trade.getClass().getSimpleName(), trade.getId(), trade.getState(), trade.getPayoutState(), trade.getDisputeState()});
                    tradeTxException.set(new TradeTxException(Res.get("error.closedTradeWithNoDepositTx", trade.getShortId())));
                }
                return trade.getId();
            }).collect(Collectors.toSet()));
            if (tradeTxException.get() != null) {
                throw (TradeTxException)tradeTxException.get();
            }
            return tradesIdSet;
        }
    }

    private boolean unFailTrade(Trade trade) {
        if (!this.recoverAddresses(trade)) {
            log.warn("Failed to recover address during unFail trade");
            return false;
        }
        this.initPersistedTrade(trade);
        UserThread.execute(() -> {
            List list = this.tradableList.getList();
            synchronized (list) {
                if (!this.tradableList.contains(trade)) {
                    this.tradableList.add(trade);
                }
            }
        });
        return true;
    }

    private boolean recoverAddresses(Trade trade) {
        Tuple2<String, String> entries = this.tradeUtil.getAvailableAddresses(trade);
        if (entries == null) {
            return false;
        }
        this.xmrWalletService.recoverAddressEntry(trade.getId(), (String)entries.second, XmrAddressEntry.Context.TRADE_PAYOUT);
        return true;
    }

    public void sendAckMessage(final NodeAddress peer, PubKeyRing peersPubKeyRing, TradeMessage message, boolean result, @Nullable String errorMessage, String updatedMultisigHex) {
        final String tradeId = message.getOfferId();
        final String sourceUid = message.getUid();
        final AckMessage ackMessage = new AckMessage(P2PService.getMyNodeAddress(), AckMessageSourceType.TRADE_MESSAGE, message.getClass().getSimpleName(), sourceUid, tradeId, result, errorMessage, updatedMultisigHex);
        log.info("Send AckMessage for {} to peer {}. tradeId={}, sourceUid={}", ackMessage.getSourceMsgClassName(), peer, tradeId, sourceUid);
        this.p2PService.getMailboxMessageService().sendEncryptedMailboxMessage(peer, peersPubKeyRing, ackMessage, new SendMailboxMessageListener(){

            @Override
            public void onArrived() {
                log.info("AckMessage for {} arrived at peer {}. tradeId={}, sourceUid={}", ackMessage.getSourceMsgClassName(), peer, tradeId, sourceUid);
            }

            @Override
            public void onStoredInMailbox() {
                log.info("AckMessage for {} stored in mailbox for peer {}. tradeId={}, sourceUid={}", ackMessage.getSourceMsgClassName(), peer, tradeId, sourceUid);
            }

            @Override
            public void onFault(String errorMessage) {
                log.error("AckMessage for {} failed. Peer {}. tradeId={}, sourceUid={}, errorMessage={}", ackMessage.getSourceMsgClassName(), peer, tradeId, sourceUid, errorMessage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObservableList<Trade> getObservableList() {
        List list = this.tradableList.getList();
        synchronized (list) {
            return this.tradableList.getObservableList();
        }
    }

    public BooleanProperty persistedTradesInitializedProperty() {
        return this.persistedTradesInitialized;
    }

    public boolean isMyOffer(Offer offer) {
        return offer.isMyOffer(this.keyRing);
    }

    public boolean wasOfferAlreadyUsedInTrade(String offerId) {
        return this.getOpenTrade(offerId).isPresent() || this.failedTradesManager.getTradeById(offerId).isPresent() || this.closedTradableManager.getTradableById(offerId).isPresent();
    }

    public boolean isBuyer(Offer offer) {
        if (this.isMyOffer(offer)) {
            return offer.isBuyOffer();
        }
        return offer.getDirection() == OfferDirection.SELL;
    }

    public Trade getTrade(String tradeId) {
        return this.getOpenTrade(tradeId).orElseGet(() -> this.getClosedTrade(tradeId).orElseGet(() -> this.getFailedTrade(tradeId).orElseGet(() -> null)));
    }

    public boolean hasTrade(String tradeId) {
        return this.getTrade(tradeId) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Trade> getOpenTrade(String tradeId) {
        List list = this.tradableList.getList();
        synchronized (list) {
            return this.tradableList.stream().filter(e -> e.getId().equals(tradeId)).findFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOpenTrade(Trade trade) {
        List list = this.tradableList.getList();
        synchronized (list) {
            return this.tradableList.contains(trade);
        }
    }

    public boolean hasFailedScheduledTrade(String offerId) {
        return this.failedTradesManager.getTradeById(offerId).isPresent() && this.failedTradesManager.getTradeById(offerId).get().isProtocolErrorHandlingScheduled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Trade> getOpenTradeByUid(String tradeUid) {
        List list = this.tradableList.getList();
        synchronized (list) {
            return this.tradableList.stream().filter(e -> e.getUid().equals(tradeUid)).findFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Trade> getAllTrades() {
        List list = this.tradableList.getList();
        synchronized (list) {
            ArrayList<Trade> trades = new ArrayList<Trade>();
            List list2 = this.tradableList.getList();
            synchronized (list2) {
                trades.addAll(this.tradableList.getList());
            }
            trades.addAll(this.closedTradableManager.getClosedTrades());
            trades.addAll(this.failedTradesManager.getObservableList());
            return trades;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Trade> getOpenTrades() {
        List list = this.tradableList.getList();
        synchronized (list) {
            return ImmutableList.copyOf(this.getObservableList().stream().filter(e -> e instanceof Trade).map(e -> e).collect(Collectors.toList()));
        }
    }

    public List<Trade> getClosedTrades() {
        return this.closedTradableManager.getClosedTrades();
    }

    public Optional<Trade> getClosedTrade(String tradeId) {
        return this.closedTradableManager.getTradeById(tradeId);
    }

    public Optional<Trade> getFailedTrade(String tradeId) {
        return this.failedTradesManager.getTradeById(tradeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTrade(Trade trade) {
        List list = this.tradableList.getList();
        synchronized (list) {
            if (this.tradableList.add(trade)) {
                this.requestPersistence();
            }
        }
    }

    private void onTradesChanged() {
        this.numPendingTrades.set(this.getObservableList().size());
    }

    public KeyRing getKeyRing() {
        return this.keyRing;
    }

    public CoreNotificationService getNotificationService() {
        return this.notificationService;
    }

    public OpenOfferManager getOpenOfferManager() {
        return this.openOfferManager;
    }

    public ArbitratorManager getArbitratorManager() {
        return this.arbitratorManager;
    }

    public BooleanProperty getPersistedTradesInitialized() {
        return this.persistedTradesInitialized;
    }

    public LongProperty getNumPendingTrades() {
        return this.numPendingTrades;
    }

    public void setLockedUpFundsHandler(@Nullable Consumer<String> lockedUpFundsHandler) {
        this.lockedUpFundsHandler = lockedUpFundsHandler;
    }

    static {
        MailboxMessageService.setMailboxMessageComparator(new MailboxMessageComparator());
    }

    public static class MailboxMessageComparator
    implements Comparator<MailboxMessage> {
        private static List<Class<? extends MailboxMessage>> messageOrder = Arrays.asList(AckMessage.class, DepositsConfirmedMessage.class, PaymentSentMessage.class, PaymentReceivedMessage.class, DisputeOpenedMessage.class, DisputeClosedMessage.class);

        @Override
        public int compare(MailboxMessage m1, MailboxMessage m22) {
            int idx1 = messageOrder.indexOf(m1.getClass());
            int idx2 = messageOrder.indexOf(m22.getClass());
            return idx1 - idx2;
        }
    }
}

