/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.failed;

import com.google.inject.Inject;
import haveno.common.crypto.KeyRing;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.persistable.PersistedDataHost;
import haveno.common.util.Tuple2;
import haveno.core.offer.Offer;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.CleanupMailboxMessages;
import haveno.core.trade.TradableList;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeUtil;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.core.xmr.wallet.XmrWalletService;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailedTradesManager
implements PersistedDataHost {
    private static final Logger log = LoggerFactory.getLogger(FailedTradesManager.class);
    private final TradableList<Trade> failedTrades = new TradableList();
    private final KeyRing keyRing;
    private final PriceFeedService priceFeedService;
    private final XmrWalletService xmrWalletService;
    private final CleanupMailboxMessages cleanupMailboxMessages;
    private final PersistenceManager<TradableList<Trade>> persistenceManager;
    private final TradeUtil tradeUtil;
    private Function<Trade, Boolean> unFailTradeCallback;

    @Inject
    public FailedTradesManager(KeyRing keyRing, PriceFeedService priceFeedService, XmrWalletService xmrWalletService, PersistenceManager<TradableList<Trade>> persistenceManager, TradeUtil tradeUtil, CleanupMailboxMessages cleanupMailboxMessages) {
        this.keyRing = keyRing;
        this.priceFeedService = priceFeedService;
        this.xmrWalletService = xmrWalletService;
        this.cleanupMailboxMessages = cleanupMailboxMessages;
        this.persistenceManager = persistenceManager;
        this.tradeUtil = tradeUtil;
        this.persistenceManager.initialize(this.failedTrades, "FailedTrades", PersistenceManager.Source.PRIVATE);
    }

    @Override
    public void readPersisted(Runnable completeHandler) {
        this.persistenceManager.readPersisted(persisted -> {
            List list = persisted.getList();
            synchronized (list) {
                this.failedTrades.setAll(persisted.getList());
                this.failedTrades.stream().filter(trade -> trade.getOffer() != null).forEach(trade -> trade.getOffer().setPriceFeedService(this.priceFeedService));
            }
            completeHandler.run();
        }, completeHandler);
    }

    public void onAllServicesInitialized() {
        this.cleanupMailboxMessages.handleTrades(this.failedTrades.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Trade trade) {
        List list = this.failedTrades.getList();
        synchronized (list) {
            if (this.failedTrades.add(trade)) {
                this.requestPersistence();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrade(Trade trade) {
        List list = this.failedTrades.getList();
        synchronized (list) {
            if (this.failedTrades.remove(trade)) {
                this.requestPersistence();
            }
        }
    }

    public boolean wasMyOffer(Offer offer) {
        return offer.isMyOffer(this.keyRing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObservableList<Trade> getObservableList() {
        List list = this.failedTrades.getList();
        synchronized (list) {
            return this.failedTrades.getObservableList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Trade> getTradeById(String id) {
        List list = this.failedTrades.getList();
        synchronized (list) {
            return this.failedTrades.stream().filter(e -> e.getId().equals(id)).findFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<Trade> getTradesStreamWithFundsLockedIn() {
        List list = this.failedTrades.getList();
        synchronized (list) {
            return this.failedTrades.stream().filter(Trade::isFundsLockedIn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unFailTrade(Trade trade) {
        List list = this.failedTrades.getList();
        synchronized (list) {
            if (this.unFailTradeCallback == null) {
                return;
            }
            if (this.unFailTradeCallback.apply(trade).booleanValue()) {
                log.info("Unfailing trade {}", (Object)trade.getId());
                if (this.failedTrades.remove(trade)) {
                    this.requestPersistence();
                }
            }
        }
    }

    public String checkUnFail(Trade trade) {
        Tuple2<String, String> addresses = this.tradeUtil.getTradeAddresses(trade);
        if (addresses == null) {
            return "Addresses not found";
        }
        StringBuilder blockingTrades = new StringBuilder();
        for (XmrAddressEntry entry : this.xmrWalletService.getAddressEntryListAsImmutableList()) {
            if (entry.getContext() == XmrAddressEntry.Context.AVAILABLE || entry.getAddressString() == null || !entry.getAddressString().equals(addresses.first) && !entry.getAddressString().equals(addresses.second)) continue;
            blockingTrades.append(entry.getOfferId()).append(", ");
        }
        return blockingTrades.toString();
    }

    private void requestPersistence() {
        this.persistenceManager.requestPersistence();
    }

    public void setUnFailTradeCallback(Function<Trade, Boolean> unFailTradeCallback) {
        this.unFailTradeCallback = unFailTradeCallback;
    }
}

