/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.messages;

import com.google.protobuf.ByteString;
import haveno.common.proto.ProtoUtil;
import haveno.common.util.Utilities;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.trade.messages.TradeMessage;
import haveno.network.p2p.DirectMessage;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import protobuf.DepositRequest;
import protobuf.NetworkEnvelope;

public final class DepositRequest
extends TradeMessage
implements DirectMessage {
    private final long currentDate;
    private final byte[] contractSignature;
    @Nullable
    private final String depositTxHex;
    @Nullable
    private final String depositTxKey;
    @Nullable
    private final byte[] paymentAccountKey;

    public DepositRequest(String tradeId, String uid, String messageVersion, long currentDate, byte[] contractSignature, @Nullable String depositTxHex, @Nullable String depositTxKey, @Nullable byte[] paymentAccountKey) {
        super(messageVersion, tradeId, uid);
        this.currentDate = currentDate;
        this.contractSignature = contractSignature;
        this.depositTxHex = depositTxHex;
        this.depositTxKey = depositTxKey;
        this.paymentAccountKey = paymentAccountKey;
    }

    @Override
    public NetworkEnvelope toProtoNetworkEnvelope() {
        DepositRequest.Builder builder = protobuf.DepositRequest.newBuilder().setTradeId(this.offerId).setUid(this.uid);
        builder.setCurrentDate(this.currentDate);
        Optional.ofNullable(this.paymentAccountKey).ifPresent(e -> builder.setPaymentAccountKey(ByteString.copyFrom(e)));
        Optional.ofNullable(this.depositTxHex).ifPresent(builder::setDepositTxHex);
        Optional.ofNullable(this.depositTxKey).ifPresent(builder::setDepositTxKey);
        Optional.ofNullable(this.contractSignature).ifPresent(e -> builder.setContractSignature(ByteString.copyFrom(e)));
        return this.getNetworkEnvelopeBuilder().setDepositRequest(builder).build();
    }

    public static DepositRequest fromProto(protobuf.DepositRequest proto, CoreProtoResolver coreProtoResolver, String messageVersion) {
        return new DepositRequest(proto.getTradeId(), proto.getUid(), messageVersion, proto.getCurrentDate(), ProtoUtil.byteArrayOrNullFromProto(proto.getContractSignature()), ProtoUtil.stringOrNullFromProto(proto.getDepositTxHex()), ProtoUtil.stringOrNullFromProto(proto.getDepositTxKey()), ProtoUtil.byteArrayOrNullFromProto(proto.getPaymentAccountKey()));
    }

    @Override
    public String toString() {
        return "DepositRequest {,\n     currentDate=" + this.currentDate + ",\n     contractSignature=" + Utilities.bytesAsHexString(this.contractSignature) + ",\n     depositTxHex='" + this.depositTxHex + ",\n     depositTxKey='" + this.depositTxKey + ",\n     paymentAccountKey='" + String.valueOf(this.paymentAccountKey) + "\n} " + super.toString();
    }

    public long getCurrentDate() {
        return this.currentDate;
    }

    public byte[] getContractSignature() {
        return this.contractSignature;
    }

    @Nullable
    public String getDepositTxHex() {
        return this.depositTxHex;
    }

    @Nullable
    public String getDepositTxKey() {
        return this.depositTxKey;
    }

    @Nullable
    public byte[] getPaymentAccountKey() {
        return this.paymentAccountKey;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DepositRequest)) {
            return false;
        }
        DepositRequest other = (DepositRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCurrentDate() != other.getCurrentDate()) {
            return false;
        }
        if (!Arrays.equals(this.getContractSignature(), other.getContractSignature())) {
            return false;
        }
        String this$depositTxHex = this.getDepositTxHex();
        String other$depositTxHex = other.getDepositTxHex();
        if (this$depositTxHex == null ? other$depositTxHex != null : !this$depositTxHex.equals(other$depositTxHex)) {
            return false;
        }
        String this$depositTxKey = this.getDepositTxKey();
        String other$depositTxKey = other.getDepositTxKey();
        if (this$depositTxKey == null ? other$depositTxKey != null : !this$depositTxKey.equals(other$depositTxKey)) {
            return false;
        }
        return Arrays.equals(this.getPaymentAccountKey(), other.getPaymentAccountKey());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DepositRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $currentDate = this.getCurrentDate();
        result = result * 59 + (int)($currentDate >>> 32 ^ $currentDate);
        result = result * 59 + Arrays.hashCode(this.getContractSignature());
        String $depositTxHex = this.getDepositTxHex();
        result = result * 59 + ($depositTxHex == null ? 43 : $depositTxHex.hashCode());
        String $depositTxKey = this.getDepositTxKey();
        result = result * 59 + ($depositTxKey == null ? 43 : $depositTxKey.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPaymentAccountKey());
        return result;
    }
}

