/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.messages;

import haveno.common.proto.ProtoUtil;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.trade.messages.TradeMessage;
import haveno.network.p2p.DirectMessage;
import java.util.Optional;
import javax.annotation.Nullable;
import protobuf.InitMultisigRequest;
import protobuf.NetworkEnvelope;

public final class InitMultisigRequest
extends TradeMessage
implements DirectMessage {
    private final long currentDate;
    @Nullable
    private final String preparedMultisigHex;
    @Nullable
    private final String madeMultisigHex;
    @Nullable
    private final String exchangedMultisigHex;
    @Nullable
    private final String tradeFeeAddress;

    public InitMultisigRequest(String tradeId, String uid, String messageVersion, long currentDate, String preparedMultisigHex, String madeMultisigHex, String exchangedMultisigHex, String tradeFeeAddress) {
        super(messageVersion, tradeId, uid);
        this.currentDate = currentDate;
        this.preparedMultisigHex = preparedMultisigHex;
        this.madeMultisigHex = madeMultisigHex;
        this.exchangedMultisigHex = exchangedMultisigHex;
        this.tradeFeeAddress = tradeFeeAddress;
    }

    @Override
    public NetworkEnvelope toProtoNetworkEnvelope() {
        InitMultisigRequest.Builder builder = protobuf.InitMultisigRequest.newBuilder().setTradeId(this.offerId).setUid(this.uid);
        Optional.ofNullable(this.preparedMultisigHex).ifPresent(e -> builder.setPreparedMultisigHex(this.preparedMultisigHex));
        Optional.ofNullable(this.madeMultisigHex).ifPresent(e -> builder.setMadeMultisigHex(this.madeMultisigHex));
        Optional.ofNullable(this.exchangedMultisigHex).ifPresent(e -> builder.setExchangedMultisigHex(this.exchangedMultisigHex));
        Optional.ofNullable(this.tradeFeeAddress).ifPresent(e -> builder.setTradeFeeAddress(this.tradeFeeAddress));
        builder.setCurrentDate(this.currentDate);
        return this.getNetworkEnvelopeBuilder().setInitMultisigRequest(builder).build();
    }

    public static InitMultisigRequest fromProto(protobuf.InitMultisigRequest proto, CoreProtoResolver coreProtoResolver, String messageVersion) {
        return new InitMultisigRequest(proto.getTradeId(), proto.getUid(), messageVersion, proto.getCurrentDate(), ProtoUtil.stringOrNullFromProto(proto.getPreparedMultisigHex()), ProtoUtil.stringOrNullFromProto(proto.getMadeMultisigHex()), ProtoUtil.stringOrNullFromProto(proto.getExchangedMultisigHex()), ProtoUtil.stringOrNullFromProto(proto.getTradeFeeAddress()));
    }

    @Override
    public String toString() {
        return "InitMultisigRequest {,\n     currentDate=" + this.currentDate + ",\n     preparedMultisigHex=" + this.preparedMultisigHex + ",\n     madeMultisigHex=" + this.madeMultisigHex + ",\n     exchangedMultisigHex=" + this.exchangedMultisigHex + ",\n     tradeFeeAddress=" + this.tradeFeeAddress + "\n} " + super.toString();
    }

    public long getCurrentDate() {
        return this.currentDate;
    }

    @Nullable
    public String getPreparedMultisigHex() {
        return this.preparedMultisigHex;
    }

    @Nullable
    public String getMadeMultisigHex() {
        return this.madeMultisigHex;
    }

    @Nullable
    public String getExchangedMultisigHex() {
        return this.exchangedMultisigHex;
    }

    @Nullable
    public String getTradeFeeAddress() {
        return this.tradeFeeAddress;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InitMultisigRequest)) {
            return false;
        }
        InitMultisigRequest other = (InitMultisigRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCurrentDate() != other.getCurrentDate()) {
            return false;
        }
        String this$preparedMultisigHex = this.getPreparedMultisigHex();
        String other$preparedMultisigHex = other.getPreparedMultisigHex();
        if (this$preparedMultisigHex == null ? other$preparedMultisigHex != null : !this$preparedMultisigHex.equals(other$preparedMultisigHex)) {
            return false;
        }
        String this$madeMultisigHex = this.getMadeMultisigHex();
        String other$madeMultisigHex = other.getMadeMultisigHex();
        if (this$madeMultisigHex == null ? other$madeMultisigHex != null : !this$madeMultisigHex.equals(other$madeMultisigHex)) {
            return false;
        }
        String this$exchangedMultisigHex = this.getExchangedMultisigHex();
        String other$exchangedMultisigHex = other.getExchangedMultisigHex();
        if (this$exchangedMultisigHex == null ? other$exchangedMultisigHex != null : !this$exchangedMultisigHex.equals(other$exchangedMultisigHex)) {
            return false;
        }
        String this$tradeFeeAddress = this.getTradeFeeAddress();
        String other$tradeFeeAddress = other.getTradeFeeAddress();
        return !(this$tradeFeeAddress == null ? other$tradeFeeAddress != null : !this$tradeFeeAddress.equals(other$tradeFeeAddress));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InitMultisigRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $currentDate = this.getCurrentDate();
        result = result * 59 + (int)($currentDate >>> 32 ^ $currentDate);
        String $preparedMultisigHex = this.getPreparedMultisigHex();
        result = result * 59 + ($preparedMultisigHex == null ? 43 : $preparedMultisigHex.hashCode());
        String $madeMultisigHex = this.getMadeMultisigHex();
        result = result * 59 + ($madeMultisigHex == null ? 43 : $madeMultisigHex.hashCode());
        String $exchangedMultisigHex = this.getExchangedMultisigHex();
        result = result * 59 + ($exchangedMultisigHex == null ? 43 : $exchangedMultisigHex.hashCode());
        String $tradeFeeAddress = this.getTradeFeeAddress();
        result = result * 59 + ($tradeFeeAddress == null ? 43 : $tradeFeeAddress.hashCode());
        return result;
    }
}

