/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.messages;

import com.google.protobuf.ByteString;
import haveno.common.app.Version;
import haveno.common.util.Utilities;
import haveno.core.trade.messages.TradeMailboxMessage;
import haveno.network.p2p.NodeAddress;
import java.util.Arrays;
import protobuf.NetworkEnvelope;

public final class MediatedPayoutTxPublishedMessage
extends TradeMailboxMessage {
    private final byte[] payoutTx;
    private final NodeAddress senderNodeAddress;

    public MediatedPayoutTxPublishedMessage(String tradeId, byte[] payoutTx, NodeAddress senderNodeAddress, String uid) {
        this(tradeId, payoutTx, senderNodeAddress, uid, Version.getP2PMessageVersion());
    }

    private MediatedPayoutTxPublishedMessage(String tradeId, byte[] payoutTx, NodeAddress senderNodeAddress, String uid, String messageVersion) {
        super(messageVersion, tradeId, uid);
        this.payoutTx = payoutTx;
        this.senderNodeAddress = senderNodeAddress;
    }

    @Override
    public NetworkEnvelope toProtoNetworkEnvelope() {
        return this.getNetworkEnvelopeBuilder().setMediatedPayoutTxPublishedMessage(protobuf.MediatedPayoutTxPublishedMessage.newBuilder().setTradeId(this.offerId).setPayoutTx(ByteString.copyFrom(this.payoutTx)).setSenderNodeAddress(this.senderNodeAddress.toProtoMessage()).setUid(this.uid)).build();
    }

    public static haveno.common.proto.network.NetworkEnvelope fromProto(protobuf.MediatedPayoutTxPublishedMessage proto, String messageVersion) {
        return new MediatedPayoutTxPublishedMessage(proto.getTradeId(), proto.getPayoutTx().toByteArray(), NodeAddress.fromProto(proto.getSenderNodeAddress()), proto.getUid(), messageVersion);
    }

    @Override
    public String toString() {
        return "MediatedPayoutTxPublishedMessage{\n     payoutTx=" + Utilities.bytesAsHexString(this.payoutTx) + ",\n     senderNodeAddress=" + String.valueOf(this.senderNodeAddress) + ",\n     uid='" + this.uid + "'\n} " + super.toString();
    }

    public byte[] getPayoutTx() {
        return this.payoutTx;
    }

    @Override
    public NodeAddress getSenderNodeAddress() {
        return this.senderNodeAddress;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MediatedPayoutTxPublishedMessage)) {
            return false;
        }
        MediatedPayoutTxPublishedMessage other = (MediatedPayoutTxPublishedMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getPayoutTx(), other.getPayoutTx())) {
            return false;
        }
        NodeAddress this$senderNodeAddress = this.getSenderNodeAddress();
        NodeAddress other$senderNodeAddress = other.getSenderNodeAddress();
        return !(this$senderNodeAddress == null ? other$senderNodeAddress != null : !((Object)this$senderNodeAddress).equals(other$senderNodeAddress));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MediatedPayoutTxPublishedMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getPayoutTx());
        NodeAddress $senderNodeAddress = this.getSenderNodeAddress();
        result = result * 59 + ($senderNodeAddress == null ? 43 : ((Object)$senderNodeAddress).hashCode());
        return result;
    }
}

