/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.messages;

import com.google.protobuf.ByteString;
import haveno.common.app.Version;
import haveno.common.util.Utilities;
import haveno.core.trade.messages.TradeMailboxMessage;
import haveno.network.p2p.NodeAddress;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.NetworkEnvelope;

public final class MediatedPayoutTxSignatureMessage
extends TradeMailboxMessage {
    private static final Logger log = LoggerFactory.getLogger(MediatedPayoutTxSignatureMessage.class);
    private final byte[] txSignature;
    private final NodeAddress senderNodeAddress;

    public MediatedPayoutTxSignatureMessage(byte[] txSignature, String tradeId, NodeAddress senderNodeAddress, String uid) {
        this(txSignature, tradeId, senderNodeAddress, uid, Version.getP2PMessageVersion());
    }

    private MediatedPayoutTxSignatureMessage(byte[] txSignature, String tradeId, NodeAddress senderNodeAddress, String uid, String messageVersion) {
        super(messageVersion, tradeId, uid);
        this.txSignature = txSignature;
        this.senderNodeAddress = senderNodeAddress;
    }

    @Override
    public NetworkEnvelope toProtoNetworkEnvelope() {
        return this.getNetworkEnvelopeBuilder().setMediatedPayoutTxSignatureMessage(protobuf.MediatedPayoutTxSignatureMessage.newBuilder().setTxSignature(ByteString.copyFrom(this.txSignature)).setTradeId(this.offerId).setSenderNodeAddress(this.senderNodeAddress.toProtoMessage()).setUid(this.uid)).build();
    }

    public static MediatedPayoutTxSignatureMessage fromProto(protobuf.MediatedPayoutTxSignatureMessage proto, String messageVersion) {
        return new MediatedPayoutTxSignatureMessage(proto.getTxSignature().toByteArray(), proto.getTradeId(), NodeAddress.fromProto(proto.getSenderNodeAddress()), proto.getUid(), messageVersion);
    }

    @Override
    public String getOfferId() {
        return this.offerId;
    }

    @Override
    public String toString() {
        return "MediatedPayoutSignatureMessage{\n     txSignature=" + Utilities.bytesAsHexString(this.txSignature) + ",\n     tradeId='" + this.offerId + "',\n     senderNodeAddress=" + String.valueOf(this.senderNodeAddress) + "\n} " + super.toString();
    }

    public byte[] getTxSignature() {
        return this.txSignature;
    }

    @Override
    public NodeAddress getSenderNodeAddress() {
        return this.senderNodeAddress;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MediatedPayoutTxSignatureMessage)) {
            return false;
        }
        MediatedPayoutTxSignatureMessage other = (MediatedPayoutTxSignatureMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getTxSignature(), other.getTxSignature())) {
            return false;
        }
        NodeAddress this$senderNodeAddress = this.getSenderNodeAddress();
        NodeAddress other$senderNodeAddress = other.getSenderNodeAddress();
        return !(this$senderNodeAddress == null ? other$senderNodeAddress != null : !((Object)this$senderNodeAddress).equals(other$senderNodeAddress));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MediatedPayoutTxSignatureMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getTxSignature());
        NodeAddress $senderNodeAddress = this.getSenderNodeAddress();
        result = result * 59 + ($senderNodeAddress == null ? 43 : ((Object)$senderNodeAddress).hashCode());
        return result;
    }
}

