/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.messages;

import com.google.protobuf.ByteString;
import haveno.common.app.Version;
import haveno.common.proto.ProtoUtil;
import haveno.core.trade.messages.PaymentSentMessage;
import haveno.core.trade.messages.TradeMailboxMessage;
import haveno.network.p2p.NodeAddress;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.AccountAgeWitness;
import protobuf.NetworkEnvelope;
import protobuf.PaymentReceivedMessage;
import protobuf.SignedWitness;

public final class PaymentReceivedMessage
extends TradeMailboxMessage {
    private static final Logger log = LoggerFactory.getLogger(PaymentReceivedMessage.class);
    private final NodeAddress senderNodeAddress;
    @Nullable
    private final String unsignedPayoutTxHex;
    @Nullable
    private final String signedPayoutTxHex;
    private final String updatedMultisigHex;
    private final boolean deferPublishPayout;
    @Nullable
    private final haveno.core.account.witness.AccountAgeWitness buyerAccountAgeWitness;
    @Nullable
    private final haveno.core.account.sign.SignedWitness buyerSignedWitness;
    @Nullable
    private final PaymentSentMessage paymentSentMessage;
    @Nullable
    private byte[] sellerSignature;

    public PaymentReceivedMessage(String tradeId, NodeAddress senderNodeAddress, String uid, String unsignedPayoutTxHex, String signedPayoutTxHex, String updatedMultisigHex, boolean deferPublishPayout, haveno.core.account.witness.AccountAgeWitness buyerAccountAgeWitness, @Nullable haveno.core.account.sign.SignedWitness buyerSignedWitness, @Nullable PaymentSentMessage paymentSentMessage) {
        this(tradeId, senderNodeAddress, uid, Version.getP2PMessageVersion(), unsignedPayoutTxHex, signedPayoutTxHex, updatedMultisigHex, deferPublishPayout, buyerAccountAgeWitness, buyerSignedWitness, paymentSentMessage);
    }

    private PaymentReceivedMessage(String tradeId, NodeAddress senderNodeAddress, String uid, String messageVersion, String unsignedPayoutTxHex, String signedPayoutTxHex, String updatedMultisigHex, boolean deferPublishPayout, haveno.core.account.witness.AccountAgeWitness buyerAccountAgeWitness, @Nullable haveno.core.account.sign.SignedWitness buyerSignedWitness, PaymentSentMessage paymentSentMessage) {
        super(messageVersion, tradeId, uid);
        this.senderNodeAddress = senderNodeAddress;
        this.unsignedPayoutTxHex = unsignedPayoutTxHex;
        this.signedPayoutTxHex = signedPayoutTxHex;
        this.updatedMultisigHex = updatedMultisigHex;
        this.deferPublishPayout = deferPublishPayout;
        this.paymentSentMessage = paymentSentMessage;
        this.buyerAccountAgeWitness = buyerAccountAgeWitness;
        this.buyerSignedWitness = buyerSignedWitness;
    }

    @Override
    public NetworkEnvelope toProtoNetworkEnvelope() {
        PaymentReceivedMessage.Builder builder = protobuf.PaymentReceivedMessage.newBuilder().setTradeId(this.offerId).setSenderNodeAddress(this.senderNodeAddress.toProtoMessage()).setUid(this.uid).setDeferPublishPayout(this.deferPublishPayout);
        Optional.ofNullable(this.updatedMultisigHex).ifPresent(e -> builder.setUpdatedMultisigHex(this.updatedMultisigHex));
        Optional.ofNullable(this.unsignedPayoutTxHex).ifPresent(e -> builder.setUnsignedPayoutTxHex(this.unsignedPayoutTxHex));
        Optional.ofNullable(this.signedPayoutTxHex).ifPresent(e -> builder.setSignedPayoutTxHex(this.signedPayoutTxHex));
        Optional.ofNullable(this.buyerAccountAgeWitness).ifPresent(buyerAccountAgeWitness -> builder.setBuyerAccountAgeWitness(buyerAccountAgeWitness.toProtoAccountAgeWitness()));
        Optional.ofNullable(this.buyerSignedWitness).ifPresent(buyerSignedWitness -> builder.setBuyerSignedWitness(buyerSignedWitness.toProtoSignedWitness()));
        Optional.ofNullable(this.paymentSentMessage).ifPresent(e -> builder.setPaymentSentMessage(this.paymentSentMessage.toProtoNetworkEnvelope().getPaymentSentMessage()));
        Optional.ofNullable(this.sellerSignature).ifPresent(e -> builder.setSellerSignature(ByteString.copyFrom(e)));
        return this.getNetworkEnvelopeBuilder().setPaymentReceivedMessage(builder).build();
    }

    public static PaymentReceivedMessage fromProto(protobuf.PaymentReceivedMessage proto, String messageVersion) {
        AccountAgeWitness protoAccountAgeWitness = proto.getBuyerAccountAgeWitness();
        haveno.core.account.witness.AccountAgeWitness buyerAccountAgeWitness = protoAccountAgeWitness.getHash().isEmpty() ? null : haveno.core.account.witness.AccountAgeWitness.fromProto(protoAccountAgeWitness);
        SignedWitness protoSignedWitness = proto.getBuyerSignedWitness();
        haveno.core.account.sign.SignedWitness buyerSignedWitness = !protoSignedWitness.getSignature().isEmpty() ? haveno.core.account.sign.SignedWitness.fromProto(protoSignedWitness) : null;
        PaymentReceivedMessage message = new PaymentReceivedMessage(proto.getTradeId(), NodeAddress.fromProto(proto.getSenderNodeAddress()), proto.getUid(), messageVersion, ProtoUtil.stringOrNullFromProto(proto.getUnsignedPayoutTxHex()), ProtoUtil.stringOrNullFromProto(proto.getSignedPayoutTxHex()), ProtoUtil.stringOrNullFromProto(proto.getUpdatedMultisigHex()), proto.getDeferPublishPayout(), buyerAccountAgeWitness, buyerSignedWitness, proto.hasPaymentSentMessage() ? PaymentSentMessage.fromProto(proto.getPaymentSentMessage(), messageVersion) : null);
        message.setSellerSignature(ProtoUtil.byteArrayOrNullFromProto(proto.getSellerSignature()));
        return message;
    }

    @Override
    public String toString() {
        return "PaymentReceivedMessage{\n     senderNodeAddress=" + String.valueOf(this.senderNodeAddress) + ",\n     buyerSignedWitness=" + String.valueOf(this.buyerSignedWitness) + ",\n     unsignedPayoutTxHex=" + this.unsignedPayoutTxHex + ",\n     signedPayoutTxHex=" + this.signedPayoutTxHex + ",\n     updatedMultisigHex=" + (this.updatedMultisigHex == null ? null : this.updatedMultisigHex.substring(0, Math.max(this.updatedMultisigHex.length(), 1000))) + ",\n     deferPublishPayout=" + this.deferPublishPayout + ",\n     paymentSentMessage=" + String.valueOf(this.paymentSentMessage) + ",\n     sellerSignature=" + String.valueOf(this.sellerSignature) + "\n} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentReceivedMessage)) {
            return false;
        }
        PaymentReceivedMessage other = (PaymentReceivedMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDeferPublishPayout() != other.isDeferPublishPayout()) {
            return false;
        }
        NodeAddress this$senderNodeAddress = this.getSenderNodeAddress();
        NodeAddress other$senderNodeAddress = other.getSenderNodeAddress();
        if (this$senderNodeAddress == null ? other$senderNodeAddress != null : !((Object)this$senderNodeAddress).equals(other$senderNodeAddress)) {
            return false;
        }
        String this$unsignedPayoutTxHex = this.getUnsignedPayoutTxHex();
        String other$unsignedPayoutTxHex = other.getUnsignedPayoutTxHex();
        if (this$unsignedPayoutTxHex == null ? other$unsignedPayoutTxHex != null : !this$unsignedPayoutTxHex.equals(other$unsignedPayoutTxHex)) {
            return false;
        }
        String this$signedPayoutTxHex = this.getSignedPayoutTxHex();
        String other$signedPayoutTxHex = other.getSignedPayoutTxHex();
        if (this$signedPayoutTxHex == null ? other$signedPayoutTxHex != null : !this$signedPayoutTxHex.equals(other$signedPayoutTxHex)) {
            return false;
        }
        String this$updatedMultisigHex = this.getUpdatedMultisigHex();
        String other$updatedMultisigHex = other.getUpdatedMultisigHex();
        if (this$updatedMultisigHex == null ? other$updatedMultisigHex != null : !this$updatedMultisigHex.equals(other$updatedMultisigHex)) {
            return false;
        }
        haveno.core.account.witness.AccountAgeWitness this$buyerAccountAgeWitness = this.getBuyerAccountAgeWitness();
        haveno.core.account.witness.AccountAgeWitness other$buyerAccountAgeWitness = other.getBuyerAccountAgeWitness();
        if (this$buyerAccountAgeWitness == null ? other$buyerAccountAgeWitness != null : !((Object)this$buyerAccountAgeWitness).equals(other$buyerAccountAgeWitness)) {
            return false;
        }
        haveno.core.account.sign.SignedWitness this$buyerSignedWitness = this.getBuyerSignedWitness();
        haveno.core.account.sign.SignedWitness other$buyerSignedWitness = other.getBuyerSignedWitness();
        if (this$buyerSignedWitness == null ? other$buyerSignedWitness != null : !((Object)this$buyerSignedWitness).equals(other$buyerSignedWitness)) {
            return false;
        }
        PaymentSentMessage this$paymentSentMessage = this.getPaymentSentMessage();
        PaymentSentMessage other$paymentSentMessage = other.getPaymentSentMessage();
        if (this$paymentSentMessage == null ? other$paymentSentMessage != null : !((Object)this$paymentSentMessage).equals(other$paymentSentMessage)) {
            return false;
        }
        return Arrays.equals(this.getSellerSignature(), other.getSellerSignature());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PaymentReceivedMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDeferPublishPayout() ? 79 : 97);
        NodeAddress $senderNodeAddress = this.getSenderNodeAddress();
        result = result * 59 + ($senderNodeAddress == null ? 43 : ((Object)$senderNodeAddress).hashCode());
        String $unsignedPayoutTxHex = this.getUnsignedPayoutTxHex();
        result = result * 59 + ($unsignedPayoutTxHex == null ? 43 : $unsignedPayoutTxHex.hashCode());
        String $signedPayoutTxHex = this.getSignedPayoutTxHex();
        result = result * 59 + ($signedPayoutTxHex == null ? 43 : $signedPayoutTxHex.hashCode());
        String $updatedMultisigHex = this.getUpdatedMultisigHex();
        result = result * 59 + ($updatedMultisigHex == null ? 43 : $updatedMultisigHex.hashCode());
        haveno.core.account.witness.AccountAgeWitness $buyerAccountAgeWitness = this.getBuyerAccountAgeWitness();
        result = result * 59 + ($buyerAccountAgeWitness == null ? 43 : ((Object)$buyerAccountAgeWitness).hashCode());
        haveno.core.account.sign.SignedWitness $buyerSignedWitness = this.getBuyerSignedWitness();
        result = result * 59 + ($buyerSignedWitness == null ? 43 : ((Object)$buyerSignedWitness).hashCode());
        PaymentSentMessage $paymentSentMessage = this.getPaymentSentMessage();
        result = result * 59 + ($paymentSentMessage == null ? 43 : ((Object)$paymentSentMessage).hashCode());
        result = result * 59 + Arrays.hashCode(this.getSellerSignature());
        return result;
    }

    @Override
    public NodeAddress getSenderNodeAddress() {
        return this.senderNodeAddress;
    }

    @Nullable
    public String getUnsignedPayoutTxHex() {
        return this.unsignedPayoutTxHex;
    }

    @Nullable
    public String getSignedPayoutTxHex() {
        return this.signedPayoutTxHex;
    }

    public String getUpdatedMultisigHex() {
        return this.updatedMultisigHex;
    }

    public boolean isDeferPublishPayout() {
        return this.deferPublishPayout;
    }

    @Nullable
    public haveno.core.account.witness.AccountAgeWitness getBuyerAccountAgeWitness() {
        return this.buyerAccountAgeWitness;
    }

    @Nullable
    public haveno.core.account.sign.SignedWitness getBuyerSignedWitness() {
        return this.buyerSignedWitness;
    }

    @Nullable
    public PaymentSentMessage getPaymentSentMessage() {
        return this.paymentSentMessage;
    }

    @Nullable
    public byte[] getSellerSignature() {
        return this.sellerSignature;
    }

    public void setSellerSignature(@Nullable byte[] sellerSignature) {
        this.sellerSignature = sellerSignature;
    }
}

