/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.messages;

import com.google.protobuf.ByteString;
import haveno.common.proto.ProtoUtil;
import haveno.common.util.Utilities;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.trade.messages.TradeMessage;
import haveno.network.p2p.DirectMessage;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import protobuf.NetworkEnvelope;
import protobuf.SignContractResponse;

public final class SignContractResponse
extends TradeMessage
implements DirectMessage {
    private final long currentDate;
    private final String contractAsJson;
    private final byte[] contractSignature;
    private final byte[] encryptedPaymentAccountPayload;

    public SignContractResponse(String tradeId, String uid, String messageVersion, long currentDate, String contractAsJson, byte[] contractSignature, @Nullable byte[] encryptedPaymentAccountPayload) {
        super(messageVersion, tradeId, uid);
        this.currentDate = currentDate;
        this.contractAsJson = contractAsJson;
        this.contractSignature = contractSignature;
        this.encryptedPaymentAccountPayload = encryptedPaymentAccountPayload;
    }

    @Override
    public NetworkEnvelope toProtoNetworkEnvelope() {
        SignContractResponse.Builder builder = protobuf.SignContractResponse.newBuilder().setTradeId(this.offerId).setUid(this.uid);
        Optional.ofNullable(this.contractAsJson).ifPresent(e -> builder.setContractAsJson(this.contractAsJson));
        Optional.ofNullable(this.contractSignature).ifPresent(e -> builder.setContractSignature(ByteString.copyFrom(e)));
        Optional.ofNullable(this.encryptedPaymentAccountPayload).ifPresent(e -> builder.setEncryptedPaymentAccountPayload(ByteString.copyFrom(e)));
        builder.setCurrentDate(this.currentDate);
        return this.getNetworkEnvelopeBuilder().setSignContractResponse(builder).build();
    }

    public static SignContractResponse fromProto(protobuf.SignContractResponse proto, CoreProtoResolver coreProtoResolver, String messageVersion) {
        return new SignContractResponse(proto.getTradeId(), proto.getUid(), messageVersion, proto.getCurrentDate(), ProtoUtil.stringOrNullFromProto(proto.getContractAsJson()), ProtoUtil.byteArrayOrNullFromProto(proto.getContractSignature()), proto.getEncryptedPaymentAccountPayload().toByteArray());
    }

    @Override
    public String toString() {
        return "SignContractResponse {,\n     currentDate=" + this.currentDate + ",\n     contractAsJson='" + this.contractAsJson + ",\n     contractSignature='" + Utilities.bytesAsHexString(this.contractSignature) + "\n} " + super.toString();
    }

    public long getCurrentDate() {
        return this.currentDate;
    }

    public String getContractAsJson() {
        return this.contractAsJson;
    }

    public byte[] getContractSignature() {
        return this.contractSignature;
    }

    public byte[] getEncryptedPaymentAccountPayload() {
        return this.encryptedPaymentAccountPayload;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignContractResponse)) {
            return false;
        }
        SignContractResponse other = (SignContractResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCurrentDate() != other.getCurrentDate()) {
            return false;
        }
        String this$contractAsJson = this.getContractAsJson();
        String other$contractAsJson = other.getContractAsJson();
        if (this$contractAsJson == null ? other$contractAsJson != null : !this$contractAsJson.equals(other$contractAsJson)) {
            return false;
        }
        if (!Arrays.equals(this.getContractSignature(), other.getContractSignature())) {
            return false;
        }
        return Arrays.equals(this.getEncryptedPaymentAccountPayload(), other.getEncryptedPaymentAccountPayload());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SignContractResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $currentDate = this.getCurrentDate();
        result = result * 59 + (int)($currentDate >>> 32 ^ $currentDate);
        String $contractAsJson = this.getContractAsJson();
        result = result * 59 + ($contractAsJson == null ? 43 : $contractAsJson.hashCode());
        result = result * 59 + Arrays.hashCode(this.getContractSignature());
        result = result * 59 + Arrays.hashCode(this.getEncryptedPaymentAccountPayload());
        return result;
    }
}

