/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol;

import haveno.common.ThreadUtils;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.core.trade.BuyerAsTakerTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.handlers.TradeResultHandler;
import haveno.core.trade.messages.InitTradeRequest;
import haveno.core.trade.protocol.BuyerProtocol;
import haveno.core.trade.protocol.TakerProtocol;
import haveno.core.trade.protocol.TradeTaskRunner;
import haveno.core.trade.protocol.tasks.ApplyFilter;
import haveno.core.trade.protocol.tasks.ProcessInitTradeRequest;
import haveno.core.trade.protocol.tasks.TakerReserveTradeFunds;
import haveno.core.trade.protocol.tasks.TakerSendInitTradeRequestToArbitrator;
import haveno.core.trade.protocol.tasks.TakerSendInitTradeRequestToMaker;
import haveno.network.p2p.NodeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuyerAsTakerProtocol
extends BuyerProtocol
implements TakerProtocol {
    private static final Logger log = LoggerFactory.getLogger(BuyerAsTakerProtocol.class);

    public BuyerAsTakerProtocol(BuyerAsTakerTrade trade) {
        super(trade);
    }

    @Override
    public void onTakeOffer(TradeResultHandler tradeResultHandler, ErrorMessageHandler errorMessageHandler) {
        log.info("onTakerOffer for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.trade.getShortId());
        ThreadUtils.execute(() -> {
            Object object = this.trade.getLock();
            synchronized (object) {
                this.latchTrade();
                this.tradeResultHandler = tradeResultHandler;
                this.errorMessageHandler = errorMessageHandler;
                this.expect(this.phase(Trade.Phase.INIT).with(TakerProtocol.TakerEvent.TAKE_OFFER).from(this.trade.getTradePeer().getNodeAddress())).setup(this.tasks(ApplyFilter.class, TakerReserveTradeFunds.class, TakerSendInitTradeRequestToMaker.class).using(new TradeTaskRunner(this.trade, () -> {
                    this.startTimeout();
                    this.unlatchTrade();
                }, errorMessage -> this.handleError(errorMessage))).withTimeout(TRADE_STEP_TIMEOUT_SECONDS)).executeTasks(true);
                this.awaitTradeLatch();
            }
        }, this.trade.getId());
    }

    @Override
    public void handleInitTradeRequest(InitTradeRequest message, NodeAddress peer) {
        log.info("handleInitTradeRequest() for {} {} from {}", this.trade.getClass().getSimpleName(), this.trade.getShortId(), peer);
        ThreadUtils.execute(() -> {
            Object object = this.trade.getLock();
            synchronized (object) {
                this.latchTrade();
                this.expect(this.phase(Trade.Phase.INIT).with(message).from(peer)).setup(this.tasks(ApplyFilter.class, ProcessInitTradeRequest.class, TakerSendInitTradeRequestToArbitrator.class).using(new TradeTaskRunner(this.trade, () -> {
                    this.startTimeout();
                    this.handleTaskRunnerSuccess(peer, message);
                }, errorMessage -> this.handleTaskRunnerFault(peer, message, errorMessage))).withTimeout(TRADE_STEP_TIMEOUT_SECONDS)).executeTasks(true);
                this.awaitTradeLatch();
            }
        }, this.trade.getId());
    }
}

