/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol;

import haveno.common.ThreadUtils;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.trade.BuyerTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.SignContractResponse;
import haveno.core.trade.messages.TradeMessage;
import haveno.core.trade.protocol.DisputeProtocol;
import haveno.core.trade.protocol.FluentProtocol;
import haveno.core.trade.protocol.TradeTaskRunner;
import haveno.core.trade.protocol.tasks.ApplyFilter;
import haveno.core.trade.protocol.tasks.BuyerPreparePaymentSentMessage;
import haveno.core.trade.protocol.tasks.BuyerSendPaymentSentMessageToArbitrator;
import haveno.core.trade.protocol.tasks.BuyerSendPaymentSentMessageToSeller;
import haveno.core.trade.protocol.tasks.SendDepositsConfirmedMessageToArbitrator;
import haveno.core.trade.protocol.tasks.SendDepositsConfirmedMessageToSeller;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.network.p2p.NodeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuyerProtocol
extends DisputeProtocol {
    private static final Logger log = LoggerFactory.getLogger(BuyerProtocol.class);

    public BuyerProtocol(BuyerTrade trade) {
        super(trade);
    }

    @Override
    protected void onInitialized() {
        super.onInitialized();
        ThreadUtils.execute(() -> {
            if (this.trade.isShutDownStarted() || this.trade.isPayoutPublished()) {
                return;
            }
            Object object = this.trade.getLock();
            synchronized (object) {
                if (this.trade.isShutDownStarted() || this.trade.isPayoutPublished()) {
                    return;
                }
                if (this.trade.getState().ordinal() >= Trade.State.BUYER_SENT_PAYMENT_SENT_MSG.ordinal() && this.trade.getState().ordinal() < Trade.State.SELLER_RECEIVED_PAYMENT_SENT_MSG.ordinal()) {
                    this.latchTrade();
                    this.given(this.anyPhase(Trade.Phase.PAYMENT_SENT).with(BuyerEvent.STARTUP)).setup(this.tasks(BuyerSendPaymentSentMessageToSeller.class, BuyerSendPaymentSentMessageToArbitrator.class).using(new TradeTaskRunner(this.trade, () -> this.unlatchTrade(), errorMessage -> {
                        log.warn("Error sending PaymentSentMessage on startup: " + errorMessage);
                        this.unlatchTrade();
                    }))).executeTasks();
                    this.awaitTradeLatch();
                }
            }
        }, this.trade.getId());
    }

    @Override
    protected void onTradeMessage(TradeMessage message, NodeAddress peer) {
        super.onTradeMessage(message, peer);
    }

    @Override
    public void onMailboxMessage(TradeMessage message, NodeAddress peer) {
        super.onMailboxMessage(message, peer);
    }

    @Override
    public void handleSignContractResponse(SignContractResponse response, NodeAddress sender) {
        super.handleSignContractResponse(response, sender);
    }

    public void onPaymentSent(ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        log.info("BuyerProtocol.onPaymentSent() for {} {}", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getShortId());
        ThreadUtils.execute(() -> {
            Object object = this.trade.getLock();
            synchronized (object) {
                this.latchTrade();
                this.errorMessageHandler = errorMessageHandler;
                BuyerEvent event = BuyerEvent.PAYMENT_SENT;
                try {
                    this.expect(this.anyPhase(Trade.Phase.DEPOSITS_UNLOCKED, Trade.Phase.PAYMENT_SENT).with(event).preCondition(this.trade.confirmPermitted())).setup(this.tasks(ApplyFilter.class, BuyerPreparePaymentSentMessage.class, BuyerSendPaymentSentMessageToSeller.class, BuyerSendPaymentSentMessageToArbitrator.class).using(new TradeTaskRunner(this.trade, () -> {
                        this.stopTimeout();
                        this.errorMessageHandler = null;
                        resultHandler.handleResult();
                        this.handleTaskRunnerSuccess(event);
                    }, errorMessage -> {
                        log.warn("Error confirming payment sent, reverting state to {}, error={}", (Object)Trade.State.DEPOSIT_TXS_UNLOCKED_IN_BLOCKCHAIN, (Object)errorMessage);
                        this.trade.setState(Trade.State.DEPOSIT_TXS_UNLOCKED_IN_BLOCKCHAIN);
                        this.handleTaskRunnerFault(event, errorMessage);
                    }))).run(() -> this.trade.advanceState(Trade.State.BUYER_CONFIRMED_PAYMENT_SENT)).executeTasks(true);
                }
                catch (Exception e) {
                    errorMessageHandler.handleErrorMessage("Error confirming payment sent: " + e.getMessage());
                    this.unlatchTrade();
                }
                this.awaitTradeLatch();
            }
        }, this.trade.getId());
    }

    @Override
    public Class<? extends TradeTask>[] getDepositsConfirmedTasks() {
        return new Class[]{SendDepositsConfirmedMessageToSeller.class, SendDepositsConfirmedMessageToArbitrator.class};
    }

    static enum BuyerEvent implements FluentProtocol.Event
    {
        STARTUP,
        DEPOSIT_TXS_CONFIRMED,
        PAYMENT_SENT;

    }
}

