/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol;

import com.google.protobuf.ByteString;
import haveno.common.crypto.KeyRing;
import haveno.common.crypto.PubKeyRing;
import haveno.common.proto.ProtoUtil;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.common.taskrunner.Model;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.filter.FilterManager;
import haveno.core.network.MessageState;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OpenOfferManager;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.core.support.dispute.mediation.mediator.MediatorManager;
import haveno.core.support.dispute.refund.refundagent.RefundAgentManager;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.trade.messages.TradeMessage;
import haveno.core.trade.protocol.ProcessModelServiceProvider;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.statistics.ReferralIdService;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.core.user.User;
import haveno.core.xmr.wallet.BtcWalletService;
import haveno.core.xmr.wallet.TradeWalletService;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.AckMessage;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.annotation.Nullable;
import monero.wallet.model.MoneroTxWallet;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.ProcessModel;

public class ProcessModel
implements Model,
PersistablePayload {
    private static final Logger log = LoggerFactory.getLogger(ProcessModel.class);
    private transient ProcessModelServiceProvider provider;
    private transient TradeManager tradeManager;
    private transient Offer offer;
    public transient Throwable error;
    private transient ObjectProperty<MessageState> depositTxMessageStateProperty = new SimpleObjectProperty<MessageState>(MessageState.UNDEFINED);
    private transient Transaction depositTx;
    private TradePeer maker = new TradePeer();
    private TradePeer taker = new TradePeer();
    private TradePeer arbitrator = new TradePeer();
    private String offerId;
    private String accountId;
    private PubKeyRing pubKeyRing;
    @Nullable
    private byte[] payoutTxSignature;
    @Nullable
    private byte[] preparedDepositTx;
    private boolean useSavingsWallet;
    private long fundsNeededForTrade;
    @Nullable
    private NodeAddress tempTradePeerNodeAddress;
    @Nullable
    private byte[] mediatedPayoutTxSignature;
    private long buyerPayoutAmountFromMediation;
    private long sellerPayoutAmountFromMediation;
    private transient TradeMessage tradeMessage;
    private byte[] makerSignature;
    @Nullable
    private transient MoneroTxWallet reserveTx;
    private transient MoneroTxWallet unsignedPayoutTx;
    @Nullable
    private String tradeFeeAddress;
    private String multisigAddress;
    private long tradeProtocolErrorHeight;
    private boolean importMultisigHexScheduled;
    private ObjectProperty<Boolean> paymentAccountDecryptedProperty = new SimpleObjectProperty<Boolean>(false);
    @Deprecated
    private ObjectProperty<MessageState> paymentSentMessageStatePropertySeller = new SimpleObjectProperty<MessageState>(MessageState.UNDEFINED);
    @Deprecated
    private ObjectProperty<MessageState> paymentSentMessageStatePropertyArbitrator = new SimpleObjectProperty<MessageState>(MessageState.UNDEFINED);

    public ProcessModel(String offerId, String accountId, PubKeyRing pubKeyRing) {
        this(offerId, accountId, pubKeyRing, new TradePeer(), new TradePeer(), new TradePeer());
    }

    public ProcessModel(String offerId, String accountId, PubKeyRing pubKeyRing, TradePeer arbitrator, TradePeer maker, TradePeer taker) {
        this.offerId = offerId;
        this.accountId = accountId;
        this.pubKeyRing = pubKeyRing;
        this.arbitrator = arbitrator != null ? arbitrator : new TradePeer();
        this.maker = maker != null ? maker : new TradePeer();
        this.taker = taker != null ? taker : new TradePeer();
    }

    public void applyTransient(ProcessModelServiceProvider provider, TradeManager tradeManager, Offer offer) {
        this.offer = offer;
        this.provider = provider;
        this.tradeManager = tradeManager;
        for (TradePeer peer : this.getTradePeers()) {
            peer.applyTransient(tradeManager);
        }
        if (this.paymentSentMessageStatePropertySeller.get() != MessageState.UNDEFINED && this.getSeller().getPaymentSentMessageStateProperty().get() == MessageState.UNDEFINED) {
            this.getSeller().getPaymentSentMessageStateProperty().set((MessageState)((Object)this.paymentSentMessageStatePropertySeller.get()));
            tradeManager.requestPersistence();
        }
        if (this.paymentSentMessageStatePropertyArbitrator.get() != MessageState.UNDEFINED && this.getArbitrator().getPaymentSentMessageStateProperty().get() == MessageState.UNDEFINED) {
            this.getArbitrator().getPaymentSentMessageStateProperty().set((MessageState)((Object)this.paymentSentMessageStatePropertyArbitrator.get()));
            tradeManager.requestPersistence();
        }
    }

    private List<TradePeer> getTradePeers() {
        return Arrays.asList(this.maker, this.taker, this.arbitrator);
    }

    private TradePeer getBuyer() {
        return this.offer.getDirection() == OfferDirection.BUY ? this.maker : this.taker;
    }

    private TradePeer getSeller() {
        return this.offer.getDirection() == OfferDirection.BUY ? this.taker : this.maker;
    }

    @Override
    public protobuf.ProcessModel toProtoMessage() {
        ProcessModel.Builder builder = protobuf.ProcessModel.newBuilder().setOfferId(this.offerId).setAccountId(this.accountId).setPubKeyRing(this.pubKeyRing.toProtoMessage()).setUseSavingsWallet(this.useSavingsWallet).setFundsNeededForTrade(this.fundsNeededForTrade).setPaymentSentMessageStateSeller(((MessageState)((Object)this.paymentSentMessageStatePropertySeller.get())).name()).setPaymentSentMessageStateArbitrator(((MessageState)((Object)this.paymentSentMessageStatePropertyArbitrator.get())).name()).setBuyerPayoutAmountFromMediation(this.buyerPayoutAmountFromMediation).setSellerPayoutAmountFromMediation(this.sellerPayoutAmountFromMediation).setTradeProtocolErrorHeight(this.tradeProtocolErrorHeight).setImportMultisigHexScheduled(this.importMultisigHexScheduled);
        Optional.ofNullable(this.maker).ifPresent(e -> builder.setMaker((protobuf.TradePeer)this.maker.toProtoMessage()));
        Optional.ofNullable(this.taker).ifPresent(e -> builder.setTaker((protobuf.TradePeer)this.taker.toProtoMessage()));
        Optional.ofNullable(this.arbitrator).ifPresent(e -> builder.setArbitrator((protobuf.TradePeer)this.arbitrator.toProtoMessage()));
        Optional.ofNullable(this.payoutTxSignature).ifPresent(e -> builder.setPayoutTxSignature(ByteString.copyFrom(this.payoutTxSignature)));
        Optional.ofNullable(this.tempTradePeerNodeAddress).ifPresent(e -> builder.setTempTradePeerNodeAddress(this.tempTradePeerNodeAddress.toProtoMessage()));
        Optional.ofNullable(this.mediatedPayoutTxSignature).ifPresent(e -> builder.setMediatedPayoutTxSignature(ByteString.copyFrom(e)));
        Optional.ofNullable(this.makerSignature).ifPresent(e -> builder.setMakerSignature(ByteString.copyFrom(e)));
        Optional.ofNullable(this.tradeFeeAddress).ifPresent(e -> builder.setTradeFeeAddress(this.tradeFeeAddress));
        Optional.ofNullable(this.multisigAddress).ifPresent(e -> builder.setMultisigAddress(this.multisigAddress));
        return builder.build();
    }

    public static ProcessModel fromProto(protobuf.ProcessModel proto, CoreProtoResolver coreProtoResolver) {
        TradePeer arbitrator = TradePeer.fromProto(proto.getArbitrator(), coreProtoResolver);
        TradePeer maker = TradePeer.fromProto(proto.getMaker(), coreProtoResolver);
        TradePeer taker = TradePeer.fromProto(proto.getTaker(), coreProtoResolver);
        PubKeyRing pubKeyRing = PubKeyRing.fromProto(proto.getPubKeyRing());
        ProcessModel processModel = new ProcessModel(proto.getOfferId(), proto.getAccountId(), pubKeyRing, arbitrator, maker, taker);
        processModel.setUseSavingsWallet(proto.getUseSavingsWallet());
        processModel.setFundsNeededForTrade(proto.getFundsNeededForTrade());
        processModel.setBuyerPayoutAmountFromMediation(proto.getBuyerPayoutAmountFromMediation());
        processModel.setSellerPayoutAmountFromMediation(proto.getSellerPayoutAmountFromMediation());
        processModel.setTradeProtocolErrorHeight(proto.getTradeProtocolErrorHeight());
        processModel.setImportMultisigHexScheduled(proto.getImportMultisigHexScheduled());
        processModel.setPayoutTxSignature(ProtoUtil.byteArrayOrNullFromProto(proto.getPayoutTxSignature()));
        processModel.setTempTradePeerNodeAddress(proto.hasTempTradePeerNodeAddress() ? NodeAddress.fromProto(proto.getTempTradePeerNodeAddress()) : null);
        processModel.setMediatedPayoutTxSignature(ProtoUtil.byteArrayOrNullFromProto(proto.getMediatedPayoutTxSignature()));
        processModel.setMakerSignature(ProtoUtil.byteArrayOrNullFromProto(proto.getMakerSignature()));
        processModel.setTradeFeeAddress(ProtoUtil.stringOrNullFromProto(proto.getTradeFeeAddress()));
        processModel.setMultisigAddress(ProtoUtil.stringOrNullFromProto(proto.getMultisigAddress()));
        String paymentSentMessageStateSellerString = ProtoUtil.stringOrNullFromProto(proto.getPaymentSentMessageStateSeller());
        MessageState paymentSentMessageStateSeller = ProtoUtil.enumFromProto(MessageState.class, paymentSentMessageStateSellerString);
        processModel.paymentSentMessageStatePropertySeller.set(paymentSentMessageStateSeller);
        String paymentSentMessageStateArbitratorString = ProtoUtil.stringOrNullFromProto(proto.getPaymentSentMessageStateArbitrator());
        MessageState paymentSentMessageStateArbitrator = ProtoUtil.enumFromProto(MessageState.class, paymentSentMessageStateArbitratorString);
        processModel.paymentSentMessageStatePropertyArbitrator.set(paymentSentMessageStateArbitrator);
        return processModel;
    }

    @Override
    public void onComplete() {
    }

    @Nullable
    public PaymentAccountPayload getPaymentAccountPayload(String paymentAccountId) {
        PaymentAccount paymentAccount = this.getUser().getPaymentAccount(paymentAccountId);
        return paymentAccount != null ? paymentAccount.getPaymentAccountPayload() : null;
    }

    public Coin getFundsNeededForTrade() {
        return Coin.valueOf(this.fundsNeededForTrade);
    }

    public NodeAddress getMyNodeAddress() {
        return this.getP2PService().getAddress();
    }

    public boolean isPaymentReceivedMessagesReceived() {
        return this.getArbitrator().isPaymentReceivedMessageReceived() && this.getBuyer().isPaymentReceivedMessageReceived();
    }

    void setDepositTxSentAckMessage(AckMessage ackMessage) {
        MessageState messageState = ackMessage.isSuccess() ? MessageState.ACKNOWLEDGED : MessageState.NACKED;
        this.setDepositTxMessageState(messageState);
    }

    public void setDepositTxMessageState(MessageState messageState) {
        this.depositTxMessageStateProperty.set(messageState);
        if (this.tradeManager != null) {
            this.tradeManager.requestPersistence();
        }
    }

    void witnessDebugLog(Trade trade) {
        this.getAccountAgeWitnessService().getAccountAgeWitnessUtils().witnessDebugLog(trade, null);
    }

    public XmrWalletService getXmrWalletService() {
        return this.provider.getXmrWalletService();
    }

    public BtcWalletService getBtcWalletService() {
        return this.provider.getBtcWalletService();
    }

    public AccountAgeWitnessService getAccountAgeWitnessService() {
        return this.provider.getAccountAgeWitnessService();
    }

    public P2PService getP2PService() {
        return this.provider.getP2PService();
    }

    public TradeWalletService getTradeWalletService() {
        return this.provider.getTradeWalletService();
    }

    public User getUser() {
        return this.provider.getUser();
    }

    public OpenOfferManager getOpenOfferManager() {
        return this.provider.getOpenOfferManager();
    }

    public ReferralIdService getReferralIdService() {
        return this.provider.getReferralIdService();
    }

    public FilterManager getFilterManager() {
        return this.provider.getFilterManager();
    }

    public TradeStatisticsManager getTradeStatisticsManager() {
        return this.provider.getTradeStatisticsManager();
    }

    public ArbitratorManager getArbitratorManager() {
        return this.provider.getArbitratorManager();
    }

    public MediatorManager getMediatorManager() {
        return this.provider.getMediatorManager();
    }

    public RefundAgentManager getRefundAgentManager() {
        return this.provider.getRefundAgentManager();
    }

    public KeyRing getKeyRing() {
        return this.provider.getKeyRing();
    }

    public ProcessModelServiceProvider getProvider() {
        return this.provider;
    }

    public TradeManager getTradeManager() {
        return this.tradeManager;
    }

    public Offer getOffer() {
        return this.offer;
    }

    public Throwable getError() {
        return this.error;
    }

    public ObjectProperty<MessageState> getDepositTxMessageStateProperty() {
        return this.depositTxMessageStateProperty;
    }

    public TradePeer getMaker() {
        return this.maker;
    }

    public TradePeer getTaker() {
        return this.taker;
    }

    public TradePeer getArbitrator() {
        return this.arbitrator;
    }

    public String getOfferId() {
        return this.offerId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public PubKeyRing getPubKeyRing() {
        return this.pubKeyRing;
    }

    @Nullable
    public byte[] getPayoutTxSignature() {
        return this.payoutTxSignature;
    }

    @Nullable
    public byte[] getPreparedDepositTx() {
        return this.preparedDepositTx;
    }

    public boolean isUseSavingsWallet() {
        return this.useSavingsWallet;
    }

    @Nullable
    public NodeAddress getTempTradePeerNodeAddress() {
        return this.tempTradePeerNodeAddress;
    }

    @Nullable
    public byte[] getMediatedPayoutTxSignature() {
        return this.mediatedPayoutTxSignature;
    }

    public long getBuyerPayoutAmountFromMediation() {
        return this.buyerPayoutAmountFromMediation;
    }

    public long getSellerPayoutAmountFromMediation() {
        return this.sellerPayoutAmountFromMediation;
    }

    public TradeMessage getTradeMessage() {
        return this.tradeMessage;
    }

    public ObjectProperty<Boolean> getPaymentAccountDecryptedProperty() {
        return this.paymentAccountDecryptedProperty;
    }

    @Deprecated
    public ObjectProperty<MessageState> getPaymentSentMessageStatePropertySeller() {
        return this.paymentSentMessageStatePropertySeller;
    }

    @Deprecated
    public ObjectProperty<MessageState> getPaymentSentMessageStatePropertyArbitrator() {
        return this.paymentSentMessageStatePropertyArbitrator;
    }

    public void setDepositTxMessageStateProperty(ObjectProperty<MessageState> depositTxMessageStateProperty) {
        this.depositTxMessageStateProperty = depositTxMessageStateProperty;
    }

    public void setDepositTx(Transaction depositTx) {
        this.depositTx = depositTx;
    }

    public Transaction getDepositTx() {
        return this.depositTx;
    }

    public void setPayoutTxSignature(@Nullable byte[] payoutTxSignature) {
        this.payoutTxSignature = payoutTxSignature;
    }

    public void setPreparedDepositTx(@Nullable byte[] preparedDepositTx) {
        this.preparedDepositTx = preparedDepositTx;
    }

    public void setUseSavingsWallet(boolean useSavingsWallet) {
        this.useSavingsWallet = useSavingsWallet;
    }

    public void setFundsNeededForTrade(long fundsNeededForTrade) {
        this.fundsNeededForTrade = fundsNeededForTrade;
    }

    public void setTempTradePeerNodeAddress(@Nullable NodeAddress tempTradePeerNodeAddress) {
        this.tempTradePeerNodeAddress = tempTradePeerNodeAddress;
    }

    public void setMediatedPayoutTxSignature(@Nullable byte[] mediatedPayoutTxSignature) {
        this.mediatedPayoutTxSignature = mediatedPayoutTxSignature;
    }

    public void setBuyerPayoutAmountFromMediation(long buyerPayoutAmountFromMediation) {
        this.buyerPayoutAmountFromMediation = buyerPayoutAmountFromMediation;
    }

    public void setSellerPayoutAmountFromMediation(long sellerPayoutAmountFromMediation) {
        this.sellerPayoutAmountFromMediation = sellerPayoutAmountFromMediation;
    }

    public void setTradeMessage(TradeMessage tradeMessage) {
        this.tradeMessage = tradeMessage;
    }

    public byte[] getMakerSignature() {
        return this.makerSignature;
    }

    public void setMakerSignature(byte[] makerSignature) {
        this.makerSignature = makerSignature;
    }

    @Nullable
    public MoneroTxWallet getReserveTx() {
        return this.reserveTx;
    }

    public void setReserveTx(@Nullable MoneroTxWallet reserveTx) {
        this.reserveTx = reserveTx;
    }

    public MoneroTxWallet getUnsignedPayoutTx() {
        return this.unsignedPayoutTx;
    }

    public void setUnsignedPayoutTx(MoneroTxWallet unsignedPayoutTx) {
        this.unsignedPayoutTx = unsignedPayoutTx;
    }

    @Nullable
    public String getTradeFeeAddress() {
        return this.tradeFeeAddress;
    }

    public void setTradeFeeAddress(@Nullable String tradeFeeAddress) {
        this.tradeFeeAddress = tradeFeeAddress;
    }

    public String getMultisigAddress() {
        return this.multisigAddress;
    }

    public void setMultisigAddress(String multisigAddress) {
        this.multisigAddress = multisigAddress;
    }

    public long getTradeProtocolErrorHeight() {
        return this.tradeProtocolErrorHeight;
    }

    public void setTradeProtocolErrorHeight(long tradeProtocolErrorHeight) {
        this.tradeProtocolErrorHeight = tradeProtocolErrorHeight;
    }

    public boolean isImportMultisigHexScheduled() {
        return this.importMultisigHexScheduled;
    }

    public void setImportMultisigHexScheduled(boolean importMultisigHexScheduled) {
        this.importMultisigHexScheduled = importMultisigHexScheduled;
    }
}

