/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol;

import haveno.common.ThreadUtils;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.core.trade.SellerAsMakerTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.InitTradeRequest;
import haveno.core.trade.protocol.MakerProtocol;
import haveno.core.trade.protocol.SellerProtocol;
import haveno.core.trade.protocol.TradeTaskRunner;
import haveno.core.trade.protocol.tasks.ApplyFilter;
import haveno.core.trade.protocol.tasks.MakerSendInitTradeRequestToArbitrator;
import haveno.core.trade.protocol.tasks.ProcessInitTradeRequest;
import haveno.network.p2p.NodeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SellerAsMakerProtocol
extends SellerProtocol
implements MakerProtocol {
    private static final Logger log = LoggerFactory.getLogger(SellerAsMakerProtocol.class);

    public SellerAsMakerProtocol(SellerAsMakerTrade trade) {
        super(trade);
    }

    @Override
    public void handleInitTradeRequest(InitTradeRequest message, NodeAddress peer, ErrorMessageHandler errorMessageHandler) {
        log.info("handleInitTradeRequest() for {} {} from {}", this.trade.getClass().getSimpleName(), this.trade.getShortId(), peer);
        ThreadUtils.execute(() -> {
            Object object = this.trade.getLock();
            synchronized (object) {
                this.latchTrade();
                this.errorMessageHandler = errorMessageHandler;
                this.expect(this.phase(Trade.Phase.INIT).with(message).from(peer)).setup(this.tasks(ApplyFilter.class, ProcessInitTradeRequest.class, MakerSendInitTradeRequestToArbitrator.class).using(new TradeTaskRunner(this.trade, () -> {
                    this.startTimeout();
                    this.handleTaskRunnerSuccess(peer, message);
                }, errorMessage -> this.handleTaskRunnerFault(peer, message, errorMessage))).withTimeout(TRADE_STEP_TIMEOUT_SECONDS)).executeTasks(true);
                this.awaitTradeLatch();
            }
        }, this.trade.getId());
    }
}

