/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol;

import haveno.common.ThreadUtils;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.trade.SellerTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.SignContractResponse;
import haveno.core.trade.messages.TradeMessage;
import haveno.core.trade.protocol.DisputeProtocol;
import haveno.core.trade.protocol.FluentProtocol;
import haveno.core.trade.protocol.TradeTaskRunner;
import haveno.core.trade.protocol.tasks.ApplyFilter;
import haveno.core.trade.protocol.tasks.SellerPreparePaymentReceivedMessage;
import haveno.core.trade.protocol.tasks.SellerSendPaymentReceivedMessageToArbitrator;
import haveno.core.trade.protocol.tasks.SellerSendPaymentReceivedMessageToBuyer;
import haveno.core.trade.protocol.tasks.SendDepositsConfirmedMessageToArbitrator;
import haveno.core.trade.protocol.tasks.SendDepositsConfirmedMessageToBuyer;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.network.p2p.NodeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SellerProtocol
extends DisputeProtocol {
    private static final Logger log = LoggerFactory.getLogger(SellerProtocol.class);

    public SellerProtocol(SellerTrade trade) {
        super(trade);
    }

    @Override
    protected void onInitialized() {
        super.onInitialized();
        ThreadUtils.execute(() -> {
            if (!this.needsToResendPaymentReceivedMessages()) {
                return;
            }
            Object object = this.trade.getLock();
            synchronized (object) {
                if (!this.needsToResendPaymentReceivedMessages()) {
                    return;
                }
                this.latchTrade();
                this.given(this.anyPhase(Trade.Phase.PAYMENT_RECEIVED).with(SellerEvent.STARTUP)).setup(this.tasks(SellerSendPaymentReceivedMessageToBuyer.class, SellerSendPaymentReceivedMessageToArbitrator.class).using(new TradeTaskRunner(this.trade, () -> this.unlatchTrade(), errorMessage -> {
                    log.warn("Error sending PaymentReceivedMessage on startup: " + errorMessage);
                    this.unlatchTrade();
                }))).executeTasks();
                this.awaitTradeLatch();
            }
        }, this.trade.getId());
    }

    public boolean needsToResendPaymentReceivedMessages() {
        return !this.trade.isShutDownStarted() && this.trade.getState().ordinal() >= Trade.State.SELLER_SENT_PAYMENT_RECEIVED_MSG.ordinal() && !this.trade.getProcessModel().isPaymentReceivedMessagesReceived() && this.resendPaymentReceivedMessagesEnabled();
    }

    private boolean resendPaymentReceivedMessagesEnabled() {
        return this.trade.getOffer().getOfferPayload().getProtocolVersion() >= 2;
    }

    @Override
    protected void onTradeMessage(TradeMessage message, NodeAddress peer) {
        super.onTradeMessage(message, peer);
    }

    @Override
    public void onMailboxMessage(TradeMessage message, NodeAddress peerNodeAddress) {
        super.onMailboxMessage(message, peerNodeAddress);
    }

    @Override
    public void handleSignContractResponse(SignContractResponse response, NodeAddress sender) {
        super.handleSignContractResponse(response, sender);
    }

    public void onPaymentReceived(ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        log.info("SellerProtocol.onPaymentReceived() for {} {}", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getShortId());
        ThreadUtils.execute(() -> {
            Object object = this.trade.getLock();
            synchronized (object) {
                this.latchTrade();
                this.errorMessageHandler = errorMessageHandler;
                SellerEvent event = SellerEvent.PAYMENT_RECEIVED;
                try {
                    this.expect(this.anyPhase(Trade.Phase.PAYMENT_SENT, Trade.Phase.PAYMENT_RECEIVED).with(event).preCondition(this.trade.confirmPermitted())).setup(this.tasks(ApplyFilter.class, SellerPreparePaymentReceivedMessage.class, SellerSendPaymentReceivedMessageToBuyer.class, SellerSendPaymentReceivedMessageToArbitrator.class).using(new TradeTaskRunner(this.trade, () -> {
                        this.stopTimeout();
                        this.errorMessageHandler = null;
                        this.handleTaskRunnerSuccess(event);
                        resultHandler.handleResult();
                    }, errorMessage -> {
                        log.warn("Error confirming payment received, reverting state to {}, error={}", (Object)Trade.State.BUYER_SENT_PAYMENT_SENT_MSG, (Object)errorMessage);
                        this.trade.resetToPaymentSentState();
                        this.handleTaskRunnerFault(event, errorMessage);
                    }))).run(() -> this.trade.advanceState(Trade.State.SELLER_CONFIRMED_PAYMENT_RECEIPT)).executeTasks(true);
                }
                catch (Exception e) {
                    errorMessageHandler.handleErrorMessage("Error confirming payment received: " + e.getMessage());
                    this.unlatchTrade();
                }
                this.awaitTradeLatch();
            }
        }, this.trade.getId());
    }

    @Override
    public Class<? extends TradeTask>[] getDepositsConfirmedTasks() {
        return new Class[]{SendDepositsConfirmedMessageToArbitrator.class, SendDepositsConfirmedMessageToBuyer.class};
    }

    static enum SellerEvent implements FluentProtocol.Event
    {
        STARTUP,
        DEPOSIT_TXS_CONFIRMED,
        PAYMENT_RECEIVED;

    }
}

