/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol;

import haveno.common.ThreadUtils;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.config.Config;
import haveno.common.crypto.PubKeyRing;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.taskrunner.Task;
import haveno.core.network.MessageState;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.BuyerTrade;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.SellerTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.trade.handlers.TradeResultHandler;
import haveno.core.trade.messages.DepositRequest;
import haveno.core.trade.messages.DepositResponse;
import haveno.core.trade.messages.DepositsConfirmedMessage;
import haveno.core.trade.messages.InitMultisigRequest;
import haveno.core.trade.messages.PaymentReceivedMessage;
import haveno.core.trade.messages.PaymentSentMessage;
import haveno.core.trade.messages.SignContractRequest;
import haveno.core.trade.messages.SignContractResponse;
import haveno.core.trade.messages.TradeMessage;
import haveno.core.trade.protocol.ArbitratorProtocol;
import haveno.core.trade.protocol.FluentProtocol;
import haveno.core.trade.protocol.ProcessModel;
import haveno.core.trade.protocol.ProcessModelServiceProvider;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.TradeTaskRunner;
import haveno.core.trade.protocol.tasks.ApplyFilter;
import haveno.core.trade.protocol.tasks.MaybeResendDisputeClosedMessageWithPayout;
import haveno.core.trade.protocol.tasks.MaybeSendSignContractRequest;
import haveno.core.trade.protocol.tasks.ProcessDepositResponse;
import haveno.core.trade.protocol.tasks.ProcessDepositsConfirmedMessage;
import haveno.core.trade.protocol.tasks.ProcessInitMultisigRequest;
import haveno.core.trade.protocol.tasks.ProcessPaymentReceivedMessage;
import haveno.core.trade.protocol.tasks.ProcessPaymentSentMessage;
import haveno.core.trade.protocol.tasks.ProcessSignContractRequest;
import haveno.core.trade.protocol.tasks.SendDepositRequest;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.core.trade.protocol.tasks.VerifyPeersAccountAgeWitness;
import haveno.core.util.Validator;
import haveno.network.p2p.AckMessage;
import haveno.network.p2p.AckMessageSourceType;
import haveno.network.p2p.DecryptedDirectMessageListener;
import haveno.network.p2p.DecryptedMessageWithPubKey;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.mailbox.MailboxMessage;
import haveno.network.p2p.mailbox.MailboxMessageService;
import haveno.network.p2p.messaging.DecryptedMailboxListener;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nullable;
import org.fxmisc.easybind.EasyBind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TradeProtocol
implements DecryptedDirectMessageListener,
DecryptedMailboxListener {
    private static final Logger log = LoggerFactory.getLogger(TradeProtocol.class);
    public static final int TRADE_STEP_TIMEOUT_SECONDS = Config.baseCurrencyNetwork().isTestnet() ? 60 : 180;
    private static final String TIMEOUT_REACHED = "Timeout reached.";
    public static final int MAX_ATTEMPTS = 5;
    public static final long REPROCESS_DELAY_MS = 5000L;
    public static final String LOG_HIGHLIGHT = "";
    protected final ProcessModel processModel;
    protected final Trade trade;
    protected CountDownLatch tradeLatch;
    private Timer timeoutTimer;
    private Object timeoutTimerLock = new Object();
    protected TradeResultHandler tradeResultHandler;
    protected ErrorMessageHandler errorMessageHandler;
    private boolean depositsConfirmedTasksCalled;
    private int reprocessPaymentSentMessageCount;
    private int reprocessPaymentReceivedMessageCount;

    public TradeProtocol(Trade trade) {
        this.trade = trade;
        this.processModel = trade.getProcessModel();
    }

    protected void onTradeMessage(TradeMessage message, NodeAddress peerNodeAddress) {
        log.info("Received {} as TradeMessage from {} with tradeId {} and uid {}", message.getClass().getSimpleName(), peerNodeAddress, message.getOfferId(), message.getUid());
        this.handle(message, peerNodeAddress);
    }

    protected void onMailboxMessage(TradeMessage message, NodeAddress peerNodeAddress) {
        log.info("Received {} as MailboxMessage from {} with tradeId {} and uid {}", message.getClass().getSimpleName(), peerNodeAddress, message.getOfferId(), message.getUid());
        this.handle(message, peerNodeAddress);
    }

    private void handle(TradeMessage message, NodeAddress peerNodeAddress) {
        if (message instanceof DepositsConfirmedMessage) {
            this.handle((DepositsConfirmedMessage)message, peerNodeAddress);
        } else if (message instanceof PaymentSentMessage) {
            this.handle((PaymentSentMessage)message, peerNodeAddress);
        } else if (message instanceof PaymentReceivedMessage) {
            this.handle((PaymentReceivedMessage)message, peerNodeAddress);
        }
    }

    @Override
    public void onDirectMessage(DecryptedMessageWithPubKey decryptedMessageWithPubKey, NodeAddress peer) {
        NetworkEnvelope networkEnvelope = decryptedMessageWithPubKey.getNetworkEnvelope();
        if (!this.isMyMessage(networkEnvelope)) {
            return;
        }
        if (!this.isPubKeyValid(decryptedMessageWithPubKey)) {
            return;
        }
        if (networkEnvelope instanceof TradeMessage) {
            this.onTradeMessage((TradeMessage)networkEnvelope, peer);
            if (((TradeMessage)networkEnvelope).getOfferId().equals(this.processModel.getOfferId())) {
                this.trade.onVerifiedTradeMessage((TradeMessage)networkEnvelope, peer);
            }
        } else if (networkEnvelope instanceof AckMessage) {
            this.onAckMessage((AckMessage)networkEnvelope, peer);
        }
    }

    @Override
    public void onMailboxMessageAdded(DecryptedMessageWithPubKey decryptedMessageWithPubKey, NodeAddress peer) {
        if (!this.isPubKeyValid(decryptedMessageWithPubKey)) {
            return;
        }
        this.handleMailboxCollectionSkipValidation(Collections.singletonList(decryptedMessageWithPubKey));
    }

    private void handleMailboxCollectionSkipValidation(Collection<DecryptedMessageWithPubKey> collection) {
        collection.stream().map(DecryptedMessageWithPubKey::getNetworkEnvelope).filter(this::isMyMessage).filter(e -> e instanceof MailboxMessage).map(e -> (MailboxMessage)((Object)e)).forEach(this::handleMailboxMessage);
    }

    private void handleMailboxCollection(Collection<DecryptedMessageWithPubKey> collection) {
        collection.stream().filter(this::isPubKeyValid).map(DecryptedMessageWithPubKey::getNetworkEnvelope).filter(this::isMyMessage).filter(e -> e instanceof MailboxMessage).map(e -> (MailboxMessage)((Object)e)).sorted(new TradeManager.MailboxMessageComparator()).forEach(this::handleMailboxMessage);
    }

    private void handleMailboxMessage(MailboxMessage mailboxMessage) {
        if (mailboxMessage instanceof TradeMessage) {
            TradeMessage tradeMessage = (TradeMessage)((Object)mailboxMessage);
            if (this.trade.isCompleted()) {
                this.processModel.getP2PService().getMailboxMessageService().removeMailboxMsg(mailboxMessage);
                log.info("Remove {} from the P2P network as trade is already completed.", (Object)tradeMessage.getClass().getSimpleName());
                return;
            }
            this.onMailboxMessage(tradeMessage, mailboxMessage.getSenderNodeAddress());
        } else if (mailboxMessage instanceof AckMessage) {
            AckMessage ackMessage = (AckMessage)mailboxMessage;
            this.onAckMessage(ackMessage, mailboxMessage.getSenderNodeAddress());
            this.processModel.getP2PService().getMailboxMessageService().removeMailboxMsg(ackMessage);
            log.info("Remove {} from the P2P network.", (Object)ackMessage.getClass().getSimpleName());
        }
    }

    public void removeMailboxMessageAfterProcessing(TradeMessage tradeMessage) {
        if (tradeMessage instanceof MailboxMessage) {
            this.processModel.getP2PService().getMailboxMessageService().removeMailboxMsg((MailboxMessage)((Object)tradeMessage));
            log.info("Remove {} from the P2P network.", (Object)tradeMessage.getClass().getSimpleName());
        }
    }

    public abstract Class<? extends TradeTask>[] getDepositsConfirmedTasks();

    public void initialize(ProcessModelServiceProvider serviceProvider, TradeManager tradeManager) {
        this.processModel.applyTransient(serviceProvider, tradeManager, this.trade.getOffer());
        this.onInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onInitialized() {
        if (!this.trade.isFinished()) {
            this.processModel.getP2PService().addDecryptedDirectMessageListener(this);
        }
        Object object = this.trade.getLock();
        synchronized (object) {
            this.trade.initialize(this.processModel.getProvider());
            MailboxMessageService mailboxMessageService = this.processModel.getP2PService().getMailboxMessageService();
            if (!this.trade.isCompleted()) {
                mailboxMessageService.addDecryptedMailboxListener(this);
            }
            this.handleMailboxCollection(mailboxMessageService.getMyDecryptedMailboxMessages());
            this.trade.reprocessApplicableMessages();
        }
        EasyBind.subscribe(this.trade.stateProperty(), state -> this.maybeSendDepositsConfirmedMessages());
    }

    public void maybeSendDepositsConfirmedMessages() {
        if (!this.trade.isInitialized() || this.trade.isShutDownStarted()) {
            return;
        }
        ThreadUtils.execute(() -> {
            if (!this.trade.isInitialized() || this.trade.isShutDownStarted()) {
                return;
            }
            if (!this.trade.isDepositsConfirmed() || this.trade.isDepositsConfirmedAcked() || this.trade.isPayoutPublished() || this.depositsConfirmedTasksCalled) {
                return;
            }
            this.depositsConfirmedTasksCalled = true;
            Object object = this.trade.getLock();
            synchronized (object) {
                if (!this.trade.isInitialized() || this.trade.isShutDownStarted()) {
                    return;
                }
                this.latchTrade();
                this.expect(new FluentProtocol.Condition(this.trade)).setup(this.tasks(this.getDepositsConfirmedTasks()).using(new TradeTaskRunner(this.trade, () -> this.handleTaskRunnerSuccess(null, null, "maybeSendDepositsConfirmedMessages"), errorMessage -> this.handleTaskRunnerFault(null, null, "maybeSendDepositsConfirmedMessages", errorMessage, null)))).executeTasks(true);
                this.awaitTradeLatch();
            }
        }, this.trade.getId());
    }

    public void maybeReprocessPaymentSentMessage(boolean reprocessOnError) {
        if (this.trade.isShutDownStarted()) {
            return;
        }
        ThreadUtils.execute(() -> {
            if (this.trade.isShutDownStarted()) {
                return;
            }
            Object object = this.trade.getLock();
            synchronized (object) {
                if (this.trade.isShutDownStarted() || this.trade.isBuyer() || this.trade.getBuyer().getPaymentSentMessage() == null || this.trade.getState().ordinal() >= Trade.State.BUYER_SENT_PAYMENT_SENT_MSG.ordinal()) {
                    return;
                }
                log.warn("Reprocessing PaymentSentMessage for {} {}", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                this.handle(this.trade.getBuyer().getPaymentSentMessage(), this.trade.getBuyer().getPaymentSentMessage().getSenderNodeAddress(), reprocessOnError);
            }
        }, this.trade.getId());
    }

    public void maybeReprocessPaymentReceivedMessage(boolean reprocessOnError) {
        if (this.trade.isShutDownStarted()) {
            return;
        }
        ThreadUtils.execute(() -> {
            if (this.trade.isShutDownStarted()) {
                return;
            }
            Object object = this.trade.getLock();
            synchronized (object) {
                if (this.trade.isShutDownStarted() || this.trade.isSeller() || this.trade.getSeller().getPaymentReceivedMessage() == null || this.trade.getState().ordinal() >= Trade.State.SELLER_SENT_PAYMENT_RECEIVED_MSG.ordinal() && this.trade.isPayoutPublished()) {
                    return;
                }
                log.warn("Reprocessing PaymentReceivedMessage for {} {}", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                this.handle(this.trade.getSeller().getPaymentReceivedMessage(), this.trade.getSeller().getPaymentReceivedMessage().getSenderNodeAddress(), reprocessOnError);
            }
        }, this.trade.getId());
    }

    public void handleInitMultisigRequest(InitMultisigRequest request, NodeAddress sender) {
        log.info("handleInitMultisigRequest() for " + this.trade.getClass().getSimpleName() + " " + this.trade.getShortId() + " from " + String.valueOf(sender));
        this.trade.addInitProgressStep();
        ThreadUtils.execute(() -> {
            Object object = this.trade.getLock();
            synchronized (object) {
                if (this.trade.hasFailed()) {
                    log.warn("{} {} ignoring {} from {} because trade failed with previous error: {}", this.trade.getClass().getSimpleName(), this.trade.getId(), request.getClass().getSimpleName(), sender, this.trade.getErrorMessage());
                    return;
                }
                Validator.checkTradeId(this.processModel.getOfferId(), request);
                this.latchTrade();
                this.processModel.setTradeMessage(request);
                this.expect(this.anyPhase(Trade.Phase.INIT).with(request).from(sender)).setup(this.tasks(ProcessInitMultisigRequest.class, MaybeSendSignContractRequest.class).using(new TradeTaskRunner(this.trade, () -> {
                    this.startTimeout();
                    this.handleTaskRunnerSuccess(sender, request);
                }, errorMessage -> this.handleTaskRunnerFault(sender, request, errorMessage))).withTimeout(TRADE_STEP_TIMEOUT_SECONDS)).executeTasks(true);
                this.awaitTradeLatch();
            }
        }, this.trade.getId());
    }

    public void handleSignContractRequest(SignContractRequest message, NodeAddress sender) {
        log.info("handleSignContractRequest() for " + this.trade.getClass().getSimpleName() + " " + this.trade.getShortId() + " from " + String.valueOf(sender));
        ThreadUtils.execute(() -> {
            Object object = this.trade.getLock();
            synchronized (object) {
                if (this.trade.hasFailed()) {
                    log.warn("{} {} ignoring {} from {} because trade failed with previous error: {}", this.trade.getClass().getSimpleName(), this.trade.getId(), message.getClass().getSimpleName(), sender, this.trade.getErrorMessage());
                    return;
                }
                Validator.checkTradeId(this.processModel.getOfferId(), message);
                if (this.trade.getState() == Trade.State.MULTISIG_COMPLETED || this.trade.getState() == Trade.State.CONTRACT_SIGNATURE_REQUESTED) {
                    this.latchTrade();
                    Validator.checkTradeId(this.processModel.getOfferId(), message);
                    this.processModel.setTradeMessage(message);
                    this.expect(this.anyState(Trade.State.MULTISIG_COMPLETED, Trade.State.CONTRACT_SIGNATURE_REQUESTED).with(message).from(sender)).setup(this.tasks(ProcessSignContractRequest.class).using(new TradeTaskRunner(this.trade, () -> this.handleTaskRunnerSuccess(sender, message), errorMessage -> this.handleTaskRunnerFault(sender, message, errorMessage)))).executeTasks(true);
                    this.awaitTradeLatch();
                } else {
                    EasyBind.subscribe(this.trade.stateProperty(), state -> {
                        if (state == Trade.State.MULTISIG_COMPLETED) {
                            ThreadUtils.execute(() -> this.handleSignContractRequest(message, sender), this.trade.getId());
                        }
                    });
                }
            }
        }, this.trade.getId());
    }

    public void handleSignContractResponse(SignContractResponse message, NodeAddress sender) {
        log.info("handleSignContractResponse() for " + this.trade.getClass().getSimpleName() + " " + this.trade.getShortId() + " from " + String.valueOf(sender));
        this.trade.addInitProgressStep();
        ThreadUtils.execute(() -> {
            Object object = this.trade.getLock();
            synchronized (object) {
                if (this.trade.hasFailed()) {
                    log.warn("{} {} ignoring {} from {} because trade failed with previous error: {}", this.trade.getClass().getSimpleName(), this.trade.getId(), message.getClass().getSimpleName(), sender, this.trade.getErrorMessage());
                    return;
                }
                Validator.checkTradeId(this.processModel.getOfferId(), message);
                if (this.trade.getState() == Trade.State.CONTRACT_SIGNED) {
                    this.latchTrade();
                    Validator.checkTradeId(this.processModel.getOfferId(), message);
                    this.processModel.setTradeMessage(message);
                    this.expect(this.state(Trade.State.CONTRACT_SIGNED).with(message).from(sender)).setup(this.tasks(SendDepositRequest.class).using(new TradeTaskRunner(this.trade, () -> {
                        this.startTimeout();
                        this.handleTaskRunnerSuccess(sender, message);
                    }, errorMessage -> this.handleTaskRunnerFault(sender, message, errorMessage))).withTimeout(TRADE_STEP_TIMEOUT_SECONDS)).executeTasks(true);
                    this.awaitTradeLatch();
                } else {
                    EasyBind.subscribe(this.trade.stateProperty(), state -> {
                        if (state == Trade.State.CONTRACT_SIGNED) {
                            ThreadUtils.execute(() -> this.handleSignContractResponse(message, sender), this.trade.getId());
                        }
                    });
                }
            }
        }, this.trade.getId());
    }

    public void handleDepositResponse(DepositResponse response, NodeAddress sender) {
        log.info("handleDepositResponse() for " + this.trade.getClass().getSimpleName() + " " + this.trade.getShortId() + " from " + String.valueOf(sender));
        this.trade.addInitProgressStep();
        ThreadUtils.execute(() -> {
            Object object = this.trade.getLock();
            synchronized (object) {
                Validator.checkTradeId(this.processModel.getOfferId(), response);
                this.latchTrade();
                this.processModel.setTradeMessage(response);
                this.expect(this.anyPhase(Trade.Phase.INIT, Trade.Phase.DEPOSIT_REQUESTED, Trade.Phase.DEPOSITS_PUBLISHED).with(response).from(sender)).setup(this.tasks(ProcessDepositResponse.class).using(new TradeTaskRunner(this.trade, () -> {
                    this.stopTimeout();
                    if (this.trade.getInitError() == null) {
                        this.errorMessageHandler = null;
                        this.handleTaskRunnerSuccess(sender, response);
                        if (this.tradeResultHandler != null) {
                            this.tradeResultHandler.handleResult(this.trade);
                        }
                    } else {
                        this.handleTaskRunnerSuccess(sender, response);
                        if (this.errorMessageHandler != null) {
                            this.errorMessageHandler.handleErrorMessage(this.trade.getInitError().getMessage());
                        }
                    }
                    this.tradeResultHandler = null;
                    this.errorMessageHandler = null;
                }, errorMessage -> this.handleTaskRunnerFault(sender, response, errorMessage))).withTimeout(TRADE_STEP_TIMEOUT_SECONDS)).executeTasks(true);
                this.awaitTradeLatch();
            }
        }, this.trade.getId());
    }

    public void handle(DepositsConfirmedMessage message, NodeAddress sender) {
        log.info("handle(DepositsConfirmedMessage) for " + this.trade.getClass().getSimpleName() + " " + this.trade.getShortId() + " from " + String.valueOf(sender));
        if (!this.trade.isInitialized() || this.trade.isShutDown()) {
            return;
        }
        ThreadUtils.execute(() -> {
            Object object = this.trade.getLock();
            synchronized (object) {
                if (!this.trade.isInitialized() || this.trade.isShutDown()) {
                    return;
                }
                this.latchTrade();
                this.errorMessageHandler = null;
                this.expect(new FluentProtocol.Condition(this.trade).with(message).from(sender)).setup(this.tasks(ProcessDepositsConfirmedMessage.class, VerifyPeersAccountAgeWitness.class, MaybeResendDisputeClosedMessageWithPayout.class).using(new TradeTaskRunner(this.trade, () -> this.handleTaskRunnerSuccess(sender, message), errorMessage -> this.handleTaskRunnerFault(sender, message, errorMessage)))).executeTasks();
                this.awaitTradeLatch();
            }
        }, this.trade.getId());
    }

    protected void handle(PaymentSentMessage message, NodeAddress peer) {
        this.handle(message, peer, true);
    }

    protected void handle(PaymentSentMessage message, NodeAddress peer, boolean reprocessOnError) {
        log.info("handle(PaymentSentMessage) for " + this.trade.getClass().getSimpleName() + " " + this.trade.getShortId() + " from " + String.valueOf(peer));
        if (!(this.trade instanceof SellerTrade) && !(this.trade instanceof ArbitratorTrade)) {
            log.warn("Ignoring PaymentSentMessage since not seller or arbitrator");
            return;
        }
        try {
            HavenoUtils.verifyPaymentSentMessage(this.trade, message);
        }
        catch (Throwable t2) {
            log.warn("Ignoring PaymentSentMessage with invalid signature for {} {}, error={}", this.trade.getClass().getSimpleName(), this.trade.getId(), t2.getMessage());
            return;
        }
        this.trade.getBuyer().setPaymentSentMessage(message);
        this.trade.persistNow(() -> {
            if (!this.trade.isInitialized() || this.trade.isShutDownStarted()) {
                return;
            }
            ThreadUtils.execute(() -> {
                Object object = this.trade.getLock();
                synchronized (object) {
                    if (!this.trade.isInitialized() || this.trade.isShutDownStarted()) {
                        return;
                    }
                    if (this.trade.getPhase().ordinal() >= Trade.Phase.PAYMENT_SENT.ordinal()) {
                        log.warn("Received another PaymentSentMessage which was already processed for {} {}, ACKing", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                        this.handleTaskRunnerSuccess(peer, message);
                        return;
                    }
                    if (this.trade.getPayoutTx() != null) {
                        log.warn("We received a PaymentSentMessage but we have already created the payout tx so we ignore the message. This can happen if the ACK message to the peer did not arrive and the peer repeats sending us the message. We send another ACK msg.");
                        this.sendAckMessage(peer, message, true, null);
                        this.removeMailboxMessageAfterProcessing(message);
                        return;
                    }
                    this.latchTrade();
                    this.expect(this.anyPhase(new Trade.Phase[0]).with(message).from(peer)).setup(this.tasks(ApplyFilter.class, ProcessPaymentSentMessage.class, VerifyPeersAccountAgeWitness.class).using(new TradeTaskRunner(this.trade, () -> this.handleTaskRunnerSuccess(peer, message), errorMessage -> {
                        log.warn("Error processing payment sent message: " + errorMessage);
                        this.processModel.getTradeManager().requestPersistence();
                        if (this.trade.getBuyer().getPaymentSentMessage() != null) {
                            UserThread.runAfter(() -> {
                                ++this.reprocessPaymentSentMessageCount;
                                this.maybeReprocessPaymentSentMessage(reprocessOnError);
                            }, this.trade.getReprocessDelayInSeconds(this.reprocessPaymentSentMessageCount));
                        } else {
                            this.handleTaskRunnerFault(peer, message, errorMessage);
                        }
                        this.unlatchTrade();
                    }))).executeTasks(true);
                    this.awaitTradeLatch();
                }
            }, this.trade.getId());
        });
    }

    protected void handle(PaymentReceivedMessage message, NodeAddress peer) {
        this.handle(message, peer, true);
    }

    private void handle(PaymentReceivedMessage message, NodeAddress peer, boolean reprocessOnError) {
        log.info("handle(PaymentReceivedMessage) for " + this.trade.getClass().getSimpleName() + " " + this.trade.getShortId() + " from " + String.valueOf(peer));
        if (!(this.trade instanceof BuyerTrade) && !(this.trade instanceof ArbitratorTrade)) {
            log.warn("Ignoring PaymentReceivedMessage since not buyer or arbitrator");
            return;
        }
        try {
            HavenoUtils.verifyPaymentReceivedMessage(this.trade, message);
        }
        catch (Throwable t2) {
            log.warn("Ignoring PaymentReceivedMessage with invalid signature for {} {}, error={}", this.trade.getClass().getSimpleName(), this.trade.getId(), t2.getMessage());
            return;
        }
        this.trade.getSeller().setPaymentReceivedMessage(message);
        this.trade.persistNow(() -> {
            if (!this.trade.isInitialized() || this.trade.isShutDownStarted()) {
                return;
            }
            ThreadUtils.execute(() -> {
                Object object = this.trade.getLock();
                synchronized (object) {
                    if (!this.trade.isInitialized() || this.trade.isShutDownStarted()) {
                        return;
                    }
                    if (this.trade.getPhase().ordinal() >= Trade.Phase.PAYMENT_RECEIVED.ordinal()) {
                        log.warn("Received another PaymentReceivedMessage which was already processed for {} {}, ACKing", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                        this.handleTaskRunnerSuccess(peer, message);
                        return;
                    }
                    this.latchTrade();
                    Validator.checkTradeId(this.processModel.getOfferId(), message);
                    this.processModel.setTradeMessage(message);
                    if (this.trade.isBuyer() && this.trade.getPhase().ordinal() < Trade.Phase.PAYMENT_SENT.ordinal()) {
                        log.warn("Received PaymentReceivedMessage before payment sent for {} {}, ignoring", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                        return;
                    }
                    if (this.trade.isArbitrator() && this.trade.getPhase().ordinal() < Trade.Phase.DEPOSITS_CONFIRMED.ordinal()) {
                        log.warn("Received PaymentReceivedMessage before deposits confirmed for {} {}, ignoring", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                        return;
                    }
                    if (this.trade.isSeller() && this.trade.getPhase().ordinal() < Trade.Phase.DEPOSITS_UNLOCKED.ordinal()) {
                        log.warn("Received PaymentReceivedMessage before deposits unlocked for {} {}, ignoring", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                        return;
                    }
                    this.expect(this.anyPhase(new Trade.Phase[0]).with(message).from(peer)).setup(this.tasks(ProcessPaymentReceivedMessage.class).using(new TradeTaskRunner(this.trade, () -> this.handleTaskRunnerSuccess(peer, message), errorMessage -> {
                        log.warn("Error processing payment received message: " + errorMessage);
                        this.processModel.getTradeManager().requestPersistence();
                        if (this.trade.getSeller().getPaymentReceivedMessage() != null) {
                            UserThread.runAfter(() -> {
                                ++this.reprocessPaymentReceivedMessageCount;
                                this.maybeReprocessPaymentReceivedMessage(reprocessOnError);
                            }, this.trade.getReprocessDelayInSeconds(this.reprocessPaymentReceivedMessageCount));
                        } else {
                            this.handleTaskRunnerFault(peer, message, null, errorMessage, this.trade.getSelf().getUpdatedMultisigHex());
                        }
                        this.unlatchTrade();
                    }))).executeTasks(true);
                    this.awaitTradeLatch();
                }
            }, this.trade.getId());
        });
    }

    public void onWithdrawCompleted() {
        log.info("Withdraw completed");
    }

    protected FluentProtocol expect(FluentProtocol.Condition condition) {
        return new FluentProtocol(this).condition(condition).resultHandler(result -> {
            if (!result.isValid()) {
                log.warn(result.getInfo());
                this.handleTaskRunnerFault(null, null, result.name(), result.getInfo(), null);
            }
        });
    }

    protected FluentProtocol given(FluentProtocol.Condition condition) {
        return new FluentProtocol(this).condition(condition);
    }

    protected FluentProtocol.Condition phase(Trade.Phase expectedPhase) {
        return new FluentProtocol.Condition(this.trade).phase(expectedPhase);
    }

    protected FluentProtocol.Condition anyPhase(Trade.Phase ... expectedPhases) {
        return new FluentProtocol.Condition(this.trade).anyPhase(expectedPhases);
    }

    protected FluentProtocol.Condition state(Trade.State expectedState) {
        return new FluentProtocol.Condition(this.trade).state(expectedState);
    }

    protected FluentProtocol.Condition anyState(Trade.State ... expectedStates) {
        return new FluentProtocol.Condition(this.trade).anyState(expectedStates);
    }

    @SafeVarargs
    public final FluentProtocol.Setup tasks(Class<? extends Task<Trade>> ... tasks) {
        return new FluentProtocol.Setup(this, this.trade).tasks(tasks);
    }

    private void onAckMessage(AckMessage ackMessage, NodeAddress sender) {
        if (this.trade.isFinished()) {
            return;
        }
        TradePeer peer = this.trade.getTradePeer(sender);
        if (peer == null) {
            if (ackMessage.getSourceUid().equals(HavenoUtils.getDeterministicId(this.trade, DepositsConfirmedMessage.class, this.trade.getArbitrator().getNodeAddress()))) {
                peer = this.trade.getArbitrator();
            } else if (ackMessage.getSourceUid().equals(HavenoUtils.getDeterministicId(this.trade, DepositsConfirmedMessage.class, this.trade.getMaker().getNodeAddress()))) {
                peer = this.trade.getMaker();
            } else if (ackMessage.getSourceUid().equals(HavenoUtils.getDeterministicId(this.trade, DepositsConfirmedMessage.class, this.trade.getTaker().getNodeAddress()))) {
                peer = this.trade.getTaker();
            }
        }
        if (peer == null) {
            if (ackMessage.isSuccess()) {
                log.warn("Received AckMessage from unknown peer for {}, sender={}, trade={} {}, messageUid={}", ackMessage.getSourceMsgClassName(), sender, this.trade.getClass().getSimpleName(), this.trade.getId(), ackMessage.getSourceUid());
            } else {
                log.warn("Received AckMessage with error state from unknown peer for {}, sender={}, trade={} {}, messageUid={}, errorMessage={}", ackMessage.getSourceMsgClassName(), sender, this.trade.getClass().getSimpleName(), this.trade.getId(), ackMessage.getSourceUid(), ackMessage.getErrorMessage());
            }
            return;
        }
        if (!peer.getNodeAddress().equals(sender)) {
            log.info("Updating peer's node address from {} to {} using ACK message to {}", peer.getNodeAddress(), sender, ackMessage.getSourceMsgClassName());
            peer.setNodeAddress(sender);
        }
        if (ackMessage.getSourceMsgClassName().equals(DepositRequest.class.getSimpleName()) && !ackMessage.isSuccess()) {
            this.trade.setStateIfValidTransitionTo(Trade.State.PUBLISH_DEPOSIT_TX_REQUEST_FAILED);
            this.processModel.getTradeManager().requestPersistence();
        }
        if (ackMessage.getSourceMsgClassName().equals(DepositsConfirmedMessage.class.getSimpleName())) {
            peer.setDepositsConfirmedAckMessage(ackMessage);
            this.processModel.getTradeManager().requestPersistence();
        }
        if (ackMessage.getSourceMsgClassName().equals(PaymentSentMessage.class.getSimpleName())) {
            if (this.trade.getTradePeer(sender) == this.trade.getSeller()) {
                this.trade.getSeller().setPaymentSentAckMessage(ackMessage);
                if (ackMessage.isSuccess()) {
                    this.trade.setStateIfValidTransitionTo(Trade.State.SELLER_RECEIVED_PAYMENT_SENT_MSG);
                } else {
                    this.trade.setState(Trade.State.BUYER_SEND_FAILED_PAYMENT_SENT_MSG);
                }
                this.processModel.getTradeManager().requestPersistence();
            } else if (this.trade.getTradePeer(sender) == this.trade.getArbitrator()) {
                this.trade.getArbitrator().setPaymentSentAckMessage(ackMessage);
                this.processModel.getTradeManager().requestPersistence();
            } else {
                log.warn("Received AckMessage from unexpected peer for {}, sender={}, trade={} {}, messageUid={}, success={}, errorMsg={}", ackMessage.getSourceMsgClassName(), sender, this.trade.getClass().getSimpleName(), this.trade.getId(), ackMessage.getSourceUid(), ackMessage.isSuccess(), ackMessage.getErrorMessage());
                return;
            }
        }
        if (ackMessage.getSourceMsgClassName().equals(PaymentReceivedMessage.class.getSimpleName())) {
            if (this.trade.getTradePeer(sender) == this.trade.getBuyer()) {
                this.trade.getBuyer().setPaymentReceivedAckMessage(ackMessage);
                if (ackMessage.isSuccess()) {
                    this.trade.setStateIfValidTransitionTo(Trade.State.BUYER_RECEIVED_PAYMENT_RECEIVED_MSG);
                } else {
                    log.warn("We received a NACK for our PaymentReceivedMessage to the buyer for {} {}", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                    if (ackMessage.getUpdatedMultisigHex() != null) {
                        this.trade.getBuyer().setUpdatedMultisigHex(ackMessage.getUpdatedMultisigHex());
                        if (this.trade.isPaymentReceived() && !this.trade.isPayoutPublished() && !this.isPaymentReceivedMessageAckedByEither()) {
                            log.warn("Resetting state to payment sent for {} {}", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                            this.trade.resetToPaymentSentState();
                        }
                    }
                }
                this.processModel.getTradeManager().requestPersistence();
            } else if (this.trade.getTradePeer(sender) == this.trade.getArbitrator()) {
                this.trade.getArbitrator().setPaymentReceivedAckMessage(ackMessage);
                if (!ackMessage.isSuccess()) {
                    log.warn("We received a NACK for our PaymentReceivedMessage to the arbitrator for {} {}", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                    if (ackMessage.getUpdatedMultisigHex() != null) {
                        this.trade.getArbitrator().setUpdatedMultisigHex(ackMessage.getUpdatedMultisigHex());
                        if (this.trade.isPaymentReceived() && !this.trade.isPayoutPublished() && !this.isPaymentReceivedMessageAckedByEither()) {
                            log.warn("Resetting state to payment sent for {} {}", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                            this.trade.resetToPaymentSentState();
                        }
                    }
                }
                this.processModel.getTradeManager().requestPersistence();
            } else {
                log.warn("Received AckMessage from unexpected peer for {}, sender={}, trade={} {}, messageUid={}, success={}, errorMsg={}", ackMessage.getSourceMsgClassName(), sender, this.trade.getClass().getSimpleName(), this.trade.getId(), ackMessage.getSourceUid(), ackMessage.isSuccess(), ackMessage.getErrorMessage());
                return;
            }
        }
        if (ackMessage.isSuccess()) {
            log.info("Received AckMessage for {}, sender={}, trade={} {}, messageUid={}", ackMessage.getSourceMsgClassName(), sender, this.trade.getClass().getSimpleName(), this.trade.getId(), ackMessage.getSourceUid());
        } else {
            log.warn("Received AckMessage with error state for {}, sender={}, trade={} {}, messageUid={}, errorMessage={}", ackMessage.getSourceMsgClassName(), sender, this.trade.getClass().getSimpleName(), this.trade.getId(), ackMessage.getSourceUid(), ackMessage.getErrorMessage());
            this.handleError("Your peer had a problem processing your message. Please ensure you and your peer are running the latest version and try again.\n\nError details:\n" + ackMessage.getErrorMessage());
        }
        this.trade.onAckMessage(ackMessage, sender);
    }

    private boolean isPaymentReceivedMessageAckedByEither() {
        if (this.trade.getBuyer().getPaymentReceivedMessageStateProperty().get() == MessageState.ACKNOWLEDGED) {
            return true;
        }
        return this.trade.getArbitrator().getPaymentReceivedMessageStateProperty().get() == MessageState.ACKNOWLEDGED;
    }

    protected void sendAckMessage(NodeAddress peer, TradeMessage message, boolean result, @Nullable String errorMessage) {
        this.sendAckMessage(peer, message, result, errorMessage, null);
    }

    protected void sendAckMessage(NodeAddress peer, TradeMessage message, boolean result, @Nullable String errorMessage, String updatedMultisigHex) {
        PubKeyRing peersPubKeyRing = this.getPeersPubKeyRing(peer);
        if (peersPubKeyRing == null) {
            log.error("We cannot send the ACK message as peersPubKeyRing is null");
            return;
        }
        this.processModel.getTradeManager().sendAckMessage(peer, peersPubKeyRing, message, result, errorMessage, updatedMultisigHex);
    }

    public synchronized void startTimeout() {
        this.startTimeout(TRADE_STEP_TIMEOUT_SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startTimeout(long timeoutSec) {
        Object object = this.timeoutTimerLock;
        synchronized (object) {
            this.stopTimeout();
            this.timeoutTimer = UserThread.runAfter(() -> this.handleError("Timeout reached. Protocol did not complete in " + timeoutSec + " sec. TradeID=" + this.trade.getId() + ", state=" + String.valueOf(this.trade.stateProperty().get())), timeoutSec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopTimeout() {
        Object object = this.timeoutTimerLock;
        synchronized (object) {
            if (this.timeoutTimer != null) {
                this.timeoutTimer.stop();
                this.timeoutTimer = null;
            }
        }
    }

    public static boolean isTimeoutError(String errorMessage) {
        return errorMessage != null && errorMessage.contains(TIMEOUT_REACHED);
    }

    protected void handleTaskRunnerSuccess(NodeAddress sender, TradeMessage message) {
        this.handleTaskRunnerSuccess(sender, message, message.getClass().getSimpleName());
    }

    protected void handleTaskRunnerSuccess(FluentProtocol.Event event) {
        this.handleTaskRunnerSuccess(null, null, event.name());
    }

    protected void handleTaskRunnerFault(NodeAddress sender, TradeMessage message, String errorMessage) {
        this.handleTaskRunnerFault(sender, message, message.getClass().getSimpleName(), errorMessage, null);
    }

    protected void handleTaskRunnerFault(FluentProtocol.Event event, String errorMessage) {
        this.handleTaskRunnerFault(null, null, event.name(), errorMessage, null);
    }

    private PubKeyRing getPeersPubKeyRing(NodeAddress address) {
        this.trade.setMyNodeAddress();
        TradePeer peer = this.trade.getTradePeer(address);
        if (peer == null) {
            log.warn("Cannot get peer's pub key ring because peer is not maker, taker, or arbitrator. Their address might have changed: " + String.valueOf(address));
            return null;
        }
        return peer.getPubKeyRing();
    }

    public boolean isPubKeyValid(DecryptedMessageWithPubKey message) {
        if (this instanceof ArbitratorProtocol) {
            if (this.trade.getMaker().getPubKeyRing() == null || this.trade.getTaker().getPubKeyRing() == null) {
                return true;
            }
            if (message.getSignaturePubKey().equals(this.trade.getMaker().getPubKeyRing().getSignaturePubKey())) {
                return true;
            }
            if (message.getSignaturePubKey().equals(this.trade.getTaker().getPubKeyRing().getSignaturePubKey())) {
                return true;
            }
        } else {
            if (this.trade.getArbitrator().getPubKeyRing() == null || this.trade.getTradePeer() == null || this.trade.getTradePeer().getPubKeyRing() == null) {
                return true;
            }
            if (message.getSignaturePubKey().equals(this.trade.getArbitrator().getPubKeyRing().getSignaturePubKey())) {
                return true;
            }
            if (message.getSignaturePubKey().equals(this.trade.getTradePeer().getPubKeyRing().getSignaturePubKey())) {
                return true;
            }
        }
        return false;
    }

    protected void handleTaskRunnerSuccess(NodeAddress sender, @Nullable TradeMessage message, String source) {
        log.info("TaskRunner successfully completed. Triggered from {}, tradeId={}", (Object)source, (Object)this.trade.getId());
        if (message != null) {
            this.sendAckMessage(sender, message, true, null);
            this.removeMailboxMessageAfterProcessing(message);
        }
        this.unlatchTrade();
    }

    void handleTaskRunnerFault(NodeAddress ackReceiver, @Nullable TradeMessage message, String source, String errorMessage, String updatedMultisigHex) {
        log.error("Task runner failed with error {}. Triggered from {}. Monerod={}", errorMessage, source, this.trade.getXmrWalletService().getXmrConnectionService().getConnection());
        if (message != null) {
            this.sendAckMessage(ackReceiver, message, false, errorMessage, updatedMultisigHex);
        }
        this.handleError(errorMessage);
    }

    protected void handleError(String errorMessage) {
        this.stopTimeout();
        log.error(errorMessage);
        this.trade.setErrorMessage(errorMessage);
        this.processModel.getTradeManager().requestPersistence();
        if (this.errorMessageHandler != null) {
            this.errorMessageHandler.handleErrorMessage(errorMessage);
        }
        this.errorMessageHandler = null;
        this.unlatchTrade();
    }

    protected void latchTrade() {
        this.trade.awaitInitialized();
        if (this.tradeLatch != null) {
            throw new RuntimeException("Trade latch is not null. That should never happen.");
        }
        if (this.trade.isShutDown()) {
            throw new RuntimeException("Cannot latch trade " + this.trade.getId() + " for protocol because it's shut down");
        }
        this.tradeLatch = new CountDownLatch(1);
    }

    protected void unlatchTrade() {
        CountDownLatch lastLatch = this.tradeLatch;
        this.tradeLatch = null;
        if (lastLatch != null) {
            lastLatch.countDown();
        }
    }

    protected void awaitTradeLatch() {
        if (this.tradeLatch == null) {
            return;
        }
        HavenoUtils.awaitLatch(this.tradeLatch);
    }

    private boolean isMyMessage(NetworkEnvelope message) {
        if (message instanceof TradeMessage) {
            TradeMessage tradeMessage = (TradeMessage)message;
            return tradeMessage.getOfferId().equals(this.trade.getId());
        }
        if (message instanceof AckMessage) {
            AckMessage ackMessage = (AckMessage)message;
            return ackMessage.getSourceType() == AckMessageSourceType.TRADE_MESSAGE && ackMessage.getSourceId().equals(this.trade.getId());
        }
        return false;
    }
}

