/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import com.google.common.base.Preconditions;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.filter.FilterManager;
import haveno.core.trade.Trade;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.network.p2p.NodeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyFilter
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(ApplyFilter.class);

    public ApplyFilter(TaskRunner<Trade> taskHandler, Trade trade) {
        super(taskHandler, trade);
    }

    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            NodeAddress nodeAddress = Preconditions.checkNotNull(this.processModel.getTempTradePeerNodeAddress());
            FilterManager filterManager = this.processModel.getFilterManager();
            if (filterManager.isNodeAddressBanned(nodeAddress)) {
                this.failed("Other trader is banned by their node address.\ntradePeerNodeAddress=" + String.valueOf(nodeAddress));
            } else if (filterManager.isOfferIdBanned(this.trade.getId())) {
                this.failed("Offer ID is banned.\nOffer ID=" + this.trade.getId());
            } else if (this.trade.getOffer() != null && filterManager.isCurrencyBanned(this.trade.getOffer().getCurrencyCode())) {
                this.failed("Currency is banned.\nCurrency code=" + this.trade.getOffer().getCurrencyCode());
            } else if (filterManager.isPaymentMethodBanned(Preconditions.checkNotNull(this.trade.getOffer()).getPaymentMethod())) {
                this.failed("Payment method is banned.\nPayment method=" + this.trade.getOffer().getPaymentMethod().getId());
            } else if (filterManager.requireUpdateToNewVersionForTrading()) {
                this.failed("Your version of Haveno is not compatible for trading anymore. Please update to the latest Haveno version.");
            } else {
                this.complete();
            }
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }
}

