/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import common.utils.JsonUtils;
import haveno.common.app.Version;
import haveno.common.crypto.PubKeyRing;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.offer.Offer;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.DepositRequest;
import haveno.core.trade.messages.DepositResponse;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.SendDirectMessageListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import monero.daemon.MoneroDaemonRpc;
import monero.daemon.model.MoneroSubmitTxResult;
import monero.daemon.model.MoneroTx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArbitratorProcessDepositRequest
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(ArbitratorProcessDepositRequest.class);
    private boolean depositResponsesSent;

    public ArbitratorProcessDepositRequest(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            if (this.trade.getState() == Trade.State.PUBLISH_DEPOSIT_TX_REQUEST_FAILED) {
                throw new RuntimeException("Cannot process deposit request because trade is already failed, tradeId=" + this.trade.getId());
            }
            this.trade.setStateIfValidTransitionTo(Trade.State.SAW_ARRIVED_PUBLISH_DEPOSIT_TX_REQUEST);
            this.processModel.getTradeManager().requestPersistence();
            this.processDepositRequest();
            this.complete();
        }
        catch (Throwable t2) {
            this.trade.getProcessModel().error = t2;
            log.error("Error processing deposit request for trade {}: {}\n", this.trade.getId(), t2.getMessage(), t2);
            this.trade.setStateIfValidTransitionTo(Trade.State.PUBLISH_DEPOSIT_TX_REQUEST_FAILED);
            this.failed(t2);
        }
        this.processModel.getTradeManager().requestPersistence();
    }

    private void processDepositRequest() {
        boolean isFromBuyerAsTakerWithoutDeposit;
        String contractAsJson = this.trade.getContractAsJson();
        DepositRequest request = (DepositRequest)this.processModel.getTradeMessage();
        byte[] signature = request.getContractSignature();
        TradePeer sender = this.trade.getTradePeer(this.processModel.getTempTradePeerNodeAddress());
        if (sender == null) {
            throw new RuntimeException(request.getClass().getSimpleName() + " is not from maker, taker, or arbitrator");
        }
        PubKeyRing senderPubKeyRing = sender.getPubKeyRing();
        if (!HavenoUtils.isSignatureValid(senderPubKeyRing, contractAsJson, signature)) {
            throw new RuntimeException("Peer's contract signature is invalid");
        }
        sender.setContractSignature(signature);
        if (!this.hasBothContractSignatures()) {
            this.trade.stateProperty().addListener((obs, oldState, newState) -> {
                if (oldState == newState) {
                    return;
                }
                if (newState == Trade.State.PUBLISH_DEPOSIT_TX_REQUEST_FAILED) {
                    this.sendDepositResponsesOnce((String)(this.trade.getProcessModel().error == null ? "Arbitrator failed to publish deposit txs within timeout for trade " + this.trade.getId() : this.trade.getProcessModel().error.getMessage()));
                } else if (newState.ordinal() >= Trade.State.ARBITRATOR_PUBLISHED_DEPOSIT_TXS.ordinal()) {
                    this.sendDepositResponsesOnce(null);
                }
            });
        }
        Offer offer = this.trade.getOffer();
        boolean isFromTaker = sender == this.trade.getTaker();
        boolean isFromBuyer = sender == this.trade.getBuyer();
        BigInteger tradeFee = isFromTaker ? this.trade.getTakerFee() : this.trade.getMakerFee();
        BigInteger sendTradeAmount = isFromBuyer ? BigInteger.ZERO : this.trade.getAmount();
        BigInteger securityDeposit = isFromBuyer ? this.trade.getBuyerSecurityDepositBeforeMiningFee() : this.trade.getSellerSecurityDepositBeforeMiningFee();
        String depositAddress = this.processModel.getMultisigAddress();
        sender.setSecurityDeposit(securityDeposit);
        boolean bl = isFromBuyerAsTakerWithoutDeposit = isFromBuyer && isFromTaker && this.trade.hasBuyerAsTakerWithoutDeposit();
        if (!isFromBuyerAsTakerWithoutDeposit) {
            MoneroTx verifiedTx;
            try {
                verifiedTx = this.trade.getXmrWalletService().verifyDepositTx(offer.getId(), tradeFee, this.trade.getProcessModel().getTradeFeeAddress(), sendTradeAmount, securityDeposit, depositAddress, sender.getDepositTxHash(), request.getDepositTxHex(), request.getDepositTxKey(), null);
            }
            catch (Exception e) {
                throw new RuntimeException("Error processing deposit tx from " + (isFromTaker ? "taker " : "maker ") + String.valueOf(sender.getNodeAddress()) + ", offerId=" + offer.getId() + ": " + e.getMessage());
            }
            sender.setSecurityDeposit(sender.getSecurityDeposit().subtract(verifiedTx.getFee()));
            sender.setDepositTxFee(verifiedTx.getFee());
            sender.setDepositTxHex(request.getDepositTxHex());
            sender.setDepositTxKey(request.getDepositTxKey());
        }
        if (request.getPaymentAccountKey() != null) {
            sender.setPaymentAccountKey(request.getPaymentAccountKey());
        }
        this.processModel.getTradeManager().requestPersistence();
        MoneroDaemonRpc daemon = this.trade.getXmrWalletService().getDaemon();
        if (this.hasBothContractSignatures()) {
            if (this.isTimedOut()) {
                throw new RuntimeException("Trade protocol has timed out before relaying deposit txs for {} {}" + this.trade.getClass().getSimpleName() + " " + this.trade.getShortId());
            }
            this.trade.addInitProgressStep();
            boolean depositTxsRelayed = false;
            ArrayList<String> txHashes = new ArrayList<String>();
            try {
                MoneroSubmitTxResult makerResult = daemon.submitTxHex(this.processModel.getMaker().getDepositTxHex(), true);
                if (!makerResult.isGood().booleanValue()) {
                    throw new RuntimeException("Error submitting maker deposit tx: " + JsonUtils.serialize(makerResult));
                }
                txHashes.add(this.processModel.getMaker().getDepositTxHash());
                if (!this.trade.hasBuyerAsTakerWithoutDeposit()) {
                    MoneroSubmitTxResult takerResult = daemon.submitTxHex(this.processModel.getTaker().getDepositTxHex(), true);
                    if (!takerResult.isGood().booleanValue()) {
                        throw new RuntimeException("Error submitting taker deposit tx: " + JsonUtils.serialize(takerResult));
                    }
                    txHashes.add(this.processModel.getTaker().getDepositTxHash());
                }
                daemon.relayTxsByHash(txHashes);
                depositTxsRelayed = true;
                log.info("Arbitrator published deposit txs for trade " + this.trade.getId());
                this.trade.setStateIfValidTransitionTo(Trade.State.ARBITRATOR_PUBLISHED_DEPOSIT_TXS);
            }
            catch (Exception e) {
                log.warn("Arbitrator error publishing deposit txs for trade {} {}: {}\n", this.trade.getClass().getSimpleName(), this.trade.getShortId(), e.getMessage(), e);
                if (!depositTxsRelayed) {
                    try {
                        daemon.flushTxPool(txHashes);
                    }
                    catch (Exception e2) {
                        log.warn("Error flushing deposit txs from pool for trade {}: {}\n", this.trade.getId(), e2.getMessage(), e2);
                    }
                }
                throw e;
            }
        }
        if (this.processModel.getMaker().getDepositTxHex() == null) {
            log.info("Arbitrator waiting for deposit request from maker for trade " + this.trade.getId());
        }
        if (this.processModel.getTaker().getDepositTxHex() == null && !this.trade.hasBuyerAsTakerWithoutDeposit()) {
            log.info("Arbitrator waiting for deposit request from taker for trade " + this.trade.getId());
        }
    }

    private boolean hasBothContractSignatures() {
        return this.processModel.getMaker().getContractSignature() != null && this.processModel.getTaker().getContractSignature() != null;
    }

    private boolean isTimedOut() {
        return !this.processModel.getTradeManager().hasOpenTrade(this.trade);
    }

    private synchronized void sendDepositResponsesOnce(String errorMessage) {
        if (this.depositResponsesSent) {
            return;
        }
        this.depositResponsesSent = true;
        if (errorMessage != null) {
            log.warn("Sending deposit responses for tradeId={}, error={}", (Object)this.trade.getId(), (Object)errorMessage);
        }
        DepositResponse response = new DepositResponse(this.trade.getOffer().getId(), UUID.randomUUID().toString(), Version.getP2PMessageVersion(), new Date().getTime(), errorMessage, this.trade.getBuyer().getSecurityDeposit().longValue(), this.trade.getSeller().getSecurityDeposit().longValue());
        this.sendDepositResponse(this.trade.getMaker().getNodeAddress(), this.trade.getMaker().getPubKeyRing(), response);
        this.sendDepositResponse(this.trade.getTaker().getNodeAddress(), this.trade.getTaker().getPubKeyRing(), response);
    }

    private void sendDepositResponse(final NodeAddress nodeAddress, PubKeyRing pubKeyRing, final DepositResponse response) {
        log.info("Sending deposit response to trader={}; offerId={}, error={}", nodeAddress, this.trade.getId(), response.getErrorMessage());
        this.processModel.getP2PService().sendEncryptedDirectMessage(nodeAddress, pubKeyRing, response, new SendDirectMessageListener(){

            @Override
            public void onArrived() {
                log.info("{} arrived: trading peer={}; offerId={}; uid={}", response.getClass().getSimpleName(), nodeAddress, ArbitratorProcessDepositRequest.this.trade.getId(), ArbitratorProcessDepositRequest.this.trade.getUid());
            }

            @Override
            public void onFault(String errorMessage) {
                log.error("Sending {} failed: uid={}; peer={}; error={}", response.getClass().getSimpleName(), nodeAddress, ArbitratorProcessDepositRequest.this.trade.getId(), errorMessage);
                ArbitratorProcessDepositRequest.this.appendToErrorMessage("Sending message failed: message=" + String.valueOf(response) + "\nerrorMessage=" + errorMessage);
            }
        });
    }
}

