/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import haveno.common.taskrunner.TaskRunner;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.InitTradeRequest;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.tasks.TradeTask;
import java.math.BigInteger;
import monero.daemon.model.MoneroTx;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArbitratorProcessReserveTx
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(ArbitratorProcessReserveTx.class);

    public ArbitratorProcessReserveTx(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    @Override
    protected void run() {
        try {
            boolean isFromBuyerAsTakerWithoutDeposit;
            boolean isFromMaker;
            this.runInterceptHook();
            Offer offer = this.trade.getOffer();
            InitTradeRequest request = (InitTradeRequest)this.processModel.getTradeMessage();
            TradePeer sender = this.trade.getTradePeer(this.processModel.getTempTradePeerNodeAddress());
            boolean bl = isFromMaker = sender == this.trade.getMaker();
            boolean isFromBuyer = isFromMaker ? offer.getDirection() == OfferDirection.BUY : offer.getDirection() == OfferDirection.SELL;
            TradePeer tradePeer = sender = isFromMaker ? this.processModel.getMaker() : this.processModel.getTaker();
            BigInteger securityDeposit = isFromMaker ? (isFromBuyer ? offer.getMaxBuyerSecurityDeposit() : offer.getMaxSellerSecurityDeposit()) : (isFromBuyer ? this.trade.getBuyerSecurityDepositBeforeMiningFee() : this.trade.getSellerSecurityDepositBeforeMiningFee());
            sender.setSecurityDeposit(securityDeposit);
            boolean bl2 = isFromBuyerAsTakerWithoutDeposit = isFromBuyer && !isFromMaker && this.trade.hasBuyerAsTakerWithoutDeposit();
            if (!isFromBuyerAsTakerWithoutDeposit) {
                MoneroTx verifiedTx;
                BigInteger tradeFee;
                BigInteger penaltyFee = HavenoUtils.multiply(isFromMaker ? offer.getAmount() : this.trade.getAmount(), offer.getPenaltyFeePct());
                BigInteger bigInteger = tradeFee = isFromMaker ? offer.getMaxMakerFee() : this.trade.getTakerFee();
                BigInteger sendAmount = isFromBuyer ? BigInteger.ZERO : (isFromMaker ? offer.getAmount() : this.trade.getAmount());
                try {
                    verifiedTx = this.trade.getXmrWalletService().verifyReserveTx(offer.getId(), penaltyFee, tradeFee, sendAmount, securityDeposit, request.getPayoutAddress(), request.getReserveTxHash(), request.getReserveTxHex(), request.getReserveTxKey(), null);
                }
                catch (Exception e) {
                    log.error(ExceptionUtils.getStackTrace(e));
                    throw new RuntimeException("Error processing reserve tx from " + (isFromMaker ? "maker " : "taker ") + String.valueOf(this.processModel.getTempTradePeerNodeAddress()) + ", offerId=" + offer.getId() + ": " + e.getMessage());
                }
                sender.setSecurityDeposit(sender.getSecurityDeposit().subtract(verifiedTx.getFee()));
                sender.setReserveTxHash(request.getReserveTxHash());
                sender.setReserveTxHex(request.getReserveTxHex());
                sender.setReserveTxKey(request.getReserveTxKey());
            }
            this.processModel.getTradeManager().requestPersistence();
            this.complete();
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }
}

