/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import haveno.common.app.Version;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.InitMultisigRequest;
import haveno.core.trade.messages.InitTradeRequest;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.network.p2p.SendDirectMessageListener;
import java.util.Date;
import java.util.UUID;
import monero.wallet.MoneroWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArbitratorSendInitTradeOrMultisigRequests
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(ArbitratorSendInitTradeOrMultisigRequests.class);

    public ArbitratorSendInitTradeOrMultisigRequests(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    @Override
    protected void run() {
        block4: {
            try {
                this.runInterceptHook();
                InitTradeRequest request = (InitTradeRequest)this.processModel.getTradeMessage();
                TradePeer sender = this.trade.getTradePeer(this.processModel.getTempTradePeerNodeAddress());
                if (sender == this.trade.getMaker()) {
                    final InitTradeRequest takerRequest = new InitTradeRequest(request.getTradeProtocolVersion(), this.processModel.getOfferId(), this.trade.getAmount().longValueExact(), this.trade.getPrice().getValue(), request.getPaymentMethodId(), request.getMakerAccountId(), request.getTakerAccountId(), request.getMakerPaymentAccountId(), request.getTakerPaymentAccountId(), request.getTakerPubKeyRing(), UUID.randomUUID().toString(), Version.getP2PMessageVersion(), request.getAccountAgeWitnessSignatureOfOfferId(), new Date().getTime(), this.trade.getMaker().getNodeAddress(), this.trade.getTaker().getNodeAddress(), this.trade.getArbitrator().getNodeAddress(), null, null, null, null, null);
                    log.info("Send {} with offerId {} and uid {} to taker {}", takerRequest.getClass().getSimpleName(), takerRequest.getOfferId(), takerRequest.getUid(), this.trade.getTaker().getNodeAddress());
                    this.processModel.getP2PService().sendEncryptedDirectMessage(this.trade.getTaker().getNodeAddress(), this.trade.getTaker().getPubKeyRing(), takerRequest, new SendDirectMessageListener(){

                        @Override
                        public void onArrived() {
                            log.info("{} arrived at taker: offerId={}; uid={}", takerRequest.getClass().getSimpleName(), takerRequest.getOfferId(), takerRequest.getUid());
                            ArbitratorSendInitTradeOrMultisigRequests.this.complete();
                        }

                        @Override
                        public void onFault(String errorMessage) {
                            log.error("Sending {} failed: uid={}; peer={}; error={}", takerRequest.getClass().getSimpleName(), takerRequest.getUid(), ArbitratorSendInitTradeOrMultisigRequests.this.trade.getTaker().getNodeAddress(), errorMessage);
                            ArbitratorSendInitTradeOrMultisigRequests.this.appendToErrorMessage("Sending message failed: message=" + String.valueOf(takerRequest) + "\nerrorMessage=" + errorMessage);
                            ArbitratorSendInitTradeOrMultisigRequests.this.failed();
                        }
                    });
                    break block4;
                }
                if (sender == this.trade.getTaker()) {
                    this.sendInitMultisigRequests();
                    this.complete();
                    break block4;
                }
                throw new RuntimeException("Request is not from maker or taker");
            }
            catch (Throwable t2) {
                this.failed(t2);
            }
        }
    }

    private void sendInitMultisigRequests() {
        if (this.processModel.getMaker().getReserveTxHash() == null) {
            throw new RuntimeException("Arbitrator does not have maker's reserve tx after initializing trade");
        }
        if (this.processModel.getTaker().getReserveTxHash() == null && !this.trade.hasBuyerAsTakerWithoutDeposit()) {
            throw new RuntimeException("Arbitrator does not have taker's reserve tx after initializing trade");
        }
        MoneroWallet multisigWallet = this.trade.createWallet();
        String preparedHex = multisigWallet.prepareMultisig();
        this.trade.getSelf().setPreparedMultisigHex(preparedHex);
        String address = this.trade.getXmrWalletService().getBaseAddressEntry().getAddressString();
        if (this.trade.getProcessModel().getTradeFeeAddress() == null) {
            this.trade.getProcessModel().setTradeFeeAddress(address);
        }
        final InitMultisigRequest initMultisigRequest = new InitMultisigRequest(this.processModel.getOffer().getId(), UUID.randomUUID().toString(), Version.getP2PMessageVersion(), new Date().getTime(), preparedHex, null, null, this.trade.getProcessModel().getTradeFeeAddress());
        log.info("Send {} with offerId {} and uid {} to maker {}", initMultisigRequest.getClass().getSimpleName(), initMultisigRequest.getOfferId(), initMultisigRequest.getUid(), this.trade.getMaker().getNodeAddress());
        this.processModel.getP2PService().sendEncryptedDirectMessage(this.trade.getMaker().getNodeAddress(), this.trade.getMaker().getPubKeyRing(), initMultisigRequest, new SendDirectMessageListener(){

            @Override
            public void onArrived() {
                log.info("{} arrived at maker: offerId={}; uid={}", initMultisigRequest.getClass().getSimpleName(), initMultisigRequest.getOfferId(), initMultisigRequest.getUid());
            }

            @Override
            public void onFault(String errorMessage) {
                log.error("Sending {} failed: uid={}; peer={}; error={}", initMultisigRequest.getClass().getSimpleName(), initMultisigRequest.getUid(), ArbitratorSendInitTradeOrMultisigRequests.this.trade.getMaker().getNodeAddress(), errorMessage);
            }
        });
        log.info("Send {} with offerId {} and uid {} to taker {}", initMultisigRequest.getClass().getSimpleName(), initMultisigRequest.getOfferId(), initMultisigRequest.getUid(), this.trade.getTaker().getNodeAddress());
        this.processModel.getP2PService().sendEncryptedDirectMessage(this.trade.getTaker().getNodeAddress(), this.trade.getTaker().getPubKeyRing(), initMultisigRequest, new SendDirectMessageListener(){

            @Override
            public void onArrived() {
                log.info("{} arrived at taker: offerId={}; uid={}", initMultisigRequest.getClass().getSimpleName(), initMultisigRequest.getOfferId(), initMultisigRequest.getUid());
            }

            @Override
            public void onFault(String errorMessage) {
                log.error("Sending {} failed: uid={}; peer={}; error={}", initMultisigRequest.getClass().getSimpleName(), initMultisigRequest.getUid(), ArbitratorSendInitTradeOrMultisigRequests.this.trade.getTaker().getNodeAddress(), errorMessage);
            }
        });
    }
}

