/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.crypto.PubKeyRing;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.network.MessageState;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.PaymentSentMessage;
import haveno.core.trade.messages.TradeMailboxMessage;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.tasks.SendMailboxMessageTask;
import haveno.core.util.JsonUtil;
import haveno.network.p2p.NodeAddress;
import java.util.concurrent.TimeUnit;
import javafx.beans.value.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BuyerSendPaymentSentMessage
extends SendMailboxMessageTask {
    private static final Logger log = LoggerFactory.getLogger(BuyerSendPaymentSentMessage.class);
    private ChangeListener<MessageState> listener;
    private Timer timer;
    private static final int MAX_RESEND_ATTEMPTS = 20;
    private int delayInMin = 10;
    private int resendCounter = 0;

    public BuyerSendPaymentSentMessage(TaskRunner<Trade> taskHandler, Trade trade) {
        super(taskHandler, trade);
    }

    protected abstract TradePeer getReceiver();

    @Override
    protected NodeAddress getReceiverNodeAddress() {
        return this.getReceiver().getNodeAddress();
    }

    @Override
    protected PubKeyRing getReceiverPubKeyRing() {
        return this.getReceiver().getPubKeyRing();
    }

    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            if (this.isAckedByReceiver()) {
                if (!this.isCompleted()) {
                    this.complete();
                }
                return;
            }
            super.run();
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }

    @Override
    protected TradeMailboxMessage getTradeMailboxMessage(String tradeId) {
        if (this.getReceiver().getPaymentSentMessage() == null) {
            String deterministicId = HavenoUtils.getDeterministicId(this.trade, PaymentSentMessage.class, this.getReceiverNodeAddress());
            PaymentSentMessage message = new PaymentSentMessage(tradeId, this.processModel.getMyNodeAddress(), this.trade.getCounterCurrencyTxId(), this.trade.getCounterCurrencyExtraData(), deterministicId, this.trade.getSelf().getUnsignedPayoutTxHex(), this.trade.getSelf().getUpdatedMultisigHex(), this.trade.getSelf().getPaymentAccountKey(), this.trade.getTradePeer().getAccountAgeWitness());
            try {
                String messageAsJson = JsonUtil.objectToJson(message);
                byte[] sig = HavenoUtils.sign(this.processModel.getP2PService().getKeyRing(), messageAsJson);
                message.setBuyerSignature(sig);
                this.getReceiver().setPaymentSentMessage(message);
                this.trade.requestPersistence();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.getReceiver().getPaymentSentMessage();
    }

    @Override
    protected void setStateSent() {
        this.getReceiver().setPaymentSentMessageState(MessageState.SENT);
        this.tryToSendAgainLater();
        this.processModel.getTradeManager().requestPersistence();
    }

    @Override
    protected void setStateArrived() {
        this.getReceiver().setPaymentSentMessageState(MessageState.ARRIVED);
        this.processModel.getTradeManager().requestPersistence();
    }

    @Override
    protected void setStateStoredInMailbox() {
        this.getReceiver().setPaymentSentMessageState(MessageState.STORED_IN_MAILBOX);
        this.processModel.getTradeManager().requestPersistence();
    }

    @Override
    protected void setStateFault() {
        this.getReceiver().setPaymentSentMessageState(MessageState.FAILED);
        this.processModel.getTradeManager().requestPersistence();
    }

    private void cleanup() {
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.listener != null) {
            this.trade.getSeller().getPaymentReceivedMessageStateProperty().removeListener(this.listener);
        }
    }

    private void tryToSendAgainLater() {
        if (this.isAckedByReceiver()) {
            return;
        }
        if (this.resendCounter >= 20) {
            this.cleanup();
            log.warn("We never received an ACK message when sending the PaymentSentMessage to the peer. We stop trying to send the message.");
            return;
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        this.timer = UserThread.runAfter(this::run, this.delayInMin, TimeUnit.MINUTES);
        if (this.resendCounter == 0) {
            this.listener = (observable2, oldValue, newValue) -> this.onMessageStateChange((MessageState)((Object)newValue));
            this.getReceiver().getPaymentSentMessageStateProperty().addListener(this.listener);
            this.onMessageStateChange((MessageState)((Object)this.getReceiver().getPaymentSentMessageStateProperty().get()));
        }
        if (this.resendCounter == 0) {
            int shortDelay = 2;
            log.info("We will send the message again to the peer after a delay of {} min.", (Object)shortDelay);
            this.timer = UserThread.runAfter(this::run, shortDelay, TimeUnit.MINUTES);
        } else {
            log.info("We will send the message again to the peer after a delay of {} min.", (Object)this.delayInMin);
            this.timer = UserThread.runAfter(this::run, this.delayInMin, TimeUnit.MINUTES);
            this.delayInMin = (int)((double)this.delayInMin * 1.5);
        }
        ++this.resendCounter;
    }

    private void onMessageStateChange(MessageState newValue) {
        if (this.isAckedByReceiver()) {
            this.cleanup();
        }
    }

    protected boolean isAckedByReceiver() {
        return this.getReceiver().isPaymentSentMessageAcked();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuyerSendPaymentSentMessage)) {
            return false;
        }
        BuyerSendPaymentSentMessage other = (BuyerSendPaymentSentMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.delayInMin != other.delayInMin) {
            return false;
        }
        if (this.resendCounter != other.resendCounter) {
            return false;
        }
        ChangeListener<MessageState> this$listener = this.listener;
        ChangeListener<MessageState> other$listener = other.listener;
        if (this$listener == null ? other$listener != null : !this$listener.equals(other$listener)) {
            return false;
        }
        Timer this$timer = this.timer;
        Timer other$timer = other.timer;
        return !(this$timer == null ? other$timer != null : !this$timer.equals(other$timer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuyerSendPaymentSentMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.delayInMin;
        result = result * 59 + this.resendCounter;
        ChangeListener<MessageState> $listener = this.listener;
        result = result * 59 + ($listener == null ? 43 : $listener.hashCode());
        Timer $timer = this.timer;
        result = result * 59 + ($timer == null ? 43 : $timer.hashCode());
        return result;
    }
}

