/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import haveno.common.config.Config;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.trade.Trade;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.core.xmr.wallet.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MakerSetLockTime
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(MakerSetLockTime.class);

    public MakerSetLockTime(TaskRunner<Trade> taskHandler, Trade trade) {
        super(taskHandler, trade);
    }

    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            int delay = Config.baseCurrencyNetwork().isTestnet() ? 5 : Restrictions.getLockTime(this.processModel.getOffer().getPaymentMethod().isBlockchain());
            long lockTime = this.processModel.getBtcWalletService().getBestChainHeight() + delay;
            log.info("lockTime={}, delay={}", (Object)lockTime, (Object)delay);
            this.trade.setLockTime(lockTime);
            this.processModel.getTradeManager().requestPersistence();
            this.complete();
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }
}

