/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import com.google.common.base.Preconditions;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeResult;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.DepositsConfirmedMessage;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.core.util.Validator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaybeResendDisputeClosedMessageWithPayout
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(MaybeResendDisputeClosedMessageWithPayout.class);

    public MaybeResendDisputeClosedMessageWithPayout(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            DepositsConfirmedMessage request = (DepositsConfirmedMessage)this.processModel.getTradeMessage();
            Preconditions.checkNotNull(request);
            Validator.checkTradeId(this.processModel.getOfferId(), request);
            TradePeer sender = this.trade.getTradePeer(request.getPubKeyRing());
            if (sender == null) {
                throw new RuntimeException("Pub key ring is not from arbitrator, buyer, or seller");
            }
            boolean ticketClosed = false;
            if (!this.trade.isPayoutPublished() && this.trade.isArbitrator()) {
                List<Dispute> disputes = this.trade.getDisputes();
                for (Dispute dispute : disputes) {
                    if (!dispute.isClosed() || !sender.getPubKeyRing().equals(dispute.getTraderPubKeyRing())) continue;
                    log.info("Arbitrator resending DisputeClosedMessage for trade {} after receiving updated multisig hex", (Object)this.trade.getId());
                    HavenoUtils.arbitrationManager.closeDisputeTicket((DisputeResult)dispute.getDisputeResultProperty().get(), dispute, (String)((DisputeResult)dispute.getDisputeResultProperty().get()).summaryNotesProperty().get(), () -> this.completeAux(), (errMessage, err) -> {
                        log.error("Failed to close dispute ticket for trade {}: {}\n", this.trade.getId(), errMessage, err);
                        this.failed(err);
                    });
                    ticketClosed = true;
                    break;
                }
            }
            if (!ticketClosed) {
                this.completeAux();
            }
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }

    private void completeAux() {
        this.processModel.getTradeManager().requestPersistence();
        this.complete();
    }
}

