/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import haveno.common.app.Version;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.offer.OpenOffer;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.BuyerTrade;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.MakerTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.SignContractRequest;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.network.p2p.SendDirectMessageListener;
import java.math.BigInteger;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import monero.common.MoneroRpcConnection;
import monero.wallet.model.MoneroTxWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaybeSendSignContractRequest
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(MaybeSendSignContractRequest.class);
    private boolean ack1 = false;
    private boolean ack2 = false;

    public MaybeSendSignContractRequest(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            if (this.trade instanceof ArbitratorTrade) {
                this.complete();
                return;
            }
            if (this.processModel.getMultisigAddress() == null) {
                this.complete();
                return;
            }
            if (this.trade.getSelf().getDepositTx() != null) {
                this.complete();
                return;
            }
            this.trade.addInitProgressStep();
            MoneroTxWallet depositTx = null;
            Object object = HavenoUtils.xmrWalletService.getWalletLock();
            synchronized (object) {
                BigInteger securityDeposit;
                Optional<OpenOffer> openOffer;
                if (this.isTimedOut()) {
                    throw new RuntimeException("Trade protocol has timed out while getting lock to create deposit tx, tradeId=" + this.trade.getShortId());
                }
                this.trade.startProtocolTimeout();
                Integer subaddressIndex = null;
                boolean reserveExactAmount = false;
                if (this.trade instanceof MakerTrade) {
                    openOffer = this.processModel.getOpenOfferManager().getOpenOffer(this.trade.getId());
                    if (openOffer.isPresent()) {
                        reserveExactAmount = openOffer.get().isReserveExactAmount();
                        if (reserveExactAmount) {
                            subaddressIndex = ((Trade)this.model).getXmrWalletService().getAddressEntry(this.trade.getId(), XmrAddressEntry.Context.OFFER_FUNDING).get().getSubaddressIndex();
                        }
                    } else {
                        throw new RuntimeException("Cannot request contract signature because open offer has been removed for " + this.trade.getClass().getSimpleName() + " " + this.trade.getShortId());
                    }
                }
                if (this.trade.getSelf().getReserveTxKeyImages() != null) {
                    this.trade.getXmrWalletService().thawOutputs(this.trade.getSelf().getReserveTxKeyImages());
                }
                if (!this.trade.isBuyerAsTakerWithoutDeposit()) {
                    try {
                        openOffer = HavenoUtils.getWalletFunctionLock();
                        synchronized (openOffer) {
                            for (int i = 0; i < 5; ++i) {
                                MoneroRpcConnection sourceConnection = this.trade.getXmrConnectionService().getConnection();
                                try {
                                    depositTx = this.trade.getXmrWalletService().createDepositTx(this.trade, reserveExactAmount, subaddressIndex);
                                }
                                catch (Exception e) {
                                    log.warn("Error creating deposit tx, tradeId={}, attempt={}/{}, error={}", this.trade.getShortId(), i + 1, 5, e.getMessage());
                                    this.trade.getXmrWalletService().handleWalletError(e, sourceConnection);
                                    if (this.isTimedOut()) {
                                        throw new RuntimeException("Trade protocol has timed out while creating deposit tx, tradeId=" + this.trade.getShortId());
                                    }
                                    if (i == 4) {
                                        throw e;
                                    }
                                    HavenoUtils.waitFor(5000L);
                                }
                                if (this.isTimedOut()) {
                                    throw new RuntimeException("Trade protocol has timed out while creating deposit tx, tradeId=" + this.trade.getShortId());
                                }
                                if (depositTx != null) break;
                            }
                        }
                    }
                    catch (Exception e) {
                        if (depositTx != null) {
                            this.trade.getXmrWalletService().thawOutputs(HavenoUtils.getInputKeyImages(depositTx));
                            this.trade.getSelf().setReserveTxKeyImages(null);
                        }
                        if (this.trade instanceof MakerTrade) {
                            this.trade.getXmrWalletService().freezeOutputs(this.trade.getOffer().getOfferPayload().getReserveTxKeyImages());
                        }
                        throw e;
                    }
                }
                this.trade.addInitProgressStep();
                this.trade.getSelf().setPayoutAddressString(this.trade.getXmrWalletService().getOrCreateAddressEntry(this.trade.getOffer().getId(), XmrAddressEntry.Context.TRADE_PAYOUT).getAddressString());
                this.trade.getSelf().setPaymentAccountPayload(this.trade.getProcessModel().getPaymentAccountPayload(this.trade.getSelf().getPaymentAccountId()));
                this.trade.getSelf().setPaymentAccountPayloadHash(this.trade.getSelf().getPaymentAccountPayload().getHash());
                BigInteger bigInteger = securityDeposit = this.trade instanceof BuyerTrade ? this.trade.getBuyerSecurityDepositBeforeMiningFee() : this.trade.getSellerSecurityDepositBeforeMiningFee();
                if (depositTx == null) {
                    this.trade.getSelf().setSecurityDeposit(securityDeposit);
                } else {
                    this.trade.getSelf().setSecurityDeposit(securityDeposit.subtract(depositTx.getFee()));
                    this.trade.getSelf().setDepositTx(depositTx);
                    this.trade.getSelf().setDepositTxHash(depositTx.getHash());
                    this.trade.getSelf().setDepositTxFee(depositTx.getFee());
                    this.trade.getSelf().setReserveTxKeyImages(HavenoUtils.getInputKeyImages(depositTx));
                }
            }
            byte[] sig = null;
            if (this.trade instanceof MakerTrade) {
                sig = HavenoUtils.sign(this.processModel.getP2PService().getKeyRing(), depositTx.getHash());
            }
            final SignContractRequest request = new SignContractRequest(this.trade.getOffer().getId(), UUID.randomUUID().toString(), Version.getP2PMessageVersion(), new Date().getTime(), this.trade.getProcessModel().getAccountId(), this.trade.getSelf().getPaymentAccountPayload().getHash(), this.trade.getSelf().getPayoutAddressString(), depositTx == null ? null : depositTx.getHash(), sig);
            this.processModel.getP2PService().sendEncryptedDirectMessage(this.trade.getTradePeer().getNodeAddress(), this.trade.getTradePeer().getPubKeyRing(), request, new SendDirectMessageListener(){

                @Override
                public void onArrived() {
                    log.info("{} arrived: trading peer={}; offerId={}; uid={}", request.getClass().getSimpleName(), MaybeSendSignContractRequest.this.trade.getTradePeer().getNodeAddress(), MaybeSendSignContractRequest.this.trade.getId());
                    MaybeSendSignContractRequest.this.ack1 = true;
                    if (MaybeSendSignContractRequest.this.ack1 && MaybeSendSignContractRequest.this.ack2) {
                        MaybeSendSignContractRequest.this.completeAux();
                    }
                }

                @Override
                public void onFault(String errorMessage) {
                    log.error("Sending {} failed: uid={}; peer={}; error={}", request.getClass().getSimpleName(), MaybeSendSignContractRequest.this.trade.getTradePeer().getNodeAddress(), MaybeSendSignContractRequest.this.trade.getId(), errorMessage);
                    MaybeSendSignContractRequest.this.appendToErrorMessage("Sending message failed: message=" + String.valueOf(request) + "\nerrorMessage=" + errorMessage);
                    MaybeSendSignContractRequest.this.failed();
                }
            });
            this.processModel.getP2PService().sendEncryptedDirectMessage(this.trade.getArbitrator().getNodeAddress(), this.trade.getArbitrator().getPubKeyRing(), request, new SendDirectMessageListener(){

                @Override
                public void onArrived() {
                    log.info("{} arrived: trading peer={}; offerId={}; uid={}", request.getClass().getSimpleName(), MaybeSendSignContractRequest.this.trade.getArbitrator().getNodeAddress(), MaybeSendSignContractRequest.this.trade.getId());
                    MaybeSendSignContractRequest.this.ack2 = true;
                    if (MaybeSendSignContractRequest.this.ack1 && MaybeSendSignContractRequest.this.ack2) {
                        MaybeSendSignContractRequest.this.completeAux();
                    }
                }

                @Override
                public void onFault(String errorMessage) {
                    log.error("Sending {} failed: uid={}; peer={}; error={}", request.getClass().getSimpleName(), MaybeSendSignContractRequest.this.trade.getArbitrator().getNodeAddress(), MaybeSendSignContractRequest.this.trade.getId(), errorMessage);
                    MaybeSendSignContractRequest.this.appendToErrorMessage("Sending message failed: message=" + String.valueOf(request) + "\nerrorMessage=" + errorMessage);
                    MaybeSendSignContractRequest.this.failed();
                }
            });
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }

    private void completeAux() {
        this.trade.setState(Trade.State.CONTRACT_SIGNATURE_REQUESTED);
        this.trade.addInitProgressStep();
        this.processModel.getTradeManager().requestPersistence();
        this.complete();
    }

    private boolean isTimedOut() {
        return !this.processModel.getTradeManager().hasOpenTrade(this.trade);
    }
}

