/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import haveno.common.taskrunner.TaskRunner;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.DepositResponse;
import haveno.core.trade.protocol.tasks.TradeTask;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDepositResponse
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(ProcessDepositResponse.class);

    public ProcessDepositResponse(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            DepositResponse message = (DepositResponse)this.processModel.getTradeMessage();
            if (message.getErrorMessage() != null) {
                log.warn("Deposit response for {} {} has error message={}", this.trade.getClass().getSimpleName(), this.trade.getShortId(), message.getErrorMessage());
                this.trade.setStateIfValidTransitionTo(Trade.State.PUBLISH_DEPOSIT_TX_REQUEST_FAILED);
                this.trade.setInitError(new RuntimeException(message.getErrorMessage()));
                this.complete();
                return;
            }
            this.trade.getBuyer().setSecurityDeposit(BigInteger.valueOf(message.getBuyerSecurityDeposit()));
            this.trade.getSeller().setSecurityDeposit(BigInteger.valueOf(message.getSellerSecurityDeposit()));
            this.trade.setStateIfValidTransitionTo(Trade.State.ARBITRATOR_PUBLISHED_DEPOSIT_TXS);
            this.processModel.getTradeManager().requestPersistence();
            this.trade.getXmrWalletService().updateBalanceListeners();
            this.complete();
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }
}

