/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import com.google.common.base.Preconditions;
import haveno.common.app.Version;
import haveno.common.crypto.PubKeyRing;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.MakerTrade;
import haveno.core.trade.TakerTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.InitMultisigRequest;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.core.util.Validator;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.SendDirectMessageListener;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import monero.wallet.MoneroWallet;
import monero.wallet.model.MoneroMultisigInfo;
import monero.wallet.model.MoneroMultisigInitResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInitMultisigRequest
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(ProcessInitMultisigRequest.class);
    private boolean ack1 = false;
    private boolean ack2 = false;
    MoneroWallet multisigWallet;

    public ProcessInitMultisigRequest(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    @Override
    protected void run() {
        try {
            MoneroMultisigInitResult result;
            this.runInterceptHook();
            log.debug("current trade state " + String.valueOf((Object)this.trade.getState()));
            final InitMultisigRequest request = (InitMultisigRequest)this.processModel.getTradeMessage();
            Preconditions.checkNotNull(request);
            Validator.checkTradeId(this.processModel.getOfferId(), request);
            XmrWalletService xmrWalletService = this.processModel.getProvider().getXmrWalletService();
            TradePeer sender = this.trade.getTradePeer(this.processModel.getTempTradePeerNodeAddress());
            if (request.getTradeFeeAddress() != null && sender == this.trade.getArbitrator()) {
                this.trade.getProcessModel().setTradeFeeAddress(request.getTradeFeeAddress());
            }
            if (sender.getPreparedMultisigHex() == null) {
                sender.setPreparedMultisigHex(request.getPreparedMultisigHex());
            } else if (request.getPreparedMultisigHex() != null && !sender.getPreparedMultisigHex().equals(request.getPreparedMultisigHex())) {
                throw new RuntimeException("Message's prepared multisig differs from previous messages, previous: " + sender.getPreparedMultisigHex() + ", message: " + request.getPreparedMultisigHex());
            }
            if (sender.getMadeMultisigHex() == null) {
                sender.setMadeMultisigHex(request.getMadeMultisigHex());
            } else if (request.getMadeMultisigHex() != null && !sender.getMadeMultisigHex().equals(request.getMadeMultisigHex())) {
                throw new RuntimeException("Message's made multisig differs from previous messages: " + request.getMadeMultisigHex() + " versus " + sender.getMadeMultisigHex());
            }
            if (sender.getExchangedMultisigHex() == null) {
                sender.setExchangedMultisigHex(request.getExchangedMultisigHex());
            } else if (request.getExchangedMultisigHex() != null && !sender.getExchangedMultisigHex().equals(request.getExchangedMultisigHex())) {
                throw new RuntimeException("Message's exchanged multisig differs from previous messages: " + request.getExchangedMultisigHex() + " versus " + sender.getExchangedMultisigHex());
            }
            boolean updateParticipants = false;
            if (this.trade.getSelf().getPreparedMultisigHex() == null) {
                log.info("Preparing multisig wallet for {} {}", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                this.multisigWallet = this.trade.createWallet();
                this.trade.getSelf().setPreparedMultisigHex(this.multisigWallet.prepareMultisig());
                this.trade.setStateIfValidTransitionTo(Trade.State.MULTISIG_PREPARED);
                updateParticipants = true;
            } else if (this.processModel.getMultisigAddress() == null) {
                this.multisigWallet = this.trade.getWallet();
            }
            TradePeer[] peers = this.getMultisigPeers();
            if (this.trade.getSelf().getMadeMultisigHex() == null && peers[0].getPreparedMultisigHex() != null && peers[1].getPreparedMultisigHex() != null) {
                log.info("Making multisig wallet for {} {}", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                String multisigHex = this.multisigWallet.makeMultisig(Arrays.asList(peers[0].getPreparedMultisigHex(), peers[1].getPreparedMultisigHex()), 2, xmrWalletService.getWalletPassword());
                this.trade.getSelf().setMadeMultisigHex(multisigHex);
                this.trade.setStateIfValidTransitionTo(Trade.State.MULTISIG_MADE);
                updateParticipants = true;
            }
            if (this.trade.getSelf().getExchangedMultisigHex() == null && peers[0].getMadeMultisigHex() != null && peers[1].getMadeMultisigHex() != null) {
                log.info("Importing made multisig hex for {} {}", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                result = this.multisigWallet.exchangeMultisigKeys(Arrays.asList(peers[0].getMadeMultisigHex(), peers[1].getMadeMultisigHex()), xmrWalletService.getWalletPassword());
                this.trade.getSelf().setExchangedMultisigHex(result.getMultisigHex());
                this.trade.setStateIfValidTransitionTo(Trade.State.MULTISIG_EXCHANGED);
                updateParticipants = true;
            }
            if (this.processModel.getMultisigAddress() == null && peers[0].getExchangedMultisigHex() != null && peers[1].getExchangedMultisigHex() != null) {
                log.info("Importing exchanged multisig hex for trade {}", (Object)this.trade.getId());
                result = this.multisigWallet.exchangeMultisigKeys(Arrays.asList(peers[0].getExchangedMultisigHex(), peers[1].getExchangedMultisigHex()), xmrWalletService.getWalletPassword());
                MoneroMultisigInfo multisigInfo = this.multisigWallet.getMultisigInfo();
                if (!multisigInfo.isMultisig()) {
                    throw new RuntimeException("Multisig wallet is not multisig on completion");
                }
                if (!multisigInfo.isReady().booleanValue()) {
                    throw new RuntimeException("Multisig wallet is not ready on completion");
                }
                if (multisigInfo.getThreshold() != 2) {
                    throw new RuntimeException("Multisig wallet has unexpected threshold: " + multisigInfo.getThreshold());
                }
                if (multisigInfo.getNumParticipants() != 3) {
                    throw new RuntimeException("Multisig wallet has unexpected number of participants: " + multisigInfo.getNumParticipants());
                }
                this.processModel.setMultisigAddress(result.getAddress());
                this.trade.saveWallet();
                this.trade.setStateIfValidTransitionTo(Trade.State.MULTISIG_COMPLETED);
            }
            if (updateParticipants) {
                PubKeyRing peer2PubKeyRing;
                NodeAddress peer2Address;
                PubKeyRing peer1PubKeyRing;
                NodeAddress peer1Address;
                if (this.trade instanceof ArbitratorTrade) {
                    peer1Address = this.trade.getTaker().getNodeAddress();
                    peer1PubKeyRing = this.trade.getTaker().getPubKeyRing();
                    peer2Address = this.trade.getMaker().getNodeAddress();
                    peer2PubKeyRing = this.trade.getMaker().getPubKeyRing();
                } else if (this.trade instanceof MakerTrade) {
                    peer1Address = this.trade.getTaker().getNodeAddress();
                    peer1PubKeyRing = this.trade.getTaker().getPubKeyRing();
                    peer2Address = this.trade.getArbitrator().getNodeAddress();
                    peer2PubKeyRing = this.trade.getArbitrator().getPubKeyRing();
                } else {
                    peer1Address = this.trade.getMaker().getNodeAddress();
                    peer1PubKeyRing = this.trade.getMaker().getPubKeyRing();
                    peer2Address = this.trade.getArbitrator().getNodeAddress();
                    peer2PubKeyRing = this.trade.getArbitrator().getPubKeyRing();
                }
                if (peer1Address == null) {
                    throw new RuntimeException("Peer1 address is null");
                }
                if (peer1PubKeyRing == null) {
                    throw new RuntimeException("Peer1 pub key ring is null");
                }
                if (peer2Address == null) {
                    throw new RuntimeException("Peer2 address is null");
                }
                if (peer2PubKeyRing == null) {
                    throw new RuntimeException("Peer2 pub key ring null");
                }
                log.info("{} {} sending InitMultisigRequests", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                this.sendInitMultisigRequest(peer1Address, peer1PubKeyRing, new SendDirectMessageListener(){

                    @Override
                    public void onArrived() {
                        log.info("{} arrived: peer={}; offerId={}; uid={}", request.getClass().getSimpleName(), peer1Address, request.getOfferId(), request.getUid());
                        ProcessInitMultisigRequest.this.ack1 = true;
                        if (ProcessInitMultisigRequest.this.ack1 && ProcessInitMultisigRequest.this.ack2) {
                            ProcessInitMultisigRequest.this.completeAux();
                        }
                    }

                    @Override
                    public void onFault(String errorMessage) {
                        log.error("Sending {} failed: uid={}; peer={}; error={}", request.getClass().getSimpleName(), request.getUid(), peer1Address, errorMessage);
                        ProcessInitMultisigRequest.this.appendToErrorMessage("Sending message failed: message=" + String.valueOf(request) + "\nerrorMessage=" + errorMessage);
                        ProcessInitMultisigRequest.this.failed();
                    }
                });
                this.sendInitMultisigRequest(peer2Address, peer2PubKeyRing, new SendDirectMessageListener(){

                    @Override
                    public void onArrived() {
                        log.info("{} arrived: peer={}; offerId={}; uid={}", request.getClass().getSimpleName(), peer2Address, request.getOfferId(), request.getUid());
                        ProcessInitMultisigRequest.this.ack2 = true;
                        if (ProcessInitMultisigRequest.this.ack1 && ProcessInitMultisigRequest.this.ack2) {
                            ProcessInitMultisigRequest.this.completeAux();
                        }
                    }

                    @Override
                    public void onFault(String errorMessage) {
                        log.error("Sending {} failed: uid={}; peer={}; error={}", request.getClass().getSimpleName(), request.getUid(), peer2Address, errorMessage);
                        ProcessInitMultisigRequest.this.appendToErrorMessage("Sending message failed: message=" + String.valueOf(request) + "\nerrorMessage=" + errorMessage);
                        ProcessInitMultisigRequest.this.failed();
                    }
                });
            } else {
                this.completeAux();
            }
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }

    private TradePeer[] getMultisigPeers() {
        TradePeer[] peers = new TradePeer[2];
        if (this.trade instanceof TakerTrade) {
            peers[0] = this.processModel.getArbitrator();
            peers[1] = this.processModel.getMaker();
        } else if (this.trade instanceof MakerTrade) {
            peers[1] = this.processModel.getTaker();
            peers[0] = this.processModel.getArbitrator();
        } else {
            peers[0] = this.processModel.getTaker();
            peers[1] = this.processModel.getMaker();
        }
        return peers;
    }

    private void sendInitMultisigRequest(NodeAddress recipient, PubKeyRing pubKeyRing, SendDirectMessageListener listener) {
        InitMultisigRequest request = new InitMultisigRequest(this.processModel.getOffer().getId(), UUID.randomUUID().toString(), Version.getP2PMessageVersion(), new Date().getTime(), this.trade.getSelf().getPreparedMultisigHex(), this.trade.getSelf().getMadeMultisigHex(), this.trade.getSelf().getExchangedMultisigHex(), null);
        log.info("Send {} with offerId {} and uid {} to peer {}", request.getClass().getSimpleName(), request.getOfferId(), request.getUid(), recipient);
        this.processModel.getP2PService().sendEncryptedDirectMessage(recipient, pubKeyRing, request, listener);
    }

    private void completeAux() {
        this.trade.addInitProgressStep();
        this.complete();
    }
}

