/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.exceptions.TradePriceOutOfToleranceException;
import haveno.core.offer.Offer;
import haveno.core.support.dispute.arbitration.arbitrator.Arbitrator;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.MakerTrade;
import haveno.core.trade.TakerTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.InitTradeRequest;
import haveno.core.trade.messages.TradeProtocolVersion;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.core.util.Validator;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInitTradeRequest
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(ProcessInitTradeRequest.class);

    public ProcessInitTradeRequest(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void run() {
        try {
            TradePeer sender;
            this.runInterceptHook();
            Offer offer = Preconditions.checkNotNull(this.trade.getOffer(), "Offer must not be null");
            InitTradeRequest request = (InitTradeRequest)this.processModel.getTradeMessage();
            Preconditions.checkNotNull(request);
            Validator.checkTradeId(this.processModel.getOfferId(), request);
            Preconditions.checkArgument(request.getTradeAmount() > 0L);
            if (this.trade.getAmount().compareTo(this.trade.getOffer().getAmount()) > 0) {
                throw new RuntimeException("Trade amount exceeds offer amount");
            }
            if (this.trade.getAmount().compareTo(this.trade.getOffer().getMinAmount()) < 0) {
                throw new RuntimeException("Trade amount is less than minimum offer amount");
            }
            if (!request.getTakerNodeAddress().equals(this.trade.getTaker().getNodeAddress())) {
                throw new RuntimeException("Trade's taker node address does not match request");
            }
            if (!request.getMakerNodeAddress().equals(this.trade.getMaker().getNodeAddress())) {
                throw new RuntimeException("Trade's maker node address does not match request");
            }
            if (!request.getOfferId().equals(offer.getId())) {
                throw new RuntimeException("Offer id does not match request's offer id");
            }
            if (this.trade instanceof MakerTrade) {
                sender = this.trade.getTradePeer(this.processModel.getTempTradePeerNodeAddress());
                if (sender != this.trade.getTaker()) {
                    throw new RuntimeException("InitTradeRequest to maker is expected from taker");
                }
                this.trade.getTaker().setPubKeyRing(request.getTakerPubKeyRing());
                if (request.getTradeProtocolVersion() != TradeProtocolVersion.MULTISIG_2_3) {
                    throw new RuntimeException("Trade protocol version is not supported");
                }
                try {
                    long tradePrice = request.getTradePrice();
                    offer.verifyTradePrice(tradePrice);
                    this.trade.setPrice(tradePrice);
                }
                catch (TradePriceOutOfToleranceException e) {
                    this.failed(e.getMessage());
                }
                catch (Throwable e2) {
                    this.failed(e2);
                }
            } else if (this.trade instanceof ArbitratorTrade) {
                this.trade.getMaker().setPubKeyRing(this.trade.getOffer().getPubKeyRing());
                this.trade.getArbitrator().setPubKeyRing(this.processModel.getPubKeyRing());
                if (!this.trade.getArbitrator().getNodeAddress().equals(request.getArbitratorNodeAddress())) {
                    throw new RuntimeException("Trade's arbitrator node address does not match request");
                }
                if (request.getTradeProtocolVersion() != TradeProtocolVersion.MULTISIG_2_3) {
                    throw new RuntimeException("Trade protocol version is not supported");
                }
                sender = this.trade.getTradePeer(this.processModel.getTempTradePeerNodeAddress());
                if (sender == this.trade.getMaker()) {
                    this.trade.getTaker().setPubKeyRing(request.getTakerPubKeyRing());
                    try {
                        long tradePrice = request.getTradePrice();
                        offer.verifyTradePrice(tradePrice);
                        this.trade.setPrice(tradePrice);
                    }
                    catch (TradePriceOutOfToleranceException e) {
                        this.failed(e.getMessage());
                    }
                    catch (Throwable e2) {
                        this.failed(e2);
                    }
                } else {
                    if (sender != this.trade.getTaker()) throw new RuntimeException("Sender is not trade's maker or taker");
                    if (!this.trade.getTaker().getPubKeyRing().equals(request.getTakerPubKeyRing())) {
                        throw new RuntimeException("Taker's pub key ring does not match request's pub key ring");
                    }
                    if (request.getTradeAmount() != this.trade.getAmount().longValueExact()) {
                        throw new RuntimeException("Trade amount does not match request's trade amount");
                    }
                    if (request.getTradePrice() != this.trade.getPrice().getValue()) {
                        throw new RuntimeException("Trade price does not match request's trade price");
                    }
                }
            } else {
                if (!(this.trade instanceof TakerTrade)) throw new RuntimeException("Invalid trade type to process init trade request: " + this.trade.getClass().getName());
                if (request.getTradeAmount() != this.trade.getAmount().longValueExact()) {
                    throw new RuntimeException("Trade amount does not match request's trade amount");
                }
                if (request.getTradePrice() != this.trade.getPrice().getValue()) {
                    throw new RuntimeException("Trade price does not match request's trade price");
                }
                Arbitrator arbitrator = this.processModel.getUser().getAcceptedArbitratorByAddress(request.getArbitratorNodeAddress());
                if (arbitrator == null) {
                    throw new RuntimeException("Arbitrator is not accepted by taker");
                }
                this.trade.getArbitrator().setNodeAddress(request.getArbitratorNodeAddress());
                this.trade.getArbitrator().setPubKeyRing(arbitrator.getPubKeyRing());
                sender = this.trade.getTradePeer(this.processModel.getTempTradePeerNodeAddress());
                if (sender != this.trade.getArbitrator()) {
                    throw new RuntimeException("InitTradeRequest to taker is expected from arbitrator");
                }
            }
            if (this.trade.getMaker().getAccountId() == null) {
                this.trade.getMaker().setAccountId(request.getMakerAccountId());
            } else if (!this.trade.getMaker().getAccountId().equals(request.getMakerAccountId())) {
                throw new RuntimeException("Maker account id is different from previous");
            }
            if (this.trade.getTaker().getAccountId() == null) {
                this.trade.getTaker().setAccountId(request.getTakerAccountId());
            } else if (!this.trade.getTaker().getAccountId().equals(request.getTakerAccountId())) {
                throw new RuntimeException("Taker account id is different from previous");
            }
            if (this.trade.getMaker().getPaymentAccountId() == null) {
                this.trade.getMaker().setPaymentAccountId(request.getMakerPaymentAccountId());
            } else if (!this.trade.getMaker().getPaymentAccountId().equals(request.getMakerPaymentAccountId())) {
                throw new RuntimeException("Maker payment account id is different from previous");
            }
            if (this.trade.getTaker().getPaymentAccountId() == null) {
                this.trade.getTaker().setPaymentAccountId(request.getTakerPaymentAccountId());
            } else if (!this.trade.getTaker().getPaymentAccountId().equals(request.getTakerPaymentAccountId())) {
                throw new RuntimeException("Taker payment account id is different from previous");
            }
            sender.setPaymentMethodId(Validator.nonEmptyStringOf(request.getPaymentMethodId()));
            sender.setAccountAgeWitnessNonce(this.trade.getId().getBytes(Charsets.UTF_8));
            sender.setAccountAgeWitnessSignature(request.getAccountAgeWitnessSignatureOfOfferId());
            sender.setCurrentDate(request.getCurrentDate());
            this.processModel.getAccountAgeWitnessService().verifyPeersCurrentDate(new Date(sender.getCurrentDate()));
            this.trade.addInitProgressStep();
            this.processModel.getTradeManager().requestPersistence();
            this.complete();
            return;
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }
}

